//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappplatform

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// BuildServiceClient contains the methods for the BuildService group.
// Don't use this type directly, use NewBuildServiceClient() instead.
type BuildServiceClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewBuildServiceClient creates a new instance of BuildServiceClient with the specified values.
//   - subscriptionID - Gets subscription ID which uniquely identify the Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewBuildServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*BuildServiceClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &BuildServiceClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Create a build service resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - buildService - Parameters for the create operation
//   - options - BuildServiceClientBeginCreateOrUpdateOptions contains the optional parameters for the BuildServiceClient.BeginCreateOrUpdate
//     method.
func (client *BuildServiceClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildService BuildService, options *BuildServiceClientBeginCreateOrUpdateOptions) (*runtime.Poller[BuildServiceClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, serviceName, buildServiceName, buildService, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[BuildServiceClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[BuildServiceClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Create a build service resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
func (client *BuildServiceClient) createOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildService BuildService, options *BuildServiceClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "BuildServiceClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildService, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *BuildServiceClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildService BuildService, options *BuildServiceClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, buildService); err != nil {
		return nil, err
	}
	return req, nil
}

// CreateOrUpdateBuild - Create or update a KPack build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - buildName - The name of the build resource.
//   - buildParam - Parameters for the create or update operation
//   - options - BuildServiceClientCreateOrUpdateBuildOptions contains the optional parameters for the BuildServiceClient.CreateOrUpdateBuild
//     method.
func (client *BuildServiceClient) CreateOrUpdateBuild(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildParam Build, options *BuildServiceClientCreateOrUpdateBuildOptions) (BuildServiceClientCreateOrUpdateBuildResponse, error) {
	var err error
	const operationName = "BuildServiceClient.CreateOrUpdateBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateBuildCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildParam, options)
	if err != nil {
		return BuildServiceClientCreateOrUpdateBuildResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientCreateOrUpdateBuildResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientCreateOrUpdateBuildResponse{}, err
	}
	resp, err := client.createOrUpdateBuildHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateBuildCreateRequest creates the CreateOrUpdateBuild request.
func (client *BuildServiceClient) createOrUpdateBuildCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildParam Build, options *BuildServiceClientCreateOrUpdateBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, buildParam); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateBuildHandleResponse handles the CreateOrUpdateBuild response.
func (client *BuildServiceClient) createOrUpdateBuildHandleResponse(resp *http.Response) (BuildServiceClientCreateOrUpdateBuildResponse, error) {
	result := BuildServiceClientCreateOrUpdateBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Build); err != nil {
		return BuildServiceClientCreateOrUpdateBuildResponse{}, err
	}
	return result, nil
}

// BeginDeleteBuild - delete a KPack build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - buildName - The name of the build resource.
//   - options - BuildServiceClientBeginDeleteBuildOptions contains the optional parameters for the BuildServiceClient.BeginDeleteBuild
//     method.
func (client *BuildServiceClient) BeginDeleteBuild(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientBeginDeleteBuildOptions) (*runtime.Poller[BuildServiceClientDeleteBuildResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteBuild(ctx, resourceGroupName, serviceName, buildServiceName, buildName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[BuildServiceClientDeleteBuildResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[BuildServiceClientDeleteBuildResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteBuild - delete a KPack build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
func (client *BuildServiceClient) deleteBuild(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientBeginDeleteBuildOptions) (*http.Response, error) {
	var err error
	const operationName = "BuildServiceClient.BeginDeleteBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteBuildCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteBuildCreateRequest creates the DeleteBuild request.
func (client *BuildServiceClient) deleteBuildCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientBeginDeleteBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetBuild - Get a KPack build.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - buildName - The name of the build resource.
//   - options - BuildServiceClientGetBuildOptions contains the optional parameters for the BuildServiceClient.GetBuild method.
func (client *BuildServiceClient) GetBuild(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientGetBuildOptions) (BuildServiceClientGetBuildResponse, error) {
	var err error
	const operationName = "BuildServiceClient.GetBuild"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getBuildCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, options)
	if err != nil {
		return BuildServiceClientGetBuildResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientGetBuildResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientGetBuildResponse{}, err
	}
	resp, err := client.getBuildHandleResponse(httpResp)
	return resp, err
}

// getBuildCreateRequest creates the GetBuild request.
func (client *BuildServiceClient) getBuildCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientGetBuildOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildHandleResponse handles the GetBuild response.
func (client *BuildServiceClient) getBuildHandleResponse(resp *http.Response) (BuildServiceClientGetBuildResponse, error) {
	result := BuildServiceClientGetBuildResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Build); err != nil {
		return BuildServiceClientGetBuildResponse{}, err
	}
	return result, nil
}

// GetBuildResult - Get a KPack build result.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - buildName - The name of the build resource.
//   - buildResultName - The name of the build result resource.
//   - options - BuildServiceClientGetBuildResultOptions contains the optional parameters for the BuildServiceClient.GetBuildResult
//     method.
func (client *BuildServiceClient) GetBuildResult(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *BuildServiceClientGetBuildResultOptions) (BuildServiceClientGetBuildResultResponse, error) {
	var err error
	const operationName = "BuildServiceClient.GetBuildResult"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getBuildResultCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, options)
	if err != nil {
		return BuildServiceClientGetBuildResultResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientGetBuildResultResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientGetBuildResultResponse{}, err
	}
	resp, err := client.getBuildResultHandleResponse(httpResp)
	return resp, err
}

// getBuildResultCreateRequest creates the GetBuildResult request.
func (client *BuildServiceClient) getBuildResultCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *BuildServiceClientGetBuildResultOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	if buildResultName == "" {
		return nil, errors.New("parameter buildResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildResultName}", url.PathEscape(buildResultName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildResultHandleResponse handles the GetBuildResult response.
func (client *BuildServiceClient) getBuildResultHandleResponse(resp *http.Response) (BuildServiceClientGetBuildResultResponse, error) {
	result := BuildServiceClientGetBuildResultResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildResult); err != nil {
		return BuildServiceClientGetBuildResultResponse{}, err
	}
	return result, nil
}

// GetBuildResultLog - Get a KPack build result log download URL.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - buildName - The name of the build resource.
//   - buildResultName - The name of the build result resource.
//   - options - BuildServiceClientGetBuildResultLogOptions contains the optional parameters for the BuildServiceClient.GetBuildResultLog
//     method.
func (client *BuildServiceClient) GetBuildResultLog(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *BuildServiceClientGetBuildResultLogOptions) (BuildServiceClientGetBuildResultLogResponse, error) {
	var err error
	const operationName = "BuildServiceClient.GetBuildResultLog"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getBuildResultLogCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildResultName, options)
	if err != nil {
		return BuildServiceClientGetBuildResultLogResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientGetBuildResultLogResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientGetBuildResultLogResponse{}, err
	}
	resp, err := client.getBuildResultLogHandleResponse(httpResp)
	return resp, err
}

// getBuildResultLogCreateRequest creates the GetBuildResultLog request.
func (client *BuildServiceClient) getBuildResultLogCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string, options *BuildServiceClientGetBuildResultLogOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}/getLogFileUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	if buildResultName == "" {
		return nil, errors.New("parameter buildResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildResultName}", url.PathEscape(buildResultName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildResultLogHandleResponse handles the GetBuildResultLog response.
func (client *BuildServiceClient) getBuildResultLogHandleResponse(resp *http.Response) (BuildServiceClientGetBuildResultLogResponse, error) {
	result := BuildServiceClientGetBuildResultLogResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildResultLog); err != nil {
		return BuildServiceClientGetBuildResultLogResponse{}, err
	}
	return result, nil
}

// GetBuildService - Get a build service resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - options - BuildServiceClientGetBuildServiceOptions contains the optional parameters for the BuildServiceClient.GetBuildService
//     method.
func (client *BuildServiceClient) GetBuildService(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientGetBuildServiceOptions) (BuildServiceClientGetBuildServiceResponse, error) {
	var err error
	const operationName = "BuildServiceClient.GetBuildService"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getBuildServiceCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
	if err != nil {
		return BuildServiceClientGetBuildServiceResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientGetBuildServiceResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientGetBuildServiceResponse{}, err
	}
	resp, err := client.getBuildServiceHandleResponse(httpResp)
	return resp, err
}

// getBuildServiceCreateRequest creates the GetBuildService request.
func (client *BuildServiceClient) getBuildServiceCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientGetBuildServiceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBuildServiceHandleResponse handles the GetBuildService response.
func (client *BuildServiceClient) getBuildServiceHandleResponse(resp *http.Response) (BuildServiceClientGetBuildServiceResponse, error) {
	result := BuildServiceClientGetBuildServiceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildService); err != nil {
		return BuildServiceClientGetBuildServiceResponse{}, err
	}
	return result, nil
}

// GetResourceUploadURL - Get an resource upload URL for build service, which may be artifacts or source archive.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - options - BuildServiceClientGetResourceUploadURLOptions contains the optional parameters for the BuildServiceClient.GetResourceUploadURL
//     method.
func (client *BuildServiceClient) GetResourceUploadURL(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientGetResourceUploadURLOptions) (BuildServiceClientGetResourceUploadURLResponse, error) {
	var err error
	const operationName = "BuildServiceClient.GetResourceUploadURL"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getResourceUploadURLCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
	if err != nil {
		return BuildServiceClientGetResourceUploadURLResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientGetResourceUploadURLResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientGetResourceUploadURLResponse{}, err
	}
	resp, err := client.getResourceUploadURLHandleResponse(httpResp)
	return resp, err
}

// getResourceUploadURLCreateRequest creates the GetResourceUploadURL request.
func (client *BuildServiceClient) getResourceUploadURLCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientGetResourceUploadURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/getResourceUploadUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getResourceUploadURLHandleResponse handles the GetResourceUploadURL response.
func (client *BuildServiceClient) getResourceUploadURLHandleResponse(resp *http.Response) (BuildServiceClientGetResourceUploadURLResponse, error) {
	result := BuildServiceClientGetResourceUploadURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceUploadDefinition); err != nil {
		return BuildServiceClientGetResourceUploadURLResponse{}, err
	}
	return result, nil
}

// GetSupportedBuildpack - Get the supported buildpack resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - buildpackName - The name of the buildpack resource.
//   - options - BuildServiceClientGetSupportedBuildpackOptions contains the optional parameters for the BuildServiceClient.GetSupportedBuildpack
//     method.
func (client *BuildServiceClient) GetSupportedBuildpack(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildpackName string, options *BuildServiceClientGetSupportedBuildpackOptions) (BuildServiceClientGetSupportedBuildpackResponse, error) {
	var err error
	const operationName = "BuildServiceClient.GetSupportedBuildpack"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getSupportedBuildpackCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildpackName, options)
	if err != nil {
		return BuildServiceClientGetSupportedBuildpackResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientGetSupportedBuildpackResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientGetSupportedBuildpackResponse{}, err
	}
	resp, err := client.getSupportedBuildpackHandleResponse(httpResp)
	return resp, err
}

// getSupportedBuildpackCreateRequest creates the GetSupportedBuildpack request.
func (client *BuildServiceClient) getSupportedBuildpackCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildpackName string, options *BuildServiceClientGetSupportedBuildpackOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedBuildpacks/{buildpackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildpackName == "" {
		return nil, errors.New("parameter buildpackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildpackName}", url.PathEscape(buildpackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSupportedBuildpackHandleResponse handles the GetSupportedBuildpack response.
func (client *BuildServiceClient) getSupportedBuildpackHandleResponse(resp *http.Response) (BuildServiceClientGetSupportedBuildpackResponse, error) {
	result := BuildServiceClientGetSupportedBuildpackResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SupportedBuildpackResource); err != nil {
		return BuildServiceClientGetSupportedBuildpackResponse{}, err
	}
	return result, nil
}

// GetSupportedStack - Get the supported stack resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - stackName - The name of the stack resource.
//   - options - BuildServiceClientGetSupportedStackOptions contains the optional parameters for the BuildServiceClient.GetSupportedStack
//     method.
func (client *BuildServiceClient) GetSupportedStack(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, stackName string, options *BuildServiceClientGetSupportedStackOptions) (BuildServiceClientGetSupportedStackResponse, error) {
	var err error
	const operationName = "BuildServiceClient.GetSupportedStack"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getSupportedStackCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, stackName, options)
	if err != nil {
		return BuildServiceClientGetSupportedStackResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientGetSupportedStackResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientGetSupportedStackResponse{}, err
	}
	resp, err := client.getSupportedStackHandleResponse(httpResp)
	return resp, err
}

// getSupportedStackCreateRequest creates the GetSupportedStack request.
func (client *BuildServiceClient) getSupportedStackCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, stackName string, options *BuildServiceClientGetSupportedStackOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedStacks/{stackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if stackName == "" {
		return nil, errors.New("parameter stackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{stackName}", url.PathEscape(stackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSupportedStackHandleResponse handles the GetSupportedStack response.
func (client *BuildServiceClient) getSupportedStackHandleResponse(resp *http.Response) (BuildServiceClientGetSupportedStackResponse, error) {
	result := BuildServiceClientGetSupportedStackResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SupportedStackResource); err != nil {
		return BuildServiceClientGetSupportedStackResponse{}, err
	}
	return result, nil
}

// NewListBuildResultsPager - List KPack build results.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - buildName - The name of the build resource.
//   - options - BuildServiceClientListBuildResultsOptions contains the optional parameters for the BuildServiceClient.NewListBuildResultsPager
//     method.
func (client *BuildServiceClient) NewListBuildResultsPager(resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientListBuildResultsOptions) *runtime.Pager[BuildServiceClientListBuildResultsResponse] {
	return runtime.NewPager(runtime.PagingHandler[BuildServiceClientListBuildResultsResponse]{
		More: func(page BuildServiceClientListBuildResultsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BuildServiceClientListBuildResultsResponse) (BuildServiceClientListBuildResultsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "BuildServiceClient.NewListBuildResultsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBuildResultsCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, buildName, options)
			}, nil)
			if err != nil {
				return BuildServiceClientListBuildResultsResponse{}, err
			}
			return client.listBuildResultsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBuildResultsCreateRequest creates the ListBuildResults request.
func (client *BuildServiceClient) listBuildResultsCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, options *BuildServiceClientListBuildResultsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	if buildName == "" {
		return nil, errors.New("parameter buildName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildName}", url.PathEscape(buildName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBuildResultsHandleResponse handles the ListBuildResults response.
func (client *BuildServiceClient) listBuildResultsHandleResponse(resp *http.Response) (BuildServiceClientListBuildResultsResponse, error) {
	result := BuildServiceClientListBuildResultsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildResultCollection); err != nil {
		return BuildServiceClientListBuildResultsResponse{}, err
	}
	return result, nil
}

// NewListBuildServicesPager - List build services resource.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - options - BuildServiceClientListBuildServicesOptions contains the optional parameters for the BuildServiceClient.NewListBuildServicesPager
//     method.
func (client *BuildServiceClient) NewListBuildServicesPager(resourceGroupName string, serviceName string, options *BuildServiceClientListBuildServicesOptions) *runtime.Pager[BuildServiceClientListBuildServicesResponse] {
	return runtime.NewPager(runtime.PagingHandler[BuildServiceClientListBuildServicesResponse]{
		More: func(page BuildServiceClientListBuildServicesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BuildServiceClientListBuildServicesResponse) (BuildServiceClientListBuildServicesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "BuildServiceClient.NewListBuildServicesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBuildServicesCreateRequest(ctx, resourceGroupName, serviceName, options)
			}, nil)
			if err != nil {
				return BuildServiceClientListBuildServicesResponse{}, err
			}
			return client.listBuildServicesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBuildServicesCreateRequest creates the ListBuildServices request.
func (client *BuildServiceClient) listBuildServicesCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, options *BuildServiceClientListBuildServicesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBuildServicesHandleResponse handles the ListBuildServices response.
func (client *BuildServiceClient) listBuildServicesHandleResponse(resp *http.Response) (BuildServiceClientListBuildServicesResponse, error) {
	result := BuildServiceClientListBuildServicesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildServiceCollection); err != nil {
		return BuildServiceClientListBuildServicesResponse{}, err
	}
	return result, nil
}

// NewListBuildsPager - List KPack builds.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - options - BuildServiceClientListBuildsOptions contains the optional parameters for the BuildServiceClient.NewListBuildsPager
//     method.
func (client *BuildServiceClient) NewListBuildsPager(resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListBuildsOptions) *runtime.Pager[BuildServiceClientListBuildsResponse] {
	return runtime.NewPager(runtime.PagingHandler[BuildServiceClientListBuildsResponse]{
		More: func(page BuildServiceClientListBuildsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BuildServiceClientListBuildsResponse) (BuildServiceClientListBuildsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "BuildServiceClient.NewListBuildsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBuildsCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
			}, nil)
			if err != nil {
				return BuildServiceClientListBuildsResponse{}, err
			}
			return client.listBuildsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBuildsCreateRequest creates the ListBuilds request.
func (client *BuildServiceClient) listBuildsCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListBuildsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBuildsHandleResponse handles the ListBuilds response.
func (client *BuildServiceClient) listBuildsHandleResponse(resp *http.Response) (BuildServiceClientListBuildsResponse, error) {
	result := BuildServiceClientListBuildsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BuildCollection); err != nil {
		return BuildServiceClientListBuildsResponse{}, err
	}
	return result, nil
}

// ListSupportedBuildpacks - Get all supported buildpacks.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - options - BuildServiceClientListSupportedBuildpacksOptions contains the optional parameters for the BuildServiceClient.ListSupportedBuildpacks
//     method.
func (client *BuildServiceClient) ListSupportedBuildpacks(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListSupportedBuildpacksOptions) (BuildServiceClientListSupportedBuildpacksResponse, error) {
	var err error
	const operationName = "BuildServiceClient.ListSupportedBuildpacks"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listSupportedBuildpacksCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
	if err != nil {
		return BuildServiceClientListSupportedBuildpacksResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientListSupportedBuildpacksResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientListSupportedBuildpacksResponse{}, err
	}
	resp, err := client.listSupportedBuildpacksHandleResponse(httpResp)
	return resp, err
}

// listSupportedBuildpacksCreateRequest creates the ListSupportedBuildpacks request.
func (client *BuildServiceClient) listSupportedBuildpacksCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListSupportedBuildpacksOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedBuildpacks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSupportedBuildpacksHandleResponse handles the ListSupportedBuildpacks response.
func (client *BuildServiceClient) listSupportedBuildpacksHandleResponse(resp *http.Response) (BuildServiceClientListSupportedBuildpacksResponse, error) {
	result := BuildServiceClientListSupportedBuildpacksResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SupportedBuildpacksCollection); err != nil {
		return BuildServiceClientListSupportedBuildpacksResponse{}, err
	}
	return result, nil
}

// ListSupportedStacks - Get all supported stacks.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serviceName - The name of the Service resource.
//   - buildServiceName - The name of the build service resource.
//   - options - BuildServiceClientListSupportedStacksOptions contains the optional parameters for the BuildServiceClient.ListSupportedStacks
//     method.
func (client *BuildServiceClient) ListSupportedStacks(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListSupportedStacksOptions) (BuildServiceClientListSupportedStacksResponse, error) {
	var err error
	const operationName = "BuildServiceClient.ListSupportedStacks"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listSupportedStacksCreateRequest(ctx, resourceGroupName, serviceName, buildServiceName, options)
	if err != nil {
		return BuildServiceClientListSupportedStacksResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BuildServiceClientListSupportedStacksResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BuildServiceClientListSupportedStacksResponse{}, err
	}
	resp, err := client.listSupportedStacksHandleResponse(httpResp)
	return resp, err
}

// listSupportedStacksCreateRequest creates the ListSupportedStacks request.
func (client *BuildServiceClient) listSupportedStacksCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, options *BuildServiceClientListSupportedStacksOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedStacks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if buildServiceName == "" {
		return nil, errors.New("parameter buildServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{buildServiceName}", url.PathEscape(buildServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSupportedStacksHandleResponse handles the ListSupportedStacks response.
func (client *BuildServiceClient) listSupportedStacksHandleResponse(resp *http.Response) (BuildServiceClientListSupportedStacksResponse, error) {
	result := BuildServiceClientListSupportedStacksResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SupportedStacksCollection); err != nil {
		return BuildServiceClientListSupportedStacksResponse{}, err
	}
	return result, nil
}
