//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
)

// CertificateOrdersServer is a fake server for instances of the armappservice.CertificateOrdersClient type.
type CertificateOrdersServer struct {
	// BeginCreateOrUpdate is the fake for method CertificateOrdersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName armappservice.CertificateOrder, options *armappservice.CertificateOrdersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armappservice.CertificateOrdersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateCertificate is the fake for method CertificateOrdersClient.BeginCreateOrUpdateCertificate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateCertificate func(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate armappservice.CertificateResource, options *armappservice.CertificateOrdersClientBeginCreateOrUpdateCertificateOptions) (resp azfake.PollerResponder[armappservice.CertificateOrdersClientCreateOrUpdateCertificateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method CertificateOrdersClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, certificateOrderName string, options *armappservice.CertificateOrdersClientDeleteOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteCertificate is the fake for method CertificateOrdersClient.DeleteCertificate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteCertificate func(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, options *armappservice.CertificateOrdersClientDeleteCertificateOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientDeleteCertificateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CertificateOrdersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, certificateOrderName string, options *armappservice.CertificateOrdersClientGetOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientGetResponse], errResp azfake.ErrorResponder)

	// GetCertificate is the fake for method CertificateOrdersClient.GetCertificate
	// HTTP status codes to indicate success: http.StatusOK
	GetCertificate func(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, options *armappservice.CertificateOrdersClientGetCertificateOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientGetCertificateResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CertificateOrdersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.CertificateOrdersClientListOptions) (resp azfake.PagerResponder[armappservice.CertificateOrdersClientListResponse])

	// NewListByResourceGroupPager is the fake for method CertificateOrdersClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armappservice.CertificateOrdersClientListByResourceGroupOptions) (resp azfake.PagerResponder[armappservice.CertificateOrdersClientListByResourceGroupResponse])

	// NewListCertificatesPager is the fake for method CertificateOrdersClient.NewListCertificatesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCertificatesPager func(resourceGroupName string, certificateOrderName string, options *armappservice.CertificateOrdersClientListCertificatesOptions) (resp azfake.PagerResponder[armappservice.CertificateOrdersClientListCertificatesResponse])

	// Reissue is the fake for method CertificateOrdersClient.Reissue
	// HTTP status codes to indicate success: http.StatusNoContent
	Reissue func(ctx context.Context, resourceGroupName string, certificateOrderName string, reissueCertificateOrderRequest armappservice.ReissueCertificateOrderRequest, options *armappservice.CertificateOrdersClientReissueOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientReissueResponse], errResp azfake.ErrorResponder)

	// Renew is the fake for method CertificateOrdersClient.Renew
	// HTTP status codes to indicate success: http.StatusNoContent
	Renew func(ctx context.Context, resourceGroupName string, certificateOrderName string, renewCertificateOrderRequest armappservice.RenewCertificateOrderRequest, options *armappservice.CertificateOrdersClientRenewOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientRenewResponse], errResp azfake.ErrorResponder)

	// ResendEmail is the fake for method CertificateOrdersClient.ResendEmail
	// HTTP status codes to indicate success: http.StatusNoContent
	ResendEmail func(ctx context.Context, resourceGroupName string, certificateOrderName string, options *armappservice.CertificateOrdersClientResendEmailOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientResendEmailResponse], errResp azfake.ErrorResponder)

	// ResendRequestEmails is the fake for method CertificateOrdersClient.ResendRequestEmails
	// HTTP status codes to indicate success: http.StatusNoContent
	ResendRequestEmails func(ctx context.Context, resourceGroupName string, certificateOrderName string, nameIdentifier armappservice.NameIdentifier, options *armappservice.CertificateOrdersClientResendRequestEmailsOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientResendRequestEmailsResponse], errResp azfake.ErrorResponder)

	// RetrieveCertificateActions is the fake for method CertificateOrdersClient.RetrieveCertificateActions
	// HTTP status codes to indicate success: http.StatusOK
	RetrieveCertificateActions func(ctx context.Context, resourceGroupName string, name string, options *armappservice.CertificateOrdersClientRetrieveCertificateActionsOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientRetrieveCertificateActionsResponse], errResp azfake.ErrorResponder)

	// RetrieveCertificateEmailHistory is the fake for method CertificateOrdersClient.RetrieveCertificateEmailHistory
	// HTTP status codes to indicate success: http.StatusOK
	RetrieveCertificateEmailHistory func(ctx context.Context, resourceGroupName string, name string, options *armappservice.CertificateOrdersClientRetrieveCertificateEmailHistoryOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientRetrieveCertificateEmailHistoryResponse], errResp azfake.ErrorResponder)

	// RetrieveSiteSeal is the fake for method CertificateOrdersClient.RetrieveSiteSeal
	// HTTP status codes to indicate success: http.StatusOK
	RetrieveSiteSeal func(ctx context.Context, resourceGroupName string, certificateOrderName string, siteSealRequest armappservice.SiteSealRequest, options *armappservice.CertificateOrdersClientRetrieveSiteSealOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientRetrieveSiteSealResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method CertificateOrdersClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName armappservice.CertificateOrderPatchResource, options *armappservice.CertificateOrdersClientUpdateOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateCertificate is the fake for method CertificateOrdersClient.UpdateCertificate
	// HTTP status codes to indicate success: http.StatusOK
	UpdateCertificate func(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate armappservice.CertificatePatchResource, options *armappservice.CertificateOrdersClientUpdateCertificateOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientUpdateCertificateResponse], errResp azfake.ErrorResponder)

	// ValidatePurchaseInformation is the fake for method CertificateOrdersClient.ValidatePurchaseInformation
	// HTTP status codes to indicate success: http.StatusNoContent
	ValidatePurchaseInformation func(ctx context.Context, appServiceCertificateOrder armappservice.CertificateOrder, options *armappservice.CertificateOrdersClientValidatePurchaseInformationOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientValidatePurchaseInformationResponse], errResp azfake.ErrorResponder)

	// VerifyDomainOwnership is the fake for method CertificateOrdersClient.VerifyDomainOwnership
	// HTTP status codes to indicate success: http.StatusNoContent
	VerifyDomainOwnership func(ctx context.Context, resourceGroupName string, certificateOrderName string, options *armappservice.CertificateOrdersClientVerifyDomainOwnershipOptions) (resp azfake.Responder[armappservice.CertificateOrdersClientVerifyDomainOwnershipResponse], errResp azfake.ErrorResponder)
}

// NewCertificateOrdersServerTransport creates a new instance of CertificateOrdersServerTransport with the provided implementation.
// The returned CertificateOrdersServerTransport instance is connected to an instance of armappservice.CertificateOrdersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCertificateOrdersServerTransport(srv *CertificateOrdersServer) *CertificateOrdersServerTransport {
	return &CertificateOrdersServerTransport{
		srv:                            srv,
		beginCreateOrUpdate:            newTracker[azfake.PollerResponder[armappservice.CertificateOrdersClientCreateOrUpdateResponse]](),
		beginCreateOrUpdateCertificate: newTracker[azfake.PollerResponder[armappservice.CertificateOrdersClientCreateOrUpdateCertificateResponse]](),
		newListPager:                   newTracker[azfake.PagerResponder[armappservice.CertificateOrdersClientListResponse]](),
		newListByResourceGroupPager:    newTracker[azfake.PagerResponder[armappservice.CertificateOrdersClientListByResourceGroupResponse]](),
		newListCertificatesPager:       newTracker[azfake.PagerResponder[armappservice.CertificateOrdersClientListCertificatesResponse]](),
	}
}

// CertificateOrdersServerTransport connects instances of armappservice.CertificateOrdersClient to instances of CertificateOrdersServer.
// Don't use this type directly, use NewCertificateOrdersServerTransport instead.
type CertificateOrdersServerTransport struct {
	srv                            *CertificateOrdersServer
	beginCreateOrUpdate            *tracker[azfake.PollerResponder[armappservice.CertificateOrdersClientCreateOrUpdateResponse]]
	beginCreateOrUpdateCertificate *tracker[azfake.PollerResponder[armappservice.CertificateOrdersClientCreateOrUpdateCertificateResponse]]
	newListPager                   *tracker[azfake.PagerResponder[armappservice.CertificateOrdersClientListResponse]]
	newListByResourceGroupPager    *tracker[azfake.PagerResponder[armappservice.CertificateOrdersClientListByResourceGroupResponse]]
	newListCertificatesPager       *tracker[azfake.PagerResponder[armappservice.CertificateOrdersClientListCertificatesResponse]]
}

// Do implements the policy.Transporter interface for CertificateOrdersServerTransport.
func (c *CertificateOrdersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CertificateOrdersClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "CertificateOrdersClient.BeginCreateOrUpdateCertificate":
		resp, err = c.dispatchBeginCreateOrUpdateCertificate(req)
	case "CertificateOrdersClient.Delete":
		resp, err = c.dispatchDelete(req)
	case "CertificateOrdersClient.DeleteCertificate":
		resp, err = c.dispatchDeleteCertificate(req)
	case "CertificateOrdersClient.Get":
		resp, err = c.dispatchGet(req)
	case "CertificateOrdersClient.GetCertificate":
		resp, err = c.dispatchGetCertificate(req)
	case "CertificateOrdersClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "CertificateOrdersClient.NewListByResourceGroupPager":
		resp, err = c.dispatchNewListByResourceGroupPager(req)
	case "CertificateOrdersClient.NewListCertificatesPager":
		resp, err = c.dispatchNewListCertificatesPager(req)
	case "CertificateOrdersClient.Reissue":
		resp, err = c.dispatchReissue(req)
	case "CertificateOrdersClient.Renew":
		resp, err = c.dispatchRenew(req)
	case "CertificateOrdersClient.ResendEmail":
		resp, err = c.dispatchResendEmail(req)
	case "CertificateOrdersClient.ResendRequestEmails":
		resp, err = c.dispatchResendRequestEmails(req)
	case "CertificateOrdersClient.RetrieveCertificateActions":
		resp, err = c.dispatchRetrieveCertificateActions(req)
	case "CertificateOrdersClient.RetrieveCertificateEmailHistory":
		resp, err = c.dispatchRetrieveCertificateEmailHistory(req)
	case "CertificateOrdersClient.RetrieveSiteSeal":
		resp, err = c.dispatchRetrieveSiteSeal(req)
	case "CertificateOrdersClient.Update":
		resp, err = c.dispatchUpdate(req)
	case "CertificateOrdersClient.UpdateCertificate":
		resp, err = c.dispatchUpdateCertificate(req)
	case "CertificateOrdersClient.ValidatePurchaseInformation":
		resp, err = c.dispatchValidatePurchaseInformation(req)
	case "CertificateOrdersClient.VerifyDomainOwnership":
		resp, err = c.dispatchVerifyDomainOwnership(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.CertificateOrder](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, certificateOrderNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchBeginCreateOrUpdateCertificate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdateCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateCertificate not implemented")}
	}
	beginCreateOrUpdateCertificate := c.beginCreateOrUpdateCertificate.get(req)
	if beginCreateOrUpdateCertificate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.CertificateResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdateCertificate(req.Context(), resourceGroupNameParam, certificateOrderNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateCertificate = &respr
		c.beginCreateOrUpdateCertificate.add(req, beginCreateOrUpdateCertificate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateCertificate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdateCertificate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateCertificate) {
		c.beginCreateOrUpdateCertificate.remove(req)
	}

	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if c.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Delete(req.Context(), resourceGroupNameParam, certificateOrderNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchDeleteCertificate(req *http.Request) (*http.Response, error) {
	if c.srv.DeleteCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteCertificate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.DeleteCertificate(req.Context(), resourceGroupNameParam, certificateOrderNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, certificateOrderNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateOrder, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchGetCertificate(req *http.Request) (*http.Response, error) {
	if c.srv.GetCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCertificate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetCertificate(req.Context(), resourceGroupNameParam, certificateOrderNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListPager(nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.CertificateOrdersClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := c.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		c.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armappservice.CertificateOrdersClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		c.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchNewListCertificatesPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListCertificatesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCertificatesPager not implemented")}
	}
	newListCertificatesPager := c.newListCertificatesPager.get(req)
	if newListCertificatesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListCertificatesPager(resourceGroupNameParam, certificateOrderNameParam, nil)
		newListCertificatesPager = &resp
		c.newListCertificatesPager.add(req, newListCertificatesPager)
		server.PagerResponderInjectNextLinks(newListCertificatesPager, req, func(page *armappservice.CertificateOrdersClientListCertificatesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCertificatesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListCertificatesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCertificatesPager) {
		c.newListCertificatesPager.remove(req)
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchReissue(req *http.Request) (*http.Response, error) {
	if c.srv.Reissue == nil {
		return nil, &nonRetriableError{errors.New("fake for method Reissue not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reissue`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.ReissueCertificateOrderRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Reissue(req.Context(), resourceGroupNameParam, certificateOrderNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchRenew(req *http.Request) (*http.Response, error) {
	if c.srv.Renew == nil {
		return nil, &nonRetriableError{errors.New("fake for method Renew not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/renew`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.RenewCertificateOrderRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Renew(req.Context(), resourceGroupNameParam, certificateOrderNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchResendEmail(req *http.Request) (*http.Response, error) {
	if c.srv.ResendEmail == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResendEmail not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resendEmail`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.ResendEmail(req.Context(), resourceGroupNameParam, certificateOrderNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchResendRequestEmails(req *http.Request) (*http.Response, error) {
	if c.srv.ResendRequestEmails == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResendRequestEmails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resendRequestEmails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.NameIdentifier](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.ResendRequestEmails(req.Context(), resourceGroupNameParam, certificateOrderNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchRetrieveCertificateActions(req *http.Request) (*http.Response, error) {
	if c.srv.RetrieveCertificateActions == nil {
		return nil, &nonRetriableError{errors.New("fake for method RetrieveCertificateActions not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveCertificateActions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.RetrieveCertificateActions(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateOrderActionArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchRetrieveCertificateEmailHistory(req *http.Request) (*http.Response, error) {
	if c.srv.RetrieveCertificateEmailHistory == nil {
		return nil, &nonRetriableError{errors.New("fake for method RetrieveCertificateEmailHistory not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveEmailHistory`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.RetrieveCertificateEmailHistory(req.Context(), resourceGroupNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateEmailArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchRetrieveSiteSeal(req *http.Request) (*http.Response, error) {
	if c.srv.RetrieveSiteSeal == nil {
		return nil, &nonRetriableError{errors.New("fake for method RetrieveSiteSeal not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveSiteSeal`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SiteSealRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.RetrieveSiteSeal(req.Context(), resourceGroupNameParam, certificateOrderNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SiteSeal, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CertificateOrderPatchResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Update(req.Context(), resourceGroupNameParam, certificateOrderNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateOrder, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchUpdateCertificate(req *http.Request) (*http.Response, error) {
	if c.srv.UpdateCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateCertificate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CertificatePatchResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.UpdateCertificate(req.Context(), resourceGroupNameParam, certificateOrderNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchValidatePurchaseInformation(req *http.Request) (*http.Response, error) {
	if c.srv.ValidatePurchaseInformation == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidatePurchaseInformation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/validateCertificateRegistrationInformation`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CertificateOrder](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.ValidatePurchaseInformation(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateOrdersServerTransport) dispatchVerifyDomainOwnership(req *http.Request) (*http.Response, error) {
	if c.srv.VerifyDomainOwnership == nil {
		return nil, &nonRetriableError{errors.New("fake for method VerifyDomainOwnership not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CertificateRegistration/certificateOrders/(?P<certificateOrderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/verifyDomainOwnership`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	certificateOrderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("certificateOrderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.VerifyDomainOwnership(req.Context(), resourceGroupNameParam, certificateOrderNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
