//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armattestation

import "time"

type JSONWebKey struct {
	// REQUIRED; The "kty" (key type) parameter identifies the cryptographic algorithm family used with the key, such as "RSA"
	// or "EC". "kty" values should either be registered in the IANA "JSON Web Key Types"
	// registry established by [JWA] or be a value that contains a Collision- Resistant Name. The "kty" value is a case-sensitive
	// string.
	Kty *string

	// The "alg" (algorithm) parameter identifies the algorithm intended for use with the key. The values used should either be
	// registered in the IANA "JSON Web Signature and Encryption Algorithms" registry
	// established by [JWA] or be a value that contains a Collision- Resistant Name.
	Alg *string

	// The "crv" (curve) parameter identifies the curve type
	Crv *string

	// RSA private exponent or ECC private key
	D *string

	// RSA Private Key Parameter
	Dp *string

	// RSA Private Key Parameter
	Dq *string

	// RSA public exponent, in Base64
	E *string

	// Symmetric key
	K *string

	// The "kid" (key ID) parameter is used to match a specific key. This is used, for instance, to choose among a set of keys
	// within a JWK Set during key rollover. The structure of the "kid" value is
	// unspecified. When "kid" values are used within a JWK Set, different keys within the JWK Set SHOULD use distinct "kid" values.
	// (One example in which different keys might use the same "kid" value is if
	// they have different "kty" (key type) values but are considered to be equivalent alternatives by the application using them.)
	// The "kid" value is a case-sensitive string.
	Kid *string

	// RSA modulus, in Base64
	N *string

	// RSA secret prime
	P *string

	// RSA secret prime, with p < q
	Q *string

	// RSA Private Key Parameter
	Qi *string

	// Use ("public key use") identifies the intended use of the public key. The "use" parameter is employed to indicate whether
	// a public key is used for encrypting data or verifying the signature on data.
	// Values are commonly "sig" (signature) or "enc" (encryption).
	Use *string

	// X coordinate for the Elliptic Curve point
	X *string

	// The "x5c" (X.509 certificate chain) parameter contains a chain of one or more PKIX certificates [RFC5280]. The certificate
	// chain is represented as a JSON array of certificate value strings. Each
	// string in the array is a base64-encoded (Section 4 of [RFC4648] -- not base64url-encoded) DER [ITU.X690.1994] PKIX certificate
	// value. The PKIX certificate containing the key value MUST be the first
	// certificate.
	X5C []*string

	// Y coordinate for the Elliptic Curve point
	Y *string
}

type JSONWebKeySet struct {
	// The value of the "keys" parameter is an array of JWK values. By default, the order of the JWK values within the array does
	// not imply an order of preference among them, although applications of JWK
	// Sets can choose to assign a meaning to the order for their purposes, if desired.
	Keys []*JSONWebKey
}

// OperationList - List of supported operations.
type OperationList struct {
	// List of supported operations.
	Value []*OperationsDefinition

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData
}

// OperationsDefinition - Definition object with the name and properties of an operation.
type OperationsDefinition struct {
	// Display object with properties of the operation.
	Display *OperationsDisplayDefinition

	// Name of the operation.
	Name *string
}

// OperationsDisplayDefinition - Display object with properties of the operation.
type OperationsDisplayDefinition struct {
	// Description of the operation.
	Description *string

	// Short description of the operation.
	Operation *string

	// Resource provider of the operation.
	Provider *string

	// Resource for the operation.
	Resource *string
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// Provider - Attestation service response message.
type Provider struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Describes Attestation service status.
	Properties *StatusResult

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProviderListResult - Attestation Providers List.
type ProviderListResult struct {
	// Attestation Provider array.
	Value []*Provider

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServiceCreationParams - Parameters for creating an attestation provider
type ServiceCreationParams struct {
	// REQUIRED; The supported Azure location where the attestation provider should be created.
	Location *string

	// REQUIRED; Properties of the attestation provider
	Properties *ServiceCreationSpecificParams

	// The tags that will be assigned to the attestation provider.
	Tags map[string]*string
}

// ServiceCreationSpecificParams - Client supplied parameters used to create a new attestation provider.
type ServiceCreationSpecificParams struct {
	// JSON Web Key Set defining a set of X.509 Certificates that will represent the parent certificate for the signing certificate
	// used for policy operations
	PolicySigningCertificates *JSONWebKeySet
}

// ServicePatchParams - Parameters for patching an attestation provider
type ServicePatchParams struct {
	// The tags that will be assigned to the attestation provider.
	Tags map[string]*string
}

// StatusResult - Status of attestation service.
type StatusResult struct {
	// Gets the uri of attestation service
	AttestURI *string

	// Status of attestation service.
	Status *AttestationServiceStatus

	// Trust model for the attestation provider.
	TrustModel *string

	// READ-ONLY; List of private endpoint connections associated with the attestation provider.
	PrivateEndpointConnections []*PrivateEndpointConnection
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}
