//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armauthorization_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/authorization/resource-manager/Microsoft.Authorization/preview/2022-05-01-preview/examples/DeleteRoleDefinition.json
func ExampleRoleDefinitionsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armauthorization.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRoleDefinitionsClient().Delete(ctx, "scope", "roleDefinitionId", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RoleDefinition = armauthorization.RoleDefinition{
	// 	Name: to.Ptr("roleDefinitionId"),
	// 	Type: to.Ptr("Microsoft.Authorization/roleDefinitions"),
	// 	ID: to.Ptr("/subscriptions/subID/providers/Microsoft.Authorization/roleDefinitions/roleDefinitionId"),
	// 	Properties: &armauthorization.RoleDefinitionProperties{
	// 		RoleType: to.Ptr("roletype"),
	// 		Description: to.Ptr("Role description"),
	// 		AssignableScopes: []*string{
	// 			to.Ptr("/subscriptions/subId")},
	// 			Permissions: []*armauthorization.Permission{
	// 				{
	// 					Actions: []*string{
	// 						to.Ptr("action")},
	// 						DataActions: []*string{
	// 							to.Ptr("dataAction")},
	// 							NotActions: []*string{
	// 							},
	// 							NotDataActions: []*string{
	// 							},
	// 					}},
	// 					RoleName: to.Ptr("Role name"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/authorization/resource-manager/Microsoft.Authorization/preview/2022-05-01-preview/examples/GetRoleDefinitionById.json
func ExampleRoleDefinitionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armauthorization.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRoleDefinitionsClient().Get(ctx, "scope", "roleDefinitionId", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RoleDefinition = armauthorization.RoleDefinition{
	// 	Name: to.Ptr("roleDefinitionId"),
	// 	Type: to.Ptr("Microsoft.Authorization/roleDefinitions"),
	// 	ID: to.Ptr("/subscriptions/subID/providers/Microsoft.Authorization/roleDefinitions/roleDefinitionId"),
	// 	Properties: &armauthorization.RoleDefinitionProperties{
	// 		RoleType: to.Ptr("roletype"),
	// 		Description: to.Ptr("Role description"),
	// 		AssignableScopes: []*string{
	// 			to.Ptr("/subscriptions/subId")},
	// 			Permissions: []*armauthorization.Permission{
	// 				{
	// 					Actions: []*string{
	// 						to.Ptr("action")},
	// 						DataActions: []*string{
	// 							to.Ptr("dataAction")},
	// 							NotActions: []*string{
	// 							},
	// 							NotDataActions: []*string{
	// 							},
	// 					}},
	// 					RoleName: to.Ptr("Role name"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/authorization/resource-manager/Microsoft.Authorization/preview/2022-05-01-preview/examples/PutRoleDefinition.json
func ExampleRoleDefinitionsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armauthorization.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewRoleDefinitionsClient().CreateOrUpdate(ctx, "scope", "roleDefinitionId", armauthorization.RoleDefinition{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/authorization/resource-manager/Microsoft.Authorization/preview/2022-05-01-preview/examples/GetRoleDefinitionAtScope.json
func ExampleRoleDefinitionsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armauthorization.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRoleDefinitionsClient().NewListPager("scope", &armauthorization.RoleDefinitionsClientListOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RoleDefinitionListResult = armauthorization.RoleDefinitionListResult{
		// 	Value: []*armauthorization.RoleDefinition{
		// 		{
		// 			Name: to.Ptr("roleDefinitionId"),
		// 			Type: to.Ptr("Microsoft.Authorization/roleDefinitions"),
		// 			ID: to.Ptr("/subscriptions/subID/providers/Microsoft.Authorization/roleDefinitions/roleDefinitionId"),
		// 			Properties: &armauthorization.RoleDefinitionProperties{
		// 				RoleType: to.Ptr("roletype"),
		// 				Description: to.Ptr("Role description"),
		// 				AssignableScopes: []*string{
		// 					to.Ptr("/subscriptions/subId")},
		// 					Permissions: []*armauthorization.Permission{
		// 						{
		// 							Actions: []*string{
		// 								to.Ptr("action")},
		// 								DataActions: []*string{
		// 									to.Ptr("dataAction")},
		// 									NotActions: []*string{
		// 									},
		// 									NotDataActions: []*string{
		// 									},
		// 							}},
		// 							RoleName: to.Ptr("Role name"),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/authorization/resource-manager/Microsoft.Authorization/preview/2022-05-01-preview/examples/GetRoleDefinitionByRoleId.json
func ExampleRoleDefinitionsClient_GetByID() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armauthorization.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRoleDefinitionsClient().GetByID(ctx, "roleDefinitionId", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RoleDefinition = armauthorization.RoleDefinition{
	// 	Name: to.Ptr("roleDefinitionId"),
	// 	Type: to.Ptr("Microsoft.Authorization/roleDefinitions"),
	// 	ID: to.Ptr("/subscriptions/subID/providers/Microsoft.Authorization/roleDefinitions/roleDefinitionId"),
	// 	Properties: &armauthorization.RoleDefinitionProperties{
	// 		RoleType: to.Ptr("roletype"),
	// 		Description: to.Ptr("Role description"),
	// 		AssignableScopes: []*string{
	// 			to.Ptr("/subscriptions/subId")},
	// 			Permissions: []*armauthorization.Permission{
	// 				{
	// 					Actions: []*string{
	// 						to.Ptr("action")},
	// 						DataActions: []*string{
	// 							to.Ptr("dataAction")},
	// 							NotActions: []*string{
	// 							},
	// 							NotDataActions: []*string{
	// 							},
	// 					}},
	// 					RoleName: to.Ptr("Role name"),
	// 				},
	// 			}
}
