//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"regexp"
)

// DeletedAutomationAccountsServer is a fake server for instances of the armautomation.DeletedAutomationAccountsClient type.
type DeletedAutomationAccountsServer struct {
	// ListBySubscription is the fake for method DeletedAutomationAccountsClient.ListBySubscription
	// HTTP status codes to indicate success: http.StatusOK
	ListBySubscription func(ctx context.Context, options *armautomation.DeletedAutomationAccountsClientListBySubscriptionOptions) (resp azfake.Responder[armautomation.DeletedAutomationAccountsClientListBySubscriptionResponse], errResp azfake.ErrorResponder)
}

// NewDeletedAutomationAccountsServerTransport creates a new instance of DeletedAutomationAccountsServerTransport with the provided implementation.
// The returned DeletedAutomationAccountsServerTransport instance is connected to an instance of armautomation.DeletedAutomationAccountsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeletedAutomationAccountsServerTransport(srv *DeletedAutomationAccountsServer) *DeletedAutomationAccountsServerTransport {
	return &DeletedAutomationAccountsServerTransport{srv: srv}
}

// DeletedAutomationAccountsServerTransport connects instances of armautomation.DeletedAutomationAccountsClient to instances of DeletedAutomationAccountsServer.
// Don't use this type directly, use NewDeletedAutomationAccountsServerTransport instead.
type DeletedAutomationAccountsServerTransport struct {
	srv *DeletedAutomationAccountsServer
}

// Do implements the policy.Transporter interface for DeletedAutomationAccountsServerTransport.
func (d *DeletedAutomationAccountsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeletedAutomationAccountsClient.ListBySubscription":
		resp, err = d.dispatchListBySubscription(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeletedAutomationAccountsServerTransport) dispatchListBySubscription(req *http.Request) (*http.Response, error) {
	if d.srv.ListBySubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListBySubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/deletedAutomationAccounts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := d.srv.ListBySubscription(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeletedAutomationAccountListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
