//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// HybridRunbookWorkersServer is a fake server for instances of the armautomation.HybridRunbookWorkersClient type.
type HybridRunbookWorkersServer struct {
	// Create is the fake for method HybridRunbookWorkersClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, hybridRunbookWorkerID string, hybridRunbookWorkerCreationParameters armautomation.HybridRunbookWorkerCreateParameters, options *armautomation.HybridRunbookWorkersClientCreateOptions) (resp azfake.Responder[armautomation.HybridRunbookWorkersClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method HybridRunbookWorkersClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, hybridRunbookWorkerID string, options *armautomation.HybridRunbookWorkersClientDeleteOptions) (resp azfake.Responder[armautomation.HybridRunbookWorkersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method HybridRunbookWorkersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, hybridRunbookWorkerID string, options *armautomation.HybridRunbookWorkersClientGetOptions) (resp azfake.Responder[armautomation.HybridRunbookWorkersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByHybridRunbookWorkerGroupPager is the fake for method HybridRunbookWorkersClient.NewListByHybridRunbookWorkerGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByHybridRunbookWorkerGroupPager func(resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, options *armautomation.HybridRunbookWorkersClientListByHybridRunbookWorkerGroupOptions) (resp azfake.PagerResponder[armautomation.HybridRunbookWorkersClientListByHybridRunbookWorkerGroupResponse])

	// Move is the fake for method HybridRunbookWorkersClient.Move
	// HTTP status codes to indicate success: http.StatusOK
	Move func(ctx context.Context, resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, hybridRunbookWorkerID string, hybridRunbookWorkerMoveParameters armautomation.HybridRunbookWorkerMoveParameters, options *armautomation.HybridRunbookWorkersClientMoveOptions) (resp azfake.Responder[armautomation.HybridRunbookWorkersClientMoveResponse], errResp azfake.ErrorResponder)
}

// NewHybridRunbookWorkersServerTransport creates a new instance of HybridRunbookWorkersServerTransport with the provided implementation.
// The returned HybridRunbookWorkersServerTransport instance is connected to an instance of armautomation.HybridRunbookWorkersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewHybridRunbookWorkersServerTransport(srv *HybridRunbookWorkersServer) *HybridRunbookWorkersServerTransport {
	return &HybridRunbookWorkersServerTransport{
		srv:                                    srv,
		newListByHybridRunbookWorkerGroupPager: newTracker[azfake.PagerResponder[armautomation.HybridRunbookWorkersClientListByHybridRunbookWorkerGroupResponse]](),
	}
}

// HybridRunbookWorkersServerTransport connects instances of armautomation.HybridRunbookWorkersClient to instances of HybridRunbookWorkersServer.
// Don't use this type directly, use NewHybridRunbookWorkersServerTransport instead.
type HybridRunbookWorkersServerTransport struct {
	srv                                    *HybridRunbookWorkersServer
	newListByHybridRunbookWorkerGroupPager *tracker[azfake.PagerResponder[armautomation.HybridRunbookWorkersClientListByHybridRunbookWorkerGroupResponse]]
}

// Do implements the policy.Transporter interface for HybridRunbookWorkersServerTransport.
func (h *HybridRunbookWorkersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "HybridRunbookWorkersClient.Create":
		resp, err = h.dispatchCreate(req)
	case "HybridRunbookWorkersClient.Delete":
		resp, err = h.dispatchDelete(req)
	case "HybridRunbookWorkersClient.Get":
		resp, err = h.dispatchGet(req)
	case "HybridRunbookWorkersClient.NewListByHybridRunbookWorkerGroupPager":
		resp, err = h.dispatchNewListByHybridRunbookWorkerGroupPager(req)
	case "HybridRunbookWorkersClient.Move":
		resp, err = h.dispatchMove(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (h *HybridRunbookWorkersServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if h.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkers/(?P<hybridRunbookWorkerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomation.HybridRunbookWorkerCreateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Create(req.Context(), resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, hybridRunbookWorkerIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridRunbookWorker, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HybridRunbookWorkersServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if h.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkers/(?P<hybridRunbookWorkerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Delete(req.Context(), resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, hybridRunbookWorkerIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HybridRunbookWorkersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if h.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkers/(?P<hybridRunbookWorkerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Get(req.Context(), resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, hybridRunbookWorkerIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridRunbookWorker, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HybridRunbookWorkersServerTransport) dispatchNewListByHybridRunbookWorkerGroupPager(req *http.Request) (*http.Response, error) {
	if h.srv.NewListByHybridRunbookWorkerGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByHybridRunbookWorkerGroupPager not implemented")}
	}
	newListByHybridRunbookWorkerGroupPager := h.newListByHybridRunbookWorkerGroupPager.get(req)
	if newListByHybridRunbookWorkerGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armautomation.HybridRunbookWorkersClientListByHybridRunbookWorkerGroupOptions
		if filterParam != nil {
			options = &armautomation.HybridRunbookWorkersClientListByHybridRunbookWorkerGroupOptions{
				Filter: filterParam,
			}
		}
		resp := h.srv.NewListByHybridRunbookWorkerGroupPager(resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, options)
		newListByHybridRunbookWorkerGroupPager = &resp
		h.newListByHybridRunbookWorkerGroupPager.add(req, newListByHybridRunbookWorkerGroupPager)
		server.PagerResponderInjectNextLinks(newListByHybridRunbookWorkerGroupPager, req, func(page *armautomation.HybridRunbookWorkersClientListByHybridRunbookWorkerGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByHybridRunbookWorkerGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		h.newListByHybridRunbookWorkerGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByHybridRunbookWorkerGroupPager) {
		h.newListByHybridRunbookWorkerGroupPager.remove(req)
	}
	return resp, nil
}

func (h *HybridRunbookWorkersServerTransport) dispatchMove(req *http.Request) (*http.Response, error) {
	if h.srv.Move == nil {
		return nil, &nonRetriableError{errors.New("fake for method Move not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkers/(?P<hybridRunbookWorkerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/move`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomation.HybridRunbookWorkerMoveParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Move(req.Context(), resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, hybridRunbookWorkerIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
