//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// StatisticsServer is a fake server for instances of the armautomation.StatisticsClient type.
type StatisticsServer struct {
	// NewListByAutomationAccountPager is the fake for method StatisticsClient.NewListByAutomationAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAutomationAccountPager func(resourceGroupName string, automationAccountName string, options *armautomation.StatisticsClientListByAutomationAccountOptions) (resp azfake.PagerResponder[armautomation.StatisticsClientListByAutomationAccountResponse])
}

// NewStatisticsServerTransport creates a new instance of StatisticsServerTransport with the provided implementation.
// The returned StatisticsServerTransport instance is connected to an instance of armautomation.StatisticsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStatisticsServerTransport(srv *StatisticsServer) *StatisticsServerTransport {
	return &StatisticsServerTransport{
		srv:                             srv,
		newListByAutomationAccountPager: newTracker[azfake.PagerResponder[armautomation.StatisticsClientListByAutomationAccountResponse]](),
	}
}

// StatisticsServerTransport connects instances of armautomation.StatisticsClient to instances of StatisticsServer.
// Don't use this type directly, use NewStatisticsServerTransport instead.
type StatisticsServerTransport struct {
	srv                             *StatisticsServer
	newListByAutomationAccountPager *tracker[azfake.PagerResponder[armautomation.StatisticsClientListByAutomationAccountResponse]]
}

// Do implements the policy.Transporter interface for StatisticsServerTransport.
func (s *StatisticsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StatisticsClient.NewListByAutomationAccountPager":
		resp, err = s.dispatchNewListByAutomationAccountPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StatisticsServerTransport) dispatchNewListByAutomationAccountPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByAutomationAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAutomationAccountPager not implemented")}
	}
	newListByAutomationAccountPager := s.newListByAutomationAccountPager.get(req)
	if newListByAutomationAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/statistics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armautomation.StatisticsClientListByAutomationAccountOptions
		if filterParam != nil {
			options = &armautomation.StatisticsClientListByAutomationAccountOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListByAutomationAccountPager(resourceGroupNameParam, automationAccountNameParam, options)
		newListByAutomationAccountPager = &resp
		s.newListByAutomationAccountPager.add(req, newListByAutomationAccountPager)
	}
	resp, err := server.PagerResponderNext(newListByAutomationAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByAutomationAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAutomationAccountPager) {
		s.newListByAutomationAccountPager.remove(req)
	}
	return resp, nil
}
