//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/azurearcdata/armazurearcdata"
	"net/http"
	"net/url"
	"regexp"
)

// ActiveDirectoryConnectorsServer is a fake server for instances of the armazurearcdata.ActiveDirectoryConnectorsClient type.
type ActiveDirectoryConnectorsServer struct {
	// BeginCreate is the fake for method ActiveDirectoryConnectorsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, dataControllerName string, activeDirectoryConnectorName string, activeDirectoryConnectorResource armazurearcdata.ActiveDirectoryConnectorResource, options *armazurearcdata.ActiveDirectoryConnectorsClientBeginCreateOptions) (resp azfake.PollerResponder[armazurearcdata.ActiveDirectoryConnectorsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ActiveDirectoryConnectorsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, dataControllerName string, activeDirectoryConnectorName string, options *armazurearcdata.ActiveDirectoryConnectorsClientBeginDeleteOptions) (resp azfake.PollerResponder[armazurearcdata.ActiveDirectoryConnectorsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ActiveDirectoryConnectorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, dataControllerName string, activeDirectoryConnectorName string, options *armazurearcdata.ActiveDirectoryConnectorsClientGetOptions) (resp azfake.Responder[armazurearcdata.ActiveDirectoryConnectorsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ActiveDirectoryConnectorsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, dataControllerName string, options *armazurearcdata.ActiveDirectoryConnectorsClientListOptions) (resp azfake.PagerResponder[armazurearcdata.ActiveDirectoryConnectorsClientListResponse])
}

// NewActiveDirectoryConnectorsServerTransport creates a new instance of ActiveDirectoryConnectorsServerTransport with the provided implementation.
// The returned ActiveDirectoryConnectorsServerTransport instance is connected to an instance of armazurearcdata.ActiveDirectoryConnectorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewActiveDirectoryConnectorsServerTransport(srv *ActiveDirectoryConnectorsServer) *ActiveDirectoryConnectorsServerTransport {
	return &ActiveDirectoryConnectorsServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armazurearcdata.ActiveDirectoryConnectorsClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armazurearcdata.ActiveDirectoryConnectorsClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armazurearcdata.ActiveDirectoryConnectorsClientListResponse]](),
	}
}

// ActiveDirectoryConnectorsServerTransport connects instances of armazurearcdata.ActiveDirectoryConnectorsClient to instances of ActiveDirectoryConnectorsServer.
// Don't use this type directly, use NewActiveDirectoryConnectorsServerTransport instead.
type ActiveDirectoryConnectorsServerTransport struct {
	srv          *ActiveDirectoryConnectorsServer
	beginCreate  *tracker[azfake.PollerResponder[armazurearcdata.ActiveDirectoryConnectorsClientCreateResponse]]
	beginDelete  *tracker[azfake.PollerResponder[armazurearcdata.ActiveDirectoryConnectorsClientDeleteResponse]]
	newListPager *tracker[azfake.PagerResponder[armazurearcdata.ActiveDirectoryConnectorsClientListResponse]]
}

// Do implements the policy.Transporter interface for ActiveDirectoryConnectorsServerTransport.
func (a *ActiveDirectoryConnectorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ActiveDirectoryConnectorsClient.BeginCreate":
		resp, err = a.dispatchBeginCreate(req)
	case "ActiveDirectoryConnectorsClient.BeginDelete":
		resp, err = a.dispatchBeginDelete(req)
	case "ActiveDirectoryConnectorsClient.Get":
		resp, err = a.dispatchGet(req)
	case "ActiveDirectoryConnectorsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ActiveDirectoryConnectorsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := a.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers/(?P<dataControllerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/activeDirectoryConnectors/(?P<activeDirectoryConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armazurearcdata.ActiveDirectoryConnectorResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataControllerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataControllerName")])
		if err != nil {
			return nil, err
		}
		activeDirectoryConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("activeDirectoryConnectorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreate(req.Context(), resourceGroupNameParam, dataControllerNameParam, activeDirectoryConnectorNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		a.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		a.beginCreate.remove(req)
	}

	return resp, nil
}

func (a *ActiveDirectoryConnectorsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := a.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers/(?P<dataControllerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/activeDirectoryConnectors/(?P<activeDirectoryConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataControllerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataControllerName")])
		if err != nil {
			return nil, err
		}
		activeDirectoryConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("activeDirectoryConnectorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDelete(req.Context(), resourceGroupNameParam, dataControllerNameParam, activeDirectoryConnectorNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		a.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		a.beginDelete.remove(req)
	}

	return resp, nil
}

func (a *ActiveDirectoryConnectorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers/(?P<dataControllerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/activeDirectoryConnectors/(?P<activeDirectoryConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataControllerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataControllerName")])
	if err != nil {
		return nil, err
	}
	activeDirectoryConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("activeDirectoryConnectorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, dataControllerNameParam, activeDirectoryConnectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ActiveDirectoryConnectorResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ActiveDirectoryConnectorsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers/(?P<dataControllerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/activeDirectoryConnectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataControllerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataControllerName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(resourceGroupNameParam, dataControllerNameParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armazurearcdata.ActiveDirectoryConnectorsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
