//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/azurearcdata/armazurearcdata"
	"net/http"
	"net/url"
	"regexp"
)

// DataControllersServer is a fake server for instances of the armazurearcdata.DataControllersClient type.
type DataControllersServer struct {
	// BeginDeleteDataController is the fake for method DataControllersClient.BeginDeleteDataController
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteDataController func(ctx context.Context, resourceGroupName string, dataControllerName string, options *armazurearcdata.DataControllersClientBeginDeleteDataControllerOptions) (resp azfake.PollerResponder[armazurearcdata.DataControllersClientDeleteDataControllerResponse], errResp azfake.ErrorResponder)

	// GetDataController is the fake for method DataControllersClient.GetDataController
	// HTTP status codes to indicate success: http.StatusOK
	GetDataController func(ctx context.Context, resourceGroupName string, dataControllerName string, options *armazurearcdata.DataControllersClientGetDataControllerOptions) (resp azfake.Responder[armazurearcdata.DataControllersClientGetDataControllerResponse], errResp azfake.ErrorResponder)

	// NewListInGroupPager is the fake for method DataControllersClient.NewListInGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInGroupPager func(resourceGroupName string, options *armazurearcdata.DataControllersClientListInGroupOptions) (resp azfake.PagerResponder[armazurearcdata.DataControllersClientListInGroupResponse])

	// NewListInSubscriptionPager is the fake for method DataControllersClient.NewListInSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInSubscriptionPager func(options *armazurearcdata.DataControllersClientListInSubscriptionOptions) (resp azfake.PagerResponder[armazurearcdata.DataControllersClientListInSubscriptionResponse])

	// BeginPatchDataController is the fake for method DataControllersClient.BeginPatchDataController
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPatchDataController func(ctx context.Context, resourceGroupName string, dataControllerName string, dataControllerResource armazurearcdata.DataControllerUpdate, options *armazurearcdata.DataControllersClientBeginPatchDataControllerOptions) (resp azfake.PollerResponder[armazurearcdata.DataControllersClientPatchDataControllerResponse], errResp azfake.ErrorResponder)

	// BeginPutDataController is the fake for method DataControllersClient.BeginPutDataController
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginPutDataController func(ctx context.Context, resourceGroupName string, dataControllerName string, dataControllerResource armazurearcdata.DataControllerResource, options *armazurearcdata.DataControllersClientBeginPutDataControllerOptions) (resp azfake.PollerResponder[armazurearcdata.DataControllersClientPutDataControllerResponse], errResp azfake.ErrorResponder)
}

// NewDataControllersServerTransport creates a new instance of DataControllersServerTransport with the provided implementation.
// The returned DataControllersServerTransport instance is connected to an instance of armazurearcdata.DataControllersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataControllersServerTransport(srv *DataControllersServer) *DataControllersServerTransport {
	return &DataControllersServerTransport{
		srv:                        srv,
		beginDeleteDataController:  newTracker[azfake.PollerResponder[armazurearcdata.DataControllersClientDeleteDataControllerResponse]](),
		newListInGroupPager:        newTracker[azfake.PagerResponder[armazurearcdata.DataControllersClientListInGroupResponse]](),
		newListInSubscriptionPager: newTracker[azfake.PagerResponder[armazurearcdata.DataControllersClientListInSubscriptionResponse]](),
		beginPatchDataController:   newTracker[azfake.PollerResponder[armazurearcdata.DataControllersClientPatchDataControllerResponse]](),
		beginPutDataController:     newTracker[azfake.PollerResponder[armazurearcdata.DataControllersClientPutDataControllerResponse]](),
	}
}

// DataControllersServerTransport connects instances of armazurearcdata.DataControllersClient to instances of DataControllersServer.
// Don't use this type directly, use NewDataControllersServerTransport instead.
type DataControllersServerTransport struct {
	srv                        *DataControllersServer
	beginDeleteDataController  *tracker[azfake.PollerResponder[armazurearcdata.DataControllersClientDeleteDataControllerResponse]]
	newListInGroupPager        *tracker[azfake.PagerResponder[armazurearcdata.DataControllersClientListInGroupResponse]]
	newListInSubscriptionPager *tracker[azfake.PagerResponder[armazurearcdata.DataControllersClientListInSubscriptionResponse]]
	beginPatchDataController   *tracker[azfake.PollerResponder[armazurearcdata.DataControllersClientPatchDataControllerResponse]]
	beginPutDataController     *tracker[azfake.PollerResponder[armazurearcdata.DataControllersClientPutDataControllerResponse]]
}

// Do implements the policy.Transporter interface for DataControllersServerTransport.
func (d *DataControllersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataControllersClient.BeginDeleteDataController":
		resp, err = d.dispatchBeginDeleteDataController(req)
	case "DataControllersClient.GetDataController":
		resp, err = d.dispatchGetDataController(req)
	case "DataControllersClient.NewListInGroupPager":
		resp, err = d.dispatchNewListInGroupPager(req)
	case "DataControllersClient.NewListInSubscriptionPager":
		resp, err = d.dispatchNewListInSubscriptionPager(req)
	case "DataControllersClient.BeginPatchDataController":
		resp, err = d.dispatchBeginPatchDataController(req)
	case "DataControllersClient.BeginPutDataController":
		resp, err = d.dispatchBeginPutDataController(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataControllersServerTransport) dispatchBeginDeleteDataController(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeleteDataController == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteDataController not implemented")}
	}
	beginDeleteDataController := d.beginDeleteDataController.get(req)
	if beginDeleteDataController == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers/(?P<dataControllerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataControllerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataControllerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeleteDataController(req.Context(), resourceGroupNameParam, dataControllerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteDataController = &respr
		d.beginDeleteDataController.add(req, beginDeleteDataController)
	}

	resp, err := server.PollerResponderNext(beginDeleteDataController, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeleteDataController.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteDataController) {
		d.beginDeleteDataController.remove(req)
	}

	return resp, nil
}

func (d *DataControllersServerTransport) dispatchGetDataController(req *http.Request) (*http.Response, error) {
	if d.srv.GetDataController == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDataController not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers/(?P<dataControllerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataControllerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataControllerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetDataController(req.Context(), resourceGroupNameParam, dataControllerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataControllerResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataControllersServerTransport) dispatchNewListInGroupPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListInGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInGroupPager not implemented")}
	}
	newListInGroupPager := d.newListInGroupPager.get(req)
	if newListInGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListInGroupPager(resourceGroupNameParam, nil)
		newListInGroupPager = &resp
		d.newListInGroupPager.add(req, newListInGroupPager)
		server.PagerResponderInjectNextLinks(newListInGroupPager, req, func(page *armazurearcdata.DataControllersClientListInGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListInGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInGroupPager) {
		d.newListInGroupPager.remove(req)
	}
	return resp, nil
}

func (d *DataControllersServerTransport) dispatchNewListInSubscriptionPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListInSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInSubscriptionPager not implemented")}
	}
	newListInSubscriptionPager := d.newListInSubscriptionPager.get(req)
	if newListInSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := d.srv.NewListInSubscriptionPager(nil)
		newListInSubscriptionPager = &resp
		d.newListInSubscriptionPager.add(req, newListInSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListInSubscriptionPager, req, func(page *armazurearcdata.DataControllersClientListInSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListInSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInSubscriptionPager) {
		d.newListInSubscriptionPager.remove(req)
	}
	return resp, nil
}

func (d *DataControllersServerTransport) dispatchBeginPatchDataController(req *http.Request) (*http.Response, error) {
	if d.srv.BeginPatchDataController == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPatchDataController not implemented")}
	}
	beginPatchDataController := d.beginPatchDataController.get(req)
	if beginPatchDataController == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers/(?P<dataControllerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armazurearcdata.DataControllerUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataControllerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataControllerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginPatchDataController(req.Context(), resourceGroupNameParam, dataControllerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPatchDataController = &respr
		d.beginPatchDataController.add(req, beginPatchDataController)
	}

	resp, err := server.PollerResponderNext(beginPatchDataController, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginPatchDataController.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPatchDataController) {
		d.beginPatchDataController.remove(req)
	}

	return resp, nil
}

func (d *DataControllersServerTransport) dispatchBeginPutDataController(req *http.Request) (*http.Response, error) {
	if d.srv.BeginPutDataController == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPutDataController not implemented")}
	}
	beginPutDataController := d.beginPutDataController.get(req)
	if beginPutDataController == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureArcData/dataControllers/(?P<dataControllerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armazurearcdata.DataControllerResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataControllerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataControllerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginPutDataController(req.Context(), resourceGroupNameParam, dataControllerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPutDataController = &respr
		d.beginPutDataController.add(req, beginPutDataController)
	}

	resp, err := server.PollerResponderNext(beginPutDataController, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginPutDataController.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPutDataController) {
		d.beginPutDataController.remove(req)
	}

	return resp, nil
}
