//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbilling_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingAccountInvoicesList.json
func ExampleInvoicesClient_NewListByBillingAccountPager_billingAccountInvoicesList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewInvoicesClient().NewListByBillingAccountPager("{billingAccountName}", "2018-01-01", "2018-06-30", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.InvoiceListResult = armbilling.InvoiceListResult{
		// 	Value: []*armbilling.Invoice{
		// 		{
		// 			Name: to.Ptr("1383723"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/1383723"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](8.53),
		// 				},
		// 				AzurePrepaymentApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](25.46),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CreditAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](1),
		// 				},
		// 				DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeInvoice),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/invoice.pdf"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
		// 				FreeAzureCreditApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				IsMonthlyInvoice: to.Ptr(false),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](1),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				Status: to.Ptr(armbilling.InvoiceStatusDue),
		// 				SubTotal: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				TaxAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				TotalAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](7.53),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("1383724"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/1383724"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](16.53),
		// 				},
		// 				AzurePrepaymentApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](15.46),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CreditAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](2),
		// 				},
		// 				DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/taxreceipt.pdf"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-01T17:32:28.000Z"); return t}()),
		// 				FreeAzureCreditApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-28T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
		// 				IsMonthlyInvoice: to.Ptr(true),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](2),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				Status: to.Ptr(armbilling.InvoiceStatus("PastDue")),
		// 				SubTotal: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				TaxAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				TotalAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](16.53),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingAccountInvoicesListWithRebillDetails.json
func ExampleInvoicesClient_NewListByBillingAccountPager_billingAccountInvoicesListWithRebillDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewInvoicesClient().NewListByBillingAccountPager("{billingAccountName}", "2018-01-01", "2018-06-30", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.InvoiceListResult = armbilling.InvoiceListResult{
		// 	Value: []*armbilling.Invoice{
		// 		{
		// 			Name: to.Ptr("I000003"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/I000003"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](8.53),
		// 				},
		// 				AzurePrepaymentApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](25.46),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CreditAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](1),
		// 				},
		// 				DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeInvoice),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/invoice.pdf"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
		// 				FreeAzureCreditApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				IsMonthlyInvoice: to.Ptr(false),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](1),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				RebillDetails: map[string]*armbilling.RebillDetails{
		// 					"creditNoteDocumentId": &armbilling.RebillDetails{
		// 					},
		// 					"invoiceDocumentId": &armbilling.RebillDetails{
		// 					},
		// 					"rebillDetails": &armbilling.RebillDetails{
		// 					},
		// 				},
		// 				Status: to.Ptr(armbilling.InvoiceStatusDue),
		// 				SubTotal: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				TaxAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				TotalAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](7.53),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("1383724"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/1383724"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](16.53),
		// 				},
		// 				AzurePrepaymentApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](15.46),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				CreditAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](2),
		// 				},
		// 				DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/taxreceipt.pdf"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-01T17:32:28.000Z"); return t}()),
		// 				FreeAzureCreditApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-28T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
		// 				IsMonthlyInvoice: to.Ptr(true),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](2),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				Status: to.Ptr(armbilling.InvoiceStatus("PastDue")),
		// 				SubTotal: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				TaxAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				TotalAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](16.53),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/InvoicesListByBillingProfile.json
func ExampleInvoicesClient_NewListByBillingProfilePager_invoicesListByBillingProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewInvoicesClient().NewListByBillingProfilePager("{billingAccountName}", "{billingProfileName}", "2018-01-01", "2018-06-30", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.InvoiceListResult = armbilling.InvoiceListResult{
		// 	Value: []*armbilling.Invoice{
		// 		{
		// 			Name: to.Ptr("1383723"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/1383723"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](8.53),
		// 				},
		// 				AzurePrepaymentApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](25.46),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
		// 				CreditAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](1),
		// 				},
		// 				DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeInvoice),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/invoice.pdf"),
		// 					},
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
		// 				FreeAzureCreditApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				IsMonthlyInvoice: to.Ptr(false),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](1),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				Status: to.Ptr(armbilling.InvoiceStatusDue),
		// 				SubTotal: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				TaxAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				TotalAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](7.53),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("1383724"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/1383724"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](16.53),
		// 				},
		// 				AzurePrepaymentApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](15.46),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
		// 				CreditAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](2),
		// 				},
		// 				DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeInvoice),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/invoice.pdf"),
		// 					},
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-01T17:32:28.000Z"); return t}()),
		// 				FreeAzureCreditApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-28T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
		// 				IsMonthlyInvoice: to.Ptr(true),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](2),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				Status: to.Ptr(armbilling.InvoiceStatusDue),
		// 				SubTotal: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				TaxAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				TotalAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](16.53),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/InvoicesListByBillingProfileWithRebillDetails.json
func ExampleInvoicesClient_NewListByBillingProfilePager_invoicesListByBillingProfileWithRebillDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewInvoicesClient().NewListByBillingProfilePager("{billingAccountName}", "{billingProfileName}", "2018-01-01", "2018-06-30", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.InvoiceListResult = armbilling.InvoiceListResult{
		// 	Value: []*armbilling.Invoice{
		// 		{
		// 			Name: to.Ptr("I000003"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/I000003"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](8.53),
		// 				},
		// 				AzurePrepaymentApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](25.46),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
		// 				CreditAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](1),
		// 				},
		// 				DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeInvoice),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/invoice.pdf"),
		// 					},
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
		// 				FreeAzureCreditApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				IsMonthlyInvoice: to.Ptr(false),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](1),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				RebillDetails: map[string]*armbilling.RebillDetails{
		// 					"creditNoteDocumentId": &armbilling.RebillDetails{
		// 					},
		// 					"invoiceDocumentId": &armbilling.RebillDetails{
		// 					},
		// 					"rebillDetails": &armbilling.RebillDetails{
		// 					},
		// 				},
		// 				Status: to.Ptr(armbilling.InvoiceStatusDue),
		// 				SubTotal: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				TaxAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				TotalAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](7.53),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("1383724"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/1383724"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](16.53),
		// 				},
		// 				AzurePrepaymentApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](15.46),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
		// 				CreditAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](2),
		// 				},
		// 				DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeInvoice),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/invoice.pdf"),
		// 					},
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-01T17:32:28.000Z"); return t}()),
		// 				FreeAzureCreditApplied: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-28T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
		// 				IsMonthlyInvoice: to.Ptr(true),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](2),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				Status: to.Ptr(armbilling.InvoiceStatusDue),
		// 				SubTotal: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](33.99),
		// 				},
		// 				TaxAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](0),
		// 				},
		// 				TotalAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](16.53),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/CreditNote.json
func ExampleInvoicesClient_Get_creditNote() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInvoicesClient().Get(ctx, "{billingAccountName}", "{invoiceName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Invoice = armbilling.Invoice{
	// 	Name: to.Ptr("{invoiceName}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}"),
	// 	Properties: &armbilling.InvoiceProperties{
	// 		AmountDue: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 		AzurePrepaymentApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](15.46),
	// 		},
	// 		BilledAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
	// 		CreditAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](2),
	// 		},
	// 		CreditForDocumentID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/I000001"),
	// 		DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeCreditNote),
	// 		Documents: []*armbilling.Document{
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeInvoice),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/invoice.pdf"),
	// 			},
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
	// 		}},
	// 		DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
	// 		FreeAzureCreditApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		IsMonthlyInvoice: to.Ptr(false),
	// 		Payments: []*armbilling.PaymentProperties{
	// 			{
	// 				Amount: &armbilling.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float32](2),
	// 				},
	// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
	// 				PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
	// 				PaymentMethodType: to.Ptr("visa"),
	// 				PaymentType: to.Ptr("credited"),
	// 		}},
	// 		PurchaseOrderNumber: to.Ptr("123456"),
	// 		Status: to.Ptr(armbilling.InvoiceStatusPaid),
	// 		SubTotal: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		TaxAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		TotalAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/Invoice.json
func ExampleInvoicesClient_Get_invoice() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInvoicesClient().Get(ctx, "{billingAccountName}", "{invoiceName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Invoice = armbilling.Invoice{
	// 	Name: to.Ptr("{invoiceName}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}"),
	// 	Properties: &armbilling.InvoiceProperties{
	// 		AmountDue: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 		AzurePrepaymentApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](15.46),
	// 		},
	// 		BilledAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
	// 		CreditAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](2),
	// 		},
	// 		DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
	// 		Documents: []*armbilling.Document{
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeInvoice),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/invoice.pdf"),
	// 			},
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
	// 		}},
	// 		DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
	// 		FreeAzureCreditApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		IsMonthlyInvoice: to.Ptr(false),
	// 		Payments: []*armbilling.PaymentProperties{
	// 			{
	// 				Amount: &armbilling.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float32](2),
	// 				},
	// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
	// 				PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
	// 				PaymentMethodType: to.Ptr("visa"),
	// 				PaymentType: to.Ptr("credited"),
	// 		}},
	// 		PurchaseOrderNumber: to.Ptr("123456"),
	// 		Status: to.Ptr(armbilling.InvoiceStatusDue),
	// 		SubTotal: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		TaxAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		TotalAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/InvoiceWithRebillDetails.json
func ExampleInvoicesClient_Get_invoiceWithRebillDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInvoicesClient().Get(ctx, "{billingAccountName}", "{invoiceName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Invoice = armbilling.Invoice{
	// 	Name: to.Ptr("{invoiceName}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}"),
	// 	Properties: &armbilling.InvoiceProperties{
	// 		AmountDue: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 		AzurePrepaymentApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](15.46),
	// 		},
	// 		BilledAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
	// 		CreditAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](2),
	// 		},
	// 		DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
	// 		Documents: []*armbilling.Document{
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeInvoice),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/invoice.pdf"),
	// 			},
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
	// 		}},
	// 		DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
	// 		FreeAzureCreditApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		IsMonthlyInvoice: to.Ptr(false),
	// 		Payments: []*armbilling.PaymentProperties{
	// 			{
	// 				Amount: &armbilling.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float32](2),
	// 				},
	// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
	// 				PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
	// 				PaymentMethodType: to.Ptr("visa"),
	// 				PaymentType: to.Ptr("credited"),
	// 		}},
	// 		PurchaseOrderNumber: to.Ptr("123456"),
	// 		RebillDetails: map[string]*armbilling.RebillDetails{
	// 			"creditNoteDocumentId": &armbilling.RebillDetails{
	// 			},
	// 			"invoiceDocumentId": &armbilling.RebillDetails{
	// 			},
	// 			"rebillDetails": &armbilling.RebillDetails{
	// 			},
	// 		},
	// 		Status: to.Ptr(armbilling.InvoiceStatusDue),
	// 		SubTotal: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		TaxAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		TotalAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/VoidInvoice.json
func ExampleInvoicesClient_Get_voidInvoice() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInvoicesClient().Get(ctx, "{billingAccountName}", "{invoiceName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Invoice = armbilling.Invoice{
	// 	Name: to.Ptr("{invoiceName}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}"),
	// 	Properties: &armbilling.InvoiceProperties{
	// 		AmountDue: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 		AzurePrepaymentApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](15.46),
	// 		},
	// 		BilledAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		BilledDocumentID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/I000002"),
	// 		BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
	// 		CreditAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](2),
	// 		},
	// 		DocumentType: to.Ptr(armbilling.InvoiceDocumentTypeInvoice),
	// 		Documents: []*armbilling.Document{
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeInvoice),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/invoice.pdf"),
	// 			},
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
	// 		}},
	// 		DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
	// 		FreeAzureCreditApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		IsMonthlyInvoice: to.Ptr(false),
	// 		Payments: []*armbilling.PaymentProperties{
	// 			{
	// 				Amount: &armbilling.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float32](2),
	// 				},
	// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
	// 				PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
	// 				PaymentMethodType: to.Ptr("visa"),
	// 				PaymentType: to.Ptr("credited"),
	// 		}},
	// 		PurchaseOrderNumber: to.Ptr("123456"),
	// 		Status: to.Ptr(armbilling.InvoiceStatusVoid),
	// 		SubTotal: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		TaxAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		TotalAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/InvoiceById.json
func ExampleInvoicesClient_GetByID() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInvoicesClient().GetByID(ctx, "{invoiceName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Invoice = armbilling.Invoice{
	// 	Name: to.Ptr("{invoiceName}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/invoices"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}"),
	// 	Properties: &armbilling.InvoiceProperties{
	// 		AmountDue: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 		AzurePrepaymentApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](15.46),
	// 		},
	// 		BilledAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
	// 		CreditAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](2),
	// 		},
	// 		Documents: []*armbilling.Document{
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeInvoice),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/invoice.pdf"),
	// 			},
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeTaxReceipt),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://microsoft.com/taxDoc.pdf"),
	// 		}},
	// 		DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
	// 		FreeAzureCreditApplied: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
	// 		IsMonthlyInvoice: to.Ptr(false),
	// 		Payments: []*armbilling.PaymentProperties{
	// 			{
	// 				Amount: &armbilling.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float32](2),
	// 				},
	// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
	// 				PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
	// 				PaymentMethodType: to.Ptr("visa"),
	// 				PaymentType: to.Ptr("credited"),
	// 		}},
	// 		PurchaseOrderNumber: to.Ptr("123456"),
	// 		Status: to.Ptr(armbilling.InvoiceStatusDue),
	// 		SubTotal: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](33.99),
	// 		},
	// 		TaxAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](0),
	// 		},
	// 		TotalAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](16.53),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/ModernInvoiceDownload.json
func ExampleInvoicesClient_BeginDownloadInvoice() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewInvoicesClient().BeginDownloadInvoice(ctx, "{billingAccountName}", "{invoiceName}", "DRS_12345", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DownloadURL = armbilling.DownloadURL{
	// 	URL: to.Ptr("https://myaccount.blob.core.windows.net/invoices/1383724.pdf?sv=2019-02-02&sr=b&sp=r"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/MultipleModernInvoiceDownload.json
func ExampleInvoicesClient_BeginDownloadMultipleBillingProfileInvoices() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewInvoicesClient().BeginDownloadMultipleBillingProfileInvoices(ctx, "{billingAccountName}", []*string{
		to.Ptr("https://management.azure.com/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}/download?downloadToken={downloadToken}&useCache=True&api-version=2020-05-01"),
		to.Ptr("https://management.azure.com/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}/download?downloadToken={downloadToken}&useCache=True&api-version=2020-05-01"),
		to.Ptr("https://management.azure.com/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoices/{invoiceName}/download?downloadToken={downloadToken}&useCache=True&api-version=2020-05-01")}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DownloadURL = armbilling.DownloadURL{
	// 	URL: to.Ptr("https://myaccount.blob.core.windows.net/invoices/1383724.pdf?sv=2019-02-02&sr=b&sp=r"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingSubscriptionInvoicesList.json
func ExampleInvoicesClient_NewListByBillingSubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewInvoicesClient().NewListByBillingSubscriptionPager("2018-01-01", "2018-06-30", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.InvoiceListResult = armbilling.InvoiceListResult{
		// 	Value: []*armbilling.Invoice{
		// 		{
		// 			Name: to.Ptr("1383723"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions/invoices"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/11000000-0000-0000-0000-000000000000/invoices/1383723"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](2000),
		// 				},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-16T17:32:28.000Z"); return t}()),
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-15T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-01T17:32:28.000Z"); return t}()),
		// 				InvoiceType: to.Ptr(armbilling.InvoiceType("AzureServices")),
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				Status: to.Ptr(armbilling.InvoiceStatusDue),
		// 				SubscriptionID: to.Ptr("55000000-0000-0000-0000-000000000011"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("1383724"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions/invoices"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/11000000-0000-0000-0000-000000000000/invoices/1383724"),
		// 			Properties: &armbilling.InvoiceProperties{
		// 				AmountDue: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](2000),
		// 				},
		// 				BilledAmount: &armbilling.Amount{
		// 					Currency: to.Ptr("USD"),
		// 					Value: to.Ptr[float32](2000),
		// 				},
		// 				BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
		// 				BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 				Documents: []*armbilling.Document{
		// 					{
		// 						Kind: to.Ptr(armbilling.DocumentTypeInvoice),
		// 						Source: to.Ptr(armbilling.DocumentSourceDRS),
		// 						URL: to.Ptr("https://management.azure.com/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/11000000-0000-0000-0000-000000000000/invoices/1383724/download"),
		// 				}},
		// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-01T17:32:28.000Z"); return t}()),
		// 				InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-02T17:32:28.000Z"); return t}()),
		// 				InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
		// 				InvoiceType: to.Ptr(armbilling.InvoiceTypeAzureMarketplace),
		// 				Payments: []*armbilling.PaymentProperties{
		// 					{
		// 						Amount: &armbilling.Amount{
		// 							Currency: to.Ptr("USD"),
		// 							Value: to.Ptr[float32](2000),
		// 						},
		// 						Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
		// 						PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
		// 						PaymentMethodType: to.Ptr("visa"),
		// 						PaymentType: to.Ptr("credited"),
		// 				}},
		// 				PurchaseOrderNumber: to.Ptr("123456"),
		// 				Status: to.Ptr(armbilling.InvoiceStatusPaid),
		// 				SubscriptionID: to.Ptr("55000000-0000-0000-0000-000000000011"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingSubscriptionInvoice.json
func ExampleInvoicesClient_GetBySubscriptionAndInvoiceID() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInvoicesClient().GetBySubscriptionAndInvoiceID(ctx, "{invoiceName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Invoice = armbilling.Invoice{
	// 	Name: to.Ptr("1383724"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/billingSubscriptions/invoices"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/11000000-0000-0000-0000-000000000000/invoices/1383724"),
	// 	Properties: &armbilling.InvoiceProperties{
	// 		AmountDue: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](2000),
	// 		},
	// 		BilledAmount: &armbilling.Amount{
	// 			Currency: to.Ptr("USD"),
	// 			Value: to.Ptr[float32](2000),
	// 		},
	// 		BillingProfileDisplayName: to.Ptr("Contoso Operations Billing"),
	// 		BillingProfileID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
	// 		Documents: []*armbilling.Document{
	// 			{
	// 				Kind: to.Ptr(armbilling.DocumentTypeInvoice),
	// 				Source: to.Ptr(armbilling.DocumentSourceDRS),
	// 				URL: to.Ptr("https://management.azure.com/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/11000000-0000-0000-0000-000000000000/invoices/1383724/download"),
	// 		}},
	// 		DueDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-01T17:32:28.000Z"); return t}()),
	// 		InvoiceDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodEndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-02T17:32:28.000Z"); return t}()),
	// 		InvoicePeriodStartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-02-01T17:32:28.000Z"); return t}()),
	// 		InvoiceType: to.Ptr(armbilling.InvoiceTypeAzureMarketplace),
	// 		Payments: []*armbilling.PaymentProperties{
	// 			{
	// 				Amount: &armbilling.Amount{
	// 					Currency: to.Ptr("USD"),
	// 					Value: to.Ptr[float32](2000),
	// 				},
	// 				Date: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-14T17:32:28.000Z"); return t}()),
	// 				PaymentMethodFamily: to.Ptr(armbilling.PaymentMethodFamilyCreditCard),
	// 				PaymentMethodType: to.Ptr("visa"),
	// 				PaymentType: to.Ptr("credited"),
	// 		}},
	// 		PurchaseOrderNumber: to.Ptr("123456"),
	// 		Status: to.Ptr(armbilling.InvoiceStatusPaid),
	// 		SubscriptionID: to.Ptr("55000000-0000-0000-0000-000000000011"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingSubscriptionInvoiceDownload.json
func ExampleInvoicesClient_BeginDownloadBillingSubscriptionInvoice() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewInvoicesClient().BeginDownloadBillingSubscriptionInvoice(ctx, "{invoiceName}", "DRS_12345", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DownloadURL = armbilling.DownloadURL{
	// 	URL: to.Ptr("https://myaccount.blob.core.windows.net/invoices/1383724.pdf?sv=2019-02-02&sr=b&sig=sp=r"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/MultipleBillingSubscriptionInvoiceDownload.json
func ExampleInvoicesClient_BeginDownloadMultipleBillingSubscriptionInvoices() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewInvoicesClient().BeginDownloadMultipleBillingSubscriptionInvoices(ctx, []*string{
		to.Ptr("https://management.azure.com/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}/download?downloadToken={downloadToken}&useCache=True&api-version=2020-05-01"),
		to.Ptr("https://management.azure.com/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}/download?downloadToken={downloadToken}&useCache=True&api-version=2020-05-01"),
		to.Ptr("https://management.azure.com/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}/download?downloadToken={downloadToken}&useCache=True&api-version=2020-05-01")}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DownloadURL = armbilling.DownloadURL{
	// 	URL: to.Ptr("https://myaccount.blob.core.windows.net/invoices/1383724.pdf?sv=2019-02-02&sr=b&sp=r"),
	// }
}
