//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/botservice/armbotservice"
	"net/http"
	"regexp"
)

// HostSettingsServer is a fake server for instances of the armbotservice.HostSettingsClient type.
type HostSettingsServer struct {
	// Get is the fake for method HostSettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, options *armbotservice.HostSettingsClientGetOptions) (resp azfake.Responder[armbotservice.HostSettingsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewHostSettingsServerTransport creates a new instance of HostSettingsServerTransport with the provided implementation.
// The returned HostSettingsServerTransport instance is connected to an instance of armbotservice.HostSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewHostSettingsServerTransport(srv *HostSettingsServer) *HostSettingsServerTransport {
	return &HostSettingsServerTransport{srv: srv}
}

// HostSettingsServerTransport connects instances of armbotservice.HostSettingsClient to instances of HostSettingsServer.
// Don't use this type directly, use NewHostSettingsServerTransport instead.
type HostSettingsServerTransport struct {
	srv *HostSettingsServer
}

// Do implements the policy.Transporter interface for HostSettingsServerTransport.
func (h *HostSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "HostSettingsClient.Get":
		resp, err = h.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (h *HostSettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if h.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.BotService/hostSettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := h.srv.Get(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HostSettingsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
