//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
)

func unmarshalCustomDomainHTTPSParametersClassification(rawMsg json.RawMessage) (armcdn.CustomDomainHTTPSParametersClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armcdn.CustomDomainHTTPSParametersClassification
	switch m["certificateSource"] {
	case string(armcdn.CertificateSourceAzureKeyVault):
		b = &armcdn.UserManagedHTTPSParameters{}
	case string(armcdn.CertificateSourceCdn):
		b = &armcdn.ManagedHTTPSParameters{}
	default:
		b = &armcdn.CustomDomainHTTPSParameters{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
