//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AFDDomain.
func (a AFDDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDDomain.
func (a *AFDDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDDomainHTTPSParameters.
func (a AFDDomainHTTPSParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateType", a.CertificateType)
	populate(objectMap, "minimumTlsVersion", a.MinimumTLSVersion)
	populate(objectMap, "secret", a.Secret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDDomainHTTPSParameters.
func (a *AFDDomainHTTPSParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateType":
			err = unpopulate(val, "CertificateType", &a.CertificateType)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &a.MinimumTLSVersion)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &a.Secret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDDomainListResult.
func (a AFDDomainListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDDomainListResult.
func (a *AFDDomainListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDDomainProperties.
func (a AFDDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureDnsZone", a.AzureDNSZone)
	populate(objectMap, "deploymentStatus", a.DeploymentStatus)
	populate(objectMap, "domainValidationState", a.DomainValidationState)
	populate(objectMap, "extendedProperties", a.ExtendedProperties)
	populate(objectMap, "hostName", a.HostName)
	populate(objectMap, "preValidatedCustomDomainResourceId", a.PreValidatedCustomDomainResourceID)
	populate(objectMap, "profileName", a.ProfileName)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "tlsSettings", a.TLSSettings)
	populate(objectMap, "validationProperties", a.ValidationProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDDomainProperties.
func (a *AFDDomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureDnsZone":
			err = unpopulate(val, "AzureDNSZone", &a.AzureDNSZone)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &a.DeploymentStatus)
			delete(rawMsg, key)
		case "domainValidationState":
			err = unpopulate(val, "DomainValidationState", &a.DomainValidationState)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &a.ExtendedProperties)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &a.HostName)
			delete(rawMsg, key)
		case "preValidatedCustomDomainResourceId":
			err = unpopulate(val, "PreValidatedCustomDomainResourceID", &a.PreValidatedCustomDomainResourceID)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &a.ProfileName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "tlsSettings":
			err = unpopulate(val, "TLSSettings", &a.TLSSettings)
			delete(rawMsg, key)
		case "validationProperties":
			err = unpopulate(val, "ValidationProperties", &a.ValidationProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDDomainUpdateParameters.
func (a AFDDomainUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDDomainUpdateParameters.
func (a *AFDDomainUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDDomainUpdatePropertiesParameters.
func (a AFDDomainUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureDnsZone", a.AzureDNSZone)
	populate(objectMap, "preValidatedCustomDomainResourceId", a.PreValidatedCustomDomainResourceID)
	populate(objectMap, "profileName", a.ProfileName)
	populate(objectMap, "tlsSettings", a.TLSSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDDomainUpdatePropertiesParameters.
func (a *AFDDomainUpdatePropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureDnsZone":
			err = unpopulate(val, "AzureDNSZone", &a.AzureDNSZone)
			delete(rawMsg, key)
		case "preValidatedCustomDomainResourceId":
			err = unpopulate(val, "PreValidatedCustomDomainResourceID", &a.PreValidatedCustomDomainResourceID)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &a.ProfileName)
			delete(rawMsg, key)
		case "tlsSettings":
			err = unpopulate(val, "TLSSettings", &a.TLSSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDEndpoint.
func (a AFDEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDEndpoint.
func (a *AFDEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDEndpointListResult.
func (a AFDEndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDEndpointListResult.
func (a *AFDEndpointListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDEndpointProperties.
func (a AFDEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoGeneratedDomainNameLabelScope", a.AutoGeneratedDomainNameLabelScope)
	populate(objectMap, "deploymentStatus", a.DeploymentStatus)
	populate(objectMap, "enabledState", a.EnabledState)
	populate(objectMap, "hostName", a.HostName)
	populate(objectMap, "profileName", a.ProfileName)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDEndpointProperties.
func (a *AFDEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoGeneratedDomainNameLabelScope":
			err = unpopulate(val, "AutoGeneratedDomainNameLabelScope", &a.AutoGeneratedDomainNameLabelScope)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &a.DeploymentStatus)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &a.EnabledState)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &a.HostName)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &a.ProfileName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDEndpointPropertiesUpdateParameters.
func (a AFDEndpointPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabledState", a.EnabledState)
	populate(objectMap, "profileName", a.ProfileName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDEndpointPropertiesUpdateParameters.
func (a *AFDEndpointPropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabledState":
			err = unpopulate(val, "EnabledState", &a.EnabledState)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &a.ProfileName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDEndpointUpdateParameters.
func (a AFDEndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDEndpointUpdateParameters.
func (a *AFDEndpointUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOrigin.
func (a AFDOrigin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOrigin.
func (a *AFDOrigin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginGroup.
func (a AFDOriginGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginGroup.
func (a *AFDOriginGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginGroupListResult.
func (a AFDOriginGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginGroupListResult.
func (a *AFDOriginGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginGroupProperties.
func (a AFDOriginGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentStatus", a.DeploymentStatus)
	populate(objectMap, "healthProbeSettings", a.HealthProbeSettings)
	populate(objectMap, "loadBalancingSettings", a.LoadBalancingSettings)
	populate(objectMap, "profileName", a.ProfileName)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "sessionAffinityState", a.SessionAffinityState)
	populate(objectMap, "trafficRestorationTimeToHealedOrNewEndpointsInMinutes", a.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginGroupProperties.
func (a *AFDOriginGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &a.DeploymentStatus)
			delete(rawMsg, key)
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &a.HealthProbeSettings)
			delete(rawMsg, key)
		case "loadBalancingSettings":
			err = unpopulate(val, "LoadBalancingSettings", &a.LoadBalancingSettings)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &a.ProfileName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "sessionAffinityState":
			err = unpopulate(val, "SessionAffinityState", &a.SessionAffinityState)
			delete(rawMsg, key)
		case "trafficRestorationTimeToHealedOrNewEndpointsInMinutes":
			err = unpopulate(val, "TrafficRestorationTimeToHealedOrNewEndpointsInMinutes", &a.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginGroupUpdateParameters.
func (a AFDOriginGroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginGroupUpdateParameters.
func (a *AFDOriginGroupUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginGroupUpdatePropertiesParameters.
func (a AFDOriginGroupUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthProbeSettings", a.HealthProbeSettings)
	populate(objectMap, "loadBalancingSettings", a.LoadBalancingSettings)
	populate(objectMap, "profileName", a.ProfileName)
	populate(objectMap, "sessionAffinityState", a.SessionAffinityState)
	populate(objectMap, "trafficRestorationTimeToHealedOrNewEndpointsInMinutes", a.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginGroupUpdatePropertiesParameters.
func (a *AFDOriginGroupUpdatePropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &a.HealthProbeSettings)
			delete(rawMsg, key)
		case "loadBalancingSettings":
			err = unpopulate(val, "LoadBalancingSettings", &a.LoadBalancingSettings)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &a.ProfileName)
			delete(rawMsg, key)
		case "sessionAffinityState":
			err = unpopulate(val, "SessionAffinityState", &a.SessionAffinityState)
			delete(rawMsg, key)
		case "trafficRestorationTimeToHealedOrNewEndpointsInMinutes":
			err = unpopulate(val, "TrafficRestorationTimeToHealedOrNewEndpointsInMinutes", &a.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginListResult.
func (a AFDOriginListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginListResult.
func (a *AFDOriginListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginProperties.
func (a AFDOriginProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureOrigin", a.AzureOrigin)
	populate(objectMap, "deploymentStatus", a.DeploymentStatus)
	populate(objectMap, "enabledState", a.EnabledState)
	populate(objectMap, "enforceCertificateNameCheck", a.EnforceCertificateNameCheck)
	populate(objectMap, "httpPort", a.HTTPPort)
	populate(objectMap, "httpsPort", a.HTTPSPort)
	populate(objectMap, "hostName", a.HostName)
	populate(objectMap, "originGroupName", a.OriginGroupName)
	populate(objectMap, "originHostHeader", a.OriginHostHeader)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "sharedPrivateLinkResource", a.SharedPrivateLinkResource)
	populate(objectMap, "weight", a.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginProperties.
func (a *AFDOriginProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureOrigin":
			err = unpopulate(val, "AzureOrigin", &a.AzureOrigin)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &a.DeploymentStatus)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &a.EnabledState)
			delete(rawMsg, key)
		case "enforceCertificateNameCheck":
			err = unpopulate(val, "EnforceCertificateNameCheck", &a.EnforceCertificateNameCheck)
			delete(rawMsg, key)
		case "httpPort":
			err = unpopulate(val, "HTTPPort", &a.HTTPPort)
			delete(rawMsg, key)
		case "httpsPort":
			err = unpopulate(val, "HTTPSPort", &a.HTTPSPort)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &a.HostName)
			delete(rawMsg, key)
		case "originGroupName":
			err = unpopulate(val, "OriginGroupName", &a.OriginGroupName)
			delete(rawMsg, key)
		case "originHostHeader":
			err = unpopulate(val, "OriginHostHeader", &a.OriginHostHeader)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "sharedPrivateLinkResource":
			err = unpopulate(val, "SharedPrivateLinkResource", &a.SharedPrivateLinkResource)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &a.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginUpdateParameters.
func (a AFDOriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginUpdateParameters.
func (a *AFDOriginUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AFDOriginUpdatePropertiesParameters.
func (a AFDOriginUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureOrigin", a.AzureOrigin)
	populate(objectMap, "enabledState", a.EnabledState)
	populate(objectMap, "enforceCertificateNameCheck", a.EnforceCertificateNameCheck)
	populate(objectMap, "httpPort", a.HTTPPort)
	populate(objectMap, "httpsPort", a.HTTPSPort)
	populate(objectMap, "hostName", a.HostName)
	populate(objectMap, "originGroupName", a.OriginGroupName)
	populate(objectMap, "originHostHeader", a.OriginHostHeader)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "sharedPrivateLinkResource", a.SharedPrivateLinkResource)
	populate(objectMap, "weight", a.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AFDOriginUpdatePropertiesParameters.
func (a *AFDOriginUpdatePropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureOrigin":
			err = unpopulate(val, "AzureOrigin", &a.AzureOrigin)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &a.EnabledState)
			delete(rawMsg, key)
		case "enforceCertificateNameCheck":
			err = unpopulate(val, "EnforceCertificateNameCheck", &a.EnforceCertificateNameCheck)
			delete(rawMsg, key)
		case "httpPort":
			err = unpopulate(val, "HTTPPort", &a.HTTPPort)
			delete(rawMsg, key)
		case "httpsPort":
			err = unpopulate(val, "HTTPSPort", &a.HTTPSPort)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &a.HostName)
			delete(rawMsg, key)
		case "originGroupName":
			err = unpopulate(val, "OriginGroupName", &a.OriginGroupName)
			delete(rawMsg, key)
		case "originHostHeader":
			err = unpopulate(val, "OriginHostHeader", &a.OriginHostHeader)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "sharedPrivateLinkResource":
			err = unpopulate(val, "SharedPrivateLinkResource", &a.SharedPrivateLinkResource)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &a.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivatedResourceReference.
func (a ActivatedResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "isActive", a.IsActive)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivatedResourceReference.
func (a *ActivatedResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &a.IsActive)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AfdPurgeParameters.
func (a AfdPurgeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentPaths", a.ContentPaths)
	populate(objectMap, "domains", a.Domains)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AfdPurgeParameters.
func (a *AfdPurgeParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentPaths":
			err = unpopulate(val, "ContentPaths", &a.ContentPaths)
			delete(rawMsg, key)
		case "domains":
			err = unpopulate(val, "Domains", &a.Domains)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AfdRouteCacheConfiguration.
func (a AfdRouteCacheConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compressionSettings", a.CompressionSettings)
	populate(objectMap, "queryParameters", a.QueryParameters)
	populate(objectMap, "queryStringCachingBehavior", a.QueryStringCachingBehavior)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AfdRouteCacheConfiguration.
func (a *AfdRouteCacheConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compressionSettings":
			err = unpopulate(val, "CompressionSettings", &a.CompressionSettings)
			delete(rawMsg, key)
		case "queryParameters":
			err = unpopulate(val, "QueryParameters", &a.QueryParameters)
			delete(rawMsg, key)
		case "queryStringCachingBehavior":
			err = unpopulate(val, "QueryStringCachingBehavior", &a.QueryStringCachingBehavior)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirstPartyManagedCertificateParameters.
func (a AzureFirstPartyManagedCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateAuthority", a.CertificateAuthority)
	populate(objectMap, "expirationDate", a.ExpirationDate)
	populate(objectMap, "secretSource", a.SecretSource)
	populate(objectMap, "subject", a.Subject)
	populate(objectMap, "subjectAlternativeNames", a.SubjectAlternativeNames)
	populate(objectMap, "thumbprint", a.Thumbprint)
	objectMap["type"] = SecretTypeAzureFirstPartyManagedCertificate
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirstPartyManagedCertificateParameters.
func (a *AzureFirstPartyManagedCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateAuthority":
			err = unpopulate(val, "CertificateAuthority", &a.CertificateAuthority)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulate(val, "ExpirationDate", &a.ExpirationDate)
			delete(rawMsg, key)
		case "secretSource":
			err = unpopulate(val, "SecretSource", &a.SecretSource)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &a.Subject)
			delete(rawMsg, key)
		case "subjectAlternativeNames":
			err = unpopulate(val, "SubjectAlternativeNames", &a.SubjectAlternativeNames)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &a.Thumbprint)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheConfiguration.
func (c CacheConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheBehavior", c.CacheBehavior)
	populate(objectMap, "cacheDuration", c.CacheDuration)
	populate(objectMap, "isCompressionEnabled", c.IsCompressionEnabled)
	populate(objectMap, "queryParameters", c.QueryParameters)
	populate(objectMap, "queryStringCachingBehavior", c.QueryStringCachingBehavior)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheConfiguration.
func (c *CacheConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheBehavior":
			err = unpopulate(val, "CacheBehavior", &c.CacheBehavior)
			delete(rawMsg, key)
		case "cacheDuration":
			err = unpopulate(val, "CacheDuration", &c.CacheDuration)
			delete(rawMsg, key)
		case "isCompressionEnabled":
			err = unpopulate(val, "IsCompressionEnabled", &c.IsCompressionEnabled)
			delete(rawMsg, key)
		case "queryParameters":
			err = unpopulate(val, "QueryParameters", &c.QueryParameters)
			delete(rawMsg, key)
		case "queryStringCachingBehavior":
			err = unpopulate(val, "QueryStringCachingBehavior", &c.QueryStringCachingBehavior)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheExpirationActionParameters.
func (c CacheExpirationActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheBehavior", c.CacheBehavior)
	populate(objectMap, "cacheDuration", c.CacheDuration)
	populate(objectMap, "cacheType", c.CacheType)
	populate(objectMap, "typeName", c.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheExpirationActionParameters.
func (c *CacheExpirationActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheBehavior":
			err = unpopulate(val, "CacheBehavior", &c.CacheBehavior)
			delete(rawMsg, key)
		case "cacheDuration":
			err = unpopulate(val, "CacheDuration", &c.CacheDuration)
			delete(rawMsg, key)
		case "cacheType":
			err = unpopulate(val, "CacheType", &c.CacheType)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &c.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheKeyQueryStringActionParameters.
func (c CacheKeyQueryStringActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "queryParameters", c.QueryParameters)
	populate(objectMap, "queryStringBehavior", c.QueryStringBehavior)
	populate(objectMap, "typeName", c.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheKeyQueryStringActionParameters.
func (c *CacheKeyQueryStringActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "queryParameters":
			err = unpopulate(val, "QueryParameters", &c.QueryParameters)
			delete(rawMsg, key)
		case "queryStringBehavior":
			err = unpopulate(val, "QueryStringBehavior", &c.QueryStringBehavior)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &c.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CanMigrateParameters.
func (c CanMigrateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "classicResourceReference", c.ClassicResourceReference)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CanMigrateParameters.
func (c *CanMigrateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classicResourceReference":
			err = unpopulate(val, "ClassicResourceReference", &c.ClassicResourceReference)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CanMigrateProperties.
func (c CanMigrateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canMigrate", c.CanMigrate)
	populate(objectMap, "defaultSku", c.DefaultSKU)
	populate(objectMap, "errors", c.Errors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CanMigrateProperties.
func (c *CanMigrateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canMigrate":
			err = unpopulate(val, "CanMigrate", &c.CanMigrate)
			delete(rawMsg, key)
		case "defaultSku":
			err = unpopulate(val, "DefaultSKU", &c.DefaultSKU)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CanMigrateResult.
func (c CanMigrateResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CanMigrateResult.
func (c *CanMigrateResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateSourceParameters.
func (c CertificateSourceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateType", c.CertificateType)
	populate(objectMap, "typeName", c.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateSourceParameters.
func (c *CertificateSourceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateType":
			err = unpopulate(val, "CertificateType", &c.CertificateType)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &c.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckEndpointNameAvailabilityInput.
func (c CheckEndpointNameAvailabilityInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoGeneratedDomainNameLabelScope", c.AutoGeneratedDomainNameLabelScope)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckEndpointNameAvailabilityInput.
func (c *CheckEndpointNameAvailabilityInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoGeneratedDomainNameLabelScope":
			err = unpopulate(val, "AutoGeneratedDomainNameLabelScope", &c.AutoGeneratedDomainNameLabelScope)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckEndpointNameAvailabilityOutput.
func (c CheckEndpointNameAvailabilityOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableHostname", c.AvailableHostname)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckEndpointNameAvailabilityOutput.
func (c *CheckEndpointNameAvailabilityOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableHostname":
			err = unpopulate(val, "AvailableHostname", &c.AvailableHostname)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckHostNameAvailabilityInput.
func (c CheckHostNameAvailabilityInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostName", c.HostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckHostNameAvailabilityInput.
func (c *CheckHostNameAvailabilityInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostName":
			err = unpopulate(val, "HostName", &c.HostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityInput.
func (c CheckNameAvailabilityInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityInput.
func (c *CheckNameAvailabilityInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityOutput.
func (c CheckNameAvailabilityOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityOutput.
func (c *CheckNameAvailabilityOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CidrIPAddress.
func (c CidrIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "baseIpAddress", c.BaseIPAddress)
	populate(objectMap, "prefixLength", c.PrefixLength)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CidrIPAddress.
func (c *CidrIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseIpAddress":
			err = unpopulate(val, "BaseIPAddress", &c.BaseIPAddress)
			delete(rawMsg, key)
		case "prefixLength":
			err = unpopulate(val, "PrefixLength", &c.PrefixLength)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientPortMatchConditionParameters.
func (c ClientPortMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", c.MatchValues)
	populate(objectMap, "negateCondition", c.NegateCondition)
	populate(objectMap, "operator", c.Operator)
	populate(objectMap, "transforms", c.Transforms)
	populate(objectMap, "typeName", c.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientPortMatchConditionParameters.
func (c *ClientPortMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &c.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &c.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &c.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &c.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &c.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems.
func (c Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "dateTime", c.DateTime)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems.
func (c *Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTime":
			err = unpopulateDateTimeRFC3339(val, "DateTime", &c.DateTime)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems.
func (c Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "dateTime", c.DateTime)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems.
func (c *Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTime":
			err = unpopulateDateTimeRFC3339(val, "DateTime", &c.DateTime)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems.
func (c ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metric", c.Metric)
	populate(objectMap, "percentage", c.Percentage)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems.
func (c *ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metric":
			err = unpopulate(val, "Metric", &c.Metric)
			delete(rawMsg, key)
		case "percentage":
			err = unpopulate(val, "Percentage", &c.Percentage)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CompressionSettings.
func (c CompressionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentTypesToCompress", c.ContentTypesToCompress)
	populate(objectMap, "isCompressionEnabled", c.IsCompressionEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CompressionSettings.
func (c *CompressionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentTypesToCompress":
			err = unpopulate(val, "ContentTypesToCompress", &c.ContentTypesToCompress)
			delete(rawMsg, key)
		case "isCompressionEnabled":
			err = unpopulate(val, "IsCompressionEnabled", &c.IsCompressionEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinentsResponse.
func (c ContinentsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "continents", c.Continents)
	populate(objectMap, "countryOrRegions", c.CountryOrRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinentsResponse.
func (c *ContinentsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "continents":
			err = unpopulate(val, "Continents", &c.Continents)
			delete(rawMsg, key)
		case "countryOrRegions":
			err = unpopulate(val, "CountryOrRegions", &c.CountryOrRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinentsResponseContinentsItem.
func (c ContinentsResponseContinentsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinentsResponseContinentsItem.
func (c *ContinentsResponseContinentsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinentsResponseCountryOrRegionsItem.
func (c ContinentsResponseCountryOrRegionsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "continentId", c.ContinentID)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinentsResponseCountryOrRegionsItem.
func (c *ContinentsResponseCountryOrRegionsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "continentId":
			err = unpopulate(val, "ContinentID", &c.ContinentID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CookiesMatchConditionParameters.
func (c CookiesMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", c.MatchValues)
	populate(objectMap, "negateCondition", c.NegateCondition)
	populate(objectMap, "operator", c.Operator)
	populate(objectMap, "selector", c.Selector)
	populate(objectMap, "transforms", c.Transforms)
	populate(objectMap, "typeName", c.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CookiesMatchConditionParameters.
func (c *CookiesMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &c.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &c.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &c.Operator)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &c.Selector)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &c.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &c.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomain.
func (c CustomDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomain.
func (c *CustomDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomainHTTPSParameters.
func (c CustomDomainHTTPSParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["certificateSource"] = c.CertificateSource
	populate(objectMap, "minimumTlsVersion", c.MinimumTLSVersion)
	populate(objectMap, "protocolType", c.ProtocolType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomainHTTPSParameters.
func (c *CustomDomainHTTPSParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateSource":
			err = unpopulate(val, "CertificateSource", &c.CertificateSource)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &c.MinimumTLSVersion)
			delete(rawMsg, key)
		case "protocolType":
			err = unpopulate(val, "ProtocolType", &c.ProtocolType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomainListResult.
func (c CustomDomainListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomainListResult.
func (c *CustomDomainListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomainParameters.
func (c CustomDomainParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomainParameters.
func (c *CustomDomainParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomainProperties.
func (c CustomDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customHttpsParameters", c.CustomHTTPSParameters)
	populate(objectMap, "customHttpsProvisioningState", c.CustomHTTPSProvisioningState)
	populate(objectMap, "customHttpsProvisioningSubstate", c.CustomHTTPSProvisioningSubstate)
	populate(objectMap, "hostName", c.HostName)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "resourceState", c.ResourceState)
	populate(objectMap, "validationData", c.ValidationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomainProperties.
func (c *CustomDomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customHttpsParameters":
			c.CustomHTTPSParameters, err = unmarshalCustomDomainHTTPSParametersClassification(val)
			delete(rawMsg, key)
		case "customHttpsProvisioningState":
			err = unpopulate(val, "CustomHTTPSProvisioningState", &c.CustomHTTPSProvisioningState)
			delete(rawMsg, key)
		case "customHttpsProvisioningSubstate":
			err = unpopulate(val, "CustomHTTPSProvisioningSubstate", &c.CustomHTTPSProvisioningSubstate)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &c.HostName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &c.ResourceState)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &c.ValidationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDomainPropertiesParameters.
func (c CustomDomainPropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostName", c.HostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDomainPropertiesParameters.
func (c *CustomDomainPropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostName":
			err = unpopulate(val, "HostName", &c.HostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRule.
func (c CustomRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "enabledState", c.EnabledState)
	populate(objectMap, "matchConditions", c.MatchConditions)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "priority", c.Priority)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRule.
func (c *CustomRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &c.EnabledState)
			delete(rawMsg, key)
		case "matchConditions":
			err = unpopulate(val, "MatchConditions", &c.MatchConditions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &c.Priority)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRuleList.
func (c CustomRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rules", c.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRuleList.
func (c *CustomRuleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &c.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerCertificateParameters.
func (c CustomerCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateAuthority", c.CertificateAuthority)
	populate(objectMap, "expirationDate", c.ExpirationDate)
	populate(objectMap, "secretSource", c.SecretSource)
	populate(objectMap, "secretVersion", c.SecretVersion)
	populate(objectMap, "subject", c.Subject)
	populate(objectMap, "subjectAlternativeNames", c.SubjectAlternativeNames)
	populate(objectMap, "thumbprint", c.Thumbprint)
	objectMap["type"] = SecretTypeCustomerCertificate
	populate(objectMap, "useLatestVersion", c.UseLatestVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerCertificateParameters.
func (c *CustomerCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateAuthority":
			err = unpopulate(val, "CertificateAuthority", &c.CertificateAuthority)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulate(val, "ExpirationDate", &c.ExpirationDate)
			delete(rawMsg, key)
		case "secretSource":
			err = unpopulate(val, "SecretSource", &c.SecretSource)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &c.SecretVersion)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &c.Subject)
			delete(rawMsg, key)
		case "subjectAlternativeNames":
			err = unpopulate(val, "SubjectAlternativeNames", &c.SubjectAlternativeNames)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "useLatestVersion":
			err = unpopulate(val, "UseLatestVersion", &c.UseLatestVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeepCreatedCustomDomain.
func (d DeepCreatedCustomDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeepCreatedCustomDomain.
func (d *DeepCreatedCustomDomain) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeepCreatedCustomDomainProperties.
func (d DeepCreatedCustomDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostName", d.HostName)
	populate(objectMap, "validationData", d.ValidationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeepCreatedCustomDomainProperties.
func (d *DeepCreatedCustomDomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostName":
			err = unpopulate(val, "HostName", &d.HostName)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &d.ValidationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeepCreatedOrigin.
func (d DeepCreatedOrigin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeepCreatedOrigin.
func (d *DeepCreatedOrigin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeepCreatedOriginGroup.
func (d DeepCreatedOriginGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeepCreatedOriginGroup.
func (d *DeepCreatedOriginGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeepCreatedOriginGroupProperties.
func (d DeepCreatedOriginGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthProbeSettings", d.HealthProbeSettings)
	populate(objectMap, "origins", d.Origins)
	populate(objectMap, "responseBasedOriginErrorDetectionSettings", d.ResponseBasedOriginErrorDetectionSettings)
	populate(objectMap, "trafficRestorationTimeToHealedOrNewEndpointsInMinutes", d.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeepCreatedOriginGroupProperties.
func (d *DeepCreatedOriginGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &d.HealthProbeSettings)
			delete(rawMsg, key)
		case "origins":
			err = unpopulate(val, "Origins", &d.Origins)
			delete(rawMsg, key)
		case "responseBasedOriginErrorDetectionSettings":
			err = unpopulate(val, "ResponseBasedOriginErrorDetectionSettings", &d.ResponseBasedOriginErrorDetectionSettings)
			delete(rawMsg, key)
		case "trafficRestorationTimeToHealedOrNewEndpointsInMinutes":
			err = unpopulate(val, "TrafficRestorationTimeToHealedOrNewEndpointsInMinutes", &d.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeepCreatedOriginProperties.
func (d DeepCreatedOriginProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "httpPort", d.HTTPPort)
	populate(objectMap, "httpsPort", d.HTTPSPort)
	populate(objectMap, "hostName", d.HostName)
	populate(objectMap, "originHostHeader", d.OriginHostHeader)
	populate(objectMap, "priority", d.Priority)
	populate(objectMap, "privateEndpointStatus", d.PrivateEndpointStatus)
	populate(objectMap, "privateLinkAlias", d.PrivateLinkAlias)
	populate(objectMap, "privateLinkApprovalMessage", d.PrivateLinkApprovalMessage)
	populate(objectMap, "privateLinkLocation", d.PrivateLinkLocation)
	populate(objectMap, "privateLinkResourceId", d.PrivateLinkResourceID)
	populate(objectMap, "weight", d.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeepCreatedOriginProperties.
func (d *DeepCreatedOriginProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "httpPort":
			err = unpopulate(val, "HTTPPort", &d.HTTPPort)
			delete(rawMsg, key)
		case "httpsPort":
			err = unpopulate(val, "HTTPSPort", &d.HTTPSPort)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &d.HostName)
			delete(rawMsg, key)
		case "originHostHeader":
			err = unpopulate(val, "OriginHostHeader", &d.OriginHostHeader)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &d.Priority)
			delete(rawMsg, key)
		case "privateEndpointStatus":
			err = unpopulate(val, "PrivateEndpointStatus", &d.PrivateEndpointStatus)
			delete(rawMsg, key)
		case "privateLinkAlias":
			err = unpopulate(val, "PrivateLinkAlias", &d.PrivateLinkAlias)
			delete(rawMsg, key)
		case "privateLinkApprovalMessage":
			err = unpopulate(val, "PrivateLinkApprovalMessage", &d.PrivateLinkApprovalMessage)
			delete(rawMsg, key)
		case "privateLinkLocation":
			err = unpopulate(val, "PrivateLinkLocation", &d.PrivateLinkLocation)
			delete(rawMsg, key)
		case "privateLinkResourceId":
			err = unpopulate(val, "PrivateLinkResourceID", &d.PrivateLinkResourceID)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &d.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRule.
func (d DeliveryRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", d.Actions)
	populate(objectMap, "conditions", d.Conditions)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "order", d.Order)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRule.
func (d *DeliveryRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			d.Actions, err = unmarshalDeliveryRuleActionAutoGeneratedClassificationArray(val)
			delete(rawMsg, key)
		case "conditions":
			d.Conditions, err = unmarshalDeliveryRuleConditionClassificationArray(val)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &d.Order)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleActionAutoGenerated.
func (d DeliveryRuleActionAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = d.Name
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleActionAutoGenerated.
func (d *DeliveryRuleActionAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleCacheExpirationAction.
func (d DeliveryRuleCacheExpirationAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionCacheExpiration
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleCacheExpirationAction.
func (d *DeliveryRuleCacheExpirationAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleCacheKeyQueryStringAction.
func (d DeliveryRuleCacheKeyQueryStringAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionCacheKeyQueryString
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleCacheKeyQueryStringAction.
func (d *DeliveryRuleCacheKeyQueryStringAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleClientPortCondition.
func (d DeliveryRuleClientPortCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableClientPort
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleClientPortCondition.
func (d *DeliveryRuleClientPortCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleCondition.
func (d DeliveryRuleCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = d.Name
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleCondition.
func (d *DeliveryRuleCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleCookiesCondition.
func (d DeliveryRuleCookiesCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableCookies
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleCookiesCondition.
func (d *DeliveryRuleCookiesCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleHTTPVersionCondition.
func (d DeliveryRuleHTTPVersionCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableHTTPVersion
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleHTTPVersionCondition.
func (d *DeliveryRuleHTTPVersionCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleHostNameCondition.
func (d DeliveryRuleHostNameCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableHostName
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleHostNameCondition.
func (d *DeliveryRuleHostNameCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleIsDeviceCondition.
func (d DeliveryRuleIsDeviceCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableIsDevice
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleIsDeviceCondition.
func (d *DeliveryRuleIsDeviceCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRulePostArgsCondition.
func (d DeliveryRulePostArgsCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariablePostArgs
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRulePostArgsCondition.
func (d *DeliveryRulePostArgsCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleQueryStringCondition.
func (d DeliveryRuleQueryStringCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableQueryString
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleQueryStringCondition.
func (d *DeliveryRuleQueryStringCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRemoteAddressCondition.
func (d DeliveryRuleRemoteAddressCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableRemoteAddress
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRemoteAddressCondition.
func (d *DeliveryRuleRemoteAddressCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestBodyCondition.
func (d DeliveryRuleRequestBodyCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableRequestBody
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestBodyCondition.
func (d *DeliveryRuleRequestBodyCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestHeaderAction.
func (d DeliveryRuleRequestHeaderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionModifyRequestHeader
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestHeaderAction.
func (d *DeliveryRuleRequestHeaderAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestHeaderCondition.
func (d DeliveryRuleRequestHeaderCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableRequestHeader
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestHeaderCondition.
func (d *DeliveryRuleRequestHeaderCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestMethodCondition.
func (d DeliveryRuleRequestMethodCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableRequestMethod
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestMethodCondition.
func (d *DeliveryRuleRequestMethodCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestSchemeCondition.
func (d DeliveryRuleRequestSchemeCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableRequestScheme
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestSchemeCondition.
func (d *DeliveryRuleRequestSchemeCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRequestURICondition.
func (d DeliveryRuleRequestURICondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableRequestURI
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRequestURICondition.
func (d *DeliveryRuleRequestURICondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleResponseHeaderAction.
func (d DeliveryRuleResponseHeaderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionModifyResponseHeader
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleResponseHeaderAction.
func (d *DeliveryRuleResponseHeaderAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleRouteConfigurationOverrideAction.
func (d DeliveryRuleRouteConfigurationOverrideAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionRouteConfigurationOverride
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleRouteConfigurationOverrideAction.
func (d *DeliveryRuleRouteConfigurationOverrideAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleSSLProtocolCondition.
func (d DeliveryRuleSSLProtocolCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableSSLProtocol
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleSSLProtocolCondition.
func (d *DeliveryRuleSSLProtocolCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleServerPortCondition.
func (d DeliveryRuleServerPortCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableServerPort
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleServerPortCondition.
func (d *DeliveryRuleServerPortCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleSocketAddrCondition.
func (d DeliveryRuleSocketAddrCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableSocketAddr
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleSocketAddrCondition.
func (d *DeliveryRuleSocketAddrCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleURLFileExtensionCondition.
func (d DeliveryRuleURLFileExtensionCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableURLFileExtension
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleURLFileExtensionCondition.
func (d *DeliveryRuleURLFileExtensionCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleURLFileNameCondition.
func (d DeliveryRuleURLFileNameCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableURLFileName
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleURLFileNameCondition.
func (d *DeliveryRuleURLFileNameCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryRuleURLPathCondition.
func (d DeliveryRuleURLPathCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = MatchVariableURLPath
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryRuleURLPathCondition.
func (d *DeliveryRuleURLPathCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DimensionProperties.
func (d DimensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "internalName", d.InternalName)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DimensionProperties.
func (d *DimensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "internalName":
			err = unpopulate(val, "InternalName", &d.InternalName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainValidationProperties.
func (d DomainValidationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expirationDate", d.ExpirationDate)
	populate(objectMap, "validationToken", d.ValidationToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainValidationProperties.
func (d *DomainValidationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulate(val, "ExpirationDate", &d.ExpirationDate)
			delete(rawMsg, key)
		case "validationToken":
			err = unpopulate(val, "ValidationToken", &d.ValidationToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdgeNode.
func (e EdgeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdgeNode.
func (e *EdgeNode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdgeNodeProperties.
func (e EdgeNodeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddressGroups", e.IPAddressGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdgeNodeProperties.
func (e *EdgeNodeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddressGroups":
			err = unpopulate(val, "IPAddressGroups", &e.IPAddressGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdgenodeResult.
func (e EdgenodeResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdgenodeResult.
func (e *EdgenodeResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Endpoint.
func (e *Endpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointListResult.
func (e EndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointListResult.
func (e *EndpointListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointProperties.
func (e EndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentTypesToCompress", e.ContentTypesToCompress)
	populate(objectMap, "customDomains", e.CustomDomains)
	populate(objectMap, "defaultOriginGroup", e.DefaultOriginGroup)
	populate(objectMap, "deliveryPolicy", e.DeliveryPolicy)
	populate(objectMap, "geoFilters", e.GeoFilters)
	populate(objectMap, "hostName", e.HostName)
	populate(objectMap, "isCompressionEnabled", e.IsCompressionEnabled)
	populate(objectMap, "isHttpAllowed", e.IsHTTPAllowed)
	populate(objectMap, "isHttpsAllowed", e.IsHTTPSAllowed)
	populate(objectMap, "optimizationType", e.OptimizationType)
	populate(objectMap, "originGroups", e.OriginGroups)
	populate(objectMap, "originHostHeader", e.OriginHostHeader)
	populate(objectMap, "originPath", e.OriginPath)
	populate(objectMap, "origins", e.Origins)
	populate(objectMap, "probePath", e.ProbePath)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "queryStringCachingBehavior", e.QueryStringCachingBehavior)
	populate(objectMap, "resourceState", e.ResourceState)
	populate(objectMap, "urlSigningKeys", e.URLSigningKeys)
	populate(objectMap, "webApplicationFirewallPolicyLink", e.WebApplicationFirewallPolicyLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointProperties.
func (e *EndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentTypesToCompress":
			err = unpopulate(val, "ContentTypesToCompress", &e.ContentTypesToCompress)
			delete(rawMsg, key)
		case "customDomains":
			err = unpopulate(val, "CustomDomains", &e.CustomDomains)
			delete(rawMsg, key)
		case "defaultOriginGroup":
			err = unpopulate(val, "DefaultOriginGroup", &e.DefaultOriginGroup)
			delete(rawMsg, key)
		case "deliveryPolicy":
			err = unpopulate(val, "DeliveryPolicy", &e.DeliveryPolicy)
			delete(rawMsg, key)
		case "geoFilters":
			err = unpopulate(val, "GeoFilters", &e.GeoFilters)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &e.HostName)
			delete(rawMsg, key)
		case "isCompressionEnabled":
			err = unpopulate(val, "IsCompressionEnabled", &e.IsCompressionEnabled)
			delete(rawMsg, key)
		case "isHttpAllowed":
			err = unpopulate(val, "IsHTTPAllowed", &e.IsHTTPAllowed)
			delete(rawMsg, key)
		case "isHttpsAllowed":
			err = unpopulate(val, "IsHTTPSAllowed", &e.IsHTTPSAllowed)
			delete(rawMsg, key)
		case "optimizationType":
			err = unpopulate(val, "OptimizationType", &e.OptimizationType)
			delete(rawMsg, key)
		case "originGroups":
			err = unpopulate(val, "OriginGroups", &e.OriginGroups)
			delete(rawMsg, key)
		case "originHostHeader":
			err = unpopulate(val, "OriginHostHeader", &e.OriginHostHeader)
			delete(rawMsg, key)
		case "originPath":
			err = unpopulate(val, "OriginPath", &e.OriginPath)
			delete(rawMsg, key)
		case "origins":
			err = unpopulate(val, "Origins", &e.Origins)
			delete(rawMsg, key)
		case "probePath":
			err = unpopulate(val, "ProbePath", &e.ProbePath)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "queryStringCachingBehavior":
			err = unpopulate(val, "QueryStringCachingBehavior", &e.QueryStringCachingBehavior)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &e.ResourceState)
			delete(rawMsg, key)
		case "urlSigningKeys":
			err = unpopulate(val, "URLSigningKeys", &e.URLSigningKeys)
			delete(rawMsg, key)
		case "webApplicationFirewallPolicyLink":
			err = unpopulate(val, "WebApplicationFirewallPolicyLink", &e.WebApplicationFirewallPolicyLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointPropertiesUpdateParameters.
func (e EndpointPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentTypesToCompress", e.ContentTypesToCompress)
	populate(objectMap, "defaultOriginGroup", e.DefaultOriginGroup)
	populate(objectMap, "deliveryPolicy", e.DeliveryPolicy)
	populate(objectMap, "geoFilters", e.GeoFilters)
	populate(objectMap, "isCompressionEnabled", e.IsCompressionEnabled)
	populate(objectMap, "isHttpAllowed", e.IsHTTPAllowed)
	populate(objectMap, "isHttpsAllowed", e.IsHTTPSAllowed)
	populate(objectMap, "optimizationType", e.OptimizationType)
	populate(objectMap, "originHostHeader", e.OriginHostHeader)
	populate(objectMap, "originPath", e.OriginPath)
	populate(objectMap, "probePath", e.ProbePath)
	populate(objectMap, "queryStringCachingBehavior", e.QueryStringCachingBehavior)
	populate(objectMap, "urlSigningKeys", e.URLSigningKeys)
	populate(objectMap, "webApplicationFirewallPolicyLink", e.WebApplicationFirewallPolicyLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointPropertiesUpdateParameters.
func (e *EndpointPropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentTypesToCompress":
			err = unpopulate(val, "ContentTypesToCompress", &e.ContentTypesToCompress)
			delete(rawMsg, key)
		case "defaultOriginGroup":
			err = unpopulate(val, "DefaultOriginGroup", &e.DefaultOriginGroup)
			delete(rawMsg, key)
		case "deliveryPolicy":
			err = unpopulate(val, "DeliveryPolicy", &e.DeliveryPolicy)
			delete(rawMsg, key)
		case "geoFilters":
			err = unpopulate(val, "GeoFilters", &e.GeoFilters)
			delete(rawMsg, key)
		case "isCompressionEnabled":
			err = unpopulate(val, "IsCompressionEnabled", &e.IsCompressionEnabled)
			delete(rawMsg, key)
		case "isHttpAllowed":
			err = unpopulate(val, "IsHTTPAllowed", &e.IsHTTPAllowed)
			delete(rawMsg, key)
		case "isHttpsAllowed":
			err = unpopulate(val, "IsHTTPSAllowed", &e.IsHTTPSAllowed)
			delete(rawMsg, key)
		case "optimizationType":
			err = unpopulate(val, "OptimizationType", &e.OptimizationType)
			delete(rawMsg, key)
		case "originHostHeader":
			err = unpopulate(val, "OriginHostHeader", &e.OriginHostHeader)
			delete(rawMsg, key)
		case "originPath":
			err = unpopulate(val, "OriginPath", &e.OriginPath)
			delete(rawMsg, key)
		case "probePath":
			err = unpopulate(val, "ProbePath", &e.ProbePath)
			delete(rawMsg, key)
		case "queryStringCachingBehavior":
			err = unpopulate(val, "QueryStringCachingBehavior", &e.QueryStringCachingBehavior)
			delete(rawMsg, key)
		case "urlSigningKeys":
			err = unpopulate(val, "URLSigningKeys", &e.URLSigningKeys)
			delete(rawMsg, key)
		case "webApplicationFirewallPolicyLink":
			err = unpopulate(val, "WebApplicationFirewallPolicyLink", &e.WebApplicationFirewallPolicyLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointPropertiesUpdateParametersDeliveryPolicy.
func (e EndpointPropertiesUpdateParametersDeliveryPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "rules", e.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointPropertiesUpdateParametersDeliveryPolicy.
func (e *EndpointPropertiesUpdateParametersDeliveryPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &e.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink.
func (e EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink.
func (e *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointUpdateParameters.
func (e EndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointUpdateParameters.
func (e *EndpointUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoFilter.
func (g GeoFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", g.Action)
	populate(objectMap, "countryCodes", g.CountryCodes)
	populate(objectMap, "relativePath", g.RelativePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoFilter.
func (g *GeoFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &g.Action)
			delete(rawMsg, key)
		case "countryCodes":
			err = unpopulate(val, "CountryCodes", &g.CountryCodes)
			delete(rawMsg, key)
		case "relativePath":
			err = unpopulate(val, "RelativePath", &g.RelativePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPErrorRangeParameters.
func (h HTTPErrorRangeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "begin", h.Begin)
	populate(objectMap, "end", h.End)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPErrorRangeParameters.
func (h *HTTPErrorRangeParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "begin":
			err = unpopulate(val, "Begin", &h.Begin)
			delete(rawMsg, key)
		case "end":
			err = unpopulate(val, "End", &h.End)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPVersionMatchConditionParameters.
func (h HTTPVersionMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", h.MatchValues)
	populate(objectMap, "negateCondition", h.NegateCondition)
	populate(objectMap, "operator", h.Operator)
	populate(objectMap, "transforms", h.Transforms)
	populate(objectMap, "typeName", h.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPVersionMatchConditionParameters.
func (h *HTTPVersionMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &h.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &h.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &h.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &h.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &h.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeaderActionParameters.
func (h HeaderActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "headerAction", h.HeaderAction)
	populate(objectMap, "headerName", h.HeaderName)
	populate(objectMap, "typeName", h.TypeName)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeaderActionParameters.
func (h *HeaderActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headerAction":
			err = unpopulate(val, "HeaderAction", &h.HeaderAction)
			delete(rawMsg, key)
		case "headerName":
			err = unpopulate(val, "HeaderName", &h.HeaderName)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &h.TypeName)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthProbeParameters.
func (h HealthProbeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "probeIntervalInSeconds", h.ProbeIntervalInSeconds)
	populate(objectMap, "probePath", h.ProbePath)
	populate(objectMap, "probeProtocol", h.ProbeProtocol)
	populate(objectMap, "probeRequestType", h.ProbeRequestType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthProbeParameters.
func (h *HealthProbeParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "probeIntervalInSeconds":
			err = unpopulate(val, "ProbeIntervalInSeconds", &h.ProbeIntervalInSeconds)
			delete(rawMsg, key)
		case "probePath":
			err = unpopulate(val, "ProbePath", &h.ProbePath)
			delete(rawMsg, key)
		case "probeProtocol":
			err = unpopulate(val, "ProbeProtocol", &h.ProbeProtocol)
			delete(rawMsg, key)
		case "probeRequestType":
			err = unpopulate(val, "ProbeRequestType", &h.ProbeRequestType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameMatchConditionParameters.
func (h HostNameMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", h.MatchValues)
	populate(objectMap, "negateCondition", h.NegateCondition)
	populate(objectMap, "operator", h.Operator)
	populate(objectMap, "transforms", h.Transforms)
	populate(objectMap, "typeName", h.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameMatchConditionParameters.
func (h *HostNameMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &h.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &h.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &h.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &h.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &h.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddressGroup.
func (i IPAddressGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deliveryRegion", i.DeliveryRegion)
	populate(objectMap, "ipv4Addresses", i.IPv4Addresses)
	populate(objectMap, "ipv6Addresses", i.IPv6Addresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddressGroup.
func (i *IPAddressGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliveryRegion":
			err = unpopulate(val, "DeliveryRegion", &i.DeliveryRegion)
			delete(rawMsg, key)
		case "ipv4Addresses":
			err = unpopulate(val, "IPv4Addresses", &i.IPv4Addresses)
			delete(rawMsg, key)
		case "ipv6Addresses":
			err = unpopulate(val, "IPv6Addresses", &i.IPv6Addresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IsDeviceMatchConditionParameters.
func (i IsDeviceMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", i.MatchValues)
	populate(objectMap, "negateCondition", i.NegateCondition)
	populate(objectMap, "operator", i.Operator)
	populate(objectMap, "transforms", i.Transforms)
	populate(objectMap, "typeName", i.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IsDeviceMatchConditionParameters.
func (i *IsDeviceMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &i.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &i.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &i.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &i.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &i.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultCertificateSourceParameters.
func (k KeyVaultCertificateSourceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleteRule", k.DeleteRule)
	populate(objectMap, "resourceGroupName", k.ResourceGroupName)
	populate(objectMap, "secretName", k.SecretName)
	populate(objectMap, "secretVersion", k.SecretVersion)
	populate(objectMap, "subscriptionId", k.SubscriptionID)
	populate(objectMap, "typeName", k.TypeName)
	populate(objectMap, "updateRule", k.UpdateRule)
	populate(objectMap, "vaultName", k.VaultName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultCertificateSourceParameters.
func (k *KeyVaultCertificateSourceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteRule":
			err = unpopulate(val, "DeleteRule", &k.DeleteRule)
			delete(rawMsg, key)
		case "resourceGroupName":
			err = unpopulate(val, "ResourceGroupName", &k.ResourceGroupName)
			delete(rawMsg, key)
		case "secretName":
			err = unpopulate(val, "SecretName", &k.SecretName)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &k.SecretVersion)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &k.SubscriptionID)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &k.TypeName)
			delete(rawMsg, key)
		case "updateRule":
			err = unpopulate(val, "UpdateRule", &k.UpdateRule)
			delete(rawMsg, key)
		case "vaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSigningKeyParameters.
func (k KeyVaultSigningKeyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceGroupName", k.ResourceGroupName)
	populate(objectMap, "secretName", k.SecretName)
	populate(objectMap, "secretVersion", k.SecretVersion)
	populate(objectMap, "subscriptionId", k.SubscriptionID)
	populate(objectMap, "typeName", k.TypeName)
	populate(objectMap, "vaultName", k.VaultName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSigningKeyParameters.
func (k *KeyVaultSigningKeyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceGroupName":
			err = unpopulate(val, "ResourceGroupName", &k.ResourceGroupName)
			delete(rawMsg, key)
		case "secretName":
			err = unpopulate(val, "SecretName", &k.SecretName)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &k.SecretVersion)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &k.SubscriptionID)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &k.TypeName)
			delete(rawMsg, key)
		case "vaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedEndpoint.
func (l LinkedEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedEndpoint.
func (l *LinkedEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingSettingsParameters.
func (l LoadBalancingSettingsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalLatencyInMilliseconds", l.AdditionalLatencyInMilliseconds)
	populate(objectMap, "sampleSize", l.SampleSize)
	populate(objectMap, "successfulSamplesRequired", l.SuccessfulSamplesRequired)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingSettingsParameters.
func (l *LoadBalancingSettingsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalLatencyInMilliseconds":
			err = unpopulate(val, "AdditionalLatencyInMilliseconds", &l.AdditionalLatencyInMilliseconds)
			delete(rawMsg, key)
		case "sampleSize":
			err = unpopulate(val, "SampleSize", &l.SampleSize)
			delete(rawMsg, key)
		case "successfulSamplesRequired":
			err = unpopulate(val, "SuccessfulSamplesRequired", &l.SuccessfulSamplesRequired)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadParameters.
func (l LoadParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentPaths", l.ContentPaths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadParameters.
func (l *LoadParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentPaths":
			err = unpopulate(val, "ContentPaths", &l.ContentPaths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", l.BlobDuration)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "logFilterPattern", l.LogFilterPattern)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &l.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "logFilterPattern":
			err = unpopulate(val, "LogFilterPattern", &l.LogFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCertificateParameters.
func (m ManagedCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expirationDate", m.ExpirationDate)
	populate(objectMap, "subject", m.Subject)
	objectMap["type"] = SecretTypeManagedCertificate
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedCertificateParameters.
func (m *ManagedCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulate(val, "ExpirationDate", &m.ExpirationDate)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &m.Subject)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedHTTPSParameters.
func (m ManagedHTTPSParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["certificateSource"] = CertificateSourceCdn
	populate(objectMap, "certificateSourceParameters", m.CertificateSourceParameters)
	populate(objectMap, "minimumTlsVersion", m.MinimumTLSVersion)
	populate(objectMap, "protocolType", m.ProtocolType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedHTTPSParameters.
func (m *ManagedHTTPSParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateSource":
			err = unpopulate(val, "CertificateSource", &m.CertificateSource)
			delete(rawMsg, key)
		case "certificateSourceParameters":
			err = unpopulate(val, "CertificateSourceParameters", &m.CertificateSourceParameters)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &m.MinimumTLSVersion)
			delete(rawMsg, key)
		case "protocolType":
			err = unpopulate(val, "ProtocolType", &m.ProtocolType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleDefinition.
func (m ManagedRuleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "ruleId", m.RuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleDefinition.
func (m *ManagedRuleDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &m.RuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleGroupDefinition.
func (m ManagedRuleGroupDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "ruleGroupName", m.RuleGroupName)
	populate(objectMap, "rules", m.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleGroupDefinition.
func (m *ManagedRuleGroupDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "ruleGroupName":
			err = unpopulate(val, "RuleGroupName", &m.RuleGroupName)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &m.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleGroupOverride.
func (m ManagedRuleGroupOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleGroupName", m.RuleGroupName)
	populate(objectMap, "rules", m.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleGroupOverride.
func (m *ManagedRuleGroupOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleGroupName":
			err = unpopulate(val, "RuleGroupName", &m.RuleGroupName)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &m.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleOverride.
func (m ManagedRuleOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", m.Action)
	populate(objectMap, "enabledState", m.EnabledState)
	populate(objectMap, "ruleId", m.RuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleOverride.
func (m *ManagedRuleOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &m.Action)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &m.EnabledState)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &m.RuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSet.
func (m ManagedRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "anomalyScore", m.AnomalyScore)
	populate(objectMap, "ruleGroupOverrides", m.RuleGroupOverrides)
	populate(objectMap, "ruleSetType", m.RuleSetType)
	populate(objectMap, "ruleSetVersion", m.RuleSetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSet.
func (m *ManagedRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "anomalyScore":
			err = unpopulate(val, "AnomalyScore", &m.AnomalyScore)
			delete(rawMsg, key)
		case "ruleGroupOverrides":
			err = unpopulate(val, "RuleGroupOverrides", &m.RuleGroupOverrides)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &m.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &m.RuleSetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetDefinition.
func (m ManagedRuleSetDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "sku", m.SKU)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSetDefinition.
func (m *ManagedRuleSetDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &m.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetDefinitionList.
func (m ManagedRuleSetDefinitionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSetDefinitionList.
func (m *ManagedRuleSetDefinitionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetDefinitionProperties.
func (m ManagedRuleSetDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "ruleGroups", m.RuleGroups)
	populate(objectMap, "ruleSetType", m.RuleSetType)
	populate(objectMap, "ruleSetVersion", m.RuleSetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSetDefinitionProperties.
func (m *ManagedRuleSetDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &m.RuleGroups)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &m.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &m.RuleSetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetList.
func (m ManagedRuleSetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managedRuleSets", m.ManagedRuleSets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSetList.
func (m *ManagedRuleSetList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managedRuleSets":
			err = unpopulate(val, "ManagedRuleSets", &m.ManagedRuleSets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MatchCondition.
func (m MatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValue", m.MatchValue)
	populate(objectMap, "matchVariable", m.MatchVariable)
	populate(objectMap, "negateCondition", m.NegateCondition)
	populate(objectMap, "operator", m.Operator)
	populate(objectMap, "selector", m.Selector)
	populate(objectMap, "transforms", m.Transforms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MatchCondition.
func (m *MatchCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValue":
			err = unpopulate(val, "MatchValue", &m.MatchValue)
			delete(rawMsg, key)
		case "matchVariable":
			err = unpopulate(val, "MatchVariable", &m.MatchVariable)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &m.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &m.Operator)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &m.Selector)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &m.Transforms)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricAvailability.
func (m MetricAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", m.BlobDuration)
	populate(objectMap, "timeGrain", m.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAvailability.
func (m *MetricAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &m.BlobDuration)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "availabilities", m.Availabilities)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "fillGapWithZero", m.FillGapWithZero)
	populate(objectMap, "isInternal", m.IsInternal)
	populate(objectMap, "metricFilterPattern", m.MetricFilterPattern)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "supportedTimeGrainTypes", m.SupportedTimeGrainTypes)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "availabilities":
			err = unpopulate(val, "Availabilities", &m.Availabilities)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &m.FillGapWithZero)
			delete(rawMsg, key)
		case "isInternal":
			err = unpopulate(val, "IsInternal", &m.IsInternal)
			delete(rawMsg, key)
		case "metricFilterPattern":
			err = unpopulate(val, "MetricFilterPattern", &m.MetricFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "supportedTimeGrainTypes":
			err = unpopulate(val, "SupportedTimeGrainTypes", &m.SupportedTimeGrainTypes)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricsResponse.
func (m MetricsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "dateTimeBegin", m.DateTimeBegin)
	populateDateTimeRFC3339(objectMap, "dateTimeEnd", m.DateTimeEnd)
	populate(objectMap, "granularity", m.Granularity)
	populate(objectMap, "series", m.Series)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricsResponse.
func (m *MetricsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTimeBegin":
			err = unpopulateDateTimeRFC3339(val, "DateTimeBegin", &m.DateTimeBegin)
			delete(rawMsg, key)
		case "dateTimeEnd":
			err = unpopulateDateTimeRFC3339(val, "DateTimeEnd", &m.DateTimeEnd)
			delete(rawMsg, key)
		case "granularity":
			err = unpopulate(val, "Granularity", &m.Granularity)
			delete(rawMsg, key)
		case "series":
			err = unpopulate(val, "Series", &m.Series)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricsResponseSeriesItem.
func (m MetricsResponseSeriesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", m.Data)
	populate(objectMap, "groups", m.Groups)
	populate(objectMap, "metric", m.Metric)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricsResponseSeriesItem.
func (m *MetricsResponseSeriesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &m.Data)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &m.Groups)
			delete(rawMsg, key)
		case "metric":
			err = unpopulate(val, "Metric", &m.Metric)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricsResponseSeriesPropertiesItemsItem.
func (m MetricsResponseSeriesPropertiesItemsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricsResponseSeriesPropertiesItemsItem.
func (m *MetricsResponseSeriesPropertiesItemsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateResult.
func (m MigrateResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateResult.
func (m *MigrateResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateResultProperties.
func (m MigrateResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "migratedProfileResourceId", m.MigratedProfileResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateResultProperties.
func (m *MigrateResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "migratedProfileResourceId":
			err = unpopulate(val, "MigratedProfileResourceID", &m.MigratedProfileResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationErrorType.
func (m MigrationErrorType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", m.Code)
	populate(objectMap, "errorMessage", m.ErrorMessage)
	populate(objectMap, "nextSteps", m.NextSteps)
	populate(objectMap, "resourceName", m.ResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationErrorType.
func (m *MigrationErrorType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &m.ErrorMessage)
			delete(rawMsg, key)
		case "nextSteps":
			err = unpopulate(val, "NextSteps", &m.NextSteps)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &m.ResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationParameters.
func (m MigrationParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "classicResourceReference", m.ClassicResourceReference)
	populate(objectMap, "migrationWebApplicationFirewallMappings", m.MigrationWebApplicationFirewallMappings)
	populate(objectMap, "profileName", m.ProfileName)
	populate(objectMap, "sku", m.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationParameters.
func (m *MigrationParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classicResourceReference":
			err = unpopulate(val, "ClassicResourceReference", &m.ClassicResourceReference)
			delete(rawMsg, key)
		case "migrationWebApplicationFirewallMappings":
			err = unpopulate(val, "MigrationWebApplicationFirewallMappings", &m.MigrationWebApplicationFirewallMappings)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &m.ProfileName)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &m.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationWebApplicationFirewallMapping.
func (m MigrationWebApplicationFirewallMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "migratedFrom", m.MigratedFrom)
	populate(objectMap, "migratedTo", m.MigratedTo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationWebApplicationFirewallMapping.
func (m *MigrationWebApplicationFirewallMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "migratedFrom":
			err = unpopulate(val, "MigratedFrom", &m.MigratedFrom)
			delete(rawMsg, key)
		case "migratedTo":
			err = unpopulate(val, "MigratedTo", &m.MigratedTo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.OperationProperties)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "OperationProperties", &o.OperationProperties)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationProperties.
func (o OperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationProperties.
func (o *OperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsListResult.
func (o OperationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsListResult.
func (o *OperationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Origin.
func (o Origin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Origin.
func (o *Origin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroup.
func (o OriginGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroup.
func (o *OriginGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupListResult.
func (o OriginGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroupListResult.
func (o *OriginGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupOverride.
func (o OriginGroupOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forwardingProtocol", o.ForwardingProtocol)
	populate(objectMap, "originGroup", o.OriginGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroupOverride.
func (o *OriginGroupOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forwardingProtocol":
			err = unpopulate(val, "ForwardingProtocol", &o.ForwardingProtocol)
			delete(rawMsg, key)
		case "originGroup":
			err = unpopulate(val, "OriginGroup", &o.OriginGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupOverrideAction.
func (o OriginGroupOverrideAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionOriginGroupOverride
	populate(objectMap, "parameters", o.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroupOverrideAction.
func (o *OriginGroupOverrideAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &o.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupOverrideActionParameters.
func (o OriginGroupOverrideActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "originGroup", o.OriginGroup)
	populate(objectMap, "typeName", o.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroupOverrideActionParameters.
func (o *OriginGroupOverrideActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "originGroup":
			err = unpopulate(val, "OriginGroup", &o.OriginGroup)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &o.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupProperties.
func (o OriginGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthProbeSettings", o.HealthProbeSettings)
	populate(objectMap, "origins", o.Origins)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	populate(objectMap, "resourceState", o.ResourceState)
	populate(objectMap, "responseBasedOriginErrorDetectionSettings", o.ResponseBasedOriginErrorDetectionSettings)
	populate(objectMap, "trafficRestorationTimeToHealedOrNewEndpointsInMinutes", o.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroupProperties.
func (o *OriginGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &o.HealthProbeSettings)
			delete(rawMsg, key)
		case "origins":
			err = unpopulate(val, "Origins", &o.Origins)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &o.ResourceState)
			delete(rawMsg, key)
		case "responseBasedOriginErrorDetectionSettings":
			err = unpopulate(val, "ResponseBasedOriginErrorDetectionSettings", &o.ResponseBasedOriginErrorDetectionSettings)
			delete(rawMsg, key)
		case "trafficRestorationTimeToHealedOrNewEndpointsInMinutes":
			err = unpopulate(val, "TrafficRestorationTimeToHealedOrNewEndpointsInMinutes", &o.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupUpdateParameters.
func (o OriginGroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroupUpdateParameters.
func (o *OriginGroupUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginGroupUpdatePropertiesParameters.
func (o OriginGroupUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthProbeSettings", o.HealthProbeSettings)
	populate(objectMap, "origins", o.Origins)
	populate(objectMap, "responseBasedOriginErrorDetectionSettings", o.ResponseBasedOriginErrorDetectionSettings)
	populate(objectMap, "trafficRestorationTimeToHealedOrNewEndpointsInMinutes", o.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginGroupUpdatePropertiesParameters.
func (o *OriginGroupUpdatePropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &o.HealthProbeSettings)
			delete(rawMsg, key)
		case "origins":
			err = unpopulate(val, "Origins", &o.Origins)
			delete(rawMsg, key)
		case "responseBasedOriginErrorDetectionSettings":
			err = unpopulate(val, "ResponseBasedOriginErrorDetectionSettings", &o.ResponseBasedOriginErrorDetectionSettings)
			delete(rawMsg, key)
		case "trafficRestorationTimeToHealedOrNewEndpointsInMinutes":
			err = unpopulate(val, "TrafficRestorationTimeToHealedOrNewEndpointsInMinutes", &o.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginListResult.
func (o OriginListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginListResult.
func (o *OriginListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginProperties.
func (o OriginProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", o.Enabled)
	populate(objectMap, "httpPort", o.HTTPPort)
	populate(objectMap, "httpsPort", o.HTTPSPort)
	populate(objectMap, "hostName", o.HostName)
	populate(objectMap, "originHostHeader", o.OriginHostHeader)
	populate(objectMap, "priority", o.Priority)
	populate(objectMap, "privateEndpointStatus", o.PrivateEndpointStatus)
	populate(objectMap, "privateLinkAlias", o.PrivateLinkAlias)
	populate(objectMap, "privateLinkApprovalMessage", o.PrivateLinkApprovalMessage)
	populate(objectMap, "privateLinkLocation", o.PrivateLinkLocation)
	populate(objectMap, "privateLinkResourceId", o.PrivateLinkResourceID)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	populate(objectMap, "resourceState", o.ResourceState)
	populate(objectMap, "weight", o.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginProperties.
func (o *OriginProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &o.Enabled)
			delete(rawMsg, key)
		case "httpPort":
			err = unpopulate(val, "HTTPPort", &o.HTTPPort)
			delete(rawMsg, key)
		case "httpsPort":
			err = unpopulate(val, "HTTPSPort", &o.HTTPSPort)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &o.HostName)
			delete(rawMsg, key)
		case "originHostHeader":
			err = unpopulate(val, "OriginHostHeader", &o.OriginHostHeader)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &o.Priority)
			delete(rawMsg, key)
		case "privateEndpointStatus":
			err = unpopulate(val, "PrivateEndpointStatus", &o.PrivateEndpointStatus)
			delete(rawMsg, key)
		case "privateLinkAlias":
			err = unpopulate(val, "PrivateLinkAlias", &o.PrivateLinkAlias)
			delete(rawMsg, key)
		case "privateLinkApprovalMessage":
			err = unpopulate(val, "PrivateLinkApprovalMessage", &o.PrivateLinkApprovalMessage)
			delete(rawMsg, key)
		case "privateLinkLocation":
			err = unpopulate(val, "PrivateLinkLocation", &o.PrivateLinkLocation)
			delete(rawMsg, key)
		case "privateLinkResourceId":
			err = unpopulate(val, "PrivateLinkResourceID", &o.PrivateLinkResourceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &o.ResourceState)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &o.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginUpdateParameters.
func (o OriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginUpdateParameters.
func (o *OriginUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OriginUpdatePropertiesParameters.
func (o OriginUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", o.Enabled)
	populate(objectMap, "httpPort", o.HTTPPort)
	populate(objectMap, "httpsPort", o.HTTPSPort)
	populate(objectMap, "hostName", o.HostName)
	populate(objectMap, "originHostHeader", o.OriginHostHeader)
	populate(objectMap, "priority", o.Priority)
	populate(objectMap, "privateLinkAlias", o.PrivateLinkAlias)
	populate(objectMap, "privateLinkApprovalMessage", o.PrivateLinkApprovalMessage)
	populate(objectMap, "privateLinkLocation", o.PrivateLinkLocation)
	populate(objectMap, "privateLinkResourceId", o.PrivateLinkResourceID)
	populate(objectMap, "weight", o.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OriginUpdatePropertiesParameters.
func (o *OriginUpdatePropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &o.Enabled)
			delete(rawMsg, key)
		case "httpPort":
			err = unpopulate(val, "HTTPPort", &o.HTTPPort)
			delete(rawMsg, key)
		case "httpsPort":
			err = unpopulate(val, "HTTPSPort", &o.HTTPSPort)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &o.HostName)
			delete(rawMsg, key)
		case "originHostHeader":
			err = unpopulate(val, "OriginHostHeader", &o.OriginHostHeader)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &o.Priority)
			delete(rawMsg, key)
		case "privateLinkAlias":
			err = unpopulate(val, "PrivateLinkAlias", &o.PrivateLinkAlias)
			delete(rawMsg, key)
		case "privateLinkApprovalMessage":
			err = unpopulate(val, "PrivateLinkApprovalMessage", &o.PrivateLinkApprovalMessage)
			delete(rawMsg, key)
		case "privateLinkLocation":
			err = unpopulate(val, "PrivateLinkLocation", &o.PrivateLinkLocation)
			delete(rawMsg, key)
		case "privateLinkResourceId":
			err = unpopulate(val, "PrivateLinkResourceID", &o.PrivateLinkResourceID)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &o.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicySettings.
func (p PolicySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultCustomBlockResponseBody", p.DefaultCustomBlockResponseBody)
	populate(objectMap, "defaultCustomBlockResponseStatusCode", p.DefaultCustomBlockResponseStatusCode)
	populate(objectMap, "defaultRedirectUrl", p.DefaultRedirectURL)
	populate(objectMap, "enabledState", p.EnabledState)
	populate(objectMap, "mode", p.Mode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicySettings.
func (p *PolicySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultCustomBlockResponseBody":
			err = unpopulate(val, "DefaultCustomBlockResponseBody", &p.DefaultCustomBlockResponseBody)
			delete(rawMsg, key)
		case "defaultCustomBlockResponseStatusCode":
			err = unpopulate(val, "DefaultCustomBlockResponseStatusCode", &p.DefaultCustomBlockResponseStatusCode)
			delete(rawMsg, key)
		case "defaultRedirectUrl":
			err = unpopulate(val, "DefaultRedirectURL", &p.DefaultRedirectURL)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &p.EnabledState)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &p.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostArgsMatchConditionParameters.
func (p PostArgsMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", p.MatchValues)
	populate(objectMap, "negateCondition", p.NegateCondition)
	populate(objectMap, "operator", p.Operator)
	populate(objectMap, "selector", p.Selector)
	populate(objectMap, "transforms", p.Transforms)
	populate(objectMap, "typeName", p.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostArgsMatchConditionParameters.
func (p *PostArgsMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &p.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &p.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &p.Operator)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &p.Selector)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &p.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &p.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Profile.
func (p *Profile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileChangeSKUWafMapping.
func (p ProfileChangeSKUWafMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "changeToWafPolicy", p.ChangeToWafPolicy)
	populate(objectMap, "securityPolicyName", p.SecurityPolicyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileChangeSKUWafMapping.
func (p *ProfileChangeSKUWafMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changeToWafPolicy":
			err = unpopulate(val, "ChangeToWafPolicy", &p.ChangeToWafPolicy)
			delete(rawMsg, key)
		case "securityPolicyName":
			err = unpopulate(val, "SecurityPolicyName", &p.SecurityPolicyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileListResult.
func (p ProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileListResult.
func (p *ProfileListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileLogScrubbing.
func (p ProfileLogScrubbing) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scrubbingRules", p.ScrubbingRules)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileLogScrubbing.
func (p *ProfileLogScrubbing) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scrubbingRules":
			err = unpopulate(val, "ScrubbingRules", &p.ScrubbingRules)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileProperties.
func (p ProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedProperties", p.ExtendedProperties)
	populate(objectMap, "frontDoorId", p.FrontDoorID)
	populate(objectMap, "logScrubbing", p.LogScrubbing)
	populate(objectMap, "originResponseTimeoutSeconds", p.OriginResponseTimeoutSeconds)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "resourceState", p.ResourceState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileProperties.
func (p *ProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &p.ExtendedProperties)
			delete(rawMsg, key)
		case "frontDoorId":
			err = unpopulate(val, "FrontDoorID", &p.FrontDoorID)
			delete(rawMsg, key)
		case "logScrubbing":
			err = unpopulate(val, "LogScrubbing", &p.LogScrubbing)
			delete(rawMsg, key)
		case "originResponseTimeoutSeconds":
			err = unpopulate(val, "OriginResponseTimeoutSeconds", &p.OriginResponseTimeoutSeconds)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &p.ResourceState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfilePropertiesUpdateParameters.
func (p ProfilePropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logScrubbing", p.LogScrubbing)
	populate(objectMap, "originResponseTimeoutSeconds", p.OriginResponseTimeoutSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfilePropertiesUpdateParameters.
func (p *ProfilePropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logScrubbing":
			err = unpopulate(val, "LogScrubbing", &p.LogScrubbing)
			delete(rawMsg, key)
		case "originResponseTimeoutSeconds":
			err = unpopulate(val, "OriginResponseTimeoutSeconds", &p.OriginResponseTimeoutSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileScrubbingRules.
func (p ProfileScrubbingRules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchVariable", p.MatchVariable)
	populate(objectMap, "selector", p.Selector)
	populate(objectMap, "selectorMatchOperator", p.SelectorMatchOperator)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileScrubbingRules.
func (p *ProfileScrubbingRules) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchVariable":
			err = unpopulate(val, "MatchVariable", &p.MatchVariable)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &p.Selector)
			delete(rawMsg, key)
		case "selectorMatchOperator":
			err = unpopulate(val, "SelectorMatchOperator", &p.SelectorMatchOperator)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileUpdateParameters.
func (p ProfileUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileUpdateParameters.
func (p *ProfileUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileUpgradeParameters.
func (p ProfileUpgradeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "wafMappingList", p.WafMappingList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileUpgradeParameters.
func (p *ProfileUpgradeParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "wafMappingList":
			err = unpopulate(val, "WafMappingList", &p.WafMappingList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurgeParameters.
func (p PurgeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentPaths", p.ContentPaths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurgeParameters.
func (p *PurgeParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentPaths":
			err = unpopulate(val, "ContentPaths", &p.ContentPaths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryStringMatchConditionParameters.
func (q QueryStringMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", q.MatchValues)
	populate(objectMap, "negateCondition", q.NegateCondition)
	populate(objectMap, "operator", q.Operator)
	populate(objectMap, "transforms", q.Transforms)
	populate(objectMap, "typeName", q.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryStringMatchConditionParameters.
func (q *QueryStringMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &q.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &q.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &q.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &q.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &q.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RankingsResponse.
func (r RankingsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "dateTimeBegin", r.DateTimeBegin)
	populateDateTimeRFC3339(objectMap, "dateTimeEnd", r.DateTimeEnd)
	populate(objectMap, "tables", r.Tables)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RankingsResponse.
func (r *RankingsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTimeBegin":
			err = unpopulateDateTimeRFC3339(val, "DateTimeBegin", &r.DateTimeBegin)
			delete(rawMsg, key)
		case "dateTimeEnd":
			err = unpopulateDateTimeRFC3339(val, "DateTimeEnd", &r.DateTimeEnd)
			delete(rawMsg, key)
		case "tables":
			err = unpopulate(val, "Tables", &r.Tables)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RankingsResponseTablesItem.
func (r RankingsResponseTablesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", r.Data)
	populate(objectMap, "ranking", r.Ranking)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RankingsResponseTablesItem.
func (r *RankingsResponseTablesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &r.Data)
			delete(rawMsg, key)
		case "ranking":
			err = unpopulate(val, "Ranking", &r.Ranking)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RankingsResponseTablesPropertiesItemsItem.
func (r RankingsResponseTablesPropertiesItemsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metrics", r.Metrics)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RankingsResponseTablesPropertiesItemsItem.
func (r *RankingsResponseTablesPropertiesItemsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metrics":
			err = unpopulate(val, "Metrics", &r.Metrics)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RankingsResponseTablesPropertiesItemsMetricsItem.
func (r RankingsResponseTablesPropertiesItemsMetricsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metric", r.Metric)
	populate(objectMap, "percentage", r.Percentage)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RankingsResponseTablesPropertiesItemsMetricsItem.
func (r *RankingsResponseTablesPropertiesItemsMetricsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metric":
			err = unpopulate(val, "Metric", &r.Metric)
			delete(rawMsg, key)
		case "percentage":
			err = unpopulate(val, "Percentage", &r.Percentage)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RateLimitRule.
func (r RateLimitRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", r.Action)
	populate(objectMap, "enabledState", r.EnabledState)
	populate(objectMap, "matchConditions", r.MatchConditions)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "priority", r.Priority)
	populate(objectMap, "rateLimitDurationInMinutes", r.RateLimitDurationInMinutes)
	populate(objectMap, "rateLimitThreshold", r.RateLimitThreshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RateLimitRule.
func (r *RateLimitRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &r.Action)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &r.EnabledState)
			delete(rawMsg, key)
		case "matchConditions":
			err = unpopulate(val, "MatchConditions", &r.MatchConditions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &r.Priority)
			delete(rawMsg, key)
		case "rateLimitDurationInMinutes":
			err = unpopulate(val, "RateLimitDurationInMinutes", &r.RateLimitDurationInMinutes)
			delete(rawMsg, key)
		case "rateLimitThreshold":
			err = unpopulate(val, "RateLimitThreshold", &r.RateLimitThreshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RateLimitRuleList.
func (r RateLimitRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rules", r.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RateLimitRuleList.
func (r *RateLimitRuleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &r.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoteAddressMatchConditionParameters.
func (r RemoteAddressMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoteAddressMatchConditionParameters.
func (r *RemoteAddressMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &r.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &r.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &r.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &r.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &r.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestBodyMatchConditionParameters.
func (r RequestBodyMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestBodyMatchConditionParameters.
func (r *RequestBodyMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &r.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &r.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &r.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &r.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &r.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestHeaderMatchConditionParameters.
func (r RequestHeaderMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "selector", r.Selector)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHeaderMatchConditionParameters.
func (r *RequestHeaderMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &r.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &r.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &r.Operator)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &r.Selector)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &r.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &r.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestMethodMatchConditionParameters.
func (r RequestMethodMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestMethodMatchConditionParameters.
func (r *RequestMethodMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &r.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &r.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &r.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &r.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &r.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestSchemeMatchConditionParameters.
func (r RequestSchemeMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestSchemeMatchConditionParameters.
func (r *RequestSchemeMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &r.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &r.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &r.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &r.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &r.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestURIMatchConditionParameters.
func (r RequestURIMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", r.MatchValues)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "transforms", r.Transforms)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestURIMatchConditionParameters.
func (r *RequestURIMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &r.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &r.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &r.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &r.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &r.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceReference.
func (r ResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceReference.
func (r *ResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceUsage.
func (r ResourceUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", r.CurrentValue)
	populate(objectMap, "limit", r.Limit)
	populate(objectMap, "resourceType", r.ResourceType)
	populate(objectMap, "unit", r.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceUsage.
func (r *ResourceUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &r.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &r.Limit)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &r.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceUsageListResult.
func (r ResourceUsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceUsageListResult.
func (r *ResourceUsageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcesResponse.
func (r ResourcesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customDomains", r.CustomDomains)
	populate(objectMap, "endpoints", r.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcesResponse.
func (r *ResourcesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDomains":
			err = unpopulate(val, "CustomDomains", &r.CustomDomains)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &r.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcesResponseCustomDomainsItem.
func (r ResourcesResponseCustomDomainsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointId", r.EndpointID)
	populate(objectMap, "history", r.History)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcesResponseCustomDomainsItem.
func (r *ResourcesResponseCustomDomainsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointId":
			err = unpopulate(val, "EndpointID", &r.EndpointID)
			delete(rawMsg, key)
		case "history":
			err = unpopulate(val, "History", &r.History)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcesResponseEndpointsItem.
func (r ResourcesResponseEndpointsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customDomains", r.CustomDomains)
	populate(objectMap, "history", r.History)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcesResponseEndpointsItem.
func (r *ResourcesResponseEndpointsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDomains":
			err = unpopulate(val, "CustomDomains", &r.CustomDomains)
			delete(rawMsg, key)
		case "history":
			err = unpopulate(val, "History", &r.History)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcesResponseEndpointsPropertiesItemsItem.
func (r ResourcesResponseEndpointsPropertiesItemsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointId", r.EndpointID)
	populate(objectMap, "history", r.History)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcesResponseEndpointsPropertiesItemsItem.
func (r *ResourcesResponseEndpointsPropertiesItemsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointId":
			err = unpopulate(val, "EndpointID", &r.EndpointID)
			delete(rawMsg, key)
		case "history":
			err = unpopulate(val, "History", &r.History)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResponseBasedOriginErrorDetectionParameters.
func (r ResponseBasedOriginErrorDetectionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "httpErrorRanges", r.HTTPErrorRanges)
	populate(objectMap, "responseBasedDetectedErrorTypes", r.ResponseBasedDetectedErrorTypes)
	populate(objectMap, "responseBasedFailoverThresholdPercentage", r.ResponseBasedFailoverThresholdPercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResponseBasedOriginErrorDetectionParameters.
func (r *ResponseBasedOriginErrorDetectionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpErrorRanges":
			err = unpopulate(val, "HTTPErrorRanges", &r.HTTPErrorRanges)
			delete(rawMsg, key)
		case "responseBasedDetectedErrorTypes":
			err = unpopulate(val, "ResponseBasedDetectedErrorTypes", &r.ResponseBasedDetectedErrorTypes)
			delete(rawMsg, key)
		case "responseBasedFailoverThresholdPercentage":
			err = unpopulate(val, "ResponseBasedFailoverThresholdPercentage", &r.ResponseBasedFailoverThresholdPercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Route.
func (r *Route) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteConfigurationOverrideActionParameters.
func (r RouteConfigurationOverrideActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheConfiguration", r.CacheConfiguration)
	populate(objectMap, "originGroupOverride", r.OriginGroupOverride)
	populate(objectMap, "typeName", r.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteConfigurationOverrideActionParameters.
func (r *RouteConfigurationOverrideActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheConfiguration":
			err = unpopulate(val, "CacheConfiguration", &r.CacheConfiguration)
			delete(rawMsg, key)
		case "originGroupOverride":
			err = unpopulate(val, "OriginGroupOverride", &r.OriginGroupOverride)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &r.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteListResult.
func (r RouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteListResult.
func (r *RouteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteProperties.
func (r RouteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheConfiguration", r.CacheConfiguration)
	populate(objectMap, "customDomains", r.CustomDomains)
	populate(objectMap, "deploymentStatus", r.DeploymentStatus)
	populate(objectMap, "enabledState", r.EnabledState)
	populate(objectMap, "endpointName", r.EndpointName)
	populate(objectMap, "forwardingProtocol", r.ForwardingProtocol)
	populate(objectMap, "httpsRedirect", r.HTTPSRedirect)
	populate(objectMap, "linkToDefaultDomain", r.LinkToDefaultDomain)
	populate(objectMap, "originGroup", r.OriginGroup)
	populate(objectMap, "originPath", r.OriginPath)
	populate(objectMap, "patternsToMatch", r.PatternsToMatch)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "ruleSets", r.RuleSets)
	populate(objectMap, "supportedProtocols", r.SupportedProtocols)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteProperties.
func (r *RouteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheConfiguration":
			err = unpopulate(val, "CacheConfiguration", &r.CacheConfiguration)
			delete(rawMsg, key)
		case "customDomains":
			err = unpopulate(val, "CustomDomains", &r.CustomDomains)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &r.DeploymentStatus)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &r.EnabledState)
			delete(rawMsg, key)
		case "endpointName":
			err = unpopulate(val, "EndpointName", &r.EndpointName)
			delete(rawMsg, key)
		case "forwardingProtocol":
			err = unpopulate(val, "ForwardingProtocol", &r.ForwardingProtocol)
			delete(rawMsg, key)
		case "httpsRedirect":
			err = unpopulate(val, "HTTPSRedirect", &r.HTTPSRedirect)
			delete(rawMsg, key)
		case "linkToDefaultDomain":
			err = unpopulate(val, "LinkToDefaultDomain", &r.LinkToDefaultDomain)
			delete(rawMsg, key)
		case "originGroup":
			err = unpopulate(val, "OriginGroup", &r.OriginGroup)
			delete(rawMsg, key)
		case "originPath":
			err = unpopulate(val, "OriginPath", &r.OriginPath)
			delete(rawMsg, key)
		case "patternsToMatch":
			err = unpopulate(val, "PatternsToMatch", &r.PatternsToMatch)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "ruleSets":
			err = unpopulate(val, "RuleSets", &r.RuleSets)
			delete(rawMsg, key)
		case "supportedProtocols":
			err = unpopulate(val, "SupportedProtocols", &r.SupportedProtocols)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteUpdateParameters.
func (r RouteUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteUpdateParameters.
func (r *RouteUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteUpdatePropertiesParameters.
func (r RouteUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheConfiguration", r.CacheConfiguration)
	populate(objectMap, "customDomains", r.CustomDomains)
	populate(objectMap, "enabledState", r.EnabledState)
	populate(objectMap, "endpointName", r.EndpointName)
	populate(objectMap, "forwardingProtocol", r.ForwardingProtocol)
	populate(objectMap, "httpsRedirect", r.HTTPSRedirect)
	populate(objectMap, "linkToDefaultDomain", r.LinkToDefaultDomain)
	populate(objectMap, "originGroup", r.OriginGroup)
	populate(objectMap, "originPath", r.OriginPath)
	populate(objectMap, "patternsToMatch", r.PatternsToMatch)
	populate(objectMap, "ruleSets", r.RuleSets)
	populate(objectMap, "supportedProtocols", r.SupportedProtocols)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteUpdatePropertiesParameters.
func (r *RouteUpdatePropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheConfiguration":
			err = unpopulate(val, "CacheConfiguration", &r.CacheConfiguration)
			delete(rawMsg, key)
		case "customDomains":
			err = unpopulate(val, "CustomDomains", &r.CustomDomains)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &r.EnabledState)
			delete(rawMsg, key)
		case "endpointName":
			err = unpopulate(val, "EndpointName", &r.EndpointName)
			delete(rawMsg, key)
		case "forwardingProtocol":
			err = unpopulate(val, "ForwardingProtocol", &r.ForwardingProtocol)
			delete(rawMsg, key)
		case "httpsRedirect":
			err = unpopulate(val, "HTTPSRedirect", &r.HTTPSRedirect)
			delete(rawMsg, key)
		case "linkToDefaultDomain":
			err = unpopulate(val, "LinkToDefaultDomain", &r.LinkToDefaultDomain)
			delete(rawMsg, key)
		case "originGroup":
			err = unpopulate(val, "OriginGroup", &r.OriginGroup)
			delete(rawMsg, key)
		case "originPath":
			err = unpopulate(val, "OriginPath", &r.OriginPath)
			delete(rawMsg, key)
		case "patternsToMatch":
			err = unpopulate(val, "PatternsToMatch", &r.PatternsToMatch)
			delete(rawMsg, key)
		case "ruleSets":
			err = unpopulate(val, "RuleSets", &r.RuleSets)
			delete(rawMsg, key)
		case "supportedProtocols":
			err = unpopulate(val, "SupportedProtocols", &r.SupportedProtocols)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Rule.
func (r Rule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Rule.
func (r *Rule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleListResult.
func (r RuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleListResult.
func (r *RuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleProperties.
func (r RuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", r.Actions)
	populate(objectMap, "conditions", r.Conditions)
	populate(objectMap, "deploymentStatus", r.DeploymentStatus)
	populate(objectMap, "matchProcessingBehavior", r.MatchProcessingBehavior)
	populate(objectMap, "order", r.Order)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "ruleSetName", r.RuleSetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleProperties.
func (r *RuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			r.Actions, err = unmarshalDeliveryRuleActionAutoGeneratedClassificationArray(val)
			delete(rawMsg, key)
		case "conditions":
			r.Conditions, err = unmarshalDeliveryRuleConditionClassificationArray(val)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &r.DeploymentStatus)
			delete(rawMsg, key)
		case "matchProcessingBehavior":
			err = unpopulate(val, "MatchProcessingBehavior", &r.MatchProcessingBehavior)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &r.Order)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "ruleSetName":
			err = unpopulate(val, "RuleSetName", &r.RuleSetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleSet.
func (r RuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleSet.
func (r *RuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleSetListResult.
func (r RuleSetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleSetListResult.
func (r *RuleSetListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleSetProperties.
func (r RuleSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentStatus", r.DeploymentStatus)
	populate(objectMap, "profileName", r.ProfileName)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleSetProperties.
func (r *RuleSetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &r.DeploymentStatus)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &r.ProfileName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleUpdateParameters.
func (r RuleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleUpdateParameters.
func (r *RuleUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleUpdatePropertiesParameters.
func (r RuleUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", r.Actions)
	populate(objectMap, "conditions", r.Conditions)
	populate(objectMap, "matchProcessingBehavior", r.MatchProcessingBehavior)
	populate(objectMap, "order", r.Order)
	populate(objectMap, "ruleSetName", r.RuleSetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleUpdatePropertiesParameters.
func (r *RuleUpdatePropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			r.Actions, err = unmarshalDeliveryRuleActionAutoGeneratedClassificationArray(val)
			delete(rawMsg, key)
		case "conditions":
			r.Conditions, err = unmarshalDeliveryRuleConditionClassificationArray(val)
			delete(rawMsg, key)
		case "matchProcessingBehavior":
			err = unpopulate(val, "MatchProcessingBehavior", &r.MatchProcessingBehavior)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &r.Order)
			delete(rawMsg, key)
		case "ruleSetName":
			err = unpopulate(val, "RuleSetName", &r.RuleSetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSLProtocolMatchConditionParameters.
func (s SSLProtocolMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", s.MatchValues)
	populate(objectMap, "negateCondition", s.NegateCondition)
	populate(objectMap, "operator", s.Operator)
	populate(objectMap, "transforms", s.Transforms)
	populate(objectMap, "typeName", s.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSLProtocolMatchConditionParameters.
func (s *SSLProtocolMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &s.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &s.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &s.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &s.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &s.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Secret.
func (s *Secret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretListResult.
func (s SecretListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretListResult.
func (s *SecretListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretParameters.
func (s SecretParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = s.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretParameters.
func (s *SecretParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretProperties.
func (s SecretProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentStatus", s.DeploymentStatus)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "profileName", s.ProfileName)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretProperties.
func (s *SecretProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &s.DeploymentStatus)
			delete(rawMsg, key)
		case "parameters":
			s.Parameters, err = unmarshalSecretParametersClassification(val)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &s.ProfileName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicy.
func (s SecurityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicy.
func (s *SecurityPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyListResult.
func (s SecurityPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyListResult.
func (s *SecurityPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyProperties.
func (s SecurityPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentStatus", s.DeploymentStatus)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "profileName", s.ProfileName)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyProperties.
func (s *SecurityPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &s.DeploymentStatus)
			delete(rawMsg, key)
		case "parameters":
			s.Parameters, err = unmarshalSecurityPolicyPropertiesParametersClassification(val)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &s.ProfileName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyPropertiesParameters.
func (s SecurityPolicyPropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = s.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyPropertiesParameters.
func (s *SecurityPolicyPropertiesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyUpdateParameters.
func (s SecurityPolicyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyUpdateParameters.
func (s *SecurityPolicyUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyUpdateProperties.
func (s SecurityPolicyUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameters", s.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyUpdateProperties.
func (s *SecurityPolicyUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			s.Parameters, err = unmarshalSecurityPolicyPropertiesParametersClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyWebApplicationFirewallAssociation.
func (s SecurityPolicyWebApplicationFirewallAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domains", s.Domains)
	populate(objectMap, "patternsToMatch", s.PatternsToMatch)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyWebApplicationFirewallAssociation.
func (s *SecurityPolicyWebApplicationFirewallAssociation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domains":
			err = unpopulate(val, "Domains", &s.Domains)
			delete(rawMsg, key)
		case "patternsToMatch":
			err = unpopulate(val, "PatternsToMatch", &s.PatternsToMatch)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyWebApplicationFirewallParameters.
func (s SecurityPolicyWebApplicationFirewallParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associations", s.Associations)
	objectMap["type"] = SecurityPolicyTypeWebApplicationFirewall
	populate(objectMap, "wafPolicy", s.WafPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyWebApplicationFirewallParameters.
func (s *SecurityPolicyWebApplicationFirewallParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associations":
			err = unpopulate(val, "Associations", &s.Associations)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "wafPolicy":
			err = unpopulate(val, "WafPolicy", &s.WafPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerPortMatchConditionParameters.
func (s ServerPortMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", s.MatchValues)
	populate(objectMap, "negateCondition", s.NegateCondition)
	populate(objectMap, "operator", s.Operator)
	populate(objectMap, "transforms", s.Transforms)
	populate(objectMap, "typeName", s.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerPortMatchConditionParameters.
func (s *ServerPortMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &s.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &s.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &s.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &s.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &s.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", s.LogSpecifications)
	populate(objectMap, "metricSpecifications", s.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &s.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &s.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedPrivateLinkResourceProperties.
func (s SharedPrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", s.GroupID)
	populate(objectMap, "privateLink", s.PrivateLink)
	populate(objectMap, "privateLinkLocation", s.PrivateLinkLocation)
	populate(objectMap, "requestMessage", s.RequestMessage)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedPrivateLinkResourceProperties.
func (s *SharedPrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &s.GroupID)
			delete(rawMsg, key)
		case "privateLink":
			err = unpopulate(val, "PrivateLink", &s.PrivateLink)
			delete(rawMsg, key)
		case "privateLinkLocation":
			err = unpopulate(val, "PrivateLinkLocation", &s.PrivateLinkLocation)
			delete(rawMsg, key)
		case "requestMessage":
			err = unpopulate(val, "RequestMessage", &s.RequestMessage)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SocketAddrMatchConditionParameters.
func (s SocketAddrMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", s.MatchValues)
	populate(objectMap, "negateCondition", s.NegateCondition)
	populate(objectMap, "operator", s.Operator)
	populate(objectMap, "transforms", s.Transforms)
	populate(objectMap, "typeName", s.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SocketAddrMatchConditionParameters.
func (s *SocketAddrMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &s.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &s.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &s.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &s.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &s.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SsoURI.
func (s SsoURI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ssoUriValue", s.SsoURIValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsoURI.
func (s *SsoURI) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ssoUriValue":
			err = unpopulate(val, "SsoURIValue", &s.SsoURIValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedOptimizationTypesListResult.
func (s SupportedOptimizationTypesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportedOptimizationTypes", s.SupportedOptimizationTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedOptimizationTypesListResult.
func (s *SupportedOptimizationTypesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportedOptimizationTypes":
			err = unpopulate(val, "SupportedOptimizationTypes", &s.SupportedOptimizationTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLFileExtensionMatchConditionParameters.
func (u URLFileExtensionMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", u.MatchValues)
	populate(objectMap, "negateCondition", u.NegateCondition)
	populate(objectMap, "operator", u.Operator)
	populate(objectMap, "transforms", u.Transforms)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLFileExtensionMatchConditionParameters.
func (u *URLFileExtensionMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &u.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &u.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &u.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &u.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &u.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLFileNameMatchConditionParameters.
func (u URLFileNameMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", u.MatchValues)
	populate(objectMap, "negateCondition", u.NegateCondition)
	populate(objectMap, "operator", u.Operator)
	populate(objectMap, "transforms", u.Transforms)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLFileNameMatchConditionParameters.
func (u *URLFileNameMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &u.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &u.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &u.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &u.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &u.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLPathMatchConditionParameters.
func (u URLPathMatchConditionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", u.MatchValues)
	populate(objectMap, "negateCondition", u.NegateCondition)
	populate(objectMap, "operator", u.Operator)
	populate(objectMap, "transforms", u.Transforms)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLPathMatchConditionParameters.
func (u *URLPathMatchConditionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &u.MatchValues)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &u.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &u.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &u.Transforms)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &u.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLRedirectAction.
func (u URLRedirectAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionURLRedirect
	populate(objectMap, "parameters", u.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLRedirectAction.
func (u *URLRedirectAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &u.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLRedirectActionParameters.
func (u URLRedirectActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customFragment", u.CustomFragment)
	populate(objectMap, "customHostname", u.CustomHostname)
	populate(objectMap, "customPath", u.CustomPath)
	populate(objectMap, "customQueryString", u.CustomQueryString)
	populate(objectMap, "destinationProtocol", u.DestinationProtocol)
	populate(objectMap, "redirectType", u.RedirectType)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLRedirectActionParameters.
func (u *URLRedirectActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customFragment":
			err = unpopulate(val, "CustomFragment", &u.CustomFragment)
			delete(rawMsg, key)
		case "customHostname":
			err = unpopulate(val, "CustomHostname", &u.CustomHostname)
			delete(rawMsg, key)
		case "customPath":
			err = unpopulate(val, "CustomPath", &u.CustomPath)
			delete(rawMsg, key)
		case "customQueryString":
			err = unpopulate(val, "CustomQueryString", &u.CustomQueryString)
			delete(rawMsg, key)
		case "destinationProtocol":
			err = unpopulate(val, "DestinationProtocol", &u.DestinationProtocol)
			delete(rawMsg, key)
		case "redirectType":
			err = unpopulate(val, "RedirectType", &u.RedirectType)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &u.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLRewriteAction.
func (u URLRewriteAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionURLRewrite
	populate(objectMap, "parameters", u.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLRewriteAction.
func (u *URLRewriteAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &u.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLRewriteActionParameters.
func (u URLRewriteActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", u.Destination)
	populate(objectMap, "preserveUnmatchedPath", u.PreserveUnmatchedPath)
	populate(objectMap, "sourcePattern", u.SourcePattern)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLRewriteActionParameters.
func (u *URLRewriteActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &u.Destination)
			delete(rawMsg, key)
		case "preserveUnmatchedPath":
			err = unpopulate(val, "PreserveUnmatchedPath", &u.PreserveUnmatchedPath)
			delete(rawMsg, key)
		case "sourcePattern":
			err = unpopulate(val, "SourcePattern", &u.SourcePattern)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &u.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLSigningAction.
func (u URLSigningAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = DeliveryRuleActionURLSigning
	populate(objectMap, "parameters", u.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLSigningAction.
func (u *URLSigningAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &u.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLSigningActionParameters.
func (u URLSigningActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "algorithm", u.Algorithm)
	populate(objectMap, "parameterNameOverride", u.ParameterNameOverride)
	populate(objectMap, "typeName", u.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLSigningActionParameters.
func (u *URLSigningActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "algorithm":
			err = unpopulate(val, "Algorithm", &u.Algorithm)
			delete(rawMsg, key)
		case "parameterNameOverride":
			err = unpopulate(val, "ParameterNameOverride", &u.ParameterNameOverride)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &u.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLSigningKey.
func (u URLSigningKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyId", u.KeyID)
	populate(objectMap, "keySourceParameters", u.KeySourceParameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLSigningKey.
func (u *URLSigningKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyId":
			err = unpopulate(val, "KeyID", &u.KeyID)
			delete(rawMsg, key)
		case "keySourceParameters":
			err = unpopulate(val, "KeySourceParameters", &u.KeySourceParameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLSigningKeyParameters.
func (u URLSigningKeyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyId", u.KeyID)
	populate(objectMap, "secretSource", u.SecretSource)
	populate(objectMap, "secretVersion", u.SecretVersion)
	objectMap["type"] = SecretTypeURLSigningKey
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLSigningKeyParameters.
func (u *URLSigningKeyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyId":
			err = unpopulate(val, "KeyID", &u.KeyID)
			delete(rawMsg, key)
		case "secretSource":
			err = unpopulate(val, "SecretSource", &u.SecretSource)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &u.SecretVersion)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLSigningParamIdentifier.
func (u URLSigningParamIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "paramIndicator", u.ParamIndicator)
	populate(objectMap, "paramName", u.ParamName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLSigningParamIdentifier.
func (u *URLSigningParamIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "paramIndicator":
			err = unpopulate(val, "ParamIndicator", &u.ParamIndicator)
			delete(rawMsg, key)
		case "paramName":
			err = unpopulate(val, "ParamName", &u.ParamName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageName.
func (u UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", u.LocalizedValue)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageName.
func (u *UsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &u.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsagesListResult.
func (u UsagesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsagesListResult.
func (u *UsagesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserManagedHTTPSParameters.
func (u UserManagedHTTPSParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["certificateSource"] = CertificateSourceAzureKeyVault
	populate(objectMap, "certificateSourceParameters", u.CertificateSourceParameters)
	populate(objectMap, "minimumTlsVersion", u.MinimumTLSVersion)
	populate(objectMap, "protocolType", u.ProtocolType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserManagedHTTPSParameters.
func (u *UserManagedHTTPSParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateSource":
			err = unpopulate(val, "CertificateSource", &u.CertificateSource)
			delete(rawMsg, key)
		case "certificateSourceParameters":
			err = unpopulate(val, "CertificateSourceParameters", &u.CertificateSourceParameters)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &u.MinimumTLSVersion)
			delete(rawMsg, key)
		case "protocolType":
			err = unpopulate(val, "ProtocolType", &u.ProtocolType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateCustomDomainInput.
func (v ValidateCustomDomainInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostName", v.HostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateCustomDomainInput.
func (v *ValidateCustomDomainInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostName":
			err = unpopulate(val, "HostName", &v.HostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateCustomDomainOutput.
func (v ValidateCustomDomainOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customDomainValidated", v.CustomDomainValidated)
	populate(objectMap, "message", v.Message)
	populate(objectMap, "reason", v.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateCustomDomainOutput.
func (v *ValidateCustomDomainOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDomainValidated":
			err = unpopulate(val, "CustomDomainValidated", &v.CustomDomainValidated)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &v.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateProbeInput.
func (v ValidateProbeInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "probeURL", v.ProbeURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateProbeInput.
func (v *ValidateProbeInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "probeURL":
			err = unpopulate(val, "ProbeURL", &v.ProbeURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateProbeOutput.
func (v ValidateProbeOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", v.ErrorCode)
	populate(objectMap, "isValid", v.IsValid)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateProbeOutput.
func (v *ValidateProbeOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &v.ErrorCode)
			delete(rawMsg, key)
		case "isValid":
			err = unpopulate(val, "IsValid", &v.IsValid)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateSecretInput.
func (v ValidateSecretInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretSource", v.SecretSource)
	populate(objectMap, "secretType", v.SecretType)
	populate(objectMap, "secretVersion", v.SecretVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateSecretInput.
func (v *ValidateSecretInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretSource":
			err = unpopulate(val, "SecretSource", &v.SecretSource)
			delete(rawMsg, key)
		case "secretType":
			err = unpopulate(val, "SecretType", &v.SecretType)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &v.SecretVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateSecretOutput.
func (v ValidateSecretOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", v.Message)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateSecretOutput.
func (v *ValidateSecretOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WafMetricsResponse.
func (w WafMetricsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "dateTimeBegin", w.DateTimeBegin)
	populateDateTimeRFC3339(objectMap, "dateTimeEnd", w.DateTimeEnd)
	populate(objectMap, "granularity", w.Granularity)
	populate(objectMap, "series", w.Series)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WafMetricsResponse.
func (w *WafMetricsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTimeBegin":
			err = unpopulateDateTimeRFC3339(val, "DateTimeBegin", &w.DateTimeBegin)
			delete(rawMsg, key)
		case "dateTimeEnd":
			err = unpopulateDateTimeRFC3339(val, "DateTimeEnd", &w.DateTimeEnd)
			delete(rawMsg, key)
		case "granularity":
			err = unpopulate(val, "Granularity", &w.Granularity)
			delete(rawMsg, key)
		case "series":
			err = unpopulate(val, "Series", &w.Series)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WafMetricsResponseSeriesItem.
func (w WafMetricsResponseSeriesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", w.Data)
	populate(objectMap, "groups", w.Groups)
	populate(objectMap, "metric", w.Metric)
	populate(objectMap, "unit", w.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WafMetricsResponseSeriesItem.
func (w *WafMetricsResponseSeriesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &w.Data)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &w.Groups)
			delete(rawMsg, key)
		case "metric":
			err = unpopulate(val, "Metric", &w.Metric)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &w.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WafMetricsResponseSeriesPropertiesItemsItem.
func (w WafMetricsResponseSeriesPropertiesItemsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WafMetricsResponseSeriesPropertiesItemsItem.
func (w *WafMetricsResponseSeriesPropertiesItemsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WafRankingsResponse.
func (w WafRankingsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", w.Data)
	populateDateTimeRFC3339(objectMap, "dateTimeBegin", w.DateTimeBegin)
	populateDateTimeRFC3339(objectMap, "dateTimeEnd", w.DateTimeEnd)
	populate(objectMap, "groups", w.Groups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WafRankingsResponse.
func (w *WafRankingsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &w.Data)
			delete(rawMsg, key)
		case "dateTimeBegin":
			err = unpopulateDateTimeRFC3339(val, "DateTimeBegin", &w.DateTimeBegin)
			delete(rawMsg, key)
		case "dateTimeEnd":
			err = unpopulateDateTimeRFC3339(val, "DateTimeEnd", &w.DateTimeEnd)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &w.Groups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WafRankingsResponseDataItem.
func (w WafRankingsResponseDataItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupValues", w.GroupValues)
	populate(objectMap, "metrics", w.Metrics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WafRankingsResponseDataItem.
func (w *WafRankingsResponseDataItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupValues":
			err = unpopulate(val, "GroupValues", &w.GroupValues)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &w.Metrics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicy.
func (w WebApplicationFirewallPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebApplicationFirewallPolicy.
func (w *WebApplicationFirewallPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &w.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicyList.
func (w WebApplicationFirewallPolicyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebApplicationFirewallPolicyList.
func (w *WebApplicationFirewallPolicyList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicyPatchParameters.
func (w WebApplicationFirewallPolicyPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebApplicationFirewallPolicyPatchParameters.
func (w *WebApplicationFirewallPolicyPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicyProperties.
func (w WebApplicationFirewallPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customRules", w.CustomRules)
	populate(objectMap, "endpointLinks", w.EndpointLinks)
	populate(objectMap, "extendedProperties", w.ExtendedProperties)
	populate(objectMap, "managedRules", w.ManagedRules)
	populate(objectMap, "policySettings", w.PolicySettings)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "rateLimitRules", w.RateLimitRules)
	populate(objectMap, "resourceState", w.ResourceState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebApplicationFirewallPolicyProperties.
func (w *WebApplicationFirewallPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customRules":
			err = unpopulate(val, "CustomRules", &w.CustomRules)
			delete(rawMsg, key)
		case "endpointLinks":
			err = unpopulate(val, "EndpointLinks", &w.EndpointLinks)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &w.ExtendedProperties)
			delete(rawMsg, key)
		case "managedRules":
			err = unpopulate(val, "ManagedRules", &w.ManagedRules)
			delete(rawMsg, key)
		case "policySettings":
			err = unpopulate(val, "PolicySettings", &w.PolicySettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "rateLimitRules":
			err = unpopulate(val, "RateLimitRules", &w.RateLimitRules)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &w.ResourceState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
