//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/confidentialledger/armconfidentialledger"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedCCFServer is a fake server for instances of the armconfidentialledger.ManagedCCFClient type.
type ManagedCCFServer struct {
	// BeginBackup is the fake for method ManagedCCFClient.BeginBackup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginBackup func(ctx context.Context, resourceGroupName string, appName string, managedCCF armconfidentialledger.ManagedCCFBackup, options *armconfidentialledger.ManagedCCFClientBeginBackupOptions) (resp azfake.PollerResponder[armconfidentialledger.ManagedCCFClientBackupResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method ManagedCCFClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, appName string, managedCCF armconfidentialledger.ManagedCCF, options *armconfidentialledger.ManagedCCFClientBeginCreateOptions) (resp azfake.PollerResponder[armconfidentialledger.ManagedCCFClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ManagedCCFClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, appName string, options *armconfidentialledger.ManagedCCFClientBeginDeleteOptions) (resp azfake.PollerResponder[armconfidentialledger.ManagedCCFClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedCCFClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, appName string, options *armconfidentialledger.ManagedCCFClientGetOptions) (resp azfake.Responder[armconfidentialledger.ManagedCCFClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method ManagedCCFClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armconfidentialledger.ManagedCCFClientListByResourceGroupOptions) (resp azfake.PagerResponder[armconfidentialledger.ManagedCCFClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method ManagedCCFClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armconfidentialledger.ManagedCCFClientListBySubscriptionOptions) (resp azfake.PagerResponder[armconfidentialledger.ManagedCCFClientListBySubscriptionResponse])

	// BeginRestore is the fake for method ManagedCCFClient.BeginRestore
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestore func(ctx context.Context, resourceGroupName string, appName string, managedCCF armconfidentialledger.ManagedCCFRestore, options *armconfidentialledger.ManagedCCFClientBeginRestoreOptions) (resp azfake.PollerResponder[armconfidentialledger.ManagedCCFClientRestoreResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ManagedCCFClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, appName string, managedCCF armconfidentialledger.ManagedCCF, options *armconfidentialledger.ManagedCCFClientBeginUpdateOptions) (resp azfake.PollerResponder[armconfidentialledger.ManagedCCFClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewManagedCCFServerTransport creates a new instance of ManagedCCFServerTransport with the provided implementation.
// The returned ManagedCCFServerTransport instance is connected to an instance of armconfidentialledger.ManagedCCFClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedCCFServerTransport(srv *ManagedCCFServer) *ManagedCCFServerTransport {
	return &ManagedCCFServerTransport{
		srv:                         srv,
		beginBackup:                 newTracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientBackupResponse]](),
		beginCreate:                 newTracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientCreateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientDeleteResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armconfidentialledger.ManagedCCFClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armconfidentialledger.ManagedCCFClientListBySubscriptionResponse]](),
		beginRestore:                newTracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientRestoreResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientUpdateResponse]](),
	}
}

// ManagedCCFServerTransport connects instances of armconfidentialledger.ManagedCCFClient to instances of ManagedCCFServer.
// Don't use this type directly, use NewManagedCCFServerTransport instead.
type ManagedCCFServerTransport struct {
	srv                         *ManagedCCFServer
	beginBackup                 *tracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientBackupResponse]]
	beginCreate                 *tracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientCreateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientDeleteResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armconfidentialledger.ManagedCCFClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armconfidentialledger.ManagedCCFClientListBySubscriptionResponse]]
	beginRestore                *tracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientRestoreResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armconfidentialledger.ManagedCCFClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ManagedCCFServerTransport.
func (m *ManagedCCFServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedCCFClient.BeginBackup":
		resp, err = m.dispatchBeginBackup(req)
	case "ManagedCCFClient.BeginCreate":
		resp, err = m.dispatchBeginCreate(req)
	case "ManagedCCFClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "ManagedCCFClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedCCFClient.NewListByResourceGroupPager":
		resp, err = m.dispatchNewListByResourceGroupPager(req)
	case "ManagedCCFClient.NewListBySubscriptionPager":
		resp, err = m.dispatchNewListBySubscriptionPager(req)
	case "ManagedCCFClient.BeginRestore":
		resp, err = m.dispatchBeginRestore(req)
	case "ManagedCCFClient.BeginUpdate":
		resp, err = m.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedCCFServerTransport) dispatchBeginBackup(req *http.Request) (*http.Response, error) {
	if m.srv.BeginBackup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginBackup not implemented")}
	}
	beginBackup := m.beginBackup.get(req)
	if beginBackup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConfidentialLedger/managedCCFs/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backup`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armconfidentialledger.ManagedCCFBackup](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginBackup(req.Context(), resourceGroupNameParam, appNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginBackup = &respr
		m.beginBackup.add(req, beginBackup)
	}

	resp, err := server.PollerResponderNext(beginBackup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginBackup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginBackup) {
		m.beginBackup.remove(req)
	}

	return resp, nil
}

func (m *ManagedCCFServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := m.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConfidentialLedger/managedCCFs/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armconfidentialledger.ManagedCCF](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreate(req.Context(), resourceGroupNameParam, appNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		m.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		m.beginCreate.remove(req)
	}

	return resp, nil
}

func (m *ManagedCCFServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConfidentialLedger/managedCCFs/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, appNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *ManagedCCFServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConfidentialLedger/managedCCFs/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, appNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedCCF, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedCCFServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := m.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConfidentialLedger/managedCCFs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armconfidentialledger.ManagedCCFClientListByResourceGroupOptions
		if filterParam != nil {
			options = &armconfidentialledger.ManagedCCFClientListByResourceGroupOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		m.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armconfidentialledger.ManagedCCFClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		m.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (m *ManagedCCFServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := m.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConfidentialLedger/managedCCFs/`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armconfidentialledger.ManagedCCFClientListBySubscriptionOptions
		if filterParam != nil {
			options = &armconfidentialledger.ManagedCCFClientListBySubscriptionOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListBySubscriptionPager(options)
		newListBySubscriptionPager = &resp
		m.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armconfidentialledger.ManagedCCFClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		m.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (m *ManagedCCFServerTransport) dispatchBeginRestore(req *http.Request) (*http.Response, error) {
	if m.srv.BeginRestore == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestore not implemented")}
	}
	beginRestore := m.beginRestore.get(req)
	if beginRestore == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConfidentialLedger/managedCCFs/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armconfidentialledger.ManagedCCFRestore](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginRestore(req.Context(), resourceGroupNameParam, appNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestore = &respr
		m.beginRestore.add(req, beginRestore)
	}

	resp, err := server.PollerResponderNext(beginRestore, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginRestore.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestore) {
		m.beginRestore.remove(req)
	}

	return resp, nil
}

func (m *ManagedCCFServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := m.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConfidentialLedger/managedCCFs/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armconfidentialledger.ManagedCCF](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginUpdate(req.Context(), resourceGroupNameParam, appNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		m.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		m.beginUpdate.remove(req)
	}

	return resp, nil
}
