//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armconfluent

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Microsoft Azure subscription id
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewAccessClient creates a new instance of AccessClient.
func (c *ClientFactory) NewAccessClient() *AccessClient {
	return &AccessClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewMarketplaceAgreementsClient creates a new instance of MarketplaceAgreementsClient.
func (c *ClientFactory) NewMarketplaceAgreementsClient() *MarketplaceAgreementsClient {
	return &MarketplaceAgreementsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOrganizationClient creates a new instance of OrganizationClient.
func (c *ClientFactory) NewOrganizationClient() *OrganizationClient {
	return &OrganizationClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOrganizationOperationsClient creates a new instance of OrganizationOperationsClient.
func (c *ClientFactory) NewOrganizationOperationsClient() *OrganizationOperationsClient {
	return &OrganizationOperationsClient{
		internal: c.internal,
	}
}

// NewValidationsClient creates a new instance of ValidationsClient.
func (c *ClientFactory) NewValidationsClient() *ValidationsClient {
	return &ValidationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
