//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerregistry/armcontainerregistry"
	"net/http"
	"net/url"
	"regexp"
)

// ConnectedRegistriesServer is a fake server for instances of the armcontainerregistry.ConnectedRegistriesClient type.
type ConnectedRegistriesServer struct {
	// BeginCreate is the fake for method ConnectedRegistriesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, registryName string, connectedRegistryName string, connectedRegistryCreateParameters armcontainerregistry.ConnectedRegistry, options *armcontainerregistry.ConnectedRegistriesClientBeginCreateOptions) (resp azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDeactivate is the fake for method ConnectedRegistriesClient.BeginDeactivate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeactivate func(ctx context.Context, resourceGroupName string, registryName string, connectedRegistryName string, options *armcontainerregistry.ConnectedRegistriesClientBeginDeactivateOptions) (resp azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientDeactivateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ConnectedRegistriesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, registryName string, connectedRegistryName string, options *armcontainerregistry.ConnectedRegistriesClientBeginDeleteOptions) (resp azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ConnectedRegistriesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, registryName string, connectedRegistryName string, options *armcontainerregistry.ConnectedRegistriesClientGetOptions) (resp azfake.Responder[armcontainerregistry.ConnectedRegistriesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ConnectedRegistriesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, registryName string, options *armcontainerregistry.ConnectedRegistriesClientListOptions) (resp azfake.PagerResponder[armcontainerregistry.ConnectedRegistriesClientListResponse])

	// BeginUpdate is the fake for method ConnectedRegistriesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginUpdate func(ctx context.Context, resourceGroupName string, registryName string, connectedRegistryName string, connectedRegistryUpdateParameters armcontainerregistry.ConnectedRegistryUpdateParameters, options *armcontainerregistry.ConnectedRegistriesClientBeginUpdateOptions) (resp azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewConnectedRegistriesServerTransport creates a new instance of ConnectedRegistriesServerTransport with the provided implementation.
// The returned ConnectedRegistriesServerTransport instance is connected to an instance of armcontainerregistry.ConnectedRegistriesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConnectedRegistriesServerTransport(srv *ConnectedRegistriesServer) *ConnectedRegistriesServerTransport {
	return &ConnectedRegistriesServerTransport{
		srv:             srv,
		beginCreate:     newTracker[azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientCreateResponse]](),
		beginDeactivate: newTracker[azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientDeactivateResponse]](),
		beginDelete:     newTracker[azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientDeleteResponse]](),
		newListPager:    newTracker[azfake.PagerResponder[armcontainerregistry.ConnectedRegistriesClientListResponse]](),
		beginUpdate:     newTracker[azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientUpdateResponse]](),
	}
}

// ConnectedRegistriesServerTransport connects instances of armcontainerregistry.ConnectedRegistriesClient to instances of ConnectedRegistriesServer.
// Don't use this type directly, use NewConnectedRegistriesServerTransport instead.
type ConnectedRegistriesServerTransport struct {
	srv             *ConnectedRegistriesServer
	beginCreate     *tracker[azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientCreateResponse]]
	beginDeactivate *tracker[azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientDeactivateResponse]]
	beginDelete     *tracker[azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientDeleteResponse]]
	newListPager    *tracker[azfake.PagerResponder[armcontainerregistry.ConnectedRegistriesClientListResponse]]
	beginUpdate     *tracker[azfake.PollerResponder[armcontainerregistry.ConnectedRegistriesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ConnectedRegistriesServerTransport.
func (c *ConnectedRegistriesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConnectedRegistriesClient.BeginCreate":
		resp, err = c.dispatchBeginCreate(req)
	case "ConnectedRegistriesClient.BeginDeactivate":
		resp, err = c.dispatchBeginDeactivate(req)
	case "ConnectedRegistriesClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "ConnectedRegistriesClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConnectedRegistriesClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "ConnectedRegistriesClient.BeginUpdate":
		resp, err = c.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConnectedRegistriesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := c.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectedRegistries/(?P<connectedRegistryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.ConnectedRegistry](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		connectedRegistryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedRegistryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreate(req.Context(), resourceGroupNameParam, registryNameParam, connectedRegistryNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		c.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		c.beginCreate.remove(req)
	}

	return resp, nil
}

func (c *ConnectedRegistriesServerTransport) dispatchBeginDeactivate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDeactivate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeactivate not implemented")}
	}
	beginDeactivate := c.beginDeactivate.get(req)
	if beginDeactivate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectedRegistries/(?P<connectedRegistryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deactivate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		connectedRegistryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedRegistryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDeactivate(req.Context(), resourceGroupNameParam, registryNameParam, connectedRegistryNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeactivate = &respr
		c.beginDeactivate.add(req, beginDeactivate)
	}

	resp, err := server.PollerResponderNext(beginDeactivate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginDeactivate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeactivate) {
		c.beginDeactivate.remove(req)
	}

	return resp, nil
}

func (c *ConnectedRegistriesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectedRegistries/(?P<connectedRegistryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		connectedRegistryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedRegistryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, registryNameParam, connectedRegistryNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *ConnectedRegistriesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectedRegistries/(?P<connectedRegistryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	connectedRegistryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedRegistryName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, registryNameParam, connectedRegistryNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectedRegistry, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectedRegistriesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectedRegistries`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armcontainerregistry.ConnectedRegistriesClientListOptions
		if filterParam != nil {
			options = &armcontainerregistry.ConnectedRegistriesClientListOptions{
				Filter: filterParam,
			}
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, registryNameParam, options)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcontainerregistry.ConnectedRegistriesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *ConnectedRegistriesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := c.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectedRegistries/(?P<connectedRegistryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.ConnectedRegistryUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		connectedRegistryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedRegistryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdate(req.Context(), resourceGroupNameParam, registryNameParam, connectedRegistryNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		c.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		c.beginUpdate.remove(req)
	}

	return resp, nil
}
