//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcosmos

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewCassandraClustersClient creates a new instance of CassandraClustersClient.
func (c *ClientFactory) NewCassandraClustersClient() *CassandraClustersClient {
	return &CassandraClustersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCassandraDataCentersClient creates a new instance of CassandraDataCentersClient.
func (c *ClientFactory) NewCassandraDataCentersClient() *CassandraDataCentersClient {
	return &CassandraDataCentersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCassandraResourcesClient creates a new instance of CassandraResourcesClient.
func (c *ClientFactory) NewCassandraResourcesClient() *CassandraResourcesClient {
	return &CassandraResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCollectionClient creates a new instance of CollectionClient.
func (c *ClientFactory) NewCollectionClient() *CollectionClient {
	return &CollectionClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCollectionPartitionClient creates a new instance of CollectionPartitionClient.
func (c *ClientFactory) NewCollectionPartitionClient() *CollectionPartitionClient {
	return &CollectionPartitionClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCollectionPartitionRegionClient creates a new instance of CollectionPartitionRegionClient.
func (c *ClientFactory) NewCollectionPartitionRegionClient() *CollectionPartitionRegionClient {
	return &CollectionPartitionRegionClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCollectionRegionClient creates a new instance of CollectionRegionClient.
func (c *ClientFactory) NewCollectionRegionClient() *CollectionRegionClient {
	return &CollectionRegionClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDataTransferJobsClient creates a new instance of DataTransferJobsClient.
func (c *ClientFactory) NewDataTransferJobsClient() *DataTransferJobsClient {
	return &DataTransferJobsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDatabaseAccountRegionClient creates a new instance of DatabaseAccountRegionClient.
func (c *ClientFactory) NewDatabaseAccountRegionClient() *DatabaseAccountRegionClient {
	return &DatabaseAccountRegionClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDatabaseAccountsClient creates a new instance of DatabaseAccountsClient.
func (c *ClientFactory) NewDatabaseAccountsClient() *DatabaseAccountsClient {
	return &DatabaseAccountsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDatabaseClient creates a new instance of DatabaseClient.
func (c *ClientFactory) NewDatabaseClient() *DatabaseClient {
	return &DatabaseClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewGraphResourcesClient creates a new instance of GraphResourcesClient.
func (c *ClientFactory) NewGraphResourcesClient() *GraphResourcesClient {
	return &GraphResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewGremlinResourcesClient creates a new instance of GremlinResourcesClient.
func (c *ClientFactory) NewGremlinResourcesClient() *GremlinResourcesClient {
	return &GremlinResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewLocationsClient creates a new instance of LocationsClient.
func (c *ClientFactory) NewLocationsClient() *LocationsClient {
	return &LocationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewMongoClustersClient creates a new instance of MongoClustersClient.
func (c *ClientFactory) NewMongoClustersClient() *MongoClustersClient {
	return &MongoClustersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewMongoDBResourcesClient creates a new instance of MongoDBResourcesClient.
func (c *ClientFactory) NewMongoDBResourcesClient() *MongoDBResourcesClient {
	return &MongoDBResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewNotebookWorkspacesClient creates a new instance of NotebookWorkspacesClient.
func (c *ClientFactory) NewNotebookWorkspacesClient() *NotebookWorkspacesClient {
	return &NotebookWorkspacesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewPartitionKeyRangeIDClient creates a new instance of PartitionKeyRangeIDClient.
func (c *ClientFactory) NewPartitionKeyRangeIDClient() *PartitionKeyRangeIDClient {
	return &PartitionKeyRangeIDClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPartitionKeyRangeIDRegionClient creates a new instance of PartitionKeyRangeIDRegionClient.
func (c *ClientFactory) NewPartitionKeyRangeIDRegionClient() *PartitionKeyRangeIDRegionClient {
	return &PartitionKeyRangeIDRegionClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPercentileClient creates a new instance of PercentileClient.
func (c *ClientFactory) NewPercentileClient() *PercentileClient {
	return &PercentileClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPercentileSourceTargetClient creates a new instance of PercentileSourceTargetClient.
func (c *ClientFactory) NewPercentileSourceTargetClient() *PercentileSourceTargetClient {
	return &PercentileSourceTargetClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPercentileTargetClient creates a new instance of PercentileTargetClient.
func (c *ClientFactory) NewPercentileTargetClient() *PercentileTargetClient {
	return &PercentileTargetClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	return &PrivateEndpointConnectionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	return &PrivateLinkResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableDatabaseAccountsClient creates a new instance of RestorableDatabaseAccountsClient.
func (c *ClientFactory) NewRestorableDatabaseAccountsClient() *RestorableDatabaseAccountsClient {
	return &RestorableDatabaseAccountsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableGremlinDatabasesClient creates a new instance of RestorableGremlinDatabasesClient.
func (c *ClientFactory) NewRestorableGremlinDatabasesClient() *RestorableGremlinDatabasesClient {
	return &RestorableGremlinDatabasesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableGremlinGraphsClient creates a new instance of RestorableGremlinGraphsClient.
func (c *ClientFactory) NewRestorableGremlinGraphsClient() *RestorableGremlinGraphsClient {
	return &RestorableGremlinGraphsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableGremlinResourcesClient creates a new instance of RestorableGremlinResourcesClient.
func (c *ClientFactory) NewRestorableGremlinResourcesClient() *RestorableGremlinResourcesClient {
	return &RestorableGremlinResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableMongodbCollectionsClient creates a new instance of RestorableMongodbCollectionsClient.
func (c *ClientFactory) NewRestorableMongodbCollectionsClient() *RestorableMongodbCollectionsClient {
	return &RestorableMongodbCollectionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableMongodbDatabasesClient creates a new instance of RestorableMongodbDatabasesClient.
func (c *ClientFactory) NewRestorableMongodbDatabasesClient() *RestorableMongodbDatabasesClient {
	return &RestorableMongodbDatabasesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableMongodbResourcesClient creates a new instance of RestorableMongodbResourcesClient.
func (c *ClientFactory) NewRestorableMongodbResourcesClient() *RestorableMongodbResourcesClient {
	return &RestorableMongodbResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableSQLContainersClient creates a new instance of RestorableSQLContainersClient.
func (c *ClientFactory) NewRestorableSQLContainersClient() *RestorableSQLContainersClient {
	return &RestorableSQLContainersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableSQLDatabasesClient creates a new instance of RestorableSQLDatabasesClient.
func (c *ClientFactory) NewRestorableSQLDatabasesClient() *RestorableSQLDatabasesClient {
	return &RestorableSQLDatabasesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableSQLResourcesClient creates a new instance of RestorableSQLResourcesClient.
func (c *ClientFactory) NewRestorableSQLResourcesClient() *RestorableSQLResourcesClient {
	return &RestorableSQLResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableTableResourcesClient creates a new instance of RestorableTableResourcesClient.
func (c *ClientFactory) NewRestorableTableResourcesClient() *RestorableTableResourcesClient {
	return &RestorableTableResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRestorableTablesClient creates a new instance of RestorableTablesClient.
func (c *ClientFactory) NewRestorableTablesClient() *RestorableTablesClient {
	return &RestorableTablesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSQLResourcesClient creates a new instance of SQLResourcesClient.
func (c *ClientFactory) NewSQLResourcesClient() *SQLResourcesClient {
	return &SQLResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewServiceClient creates a new instance of ServiceClient.
func (c *ClientFactory) NewServiceClient() *ServiceClient {
	return &ServiceClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewTableResourcesClient creates a new instance of TableResourcesClient.
func (c *ClientFactory) NewTableResourcesClient() *TableResourcesClient {
	return &TableResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewThroughputPoolAccountClient creates a new instance of ThroughputPoolAccountClient.
func (c *ClientFactory) NewThroughputPoolAccountClient() *ThroughputPoolAccountClient {
	return &ThroughputPoolAccountClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewThroughputPoolAccountsClient creates a new instance of ThroughputPoolAccountsClient.
func (c *ClientFactory) NewThroughputPoolAccountsClient() *ThroughputPoolAccountsClient {
	return &ThroughputPoolAccountsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewThroughputPoolClient creates a new instance of ThroughputPoolClient.
func (c *ClientFactory) NewThroughputPoolClient() *ThroughputPoolClient {
	return &ThroughputPoolClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewThroughputPoolsClient creates a new instance of ThroughputPoolsClient.
func (c *ClientFactory) NewThroughputPoolsClient() *ThroughputPoolsClient {
	return &ThroughputPoolsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
