//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ScheduledActionsClient contains the methods for the ScheduledActions group.
// Don't use this type directly, use NewScheduledActionsClient() instead.
type ScheduledActionsClient struct {
	internal *arm.Client
}

// NewScheduledActionsClient creates a new instance of ScheduledActionsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewScheduledActionsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ScheduledActionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ScheduledActionsClient{
		internal: cl,
	}
	return client, nil
}

// CheckNameAvailability - Checks availability and correctness of the name for a scheduled action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - checkNameAvailabilityRequest - Scheduled action to be created or updated.
//   - options - ScheduledActionsClientCheckNameAvailabilityOptions contains the optional parameters for the ScheduledActionsClient.CheckNameAvailability
//     method.
func (client *ScheduledActionsClient) CheckNameAvailability(ctx context.Context, checkNameAvailabilityRequest CheckNameAvailabilityRequest, options *ScheduledActionsClientCheckNameAvailabilityOptions) (ScheduledActionsClientCheckNameAvailabilityResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.CheckNameAvailability"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.checkNameAvailabilityCreateRequest(ctx, checkNameAvailabilityRequest, options)
	if err != nil {
		return ScheduledActionsClientCheckNameAvailabilityResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientCheckNameAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientCheckNameAvailabilityResponse{}, err
	}
	resp, err := client.checkNameAvailabilityHandleResponse(httpResp)
	return resp, err
}

// checkNameAvailabilityCreateRequest creates the CheckNameAvailability request.
func (client *ScheduledActionsClient) checkNameAvailabilityCreateRequest(ctx context.Context, checkNameAvailabilityRequest CheckNameAvailabilityRequest, options *ScheduledActionsClientCheckNameAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CostManagement/checkNameAvailability"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, checkNameAvailabilityRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// checkNameAvailabilityHandleResponse handles the CheckNameAvailability response.
func (client *ScheduledActionsClient) checkNameAvailabilityHandleResponse(resp *http.Response) (ScheduledActionsClientCheckNameAvailabilityResponse, error) {
	result := ScheduledActionsClientCheckNameAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckNameAvailabilityResponse); err != nil {
		return ScheduledActionsClientCheckNameAvailabilityResponse{}, err
	}
	return result, nil
}

// CheckNameAvailabilityByScope - Checks availability and correctness of the name for a scheduled action within the given
// scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with scheduled action operations. This includes 'subscriptions/{subscriptionId}' for subscription
//     scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
//     scope,
//     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account
//     scope and
//     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
//     Note: Insight Alerts are only available on subscription scope.
//   - checkNameAvailabilityRequest - Scheduled action to be created or updated.
//   - options - ScheduledActionsClientCheckNameAvailabilityByScopeOptions contains the optional parameters for the ScheduledActionsClient.CheckNameAvailabilityByScope
//     method.
func (client *ScheduledActionsClient) CheckNameAvailabilityByScope(ctx context.Context, scope string, checkNameAvailabilityRequest CheckNameAvailabilityRequest, options *ScheduledActionsClientCheckNameAvailabilityByScopeOptions) (ScheduledActionsClientCheckNameAvailabilityByScopeResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.CheckNameAvailabilityByScope"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.checkNameAvailabilityByScopeCreateRequest(ctx, scope, checkNameAvailabilityRequest, options)
	if err != nil {
		return ScheduledActionsClientCheckNameAvailabilityByScopeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientCheckNameAvailabilityByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientCheckNameAvailabilityByScopeResponse{}, err
	}
	resp, err := client.checkNameAvailabilityByScopeHandleResponse(httpResp)
	return resp, err
}

// checkNameAvailabilityByScopeCreateRequest creates the CheckNameAvailabilityByScope request.
func (client *ScheduledActionsClient) checkNameAvailabilityByScopeCreateRequest(ctx context.Context, scope string, checkNameAvailabilityRequest CheckNameAvailabilityRequest, options *ScheduledActionsClientCheckNameAvailabilityByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/checkNameAvailability"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, checkNameAvailabilityRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// checkNameAvailabilityByScopeHandleResponse handles the CheckNameAvailabilityByScope response.
func (client *ScheduledActionsClient) checkNameAvailabilityByScopeHandleResponse(resp *http.Response) (ScheduledActionsClientCheckNameAvailabilityByScopeResponse, error) {
	result := ScheduledActionsClientCheckNameAvailabilityByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckNameAvailabilityResponse); err != nil {
		return ScheduledActionsClientCheckNameAvailabilityByScopeResponse{}, err
	}
	return result, nil
}

// CreateOrUpdate - Create or update a private scheduled action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - name - Scheduled action name.
//   - scheduledAction - Scheduled action to be created or updated.
//   - options - ScheduledActionsClientCreateOrUpdateOptions contains the optional parameters for the ScheduledActionsClient.CreateOrUpdate
//     method.
func (client *ScheduledActionsClient) CreateOrUpdate(ctx context.Context, name string, scheduledAction ScheduledAction, options *ScheduledActionsClientCreateOrUpdateOptions) (ScheduledActionsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, name, scheduledAction, options)
	if err != nil {
		return ScheduledActionsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ScheduledActionsClient) createOrUpdateCreateRequest(ctx context.Context, name string, scheduledAction ScheduledAction, options *ScheduledActionsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CostManagement/scheduledActions/{name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, scheduledAction); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ScheduledActionsClient) createOrUpdateHandleResponse(resp *http.Response) (ScheduledActionsClientCreateOrUpdateResponse, error) {
	result := ScheduledActionsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScheduledAction); err != nil {
		return ScheduledActionsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateByScope - Create or update a shared scheduled action within the given scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with scheduled action operations. This includes 'subscriptions/{subscriptionId}' for subscription
//     scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
//     scope,
//     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account
//     scope and
//     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
//     Note: Insight Alerts are only available on subscription scope.
//   - name - Scheduled action name.
//   - scheduledAction - Scheduled action to be created or updated.
//   - options - ScheduledActionsClientCreateOrUpdateByScopeOptions contains the optional parameters for the ScheduledActionsClient.CreateOrUpdateByScope
//     method.
func (client *ScheduledActionsClient) CreateOrUpdateByScope(ctx context.Context, scope string, name string, scheduledAction ScheduledAction, options *ScheduledActionsClientCreateOrUpdateByScopeOptions) (ScheduledActionsClientCreateOrUpdateByScopeResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.CreateOrUpdateByScope"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateByScopeCreateRequest(ctx, scope, name, scheduledAction, options)
	if err != nil {
		return ScheduledActionsClientCreateOrUpdateByScopeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientCreateOrUpdateByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientCreateOrUpdateByScopeResponse{}, err
	}
	resp, err := client.createOrUpdateByScopeHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateByScopeCreateRequest creates the CreateOrUpdateByScope request.
func (client *ScheduledActionsClient) createOrUpdateByScopeCreateRequest(ctx context.Context, scope string, name string, scheduledAction ScheduledAction, options *ScheduledActionsClientCreateOrUpdateByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, scheduledAction); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateByScopeHandleResponse handles the CreateOrUpdateByScope response.
func (client *ScheduledActionsClient) createOrUpdateByScopeHandleResponse(resp *http.Response) (ScheduledActionsClientCreateOrUpdateByScopeResponse, error) {
	result := ScheduledActionsClientCreateOrUpdateByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScheduledAction); err != nil {
		return ScheduledActionsClientCreateOrUpdateByScopeResponse{}, err
	}
	return result, nil
}

// Delete - Delete a private scheduled action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - name - Scheduled action name.
//   - options - ScheduledActionsClientDeleteOptions contains the optional parameters for the ScheduledActionsClient.Delete method.
func (client *ScheduledActionsClient) Delete(ctx context.Context, name string, options *ScheduledActionsClientDeleteOptions) (ScheduledActionsClientDeleteResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, name, options)
	if err != nil {
		return ScheduledActionsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientDeleteResponse{}, err
	}
	return ScheduledActionsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ScheduledActionsClient) deleteCreateRequest(ctx context.Context, name string, options *ScheduledActionsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CostManagement/scheduledActions/{name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteByScope - Delete a scheduled action within the given scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with scheduled action operations. This includes 'subscriptions/{subscriptionId}' for subscription
//     scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
//     scope,
//     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account
//     scope and
//     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
//     Note: Insight Alerts are only available on subscription scope.
//   - name - Scheduled action name.
//   - options - ScheduledActionsClientDeleteByScopeOptions contains the optional parameters for the ScheduledActionsClient.DeleteByScope
//     method.
func (client *ScheduledActionsClient) DeleteByScope(ctx context.Context, scope string, name string, options *ScheduledActionsClientDeleteByScopeOptions) (ScheduledActionsClientDeleteByScopeResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.DeleteByScope"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteByScopeCreateRequest(ctx, scope, name, options)
	if err != nil {
		return ScheduledActionsClientDeleteByScopeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientDeleteByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientDeleteByScopeResponse{}, err
	}
	return ScheduledActionsClientDeleteByScopeResponse{}, nil
}

// deleteByScopeCreateRequest creates the DeleteByScope request.
func (client *ScheduledActionsClient) deleteByScopeCreateRequest(ctx context.Context, scope string, name string, options *ScheduledActionsClientDeleteByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get the private scheduled action by name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - name - Scheduled action name.
//   - options - ScheduledActionsClientGetOptions contains the optional parameters for the ScheduledActionsClient.Get method.
func (client *ScheduledActionsClient) Get(ctx context.Context, name string, options *ScheduledActionsClientGetOptions) (ScheduledActionsClientGetResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, name, options)
	if err != nil {
		return ScheduledActionsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ScheduledActionsClient) getCreateRequest(ctx context.Context, name string, options *ScheduledActionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CostManagement/scheduledActions/{name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ScheduledActionsClient) getHandleResponse(resp *http.Response) (ScheduledActionsClientGetResponse, error) {
	result := ScheduledActionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScheduledAction); err != nil {
		return ScheduledActionsClientGetResponse{}, err
	}
	return result, nil
}

// GetByScope - Get the shared scheduled action from the given scope by name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with scheduled action operations. This includes 'subscriptions/{subscriptionId}' for subscription
//     scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
//     scope,
//     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account
//     scope and
//     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
//     Note: Insight Alerts are only available on subscription scope.
//   - name - Scheduled action name.
//   - options - ScheduledActionsClientGetByScopeOptions contains the optional parameters for the ScheduledActionsClient.GetByScope
//     method.
func (client *ScheduledActionsClient) GetByScope(ctx context.Context, scope string, name string, options *ScheduledActionsClientGetByScopeOptions) (ScheduledActionsClientGetByScopeResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.GetByScope"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getByScopeCreateRequest(ctx, scope, name, options)
	if err != nil {
		return ScheduledActionsClientGetByScopeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientGetByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientGetByScopeResponse{}, err
	}
	resp, err := client.getByScopeHandleResponse(httpResp)
	return resp, err
}

// getByScopeCreateRequest creates the GetByScope request.
func (client *ScheduledActionsClient) getByScopeCreateRequest(ctx context.Context, scope string, name string, options *ScheduledActionsClientGetByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getByScopeHandleResponse handles the GetByScope response.
func (client *ScheduledActionsClient) getByScopeHandleResponse(resp *http.Response) (ScheduledActionsClientGetByScopeResponse, error) {
	result := ScheduledActionsClientGetByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScheduledAction); err != nil {
		return ScheduledActionsClientGetByScopeResponse{}, err
	}
	return result, nil
}

// NewListPager - List all private scheduled actions.
//
// Generated from API version 2022-10-01
//   - options - ScheduledActionsClientListOptions contains the optional parameters for the ScheduledActionsClient.NewListPager
//     method.
func (client *ScheduledActionsClient) NewListPager(options *ScheduledActionsClientListOptions) *runtime.Pager[ScheduledActionsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ScheduledActionsClientListResponse]{
		More: func(page ScheduledActionsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ScheduledActionsClientListResponse) (ScheduledActionsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ScheduledActionsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ScheduledActionsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ScheduledActionsClient) listCreateRequest(ctx context.Context, options *ScheduledActionsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CostManagement/scheduledActions"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ScheduledActionsClient) listHandleResponse(resp *http.Response) (ScheduledActionsClientListResponse, error) {
	result := ScheduledActionsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScheduledActionListResult); err != nil {
		return ScheduledActionsClientListResponse{}, err
	}
	return result, nil
}

// NewListByScopePager - List all shared scheduled actions within the given scope.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with scheduled action operations. This includes 'subscriptions/{subscriptionId}' for subscription
//     scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
//     scope,
//     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account
//     scope and
//     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
//     Note: Insight Alerts are only available on subscription scope.
//   - options - ScheduledActionsClientListByScopeOptions contains the optional parameters for the ScheduledActionsClient.NewListByScopePager
//     method.
func (client *ScheduledActionsClient) NewListByScopePager(scope string, options *ScheduledActionsClientListByScopeOptions) *runtime.Pager[ScheduledActionsClientListByScopeResponse] {
	return runtime.NewPager(runtime.PagingHandler[ScheduledActionsClientListByScopeResponse]{
		More: func(page ScheduledActionsClientListByScopeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ScheduledActionsClientListByScopeResponse) (ScheduledActionsClientListByScopeResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ScheduledActionsClient.NewListByScopePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByScopeCreateRequest(ctx, scope, options)
			}, nil)
			if err != nil {
				return ScheduledActionsClientListByScopeResponse{}, err
			}
			return client.listByScopeHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByScopeCreateRequest creates the ListByScope request.
func (client *ScheduledActionsClient) listByScopeCreateRequest(ctx context.Context, scope string, options *ScheduledActionsClientListByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/scheduledActions"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByScopeHandleResponse handles the ListByScope response.
func (client *ScheduledActionsClient) listByScopeHandleResponse(resp *http.Response) (ScheduledActionsClientListByScopeResponse, error) {
	result := ScheduledActionsClientListByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScheduledActionListResult); err != nil {
		return ScheduledActionsClientListByScopeResponse{}, err
	}
	return result, nil
}

// Run - Processes a private scheduled action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - name - Scheduled action name.
//   - options - ScheduledActionsClientRunOptions contains the optional parameters for the ScheduledActionsClient.Run method.
func (client *ScheduledActionsClient) Run(ctx context.Context, name string, options *ScheduledActionsClientRunOptions) (ScheduledActionsClientRunResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.Run"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.runCreateRequest(ctx, name, options)
	if err != nil {
		return ScheduledActionsClientRunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientRunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientRunResponse{}, err
	}
	return ScheduledActionsClientRunResponse{}, nil
}

// runCreateRequest creates the Run request.
func (client *ScheduledActionsClient) runCreateRequest(ctx context.Context, name string, options *ScheduledActionsClientRunOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CostManagement/scheduledActions/{name}/execute"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RunByScope - Runs a shared scheduled action within the given scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with scheduled action operations. This includes 'subscriptions/{subscriptionId}' for subscription
//     scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
//     scope,
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
//     scope,
//     'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account
//     scope and
//     'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
//     Note: Insight Alerts are only available on subscription scope.
//   - name - Scheduled action name.
//   - options - ScheduledActionsClientRunByScopeOptions contains the optional parameters for the ScheduledActionsClient.RunByScope
//     method.
func (client *ScheduledActionsClient) RunByScope(ctx context.Context, scope string, name string, options *ScheduledActionsClientRunByScopeOptions) (ScheduledActionsClientRunByScopeResponse, error) {
	var err error
	const operationName = "ScheduledActionsClient.RunByScope"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.runByScopeCreateRequest(ctx, scope, name, options)
	if err != nil {
		return ScheduledActionsClientRunByScopeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScheduledActionsClientRunByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScheduledActionsClientRunByScopeResponse{}, err
	}
	return ScheduledActionsClientRunByScopeResponse{}, nil
}

// runByScopeCreateRequest creates the RunByScope request.
func (client *ScheduledActionsClient) runByScopeCreateRequest(ctx context.Context, scope string, name string, options *ScheduledActionsClientRunByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}/execute"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
