//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PredictionsClient contains the methods for the Predictions group.
// Don't use this type directly, use NewPredictionsClient() instead.
type PredictionsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewPredictionsClient creates a new instance of PredictionsClient with the specified values.
//   - subscriptionID - Gets subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID
//     forms part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPredictionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*PredictionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PredictionsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates a Prediction or updates an existing Prediction in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - predictionName - The name of the Prediction.
//   - parameters - Parameters supplied to the create/update Prediction operation.
//   - options - PredictionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PredictionsClient.BeginCreateOrUpdate
//     method.
func (client *PredictionsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, hubName string, predictionName string, parameters PredictionResourceFormat, options *PredictionsClientBeginCreateOrUpdateOptions) (*runtime.Poller[PredictionsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, hubName, predictionName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[PredictionsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[PredictionsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Creates a Prediction or updates an existing Prediction in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
func (client *PredictionsClient) createOrUpdate(ctx context.Context, resourceGroupName string, hubName string, predictionName string, parameters PredictionResourceFormat, options *PredictionsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "PredictionsClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, hubName, predictionName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *PredictionsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, hubName string, predictionName string, parameters PredictionResourceFormat, options *PredictionsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if predictionName == "" {
		return nil, errors.New("parameter predictionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{predictionName}", url.PathEscape(predictionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes a Prediction in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - predictionName - The name of the Prediction.
//   - options - PredictionsClientBeginDeleteOptions contains the optional parameters for the PredictionsClient.BeginDelete method.
func (client *PredictionsClient) BeginDelete(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientBeginDeleteOptions) (*runtime.Poller[PredictionsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, hubName, predictionName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[PredictionsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[PredictionsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes a Prediction in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
func (client *PredictionsClient) deleteOperation(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "PredictionsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, hubName, predictionName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *PredictionsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if predictionName == "" {
		return nil, errors.New("parameter predictionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{predictionName}", url.PathEscape(predictionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets a Prediction in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - predictionName - The name of the Prediction.
//   - options - PredictionsClientGetOptions contains the optional parameters for the PredictionsClient.Get method.
func (client *PredictionsClient) Get(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientGetOptions) (PredictionsClientGetResponse, error) {
	var err error
	const operationName = "PredictionsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, hubName, predictionName, options)
	if err != nil {
		return PredictionsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PredictionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PredictionsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *PredictionsClient) getCreateRequest(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if predictionName == "" {
		return nil, errors.New("parameter predictionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{predictionName}", url.PathEscape(predictionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *PredictionsClient) getHandleResponse(resp *http.Response) (PredictionsClientGetResponse, error) {
	result := PredictionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PredictionResourceFormat); err != nil {
		return PredictionsClientGetResponse{}, err
	}
	return result, nil
}

// GetModelStatus - Gets model status of the prediction.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - predictionName - The name of the Prediction.
//   - options - PredictionsClientGetModelStatusOptions contains the optional parameters for the PredictionsClient.GetModelStatus
//     method.
func (client *PredictionsClient) GetModelStatus(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientGetModelStatusOptions) (PredictionsClientGetModelStatusResponse, error) {
	var err error
	const operationName = "PredictionsClient.GetModelStatus"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getModelStatusCreateRequest(ctx, resourceGroupName, hubName, predictionName, options)
	if err != nil {
		return PredictionsClientGetModelStatusResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PredictionsClientGetModelStatusResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PredictionsClientGetModelStatusResponse{}, err
	}
	resp, err := client.getModelStatusHandleResponse(httpResp)
	return resp, err
}

// getModelStatusCreateRequest creates the GetModelStatus request.
func (client *PredictionsClient) getModelStatusCreateRequest(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientGetModelStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/getModelStatus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if predictionName == "" {
		return nil, errors.New("parameter predictionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{predictionName}", url.PathEscape(predictionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getModelStatusHandleResponse handles the GetModelStatus response.
func (client *PredictionsClient) getModelStatusHandleResponse(resp *http.Response) (PredictionsClientGetModelStatusResponse, error) {
	result := PredictionsClientGetModelStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PredictionModelStatus); err != nil {
		return PredictionsClientGetModelStatusResponse{}, err
	}
	return result, nil
}

// GetTrainingResults - Gets training results.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - predictionName - The name of the Prediction.
//   - options - PredictionsClientGetTrainingResultsOptions contains the optional parameters for the PredictionsClient.GetTrainingResults
//     method.
func (client *PredictionsClient) GetTrainingResults(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientGetTrainingResultsOptions) (PredictionsClientGetTrainingResultsResponse, error) {
	var err error
	const operationName = "PredictionsClient.GetTrainingResults"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getTrainingResultsCreateRequest(ctx, resourceGroupName, hubName, predictionName, options)
	if err != nil {
		return PredictionsClientGetTrainingResultsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PredictionsClientGetTrainingResultsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PredictionsClientGetTrainingResultsResponse{}, err
	}
	resp, err := client.getTrainingResultsHandleResponse(httpResp)
	return resp, err
}

// getTrainingResultsCreateRequest creates the GetTrainingResults request.
func (client *PredictionsClient) getTrainingResultsCreateRequest(ctx context.Context, resourceGroupName string, hubName string, predictionName string, options *PredictionsClientGetTrainingResultsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/getTrainingResults"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if predictionName == "" {
		return nil, errors.New("parameter predictionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{predictionName}", url.PathEscape(predictionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getTrainingResultsHandleResponse handles the GetTrainingResults response.
func (client *PredictionsClient) getTrainingResultsHandleResponse(resp *http.Response) (PredictionsClientGetTrainingResultsResponse, error) {
	result := PredictionsClientGetTrainingResultsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PredictionTrainingResults); err != nil {
		return PredictionsClientGetTrainingResultsResponse{}, err
	}
	return result, nil
}

// NewListByHubPager - Gets all the predictions in the specified hub.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - options - PredictionsClientListByHubOptions contains the optional parameters for the PredictionsClient.NewListByHubPager
//     method.
func (client *PredictionsClient) NewListByHubPager(resourceGroupName string, hubName string, options *PredictionsClientListByHubOptions) *runtime.Pager[PredictionsClientListByHubResponse] {
	return runtime.NewPager(runtime.PagingHandler[PredictionsClientListByHubResponse]{
		More: func(page PredictionsClientListByHubResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PredictionsClientListByHubResponse) (PredictionsClientListByHubResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PredictionsClient.NewListByHubPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByHubCreateRequest(ctx, resourceGroupName, hubName, options)
			}, nil)
			if err != nil {
				return PredictionsClientListByHubResponse{}, err
			}
			return client.listByHubHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByHubCreateRequest creates the ListByHub request.
func (client *PredictionsClient) listByHubCreateRequest(ctx context.Context, resourceGroupName string, hubName string, options *PredictionsClientListByHubOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByHubHandleResponse handles the ListByHub response.
func (client *PredictionsClient) listByHubHandleResponse(resp *http.Response) (PredictionsClientListByHubResponse, error) {
	result := PredictionsClientListByHubResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PredictionListResult); err != nil {
		return PredictionsClientListByHubResponse{}, err
	}
	return result, nil
}

// ModelStatus - Creates or updates the model status of prediction.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - predictionName - The name of the Prediction.
//   - parameters - Parameters supplied to the create/update prediction model status operation.
//   - options - PredictionsClientModelStatusOptions contains the optional parameters for the PredictionsClient.ModelStatus method.
func (client *PredictionsClient) ModelStatus(ctx context.Context, resourceGroupName string, hubName string, predictionName string, parameters PredictionModelStatus, options *PredictionsClientModelStatusOptions) (PredictionsClientModelStatusResponse, error) {
	var err error
	const operationName = "PredictionsClient.ModelStatus"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.modelStatusCreateRequest(ctx, resourceGroupName, hubName, predictionName, parameters, options)
	if err != nil {
		return PredictionsClientModelStatusResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PredictionsClientModelStatusResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PredictionsClientModelStatusResponse{}, err
	}
	return PredictionsClientModelStatusResponse{}, nil
}

// modelStatusCreateRequest creates the ModelStatus request.
func (client *PredictionsClient) modelStatusCreateRequest(ctx context.Context, resourceGroupName string, hubName string, predictionName string, parameters PredictionModelStatus, options *PredictionsClientModelStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/modelStatus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if predictionName == "" {
		return nil, errors.New("parameter predictionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{predictionName}", url.PathEscape(predictionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
