//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomproviders

// Association - The resource definition of this association.
type Association struct {
	// The properties of the association.
	Properties *AssociationProperties

	// READ-ONLY; The association id.
	ID *string

	// READ-ONLY; The association name.
	Name *string

	// READ-ONLY; The association type.
	Type *string
}

// AssociationProperties - The properties of the association.
type AssociationProperties struct {
	// The REST resource instance of the target resource for this association.
	TargetResourceID *string

	// READ-ONLY; The provisioning state of the association.
	ProvisioningState *ProvisioningState
}

// AssociationsList - List of associations.
type AssociationsList struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The array of associations.
	Value []*Association
}

// CustomRPActionRouteDefinition - The route definition for an action implemented by the custom resource provider.
type CustomRPActionRouteDefinition struct {
	// REQUIRED; The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the
	// form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path
	// (e.g. 'https://testendpoint/{requestPath}')
	Endpoint *string

	// REQUIRED; The name of the route definition. This becomes the name for the ARM extension (e.g.
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
	Name *string

	// The routing types that are supported for action requests.
	RoutingType *ActionRouting
}

// CustomRPManifest - A manifest file that defines the custom resource provider resources.
type CustomRPManifest struct {
	// REQUIRED; Resource location
	Location *string

	// The manifest for the custom resource provider
	Properties *CustomRPManifestProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// CustomRPManifestProperties - The manifest for the custom resource provider
type CustomRPManifestProperties struct {
	// A list of actions that the custom resource provider implements.
	Actions []*CustomRPActionRouteDefinition

	// A list of resource types that the custom resource provider implements.
	ResourceTypes []*CustomRPResourceTypeRouteDefinition

	// A list of validations to run on the custom resource provider's requests.
	Validations []*CustomRPValidations

	// READ-ONLY; The provisioning state of the resource provider.
	ProvisioningState *ProvisioningState
}

// CustomRPResourceTypeRouteDefinition - The route definition for a resource implemented by the custom resource provider.
type CustomRPResourceTypeRouteDefinition struct {
	// REQUIRED; The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the
	// form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path
	// (e.g. 'https://testendpoint/{requestPath}')
	Endpoint *string

	// REQUIRED; The name of the route definition. This becomes the name for the ARM extension (e.g.
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
	Name *string

	// The routing types that are supported for resource requests.
	RoutingType *ResourceTypeRouting
}

// CustomRPRouteDefinition - A route definition that defines an action or resource that can be interacted with through the
// custom resource provider.
type CustomRPRouteDefinition struct {
	// REQUIRED; The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the
	// form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path
	// (e.g. 'https://testendpoint/{requestPath}')
	Endpoint *string

	// REQUIRED; The name of the route definition. This becomes the name for the ARM extension (e.g.
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
	Name *string
}

// CustomRPValidations - A validation to apply on custom resource provider requests.
type CustomRPValidations struct {
	// REQUIRED; A link to the validation specification. The specification must be hosted on raw.githubusercontent.com.
	Specification *string

	// The type of validation to run against a matching request.
	ValidationType *ValidationType
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition

	// READ-ONLY; Description of the error.
	Message *string
}

// ErrorResponse - Error response.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition
}

// ListByCustomRPManifest - List of custom resource providers.
type ListByCustomRPManifest struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The array of custom resource provider manifests.
	Value []*CustomRPManifest
}

// Resource - The resource definition.
type Resource struct {
	// REQUIRED; Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ResourceProviderOperation - Supported operations of this resource provider.
type ResourceProviderOperation struct {
	// Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay

	// Operation name, in format of {provider}/{resource}/{operation}
	Name *string
}

// ResourceProviderOperationDisplay - Display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Description of this operation.
	Description *string

	// Type of operation: get, read, delete, etc.
	Operation *string

	// Resource provider: Microsoft Custom Providers.
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// ResourceProviderOperationList - Results of the request to list operations.
type ResourceProviderOperationList struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// List of operations supported by this resource provider.
	Value []*ResourceProviderOperation
}

// ResourceProvidersUpdate - custom resource provider update information.
type ResourceProvidersUpdate struct {
	// Resource tags
	Tags map[string]*string
}
