//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatabox_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/databox/armdatabox/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/databox/resource-manager/Microsoft.DataBox/stable/2022-12-01/examples/OperationsGet.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatabox.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationList = armdatabox.OperationList{
		// 	Value: []*armdatabox.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/locations/operationResults/read"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("List or get the Operation Results"),
		// 				Operation: to.Ptr("List Operation Results"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Operation Results"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/jobs/cancel/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("Cancels an order in progress."),
		// 				Operation: to.Ptr("Cancel"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Orders"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/jobs/bookShipmentPickUp/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("Allows to book a pick up for return shipments."),
		// 				Operation: to.Ptr("Book Shipment Pick Up"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Orders"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/jobs/read"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("List or get the Orders"),
		// 				Operation: to.Ptr("List Orders"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Orders"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/jobs/delete"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("Delete the Orders"),
		// 				Operation: to.Ptr("Delete Orders"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Orders"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/jobs/write"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("Create or update the Orders"),
		// 				Operation: to.Ptr("Create or Update Orders"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Orders"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/jobs/listCredentials/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("Lists the unencrypted credentials related to the order."),
		// 				Operation: to.Ptr("List Credentials"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Orders"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/locations/validateInputs/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("This method does all type of validations."),
		// 				Operation: to.Ptr("Validate Inputs"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Validate Inputs"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/locations/validateAddress/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("Validates the shipping address and provides alternate addresses if any."),
		// 				Operation: to.Ptr("Validate Address"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Validate Address"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/subscriptions/resourceGroups/moveResources/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("This method performs the resource move."),
		// 				Operation: to.Ptr("Move Resource"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Move Resource"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/subscriptions/resourceGroups/validateMoveResources/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("This method validates whether resource move is allowed or not."),
		// 				Operation: to.Ptr("Validate Move Resource Request"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Move Resource"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/locations/availableSkus/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("This method returns the list of available skus."),
		// 				Operation: to.Ptr("Availabe Skus"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Available Skus"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/locations/regionConfiguration/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("This method returns the configurations for the region."),
		// 				Operation: to.Ptr("Region Configuration"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Region Configuration"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/locations/availableSkus/read"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("List or get the Available Skus"),
		// 				Operation: to.Ptr("List Available Skus"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Available Skus"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/register/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("Register Provider Microsoft.Databox"),
		// 				Operation: to.Ptr("Register Microsoft.Databox"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Register Microsoft.Databox"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/unregister/action"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("Un-Register Provider Microsoft.Databox"),
		// 				Operation: to.Ptr("Un-Register Microsoft.Databox"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Register Microsoft.Databox"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataBox/operations/read"),
		// 			Display: &armdatabox.OperationDisplay{
		// 				Description: to.Ptr("List or get the Operations"),
		// 				Operation: to.Ptr("List Operations"),
		// 				Provider: to.Ptr("Azure Data Box"),
		// 				Resource: to.Ptr("Operations"),
		// 			},
		// 			Origin: to.Ptr("user"),
		// 			Properties: map[string]any{
		// 			},
		// 	}},
		// }
	}
}
