//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
	"time"
)

// MarshalJSON implements the json.Marshaller interface for type AbsoluteDeleteOption.
func (a AbsoluteDeleteOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", a.Duration)
	objectMap["objectType"] = "AbsoluteDeleteOption"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AbsoluteDeleteOption.
func (a *AbsoluteDeleteOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdHocBackupRuleOptions.
func (a AdHocBackupRuleOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleName", a.RuleName)
	populate(objectMap, "triggerOption", a.TriggerOption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdHocBackupRuleOptions.
func (a *AdHocBackupRuleOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleName":
			err = unpopulate(val, "RuleName", &a.RuleName)
			delete(rawMsg, key)
		case "triggerOption":
			err = unpopulate(val, "TriggerOption", &a.TriggerOption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdhocBackupTriggerOption.
func (a AdhocBackupTriggerOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "retentionTagOverride", a.RetentionTagOverride)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdhocBackupTriggerOption.
func (a *AdhocBackupTriggerOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "retentionTagOverride":
			err = unpopulate(val, "RetentionTagOverride", &a.RetentionTagOverride)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdhocBasedTaggingCriteria.
func (a AdhocBasedTaggingCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tagInfo", a.TagInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdhocBasedTaggingCriteria.
func (a *AdhocBasedTaggingCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tagInfo":
			err = unpopulate(val, "TagInfo", &a.TagInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdhocBasedTriggerContext.
func (a AdhocBasedTriggerContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = "AdhocBasedTriggerContext"
	populate(objectMap, "taggingCriteria", a.TaggingCriteria)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdhocBasedTriggerContext.
func (a *AdhocBasedTriggerContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "taggingCriteria":
			err = unpopulate(val, "TaggingCriteria", &a.TaggingCriteria)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthCredentials.
func (a AuthCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = a.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthCredentials.
func (a *AuthCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupDiscreteRecoveryPoint.
func (a AzureBackupDiscreteRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiryTime", a.ExpiryTime)
	populate(objectMap, "friendlyName", a.FriendlyName)
	objectMap["objectType"] = "AzureBackupDiscreteRecoveryPoint"
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "policyVersion", a.PolicyVersion)
	populate(objectMap, "recoveryPointDataStoresDetails", a.RecoveryPointDataStoresDetails)
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	populate(objectMap, "recoveryPointState", a.RecoveryPointState)
	populateDateTimeRFC3339(objectMap, "recoveryPointTime", a.RecoveryPointTime)
	populate(objectMap, "recoveryPointType", a.RecoveryPointType)
	populate(objectMap, "retentionTagName", a.RetentionTagName)
	populate(objectMap, "retentionTagVersion", a.RetentionTagVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupDiscreteRecoveryPoint.
func (a *AzureBackupDiscreteRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryTime", &a.ExpiryTime)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "policyVersion":
			err = unpopulate(val, "PolicyVersion", &a.PolicyVersion)
			delete(rawMsg, key)
		case "recoveryPointDataStoresDetails":
			err = unpopulate(val, "RecoveryPointDataStoresDetails", &a.RecoveryPointDataStoresDetails)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointState":
			err = unpopulate(val, "RecoveryPointState", &a.RecoveryPointState)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateDateTimeRFC3339(val, "RecoveryPointTime", &a.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &a.RecoveryPointType)
			delete(rawMsg, key)
		case "retentionTagName":
			err = unpopulate(val, "RetentionTagName", &a.RetentionTagName)
			delete(rawMsg, key)
		case "retentionTagVersion":
			err = unpopulate(val, "RetentionTagVersion", &a.RetentionTagVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupFindRestorableTimeRangesRequest.
func (a AzureBackupFindRestorableTimeRangesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", a.EndTime)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "startTime", a.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupFindRestorableTimeRangesRequest.
func (a *AzureBackupFindRestorableTimeRangesRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupFindRestorableTimeRangesRequestResource.
func (a AzureBackupFindRestorableTimeRangesRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", a.Content)
	populate(objectMap, "cultureInfo", a.CultureInfo)
	populate(objectMap, "httpMethod", a.HTTPMethod)
	populate(objectMap, "headers", a.Headers)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	populate(objectMap, "supportedGroupVersions", a.SupportedGroupVersions)
	populate(objectMap, "uri", a.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupFindRestorableTimeRangesRequestResource.
func (a *AzureBackupFindRestorableTimeRangesRequestResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "cultureInfo":
			err = unpopulate(val, "CultureInfo", &a.CultureInfo)
			delete(rawMsg, key)
		case "httpMethod":
			err = unpopulate(val, "HTTPMethod", &a.HTTPMethod)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &a.Headers)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "supportedGroupVersions":
			err = unpopulate(val, "SupportedGroupVersions", &a.SupportedGroupVersions)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &a.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupFindRestorableTimeRangesResponse.
func (a AzureBackupFindRestorableTimeRangesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "objectType", a.ObjectType)
	populate(objectMap, "restorableTimeRanges", a.RestorableTimeRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupFindRestorableTimeRangesResponse.
func (a *AzureBackupFindRestorableTimeRangesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "restorableTimeRanges":
			err = unpopulate(val, "RestorableTimeRanges", &a.RestorableTimeRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupFindRestorableTimeRangesResponseResource.
func (a AzureBackupFindRestorableTimeRangesResponseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupFindRestorableTimeRangesResponseResource.
func (a *AzureBackupFindRestorableTimeRangesResponseResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupJob.
func (a AzureBackupJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activityID", a.ActivityID)
	populate(objectMap, "backupInstanceFriendlyName", a.BackupInstanceFriendlyName)
	populate(objectMap, "backupInstanceId", a.BackupInstanceID)
	populate(objectMap, "dataSourceId", a.DataSourceID)
	populate(objectMap, "dataSourceLocation", a.DataSourceLocation)
	populate(objectMap, "dataSourceName", a.DataSourceName)
	populate(objectMap, "dataSourceSetName", a.DataSourceSetName)
	populate(objectMap, "dataSourceType", a.DataSourceType)
	populate(objectMap, "destinationDataStoreName", a.DestinationDataStoreName)
	populate(objectMap, "duration", a.Duration)
	populateDateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "isUserTriggered", a.IsUserTriggered)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "operationCategory", a.OperationCategory)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "progressEnabled", a.ProgressEnabled)
	populate(objectMap, "progressUrl", a.ProgressURL)
	populate(objectMap, "rehydrationPriority", a.RehydrationPriority)
	populate(objectMap, "restoreType", a.RestoreType)
	populate(objectMap, "sourceDataStoreName", a.SourceDataStoreName)
	populate(objectMap, "sourceResourceGroup", a.SourceResourceGroup)
	populate(objectMap, "sourceSubscriptionID", a.SourceSubscriptionID)
	populateDateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	populate(objectMap, "supportedActions", a.SupportedActions)
	populate(objectMap, "vaultName", a.VaultName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupJob.
func (a *AzureBackupJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityID":
			err = unpopulate(val, "ActivityID", &a.ActivityID)
			delete(rawMsg, key)
		case "backupInstanceFriendlyName":
			err = unpopulate(val, "BackupInstanceFriendlyName", &a.BackupInstanceFriendlyName)
			delete(rawMsg, key)
		case "backupInstanceId":
			err = unpopulate(val, "BackupInstanceID", &a.BackupInstanceID)
			delete(rawMsg, key)
		case "dataSourceId":
			err = unpopulate(val, "DataSourceID", &a.DataSourceID)
			delete(rawMsg, key)
		case "dataSourceLocation":
			err = unpopulate(val, "DataSourceLocation", &a.DataSourceLocation)
			delete(rawMsg, key)
		case "dataSourceName":
			err = unpopulate(val, "DataSourceName", &a.DataSourceName)
			delete(rawMsg, key)
		case "dataSourceSetName":
			err = unpopulate(val, "DataSourceSetName", &a.DataSourceSetName)
			delete(rawMsg, key)
		case "dataSourceType":
			err = unpopulate(val, "DataSourceType", &a.DataSourceType)
			delete(rawMsg, key)
		case "destinationDataStoreName":
			err = unpopulate(val, "DestinationDataStoreName", &a.DestinationDataStoreName)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "isUserTriggered":
			err = unpopulate(val, "IsUserTriggered", &a.IsUserTriggered)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "operationCategory":
			err = unpopulate(val, "OperationCategory", &a.OperationCategory)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "progressEnabled":
			err = unpopulate(val, "ProgressEnabled", &a.ProgressEnabled)
			delete(rawMsg, key)
		case "progressUrl":
			err = unpopulate(val, "ProgressURL", &a.ProgressURL)
			delete(rawMsg, key)
		case "rehydrationPriority":
			err = unpopulate(val, "RehydrationPriority", &a.RehydrationPriority)
			delete(rawMsg, key)
		case "restoreType":
			err = unpopulate(val, "RestoreType", &a.RestoreType)
			delete(rawMsg, key)
		case "sourceDataStoreName":
			err = unpopulate(val, "SourceDataStoreName", &a.SourceDataStoreName)
			delete(rawMsg, key)
		case "sourceResourceGroup":
			err = unpopulate(val, "SourceResourceGroup", &a.SourceResourceGroup)
			delete(rawMsg, key)
		case "sourceSubscriptionID":
			err = unpopulate(val, "SourceSubscriptionID", &a.SourceSubscriptionID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "supportedActions":
			err = unpopulate(val, "SupportedActions", &a.SupportedActions)
			delete(rawMsg, key)
		case "vaultName":
			err = unpopulate(val, "VaultName", &a.VaultName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupJobResource.
func (a AzureBackupJobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupJobResource.
func (a *AzureBackupJobResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupJobResourceList.
func (a AzureBackupJobResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupJobResourceList.
func (a *AzureBackupJobResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupParams.
func (a AzureBackupParams) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupType", a.BackupType)
	objectMap["objectType"] = "AzureBackupParams"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupParams.
func (a *AzureBackupParams) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupType":
			err = unpopulate(val, "BackupType", &a.BackupType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRecoveryPoint.
func (a AzureBackupRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = a.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRecoveryPoint.
func (a *AzureBackupRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRecoveryPointBasedRestoreRequest.
func (a AzureBackupRecoveryPointBasedRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityDetails", a.IdentityDetails)
	objectMap["objectType"] = "AzureBackupRecoveryPointBasedRestoreRequest"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	populate(objectMap, "restoreTargetInfo", a.RestoreTargetInfo)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRecoveryPointBasedRestoreRequest.
func (a *AzureBackupRecoveryPointBasedRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityDetails":
			err = unpopulate(val, "IdentityDetails", &a.IdentityDetails)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		case "restoreTargetInfo":
			a.RestoreTargetInfo, err = unmarshalRestoreTargetInfoBaseClassification(val)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRecoveryPointResource.
func (a AzureBackupRecoveryPointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRecoveryPointResource.
func (a *AzureBackupRecoveryPointResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			a.Properties, err = unmarshalAzureBackupRecoveryPointClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRecoveryPointResourceList.
func (a AzureBackupRecoveryPointResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRecoveryPointResourceList.
func (a *AzureBackupRecoveryPointResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRecoveryTimeBasedRestoreRequest.
func (a AzureBackupRecoveryTimeBasedRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityDetails", a.IdentityDetails)
	objectMap["objectType"] = "AzureBackupRecoveryTimeBasedRestoreRequest"
	populate(objectMap, "recoveryPointTime", a.RecoveryPointTime)
	populate(objectMap, "restoreTargetInfo", a.RestoreTargetInfo)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRecoveryTimeBasedRestoreRequest.
func (a *AzureBackupRecoveryTimeBasedRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityDetails":
			err = unpopulate(val, "IdentityDetails", &a.IdentityDetails)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulate(val, "RecoveryPointTime", &a.RecoveryPointTime)
			delete(rawMsg, key)
		case "restoreTargetInfo":
			a.RestoreTargetInfo, err = unmarshalRestoreTargetInfoBaseClassification(val)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRehydrationRequest.
func (a AzureBackupRehydrationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	populate(objectMap, "rehydrationPriority", a.RehydrationPriority)
	populate(objectMap, "rehydrationRetentionDuration", a.RehydrationRetentionDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRehydrationRequest.
func (a *AzureBackupRehydrationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		case "rehydrationPriority":
			err = unpopulate(val, "RehydrationPriority", &a.RehydrationPriority)
			delete(rawMsg, key)
		case "rehydrationRetentionDuration":
			err = unpopulate(val, "RehydrationRetentionDuration", &a.RehydrationRetentionDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRestoreRequest.
func (a AzureBackupRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityDetails", a.IdentityDetails)
	objectMap["objectType"] = a.ObjectType
	populate(objectMap, "restoreTargetInfo", a.RestoreTargetInfo)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRestoreRequest.
func (a *AzureBackupRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityDetails":
			err = unpopulate(val, "IdentityDetails", &a.IdentityDetails)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "restoreTargetInfo":
			a.RestoreTargetInfo, err = unmarshalRestoreTargetInfoBaseClassification(val)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRestoreWithRehydrationRequest.
func (a AzureBackupRestoreWithRehydrationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityDetails", a.IdentityDetails)
	objectMap["objectType"] = "AzureBackupRestoreWithRehydrationRequest"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	populate(objectMap, "rehydrationPriority", a.RehydrationPriority)
	populate(objectMap, "rehydrationRetentionDuration", a.RehydrationRetentionDuration)
	populate(objectMap, "restoreTargetInfo", a.RestoreTargetInfo)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRestoreWithRehydrationRequest.
func (a *AzureBackupRestoreWithRehydrationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityDetails":
			err = unpopulate(val, "IdentityDetails", &a.IdentityDetails)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		case "rehydrationPriority":
			err = unpopulate(val, "RehydrationPriority", &a.RehydrationPriority)
			delete(rawMsg, key)
		case "rehydrationRetentionDuration":
			err = unpopulate(val, "RehydrationRetentionDuration", &a.RehydrationRetentionDuration)
			delete(rawMsg, key)
		case "restoreTargetInfo":
			a.RestoreTargetInfo, err = unmarshalRestoreTargetInfoBaseClassification(val)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRule.
func (a AzureBackupRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupParameters", a.BackupParameters)
	populate(objectMap, "dataStore", a.DataStore)
	populate(objectMap, "name", a.Name)
	objectMap["objectType"] = "AzureBackupRule"
	populate(objectMap, "trigger", a.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRule.
func (a *AzureBackupRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupParameters":
			a.BackupParameters, err = unmarshalBackupParametersClassification(val)
			delete(rawMsg, key)
		case "dataStore":
			err = unpopulate(val, "DataStore", &a.DataStore)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "trigger":
			a.Trigger, err = unmarshalTriggerContextClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMonitorAlertSettings.
func (a AzureMonitorAlertSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertsForAllJobFailures", a.AlertsForAllJobFailures)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMonitorAlertSettings.
func (a *AzureMonitorAlertSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertsForAllJobFailures":
			err = unpopulate(val, "AlertsForAllJobFailures", &a.AlertsForAllJobFailures)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperationalStoreParameters.
func (a AzureOperationalStoreParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataStoreType", a.DataStoreType)
	objectMap["objectType"] = "AzureOperationalStoreParameters"
	populate(objectMap, "resourceGroupId", a.ResourceGroupID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperationalStoreParameters.
func (a *AzureOperationalStoreParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataStoreType":
			err = unpopulate(val, "DataStoreType", &a.DataStoreType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "resourceGroupId":
			err = unpopulate(val, "ResourceGroupID", &a.ResourceGroupID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureRetentionRule.
func (a AzureRetentionRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isDefault", a.IsDefault)
	populate(objectMap, "lifecycles", a.Lifecycles)
	populate(objectMap, "name", a.Name)
	objectMap["objectType"] = "AzureRetentionRule"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureRetentionRule.
func (a *AzureRetentionRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isDefault":
			err = unpopulate(val, "IsDefault", &a.IsDefault)
			delete(rawMsg, key)
		case "lifecycles":
			err = unpopulate(val, "Lifecycles", &a.Lifecycles)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupCriteria.
func (b BackupCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = b.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupCriteria.
func (b *BackupCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupDatasourceParameters.
func (b BackupDatasourceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = b.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupDatasourceParameters.
func (b *BackupDatasourceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupInstance.
func (b BackupInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentProtectionState", b.CurrentProtectionState)
	populate(objectMap, "dataSourceInfo", b.DataSourceInfo)
	populate(objectMap, "dataSourceSetInfo", b.DataSourceSetInfo)
	populate(objectMap, "datasourceAuthCredentials", b.DatasourceAuthCredentials)
	populate(objectMap, "friendlyName", b.FriendlyName)
	populate(objectMap, "identityDetails", b.IdentityDetails)
	populate(objectMap, "objectType", b.ObjectType)
	populate(objectMap, "policyInfo", b.PolicyInfo)
	populate(objectMap, "protectionErrorDetails", b.ProtectionErrorDetails)
	populate(objectMap, "protectionStatus", b.ProtectionStatus)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "validationType", b.ValidationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupInstance.
func (b *BackupInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentProtectionState":
			err = unpopulate(val, "CurrentProtectionState", &b.CurrentProtectionState)
			delete(rawMsg, key)
		case "dataSourceInfo":
			err = unpopulate(val, "DataSourceInfo", &b.DataSourceInfo)
			delete(rawMsg, key)
		case "dataSourceSetInfo":
			err = unpopulate(val, "DataSourceSetInfo", &b.DataSourceSetInfo)
			delete(rawMsg, key)
		case "datasourceAuthCredentials":
			b.DatasourceAuthCredentials, err = unmarshalAuthCredentialsClassification(val)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &b.FriendlyName)
			delete(rawMsg, key)
		case "identityDetails":
			err = unpopulate(val, "IdentityDetails", &b.IdentityDetails)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		case "policyInfo":
			err = unpopulate(val, "PolicyInfo", &b.PolicyInfo)
			delete(rawMsg, key)
		case "protectionErrorDetails":
			err = unpopulate(val, "ProtectionErrorDetails", &b.ProtectionErrorDetails)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &b.ProtectionStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &b.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupInstanceResource.
func (b BackupInstanceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupInstanceResource.
func (b *BackupInstanceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupInstanceResourceList.
func (b BackupInstanceResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupInstanceResourceList.
func (b *BackupInstanceResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupParameters.
func (b BackupParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = b.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupParameters.
func (b *BackupParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicy.
func (b BackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasourceTypes", b.DatasourceTypes)
	objectMap["objectType"] = "BackupPolicy"
	populate(objectMap, "policyRules", b.PolicyRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicy.
func (b *BackupPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceTypes":
			err = unpopulate(val, "DatasourceTypes", &b.DatasourceTypes)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		case "policyRules":
			b.PolicyRules, err = unmarshalBasePolicyRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupSchedule.
func (b BackupSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "repeatingTimeIntervals", b.RepeatingTimeIntervals)
	populate(objectMap, "timeZone", b.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupSchedule.
func (b *BackupSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "repeatingTimeIntervals":
			err = unpopulate(val, "RepeatingTimeIntervals", &b.RepeatingTimeIntervals)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &b.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupVault.
func (b BackupVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featureSettings", b.FeatureSettings)
	populate(objectMap, "isVaultProtectedByResourceGuard", b.IsVaultProtectedByResourceGuard)
	populate(objectMap, "monitoringSettings", b.MonitoringSettings)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "replicatedRegions", b.ReplicatedRegions)
	populate(objectMap, "resourceMoveDetails", b.ResourceMoveDetails)
	populate(objectMap, "resourceMoveState", b.ResourceMoveState)
	populate(objectMap, "secureScore", b.SecureScore)
	populate(objectMap, "securitySettings", b.SecuritySettings)
	populate(objectMap, "storageSettings", b.StorageSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupVault.
func (b *BackupVault) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureSettings":
			err = unpopulate(val, "FeatureSettings", &b.FeatureSettings)
			delete(rawMsg, key)
		case "isVaultProtectedByResourceGuard":
			err = unpopulate(val, "IsVaultProtectedByResourceGuard", &b.IsVaultProtectedByResourceGuard)
			delete(rawMsg, key)
		case "monitoringSettings":
			err = unpopulate(val, "MonitoringSettings", &b.MonitoringSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "replicatedRegions":
			err = unpopulate(val, "ReplicatedRegions", &b.ReplicatedRegions)
			delete(rawMsg, key)
		case "resourceMoveDetails":
			err = unpopulate(val, "ResourceMoveDetails", &b.ResourceMoveDetails)
			delete(rawMsg, key)
		case "resourceMoveState":
			err = unpopulate(val, "ResourceMoveState", &b.ResourceMoveState)
			delete(rawMsg, key)
		case "secureScore":
			err = unpopulate(val, "SecureScore", &b.SecureScore)
			delete(rawMsg, key)
		case "securitySettings":
			err = unpopulate(val, "SecuritySettings", &b.SecuritySettings)
			delete(rawMsg, key)
		case "storageSettings":
			err = unpopulate(val, "StorageSettings", &b.StorageSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupVaultResource.
func (b BackupVaultResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "identity", b.Identity)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupVaultResource.
func (b *BackupVaultResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &b.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &b.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupVaultResourceList.
func (b BackupVaultResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupVaultResourceList.
func (b *BackupVaultResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BaseBackupPolicy.
func (b BaseBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasourceTypes", b.DatasourceTypes)
	objectMap["objectType"] = b.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaseBackupPolicy.
func (b *BaseBackupPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceTypes":
			err = unpopulate(val, "DatasourceTypes", &b.DatasourceTypes)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BaseBackupPolicyResource.
func (b BaseBackupPolicyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaseBackupPolicyResource.
func (b *BaseBackupPolicyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			b.Properties, err = unmarshalBaseBackupPolicyClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BaseBackupPolicyResourceList.
func (b BaseBackupPolicyResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaseBackupPolicyResourceList.
func (b *BaseBackupPolicyResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BasePolicyRule.
func (b BasePolicyRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", b.Name)
	objectMap["objectType"] = b.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BasePolicyRule.
func (b *BasePolicyRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BaseResourceProperties.
func (b BaseResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = b.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaseResourceProperties.
func (b *BaseResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobBackupDatasourceParameters.
func (b BlobBackupDatasourceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containersList", b.ContainersList)
	objectMap["objectType"] = "BlobBackupDatasourceParameters"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobBackupDatasourceParameters.
func (b *BlobBackupDatasourceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containersList":
			err = unpopulate(val, "ContainersList", &b.ContainersList)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityRequest.
func (c CheckNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityRequest.
func (c *CheckNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResult.
func (c CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResult.
func (c *CheckNameAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientDiscoveryDisplay.
func (c ClientDiscoveryDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "operation", c.Operation)
	populate(objectMap, "provider", c.Provider)
	populate(objectMap, "resource", c.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientDiscoveryDisplay.
func (c *ClientDiscoveryDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &c.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &c.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &c.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientDiscoveryForLogSpecification.
func (c ClientDiscoveryForLogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", c.BlobDuration)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientDiscoveryForLogSpecification.
func (c *ClientDiscoveryForLogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &c.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientDiscoveryForProperties.
func (c ClientDiscoveryForProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", c.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientDiscoveryForProperties.
func (c *ClientDiscoveryForProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &c.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientDiscoveryForServiceSpecification.
func (c ClientDiscoveryForServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", c.LogSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientDiscoveryForServiceSpecification.
func (c *ClientDiscoveryForServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &c.LogSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientDiscoveryResponse.
func (c ClientDiscoveryResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientDiscoveryResponse.
func (c *ClientDiscoveryResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientDiscoveryValueForSingleAPI.
func (c ClientDiscoveryValueForSingleAPI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", c.Display)
	populate(objectMap, "isDataAction", c.IsDataAction)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "origin", c.Origin)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientDiscoveryValueForSingleAPI.
func (c *ClientDiscoveryValueForSingleAPI) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &c.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &c.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &c.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyOnExpiryOption.
func (c CopyOnExpiryOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = "CopyOnExpiryOption"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyOnExpiryOption.
func (c *CopyOnExpiryOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &c.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyOption.
func (c CopyOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = c.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyOption.
func (c *CopyOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &c.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrossRegionRestoreDetails.
func (c CrossRegionRestoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceBackupInstanceId", c.SourceBackupInstanceID)
	populate(objectMap, "sourceRegion", c.SourceRegion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrossRegionRestoreDetails.
func (c *CrossRegionRestoreDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceBackupInstanceId":
			err = unpopulate(val, "SourceBackupInstanceID", &c.SourceBackupInstanceID)
			delete(rawMsg, key)
		case "sourceRegion":
			err = unpopulate(val, "SourceRegion", &c.SourceRegion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrossRegionRestoreJobRequest.
func (c CrossRegionRestoreJobRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobId", c.JobID)
	populate(objectMap, "sourceBackupVaultId", c.SourceBackupVaultID)
	populate(objectMap, "sourceRegion", c.SourceRegion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrossRegionRestoreJobRequest.
func (c *CrossRegionRestoreJobRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &c.JobID)
			delete(rawMsg, key)
		case "sourceBackupVaultId":
			err = unpopulate(val, "SourceBackupVaultID", &c.SourceBackupVaultID)
			delete(rawMsg, key)
		case "sourceRegion":
			err = unpopulate(val, "SourceRegion", &c.SourceRegion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrossRegionRestoreJobsRequest.
func (c CrossRegionRestoreJobsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceBackupVaultId", c.SourceBackupVaultID)
	populate(objectMap, "sourceRegion", c.SourceRegion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrossRegionRestoreJobsRequest.
func (c *CrossRegionRestoreJobsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceBackupVaultId":
			err = unpopulate(val, "SourceBackupVaultID", &c.SourceBackupVaultID)
			delete(rawMsg, key)
		case "sourceRegion":
			err = unpopulate(val, "SourceRegion", &c.SourceRegion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrossRegionRestoreRequestObject.
func (c CrossRegionRestoreRequestObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "crossRegionRestoreDetails", c.CrossRegionRestoreDetails)
	populate(objectMap, "restoreRequestObject", c.RestoreRequestObject)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrossRegionRestoreRequestObject.
func (c *CrossRegionRestoreRequestObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crossRegionRestoreDetails":
			err = unpopulate(val, "CrossRegionRestoreDetails", &c.CrossRegionRestoreDetails)
			delete(rawMsg, key)
		case "restoreRequestObject":
			c.RestoreRequestObject, err = unmarshalAzureBackupRestoreRequestClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrossRegionRestoreSettings.
func (c CrossRegionRestoreSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrossRegionRestoreSettings.
func (c *CrossRegionRestoreSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrossSubscriptionRestoreSettings.
func (c CrossSubscriptionRestoreSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrossSubscriptionRestoreSettings.
func (c *CrossSubscriptionRestoreSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomCopyOption.
func (c CustomCopyOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", c.Duration)
	objectMap["objectType"] = "CustomCopyOption"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomCopyOption.
func (c *CustomCopyOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &c.Duration)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &c.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataStoreInfoBase.
func (d DataStoreInfoBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataStoreType", d.DataStoreType)
	populate(objectMap, "objectType", d.ObjectType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataStoreInfoBase.
func (d *DataStoreInfoBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataStoreType":
			err = unpopulate(val, "DataStoreType", &d.DataStoreType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &d.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataStoreParameters.
func (d DataStoreParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataStoreType", d.DataStoreType)
	objectMap["objectType"] = d.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataStoreParameters.
func (d *DataStoreParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataStoreType":
			err = unpopulate(val, "DataStoreType", &d.DataStoreType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &d.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Datasource.
func (d Datasource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasourceType", d.DatasourceType)
	populate(objectMap, "objectType", d.ObjectType)
	populate(objectMap, "resourceID", d.ResourceID)
	populate(objectMap, "resourceLocation", d.ResourceLocation)
	populate(objectMap, "resourceName", d.ResourceName)
	populate(objectMap, "resourceProperties", d.ResourceProperties)
	populate(objectMap, "resourceType", d.ResourceType)
	populate(objectMap, "resourceUri", d.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Datasource.
func (d *Datasource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceType":
			err = unpopulate(val, "DatasourceType", &d.DatasourceType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &d.ObjectType)
			delete(rawMsg, key)
		case "resourceID":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &d.ResourceLocation)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &d.ResourceName)
			delete(rawMsg, key)
		case "resourceProperties":
			d.ResourceProperties, err = unmarshalBaseResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &d.ResourceType)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &d.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasourceSet.
func (d DatasourceSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasourceType", d.DatasourceType)
	populate(objectMap, "objectType", d.ObjectType)
	populate(objectMap, "resourceID", d.ResourceID)
	populate(objectMap, "resourceLocation", d.ResourceLocation)
	populate(objectMap, "resourceName", d.ResourceName)
	populate(objectMap, "resourceProperties", d.ResourceProperties)
	populate(objectMap, "resourceType", d.ResourceType)
	populate(objectMap, "resourceUri", d.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasourceSet.
func (d *DatasourceSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceType":
			err = unpopulate(val, "DatasourceType", &d.DatasourceType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &d.ObjectType)
			delete(rawMsg, key)
		case "resourceID":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &d.ResourceLocation)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &d.ResourceName)
			delete(rawMsg, key)
		case "resourceProperties":
			d.ResourceProperties, err = unmarshalBaseResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &d.ResourceType)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &d.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Day.
func (d Day) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "date", d.Date)
	populate(objectMap, "isLast", d.IsLast)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Day.
func (d *Day) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "date":
			err = unpopulate(val, "Date", &d.Date)
			delete(rawMsg, key)
		case "isLast":
			err = unpopulate(val, "IsLast", &d.IsLast)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultResourceProperties.
func (d DefaultResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = ResourcePropertiesObjectTypeDefaultResourceProperties
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultResourceProperties.
func (d *DefaultResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &d.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeleteOption.
func (d DeleteOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", d.Duration)
	objectMap["objectType"] = d.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeleteOption.
func (d *DeleteOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &d.Duration)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &d.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedBackupInstance.
func (d DeletedBackupInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentProtectionState", d.CurrentProtectionState)
	populate(objectMap, "dataSourceInfo", d.DataSourceInfo)
	populate(objectMap, "dataSourceSetInfo", d.DataSourceSetInfo)
	populate(objectMap, "datasourceAuthCredentials", d.DatasourceAuthCredentials)
	populate(objectMap, "deletionInfo", d.DeletionInfo)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "identityDetails", d.IdentityDetails)
	populate(objectMap, "objectType", d.ObjectType)
	populate(objectMap, "policyInfo", d.PolicyInfo)
	populate(objectMap, "protectionErrorDetails", d.ProtectionErrorDetails)
	populate(objectMap, "protectionStatus", d.ProtectionStatus)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "validationType", d.ValidationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedBackupInstance.
func (d *DeletedBackupInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentProtectionState":
			err = unpopulate(val, "CurrentProtectionState", &d.CurrentProtectionState)
			delete(rawMsg, key)
		case "dataSourceInfo":
			err = unpopulate(val, "DataSourceInfo", &d.DataSourceInfo)
			delete(rawMsg, key)
		case "dataSourceSetInfo":
			err = unpopulate(val, "DataSourceSetInfo", &d.DataSourceSetInfo)
			delete(rawMsg, key)
		case "datasourceAuthCredentials":
			d.DatasourceAuthCredentials, err = unmarshalAuthCredentialsClassification(val)
			delete(rawMsg, key)
		case "deletionInfo":
			err = unpopulate(val, "DeletionInfo", &d.DeletionInfo)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "identityDetails":
			err = unpopulate(val, "IdentityDetails", &d.IdentityDetails)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &d.ObjectType)
			delete(rawMsg, key)
		case "policyInfo":
			err = unpopulate(val, "PolicyInfo", &d.PolicyInfo)
			delete(rawMsg, key)
		case "protectionErrorDetails":
			err = unpopulate(val, "ProtectionErrorDetails", &d.ProtectionErrorDetails)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &d.ProtectionStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &d.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedBackupInstanceResource.
func (d DeletedBackupInstanceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedBackupInstanceResource.
func (d *DeletedBackupInstanceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedBackupInstanceResourceList.
func (d DeletedBackupInstanceResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedBackupInstanceResourceList.
func (d *DeletedBackupInstanceResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletionInfo.
func (d DeletionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingEndDate", d.BillingEndDate)
	populate(objectMap, "deleteActivityID", d.DeleteActivityID)
	populate(objectMap, "deletionTime", d.DeletionTime)
	populate(objectMap, "scheduledPurgeTime", d.ScheduledPurgeTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletionInfo.
func (d *DeletionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingEndDate":
			err = unpopulate(val, "BillingEndDate", &d.BillingEndDate)
			delete(rawMsg, key)
		case "deleteActivityID":
			err = unpopulate(val, "DeleteActivityID", &d.DeleteActivityID)
			delete(rawMsg, key)
		case "deletionTime":
			err = unpopulate(val, "DeletionTime", &d.DeletionTime)
			delete(rawMsg, key)
		case "scheduledPurgeTime":
			err = unpopulate(val, "ScheduledPurgeTime", &d.ScheduledPurgeTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppBaseResource.
func (d DppBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppBaseResource.
func (d *DppBaseResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppBaseResourceList.
func (d DppBaseResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppBaseResourceList.
func (d *DppBaseResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppBaseTrackedResource.
func (d DppBaseTrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", d.ETag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppBaseTrackedResource.
func (d *DppBaseTrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &d.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppIdentityDetails.
func (d DppIdentityDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", d.PrincipalID)
	populate(objectMap, "tenantId", d.TenantID)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "userAssignedIdentities", d.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppIdentityDetails.
func (d *DppIdentityDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &d.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &d.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &d.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppProxyResource.
func (d DppProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppProxyResource.
func (d *DppProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppResource.
func (d DppResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppResource.
func (d *DppResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppResourceList.
func (d DppResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppResourceList.
func (d *DppResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppTrackedResource.
func (d DppTrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", d.ETag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppTrackedResource.
func (d *DppTrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &d.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &d.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppTrackedResourceList.
func (d DppTrackedResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppTrackedResourceList.
func (d *DppTrackedResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppWorkerRequest.
func (d DppWorkerRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cultureInfo", d.CultureInfo)
	populate(objectMap, "httpMethod", d.HTTPMethod)
	populate(objectMap, "headers", d.Headers)
	populate(objectMap, "parameters", d.Parameters)
	populate(objectMap, "subscriptionId", d.SubscriptionID)
	populate(objectMap, "supportedGroupVersions", d.SupportedGroupVersions)
	populate(objectMap, "uri", d.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DppWorkerRequest.
func (d *DppWorkerRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cultureInfo":
			err = unpopulate(val, "CultureInfo", &d.CultureInfo)
			delete(rawMsg, key)
		case "httpMethod":
			err = unpopulate(val, "HTTPMethod", &d.HTTPMethod)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &d.Headers)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &d.SubscriptionID)
			delete(rawMsg, key)
		case "supportedGroupVersions":
			err = unpopulate(val, "SupportedGroupVersions", &d.SupportedGroupVersions)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &d.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportJobsResult.
func (e ExportJobsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobSasKey", e.BlobSasKey)
	populate(objectMap, "blobUrl", e.BlobURL)
	populate(objectMap, "excelFileBlobSasKey", e.ExcelFileBlobSasKey)
	populate(objectMap, "excelFileBlobUrl", e.ExcelFileBlobURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportJobsResult.
func (e *ExportJobsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobSasKey":
			err = unpopulate(val, "BlobSasKey", &e.BlobSasKey)
			delete(rawMsg, key)
		case "blobUrl":
			err = unpopulate(val, "BlobURL", &e.BlobURL)
			delete(rawMsg, key)
		case "excelFileBlobSasKey":
			err = unpopulate(val, "ExcelFileBlobSasKey", &e.ExcelFileBlobSasKey)
			delete(rawMsg, key)
		case "excelFileBlobUrl":
			err = unpopulate(val, "ExcelFileBlobURL", &e.ExcelFileBlobURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeatureSettings.
func (f FeatureSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "crossRegionRestoreSettings", f.CrossRegionRestoreSettings)
	populate(objectMap, "crossSubscriptionRestoreSettings", f.CrossSubscriptionRestoreSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureSettings.
func (f *FeatureSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crossRegionRestoreSettings":
			err = unpopulate(val, "CrossRegionRestoreSettings", &f.CrossRegionRestoreSettings)
			delete(rawMsg, key)
		case "crossSubscriptionRestoreSettings":
			err = unpopulate(val, "CrossSubscriptionRestoreSettings", &f.CrossSubscriptionRestoreSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeatureValidationRequest.
func (f FeatureValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featureName", f.FeatureName)
	populate(objectMap, "featureType", f.FeatureType)
	objectMap["objectType"] = "FeatureValidationRequest"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureValidationRequest.
func (f *FeatureValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureName":
			err = unpopulate(val, "FeatureName", &f.FeatureName)
			delete(rawMsg, key)
		case "featureType":
			err = unpopulate(val, "FeatureType", &f.FeatureType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &f.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeatureValidationRequestBase.
func (f FeatureValidationRequestBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = f.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureValidationRequestBase.
func (f *FeatureValidationRequestBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &f.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeatureValidationResponse.
func (f FeatureValidationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featureType", f.FeatureType)
	populate(objectMap, "features", f.Features)
	objectMap["objectType"] = "FeatureValidationResponse"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureValidationResponse.
func (f *FeatureValidationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureType":
			err = unpopulate(val, "FeatureType", &f.FeatureType)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &f.Features)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &f.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeatureValidationResponseBase.
func (f FeatureValidationResponseBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = f.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureValidationResponseBase.
func (f *FeatureValidationResponseBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &f.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FetchSecondaryRPsRequestParameters.
func (f FetchSecondaryRPsRequestParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceBackupInstanceId", f.SourceBackupInstanceID)
	populate(objectMap, "sourceRegion", f.SourceRegion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FetchSecondaryRPsRequestParameters.
func (f *FetchSecondaryRPsRequestParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceBackupInstanceId":
			err = unpopulate(val, "SourceBackupInstanceID", &f.SourceBackupInstanceID)
			delete(rawMsg, key)
		case "sourceRegion":
			err = unpopulate(val, "SourceRegion", &f.SourceRegion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityDetails.
func (i IdentityDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "useSystemAssignedIdentity", i.UseSystemAssignedIdentity)
	populate(objectMap, "userAssignedIdentityArmUrl", i.UserAssignedIdentityArmURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityDetails.
func (i *IdentityDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "useSystemAssignedIdentity":
			err = unpopulate(val, "UseSystemAssignedIdentity", &i.UseSystemAssignedIdentity)
			delete(rawMsg, key)
		case "userAssignedIdentityArmUrl":
			err = unpopulate(val, "UserAssignedIdentityArmURL", &i.UserAssignedIdentityArmURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImmediateCopyOption.
func (i ImmediateCopyOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = "ImmediateCopyOption"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImmediateCopyOption.
func (i *ImmediateCopyOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImmutabilitySettings.
func (i ImmutabilitySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImmutabilitySettings.
func (i *ImmutabilitySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerError.
func (i InnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", i.AdditionalInfo)
	populate(objectMap, "code", i.Code)
	populate(objectMap, "embeddedInnerError", i.EmbeddedInnerError)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerError.
func (i *InnerError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &i.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &i.Code)
			delete(rawMsg, key)
		case "embeddedInnerError":
			err = unpopulate(val, "EmbeddedInnerError", &i.EmbeddedInnerError)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ItemLevelRestoreCriteria.
func (i ItemLevelRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = i.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ItemLevelRestoreCriteria.
func (i *ItemLevelRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ItemLevelRestoreTargetInfo.
func (i ItemLevelRestoreTargetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasourceAuthCredentials", i.DatasourceAuthCredentials)
	populate(objectMap, "datasourceInfo", i.DatasourceInfo)
	populate(objectMap, "datasourceSetInfo", i.DatasourceSetInfo)
	objectMap["objectType"] = "ItemLevelRestoreTargetInfo"
	populate(objectMap, "recoveryOption", i.RecoveryOption)
	populate(objectMap, "restoreCriteria", i.RestoreCriteria)
	populate(objectMap, "restoreLocation", i.RestoreLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ItemLevelRestoreTargetInfo.
func (i *ItemLevelRestoreTargetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceAuthCredentials":
			i.DatasourceAuthCredentials, err = unmarshalAuthCredentialsClassification(val)
			delete(rawMsg, key)
		case "datasourceInfo":
			err = unpopulate(val, "DatasourceInfo", &i.DatasourceInfo)
			delete(rawMsg, key)
		case "datasourceSetInfo":
			err = unpopulate(val, "DatasourceSetInfo", &i.DatasourceSetInfo)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		case "recoveryOption":
			err = unpopulate(val, "RecoveryOption", &i.RecoveryOption)
			delete(rawMsg, key)
		case "restoreCriteria":
			i.RestoreCriteria, err = unmarshalItemLevelRestoreCriteriaClassificationArray(val)
			delete(rawMsg, key)
		case "restoreLocation":
			err = unpopulate(val, "RestoreLocation", &i.RestoreLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ItemPathBasedRestoreCriteria.
func (i ItemPathBasedRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPathRelativeToBackupItem", i.IsPathRelativeToBackupItem)
	populate(objectMap, "itemPath", i.ItemPath)
	objectMap["objectType"] = "ItemPathBasedRestoreCriteria"
	populate(objectMap, "subItemPathPrefix", i.SubItemPathPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ItemPathBasedRestoreCriteria.
func (i *ItemPathBasedRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPathRelativeToBackupItem":
			err = unpopulate(val, "IsPathRelativeToBackupItem", &i.IsPathRelativeToBackupItem)
			delete(rawMsg, key)
		case "itemPath":
			err = unpopulate(val, "ItemPath", &i.ItemPath)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		case "subItemPathPrefix":
			err = unpopulate(val, "SubItemPathPrefix", &i.SubItemPathPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobExtendedInfo.
func (j JobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalDetails", j.AdditionalDetails)
	populate(objectMap, "backupInstanceState", j.BackupInstanceState)
	populate(objectMap, "dataTransferredInBytes", j.DataTransferredInBytes)
	populate(objectMap, "recoveryDestination", j.RecoveryDestination)
	populate(objectMap, "sourceRecoverPoint", j.SourceRecoverPoint)
	populate(objectMap, "subTasks", j.SubTasks)
	populate(objectMap, "targetRecoverPoint", j.TargetRecoverPoint)
	populate(objectMap, "warningDetails", j.WarningDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobExtendedInfo.
func (j *JobExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalDetails":
			err = unpopulate(val, "AdditionalDetails", &j.AdditionalDetails)
			delete(rawMsg, key)
		case "backupInstanceState":
			err = unpopulate(val, "BackupInstanceState", &j.BackupInstanceState)
			delete(rawMsg, key)
		case "dataTransferredInBytes":
			err = unpopulate(val, "DataTransferredInBytes", &j.DataTransferredInBytes)
			delete(rawMsg, key)
		case "recoveryDestination":
			err = unpopulate(val, "RecoveryDestination", &j.RecoveryDestination)
			delete(rawMsg, key)
		case "sourceRecoverPoint":
			err = unpopulate(val, "SourceRecoverPoint", &j.SourceRecoverPoint)
			delete(rawMsg, key)
		case "subTasks":
			err = unpopulate(val, "SubTasks", &j.SubTasks)
			delete(rawMsg, key)
		case "targetRecoverPoint":
			err = unpopulate(val, "TargetRecoverPoint", &j.TargetRecoverPoint)
			delete(rawMsg, key)
		case "warningDetails":
			err = unpopulate(val, "WarningDetails", &j.WarningDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobSubTask.
func (j JobSubTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalDetails", j.AdditionalDetails)
	populate(objectMap, "taskId", j.TaskID)
	populate(objectMap, "taskName", j.TaskName)
	populate(objectMap, "taskProgress", j.TaskProgress)
	populate(objectMap, "taskStatus", j.TaskStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobSubTask.
func (j *JobSubTask) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalDetails":
			err = unpopulate(val, "AdditionalDetails", &j.AdditionalDetails)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &j.TaskID)
			delete(rawMsg, key)
		case "taskName":
			err = unpopulate(val, "TaskName", &j.TaskName)
			delete(rawMsg, key)
		case "taskProgress":
			err = unpopulate(val, "TaskProgress", &j.TaskProgress)
			delete(rawMsg, key)
		case "taskStatus":
			err = unpopulate(val, "TaskStatus", &j.TaskStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterBackupDatasourceParameters.
func (k KubernetesClusterBackupDatasourceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupHookReferences", k.BackupHookReferences)
	populate(objectMap, "excludedNamespaces", k.ExcludedNamespaces)
	populate(objectMap, "excludedResourceTypes", k.ExcludedResourceTypes)
	populate(objectMap, "includeClusterScopeResources", k.IncludeClusterScopeResources)
	populate(objectMap, "includedNamespaces", k.IncludedNamespaces)
	populate(objectMap, "includedResourceTypes", k.IncludedResourceTypes)
	populate(objectMap, "labelSelectors", k.LabelSelectors)
	objectMap["objectType"] = "KubernetesClusterBackupDatasourceParameters"
	populate(objectMap, "snapshotVolumes", k.SnapshotVolumes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterBackupDatasourceParameters.
func (k *KubernetesClusterBackupDatasourceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupHookReferences":
			err = unpopulate(val, "BackupHookReferences", &k.BackupHookReferences)
			delete(rawMsg, key)
		case "excludedNamespaces":
			err = unpopulate(val, "ExcludedNamespaces", &k.ExcludedNamespaces)
			delete(rawMsg, key)
		case "excludedResourceTypes":
			err = unpopulate(val, "ExcludedResourceTypes", &k.ExcludedResourceTypes)
			delete(rawMsg, key)
		case "includeClusterScopeResources":
			err = unpopulate(val, "IncludeClusterScopeResources", &k.IncludeClusterScopeResources)
			delete(rawMsg, key)
		case "includedNamespaces":
			err = unpopulate(val, "IncludedNamespaces", &k.IncludedNamespaces)
			delete(rawMsg, key)
		case "includedResourceTypes":
			err = unpopulate(val, "IncludedResourceTypes", &k.IncludedResourceTypes)
			delete(rawMsg, key)
		case "labelSelectors":
			err = unpopulate(val, "LabelSelectors", &k.LabelSelectors)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "snapshotVolumes":
			err = unpopulate(val, "SnapshotVolumes", &k.SnapshotVolumes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterRestoreCriteria.
func (k KubernetesClusterRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "conflictPolicy", k.ConflictPolicy)
	populate(objectMap, "excludedNamespaces", k.ExcludedNamespaces)
	populate(objectMap, "excludedResourceTypes", k.ExcludedResourceTypes)
	populate(objectMap, "includeClusterScopeResources", k.IncludeClusterScopeResources)
	populate(objectMap, "includedNamespaces", k.IncludedNamespaces)
	populate(objectMap, "includedResourceTypes", k.IncludedResourceTypes)
	populate(objectMap, "labelSelectors", k.LabelSelectors)
	populate(objectMap, "namespaceMappings", k.NamespaceMappings)
	objectMap["objectType"] = "KubernetesClusterRestoreCriteria"
	populate(objectMap, "persistentVolumeRestoreMode", k.PersistentVolumeRestoreMode)
	populate(objectMap, "restoreHookReferences", k.RestoreHookReferences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterRestoreCriteria.
func (k *KubernetesClusterRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conflictPolicy":
			err = unpopulate(val, "ConflictPolicy", &k.ConflictPolicy)
			delete(rawMsg, key)
		case "excludedNamespaces":
			err = unpopulate(val, "ExcludedNamespaces", &k.ExcludedNamespaces)
			delete(rawMsg, key)
		case "excludedResourceTypes":
			err = unpopulate(val, "ExcludedResourceTypes", &k.ExcludedResourceTypes)
			delete(rawMsg, key)
		case "includeClusterScopeResources":
			err = unpopulate(val, "IncludeClusterScopeResources", &k.IncludeClusterScopeResources)
			delete(rawMsg, key)
		case "includedNamespaces":
			err = unpopulate(val, "IncludedNamespaces", &k.IncludedNamespaces)
			delete(rawMsg, key)
		case "includedResourceTypes":
			err = unpopulate(val, "IncludedResourceTypes", &k.IncludedResourceTypes)
			delete(rawMsg, key)
		case "labelSelectors":
			err = unpopulate(val, "LabelSelectors", &k.LabelSelectors)
			delete(rawMsg, key)
		case "namespaceMappings":
			err = unpopulate(val, "NamespaceMappings", &k.NamespaceMappings)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "persistentVolumeRestoreMode":
			err = unpopulate(val, "PersistentVolumeRestoreMode", &k.PersistentVolumeRestoreMode)
			delete(rawMsg, key)
		case "restoreHookReferences":
			err = unpopulate(val, "RestoreHookReferences", &k.RestoreHookReferences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterVaultTierRestoreCriteria.
func (k KubernetesClusterVaultTierRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "conflictPolicy", k.ConflictPolicy)
	populate(objectMap, "excludedNamespaces", k.ExcludedNamespaces)
	populate(objectMap, "excludedResourceTypes", k.ExcludedResourceTypes)
	populate(objectMap, "includeClusterScopeResources", k.IncludeClusterScopeResources)
	populate(objectMap, "includedNamespaces", k.IncludedNamespaces)
	populate(objectMap, "includedResourceTypes", k.IncludedResourceTypes)
	populate(objectMap, "labelSelectors", k.LabelSelectors)
	populate(objectMap, "namespaceMappings", k.NamespaceMappings)
	objectMap["objectType"] = "KubernetesClusterVaultTierRestoreCriteria"
	populate(objectMap, "persistentVolumeRestoreMode", k.PersistentVolumeRestoreMode)
	populate(objectMap, "restoreHookReferences", k.RestoreHookReferences)
	populate(objectMap, "stagingResourceGroupId", k.StagingResourceGroupID)
	populate(objectMap, "stagingStorageAccountId", k.StagingStorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterVaultTierRestoreCriteria.
func (k *KubernetesClusterVaultTierRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conflictPolicy":
			err = unpopulate(val, "ConflictPolicy", &k.ConflictPolicy)
			delete(rawMsg, key)
		case "excludedNamespaces":
			err = unpopulate(val, "ExcludedNamespaces", &k.ExcludedNamespaces)
			delete(rawMsg, key)
		case "excludedResourceTypes":
			err = unpopulate(val, "ExcludedResourceTypes", &k.ExcludedResourceTypes)
			delete(rawMsg, key)
		case "includeClusterScopeResources":
			err = unpopulate(val, "IncludeClusterScopeResources", &k.IncludeClusterScopeResources)
			delete(rawMsg, key)
		case "includedNamespaces":
			err = unpopulate(val, "IncludedNamespaces", &k.IncludedNamespaces)
			delete(rawMsg, key)
		case "includedResourceTypes":
			err = unpopulate(val, "IncludedResourceTypes", &k.IncludedResourceTypes)
			delete(rawMsg, key)
		case "labelSelectors":
			err = unpopulate(val, "LabelSelectors", &k.LabelSelectors)
			delete(rawMsg, key)
		case "namespaceMappings":
			err = unpopulate(val, "NamespaceMappings", &k.NamespaceMappings)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "persistentVolumeRestoreMode":
			err = unpopulate(val, "PersistentVolumeRestoreMode", &k.PersistentVolumeRestoreMode)
			delete(rawMsg, key)
		case "restoreHookReferences":
			err = unpopulate(val, "RestoreHookReferences", &k.RestoreHookReferences)
			delete(rawMsg, key)
		case "stagingResourceGroupId":
			err = unpopulate(val, "StagingResourceGroupID", &k.StagingResourceGroupID)
			delete(rawMsg, key)
		case "stagingStorageAccountId":
			err = unpopulate(val, "StagingStorageAccountID", &k.StagingStorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesPVRestoreCriteria.
func (k KubernetesPVRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", k.Name)
	objectMap["objectType"] = "KubernetesPVRestoreCriteria"
	populate(objectMap, "storageClassName", k.StorageClassName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesPVRestoreCriteria.
func (k *KubernetesPVRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "storageClassName":
			err = unpopulate(val, "StorageClassName", &k.StorageClassName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesStorageClassRestoreCriteria.
func (k KubernetesStorageClassRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = "KubernetesStorageClassRestoreCriteria"
	populate(objectMap, "provisioner", k.Provisioner)
	populate(objectMap, "selectedStorageClassName", k.SelectedStorageClassName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesStorageClassRestoreCriteria.
func (k *KubernetesStorageClassRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "provisioner":
			err = unpopulate(val, "Provisioner", &k.Provisioner)
			delete(rawMsg, key)
		case "selectedStorageClassName":
			err = unpopulate(val, "SelectedStorageClassName", &k.SelectedStorageClassName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MonitoringSettings.
func (m MonitoringSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureMonitorAlertSettings", m.AzureMonitorAlertSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MonitoringSettings.
func (m *MonitoringSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureMonitorAlertSettings":
			err = unpopulate(val, "AzureMonitorAlertSettings", &m.AzureMonitorAlertSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamespacedNameResource.
func (n NamespacedNameResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "namespace", n.Namespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamespacedNameResource.
func (n *NamespacedNameResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &n.Namespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationExtendedInfo.
func (o OperationExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = o.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationExtendedInfo.
func (o *OperationExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationJobExtendedInfo.
func (o OperationJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobId", o.JobID)
	objectMap["objectType"] = "OperationJobExtendedInfo"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationJobExtendedInfo.
func (o *OperationJobExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &o.JobID)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResource.
func (o OperationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResource.
func (o *OperationResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			o.Properties, err = unmarshalOperationExtendedInfoClassification(val)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchBackupVaultInput.
func (p PatchBackupVaultInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featureSettings", p.FeatureSettings)
	populate(objectMap, "monitoringSettings", p.MonitoringSettings)
	populate(objectMap, "securitySettings", p.SecuritySettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchBackupVaultInput.
func (p *PatchBackupVaultInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureSettings":
			err = unpopulate(val, "FeatureSettings", &p.FeatureSettings)
			delete(rawMsg, key)
		case "monitoringSettings":
			err = unpopulate(val, "MonitoringSettings", &p.MonitoringSettings)
			delete(rawMsg, key)
		case "securitySettings":
			err = unpopulate(val, "SecuritySettings", &p.SecuritySettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchResourceGuardInput.
func (p PatchResourceGuardInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchResourceGuardInput.
func (p *PatchResourceGuardInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchResourceRequestInput.
func (p PatchResourceRequestInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchResourceRequestInput.
func (p *PatchResourceRequestInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyInfo.
func (p PolicyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyId", p.PolicyID)
	populate(objectMap, "policyParameters", p.PolicyParameters)
	populate(objectMap, "policyVersion", p.PolicyVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyInfo.
func (p *PolicyInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyId":
			err = unpopulate(val, "PolicyID", &p.PolicyID)
			delete(rawMsg, key)
		case "policyParameters":
			err = unpopulate(val, "PolicyParameters", &p.PolicyParameters)
			delete(rawMsg, key)
		case "policyVersion":
			err = unpopulate(val, "PolicyVersion", &p.PolicyVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyParameters.
func (p PolicyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupDatasourceParametersList", p.BackupDatasourceParametersList)
	populate(objectMap, "dataStoreParametersList", p.DataStoreParametersList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyParameters.
func (p *PolicyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupDatasourceParametersList":
			p.BackupDatasourceParametersList, err = unmarshalBackupDatasourceParametersClassificationArray(val)
			delete(rawMsg, key)
		case "dataStoreParametersList":
			p.DataStoreParametersList, err = unmarshalDataStoreParametersClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionStatusDetails.
func (p ProtectionStatusDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorDetails", p.ErrorDetails)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionStatusDetails.
func (p *ProtectionStatusDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &p.ErrorDetails)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RangeBasedItemLevelRestoreCriteria.
func (r RangeBasedItemLevelRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxMatchingValue", r.MaxMatchingValue)
	populate(objectMap, "minMatchingValue", r.MinMatchingValue)
	objectMap["objectType"] = "RangeBasedItemLevelRestoreCriteria"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RangeBasedItemLevelRestoreCriteria.
func (r *RangeBasedItemLevelRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxMatchingValue":
			err = unpopulate(val, "MaxMatchingValue", &r.MaxMatchingValue)
			delete(rawMsg, key)
		case "minMatchingValue":
			err = unpopulate(val, "MinMatchingValue", &r.MinMatchingValue)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointDataStoreDetails.
func (r RecoveryPointDataStoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populateDateTimeRFC3339(objectMap, "expiryTime", r.ExpiryTime)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "metaData", r.MetaData)
	populateDateTimeRFC3339(objectMap, "rehydrationExpiryTime", r.RehydrationExpiryTime)
	populate(objectMap, "rehydrationStatus", r.RehydrationStatus)
	populate(objectMap, "state", r.State)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "visible", r.Visible)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointDataStoreDetails.
func (r *RecoveryPointDataStoreDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryTime", &r.ExpiryTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "metaData":
			err = unpopulate(val, "MetaData", &r.MetaData)
			delete(rawMsg, key)
		case "rehydrationExpiryTime":
			err = unpopulateDateTimeRFC3339(val, "RehydrationExpiryTime", &r.RehydrationExpiryTime)
			delete(rawMsg, key)
		case "rehydrationStatus":
			err = unpopulate(val, "RehydrationStatus", &r.RehydrationStatus)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "visible":
			err = unpopulate(val, "Visible", &r.Visible)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointsFilters.
func (r RecoveryPointsFilters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endDate", r.EndDate)
	populate(objectMap, "extendedInfo", r.ExtendedInfo)
	populate(objectMap, "isVisible", r.IsVisible)
	populate(objectMap, "restorePointDataStoreId", r.RestorePointDataStoreID)
	populate(objectMap, "restorePointState", r.RestorePointState)
	populate(objectMap, "startDate", r.StartDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointsFilters.
func (r *RecoveryPointsFilters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endDate":
			err = unpopulate(val, "EndDate", &r.EndDate)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &r.ExtendedInfo)
			delete(rawMsg, key)
		case "isVisible":
			err = unpopulate(val, "IsVisible", &r.IsVisible)
			delete(rawMsg, key)
		case "restorePointDataStoreId":
			err = unpopulate(val, "RestorePointDataStoreID", &r.RestorePointDataStoreID)
			delete(rawMsg, key)
		case "restorePointState":
			err = unpopulate(val, "RestorePointState", &r.RestorePointState)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulate(val, "StartDate", &r.StartDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuard.
func (r ResourceGuard) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowAutoApprovals", r.AllowAutoApprovals)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "resourceGuardOperations", r.ResourceGuardOperations)
	populate(objectMap, "vaultCriticalOperationExclusionList", r.VaultCriticalOperationExclusionList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGuard.
func (r *ResourceGuard) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowAutoApprovals":
			err = unpopulate(val, "AllowAutoApprovals", &r.AllowAutoApprovals)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuardOperations":
			err = unpopulate(val, "ResourceGuardOperations", &r.ResourceGuardOperations)
			delete(rawMsg, key)
		case "vaultCriticalOperationExclusionList":
			err = unpopulate(val, "VaultCriticalOperationExclusionList", &r.VaultCriticalOperationExclusionList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardOperation.
func (r ResourceGuardOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requestResourceType", r.RequestResourceType)
	populate(objectMap, "vaultCriticalOperation", r.VaultCriticalOperation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGuardOperation.
func (r *ResourceGuardOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requestResourceType":
			err = unpopulate(val, "RequestResourceType", &r.RequestResourceType)
			delete(rawMsg, key)
		case "vaultCriticalOperation":
			err = unpopulate(val, "VaultCriticalOperation", &r.VaultCriticalOperation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardOperationDetail.
func (r ResourceGuardOperationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultResourceRequest", r.DefaultResourceRequest)
	populate(objectMap, "vaultCriticalOperation", r.VaultCriticalOperation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGuardOperationDetail.
func (r *ResourceGuardOperationDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultResourceRequest":
			err = unpopulate(val, "DefaultResourceRequest", &r.DefaultResourceRequest)
			delete(rawMsg, key)
		case "vaultCriticalOperation":
			err = unpopulate(val, "VaultCriticalOperation", &r.VaultCriticalOperation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardProxyBase.
func (r ResourceGuardProxyBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "lastUpdatedTime", r.LastUpdatedTime)
	populate(objectMap, "resourceGuardOperationDetails", r.ResourceGuardOperationDetails)
	populate(objectMap, "resourceGuardResourceId", r.ResourceGuardResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGuardProxyBase.
func (r *ResourceGuardProxyBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulate(val, "LastUpdatedTime", &r.LastUpdatedTime)
			delete(rawMsg, key)
		case "resourceGuardOperationDetails":
			err = unpopulate(val, "ResourceGuardOperationDetails", &r.ResourceGuardOperationDetails)
			delete(rawMsg, key)
		case "resourceGuardResourceId":
			err = unpopulate(val, "ResourceGuardResourceID", &r.ResourceGuardResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardProxyBaseResource.
func (r ResourceGuardProxyBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGuardProxyBaseResource.
func (r *ResourceGuardProxyBaseResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardProxyBaseResourceList.
func (r ResourceGuardProxyBaseResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGuardProxyBaseResourceList.
func (r *ResourceGuardProxyBaseResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardResource.
func (r ResourceGuardResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", r.ETag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGuardResource.
func (r *ResourceGuardResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &r.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardResourceList.
func (r ResourceGuardResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGuardResourceList.
func (r *ResourceGuardResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMoveDetails.
func (r ResourceMoveDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completionTimeUtc", r.CompletionTimeUTC)
	populate(objectMap, "operationId", r.OperationID)
	populate(objectMap, "sourceResourcePath", r.SourceResourcePath)
	populate(objectMap, "startTimeUtc", r.StartTimeUTC)
	populate(objectMap, "targetResourcePath", r.TargetResourcePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMoveDetails.
func (r *ResourceMoveDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completionTimeUtc":
			err = unpopulate(val, "CompletionTimeUTC", &r.CompletionTimeUTC)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &r.OperationID)
			delete(rawMsg, key)
		case "sourceResourcePath":
			err = unpopulate(val, "SourceResourcePath", &r.SourceResourcePath)
			delete(rawMsg, key)
		case "startTimeUtc":
			err = unpopulate(val, "StartTimeUTC", &r.StartTimeUTC)
			delete(rawMsg, key)
		case "targetResourcePath":
			err = unpopulate(val, "TargetResourcePath", &r.TargetResourcePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorableTimeRange.
func (r RestorableTimeRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", r.EndTime)
	populate(objectMap, "objectType", r.ObjectType)
	populate(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorableTimeRange.
func (r *RestorableTimeRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreFilesTargetInfo.
func (r RestoreFilesTargetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = "RestoreFilesTargetInfo"
	populate(objectMap, "recoveryOption", r.RecoveryOption)
	populate(objectMap, "restoreLocation", r.RestoreLocation)
	populate(objectMap, "targetDetails", r.TargetDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreFilesTargetInfo.
func (r *RestoreFilesTargetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		case "recoveryOption":
			err = unpopulate(val, "RecoveryOption", &r.RecoveryOption)
			delete(rawMsg, key)
		case "restoreLocation":
			err = unpopulate(val, "RestoreLocation", &r.RestoreLocation)
			delete(rawMsg, key)
		case "targetDetails":
			err = unpopulate(val, "TargetDetails", &r.TargetDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreJobRecoveryPointDetails.
func (r RestoreJobRecoveryPointDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recoveryPointID", r.RecoveryPointID)
	populateDateTimeRFC3339(objectMap, "recoveryPointTime", r.RecoveryPointTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreJobRecoveryPointDetails.
func (r *RestoreJobRecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryPointID":
			err = unpopulate(val, "RecoveryPointID", &r.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateDateTimeRFC3339(val, "RecoveryPointTime", &r.RecoveryPointTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreTargetInfo.
func (r RestoreTargetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasourceAuthCredentials", r.DatasourceAuthCredentials)
	populate(objectMap, "datasourceInfo", r.DatasourceInfo)
	populate(objectMap, "datasourceSetInfo", r.DatasourceSetInfo)
	objectMap["objectType"] = "RestoreTargetInfo"
	populate(objectMap, "recoveryOption", r.RecoveryOption)
	populate(objectMap, "restoreLocation", r.RestoreLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreTargetInfo.
func (r *RestoreTargetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceAuthCredentials":
			r.DatasourceAuthCredentials, err = unmarshalAuthCredentialsClassification(val)
			delete(rawMsg, key)
		case "datasourceInfo":
			err = unpopulate(val, "DatasourceInfo", &r.DatasourceInfo)
			delete(rawMsg, key)
		case "datasourceSetInfo":
			err = unpopulate(val, "DatasourceSetInfo", &r.DatasourceSetInfo)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		case "recoveryOption":
			err = unpopulate(val, "RecoveryOption", &r.RecoveryOption)
			delete(rawMsg, key)
		case "restoreLocation":
			err = unpopulate(val, "RestoreLocation", &r.RestoreLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreTargetInfoBase.
func (r RestoreTargetInfoBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = r.ObjectType
	populate(objectMap, "recoveryOption", r.RecoveryOption)
	populate(objectMap, "restoreLocation", r.RestoreLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreTargetInfoBase.
func (r *RestoreTargetInfoBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		case "recoveryOption":
			err = unpopulate(val, "RecoveryOption", &r.RecoveryOption)
			delete(rawMsg, key)
		case "restoreLocation":
			err = unpopulate(val, "RestoreLocation", &r.RestoreLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetentionTag.
func (r RetentionTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", r.ETag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "tagName", r.TagName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetentionTag.
func (r *RetentionTag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &r.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "tagName":
			err = unpopulate(val, "TagName", &r.TagName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleBasedBackupCriteria.
func (s ScheduleBasedBackupCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "absoluteCriteria", s.AbsoluteCriteria)
	populate(objectMap, "daysOfMonth", s.DaysOfMonth)
	populate(objectMap, "daysOfTheWeek", s.DaysOfTheWeek)
	populate(objectMap, "monthsOfYear", s.MonthsOfYear)
	objectMap["objectType"] = "ScheduleBasedBackupCriteria"
	aux := make([]*dateTimeRFC3339, len(s.ScheduleTimes), len(s.ScheduleTimes))
	for i := 0; i < len(s.ScheduleTimes); i++ {
		aux[i] = (*dateTimeRFC3339)(s.ScheduleTimes[i])
	}
	populate(objectMap, "scheduleTimes", aux)
	populate(objectMap, "weeksOfTheMonth", s.WeeksOfTheMonth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleBasedBackupCriteria.
func (s *ScheduleBasedBackupCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "absoluteCriteria":
			err = unpopulate(val, "AbsoluteCriteria", &s.AbsoluteCriteria)
			delete(rawMsg, key)
		case "daysOfMonth":
			err = unpopulate(val, "DaysOfMonth", &s.DaysOfMonth)
			delete(rawMsg, key)
		case "daysOfTheWeek":
			err = unpopulate(val, "DaysOfTheWeek", &s.DaysOfTheWeek)
			delete(rawMsg, key)
		case "monthsOfYear":
			err = unpopulate(val, "MonthsOfYear", &s.MonthsOfYear)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &s.ObjectType)
			delete(rawMsg, key)
		case "scheduleTimes":
			var aux []*dateTimeRFC3339
			err = unpopulate(val, "ScheduleTimes", &aux)
			for _, au := range aux {
				s.ScheduleTimes = append(s.ScheduleTimes, (*time.Time)(au))
			}
			delete(rawMsg, key)
		case "weeksOfTheMonth":
			err = unpopulate(val, "WeeksOfTheMonth", &s.WeeksOfTheMonth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleBasedTriggerContext.
func (s ScheduleBasedTriggerContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = "ScheduleBasedTriggerContext"
	populate(objectMap, "schedule", s.Schedule)
	populate(objectMap, "taggingCriteria", s.TaggingCriteria)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleBasedTriggerContext.
func (s *ScheduleBasedTriggerContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &s.ObjectType)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &s.Schedule)
			delete(rawMsg, key)
		case "taggingCriteria":
			err = unpopulate(val, "TaggingCriteria", &s.TaggingCriteria)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretStoreBasedAuthCredentials.
func (s SecretStoreBasedAuthCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = "SecretStoreBasedAuthCredentials"
	populate(objectMap, "secretStoreResource", s.SecretStoreResource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretStoreBasedAuthCredentials.
func (s *SecretStoreBasedAuthCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &s.ObjectType)
			delete(rawMsg, key)
		case "secretStoreResource":
			err = unpopulate(val, "SecretStoreResource", &s.SecretStoreResource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretStoreResource.
func (s SecretStoreResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretStoreType", s.SecretStoreType)
	populate(objectMap, "uri", s.URI)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretStoreResource.
func (s *SecretStoreResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretStoreType":
			err = unpopulate(val, "SecretStoreType", &s.SecretStoreType)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &s.URI)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecuritySettings.
func (s SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "immutabilitySettings", s.ImmutabilitySettings)
	populate(objectMap, "softDeleteSettings", s.SoftDeleteSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecuritySettings.
func (s *SecuritySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "immutabilitySettings":
			err = unpopulate(val, "ImmutabilitySettings", &s.ImmutabilitySettings)
			delete(rawMsg, key)
		case "softDeleteSettings":
			err = unpopulate(val, "SoftDeleteSettings", &s.SoftDeleteSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftDeleteSettings.
func (s SoftDeleteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "retentionDurationInDays", s.RetentionDurationInDays)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftDeleteSettings.
func (s *SoftDeleteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "retentionDurationInDays":
			err = unpopulate(val, "RetentionDurationInDays", &s.RetentionDurationInDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceLifeCycle.
func (s SourceLifeCycle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleteAfter", s.DeleteAfter)
	populate(objectMap, "sourceDataStore", s.SourceDataStore)
	populate(objectMap, "targetDataStoreCopySettings", s.TargetDataStoreCopySettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceLifeCycle.
func (s *SourceLifeCycle) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteAfter":
			s.DeleteAfter, err = unmarshalDeleteOptionClassification(val)
			delete(rawMsg, key)
		case "sourceDataStore":
			err = unpopulate(val, "SourceDataStore", &s.SourceDataStore)
			delete(rawMsg, key)
		case "targetDataStoreCopySettings":
			err = unpopulate(val, "TargetDataStoreCopySettings", &s.TargetDataStoreCopySettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageSetting.
func (s StorageSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datastoreType", s.DatastoreType)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageSetting.
func (s *StorageSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datastoreType":
			err = unpopulate(val, "DatastoreType", &s.DatastoreType)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedFeature.
func (s SupportedFeature) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exposureControlledFeatures", s.ExposureControlledFeatures)
	populate(objectMap, "featureName", s.FeatureName)
	populate(objectMap, "supportStatus", s.SupportStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedFeature.
func (s *SupportedFeature) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exposureControlledFeatures":
			err = unpopulate(val, "ExposureControlledFeatures", &s.ExposureControlledFeatures)
			delete(rawMsg, key)
		case "featureName":
			err = unpopulate(val, "FeatureName", &s.FeatureName)
			delete(rawMsg, key)
		case "supportStatus":
			err = unpopulate(val, "SupportStatus", &s.SupportStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncBackupInstanceRequest.
func (s SyncBackupInstanceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "syncType", s.SyncType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncBackupInstanceRequest.
func (s *SyncBackupInstanceRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "syncType":
			err = unpopulate(val, "SyncType", &s.SyncType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaggingCriteria.
func (t TaggingCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "criteria", t.Criteria)
	populate(objectMap, "isDefault", t.IsDefault)
	populate(objectMap, "tagInfo", t.TagInfo)
	populate(objectMap, "taggingPriority", t.TaggingPriority)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaggingCriteria.
func (t *TaggingCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "criteria":
			t.Criteria, err = unmarshalBackupCriteriaClassificationArray(val)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &t.IsDefault)
			delete(rawMsg, key)
		case "tagInfo":
			err = unpopulate(val, "TagInfo", &t.TagInfo)
			delete(rawMsg, key)
		case "taggingPriority":
			err = unpopulate(val, "TaggingPriority", &t.TaggingPriority)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetCopySetting.
func (t TargetCopySetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "copyAfter", t.CopyAfter)
	populate(objectMap, "dataStore", t.DataStore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetCopySetting.
func (t *TargetCopySetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyAfter":
			t.CopyAfter, err = unmarshalCopyOptionClassification(val)
			delete(rawMsg, key)
		case "dataStore":
			err = unpopulate(val, "DataStore", &t.DataStore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetDetails.
func (t TargetDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filePrefix", t.FilePrefix)
	populate(objectMap, "restoreTargetLocationType", t.RestoreTargetLocationType)
	populate(objectMap, "targetResourceArmId", t.TargetResourceArmID)
	populate(objectMap, "url", t.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetDetails.
func (t *TargetDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filePrefix":
			err = unpopulate(val, "FilePrefix", &t.FilePrefix)
			delete(rawMsg, key)
		case "restoreTargetLocationType":
			err = unpopulate(val, "RestoreTargetLocationType", &t.RestoreTargetLocationType)
			delete(rawMsg, key)
		case "targetResourceArmId":
			err = unpopulate(val, "TargetResourceArmID", &t.TargetResourceArmID)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &t.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggerBackupRequest.
func (t TriggerBackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupRuleOptions", t.BackupRuleOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggerBackupRequest.
func (t *TriggerBackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupRuleOptions":
			err = unpopulate(val, "BackupRuleOptions", &t.BackupRuleOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggerContext.
func (t TriggerContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["objectType"] = t.ObjectType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggerContext.
func (t *TriggerContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &t.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnlockDeleteRequest.
func (u UnlockDeleteRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceGuardOperationRequests", u.ResourceGuardOperationRequests)
	populate(objectMap, "resourceToBeDeleted", u.ResourceToBeDeleted)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnlockDeleteRequest.
func (u *UnlockDeleteRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceGuardOperationRequests":
			err = unpopulate(val, "ResourceGuardOperationRequests", &u.ResourceGuardOperationRequests)
			delete(rawMsg, key)
		case "resourceToBeDeleted":
			err = unpopulate(val, "ResourceToBeDeleted", &u.ResourceToBeDeleted)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnlockDeleteResponse.
func (u UnlockDeleteResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "unlockDeleteExpiryTime", u.UnlockDeleteExpiryTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnlockDeleteResponse.
func (u *UnlockDeleteResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "unlockDeleteExpiryTime":
			err = unpopulate(val, "UnlockDeleteExpiryTime", &u.UnlockDeleteExpiryTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserFacingError.
func (u UserFacingError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", u.Code)
	populate(objectMap, "details", u.Details)
	populate(objectMap, "innerError", u.InnerError)
	populate(objectMap, "isRetryable", u.IsRetryable)
	populate(objectMap, "isUserError", u.IsUserError)
	populate(objectMap, "message", u.Message)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "recommendedAction", u.RecommendedAction)
	populate(objectMap, "target", u.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserFacingError.
func (u *UserFacingError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &u.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &u.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &u.InnerError)
			delete(rawMsg, key)
		case "isRetryable":
			err = unpopulate(val, "IsRetryable", &u.IsRetryable)
			delete(rawMsg, key)
		case "isUserError":
			err = unpopulate(val, "IsUserError", &u.IsUserError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &u.Message)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &u.RecommendedAction)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &u.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserFacingWarningDetail.
func (u UserFacingWarningDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceName", u.ResourceName)
	populate(objectMap, "warning", u.Warning)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserFacingWarningDetail.
func (u *UserFacingWarningDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceName":
			err = unpopulate(val, "ResourceName", &u.ResourceName)
			delete(rawMsg, key)
		case "warning":
			err = unpopulate(val, "Warning", &u.Warning)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateCrossRegionRestoreRequestObject.
func (v ValidateCrossRegionRestoreRequestObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "crossRegionRestoreDetails", v.CrossRegionRestoreDetails)
	populate(objectMap, "restoreRequestObject", v.RestoreRequestObject)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateCrossRegionRestoreRequestObject.
func (v *ValidateCrossRegionRestoreRequestObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crossRegionRestoreDetails":
			err = unpopulate(val, "CrossRegionRestoreDetails", &v.CrossRegionRestoreDetails)
			delete(rawMsg, key)
		case "restoreRequestObject":
			v.RestoreRequestObject, err = unmarshalAzureBackupRestoreRequestClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateForBackupRequest.
func (v ValidateForBackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupInstance", v.BackupInstance)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateForBackupRequest.
func (v *ValidateForBackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupInstance":
			err = unpopulate(val, "BackupInstance", &v.BackupInstance)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateRestoreRequestObject.
func (v ValidateRestoreRequestObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "restoreRequestObject", v.RestoreRequestObject)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateRestoreRequestObject.
func (v *ValidateRestoreRequestObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "restoreRequestObject":
			v.RestoreRequestObject, err = unmarshalAzureBackupRestoreRequestClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
