//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
	"net/http"
	"net/url"
	"regexp"
)

// SynchronizationSettingsServer is a fake server for instances of the armdatashare.SynchronizationSettingsClient type.
type SynchronizationSettingsServer struct {
	// Create is the fake for method SynchronizationSettingsClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, accountName string, shareName string, synchronizationSettingName string, synchronizationSetting armdatashare.SynchronizationSettingClassification, options *armdatashare.SynchronizationSettingsClientCreateOptions) (resp azfake.Responder[armdatashare.SynchronizationSettingsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SynchronizationSettingsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, shareName string, synchronizationSettingName string, options *armdatashare.SynchronizationSettingsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdatashare.SynchronizationSettingsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SynchronizationSettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, shareName string, synchronizationSettingName string, options *armdatashare.SynchronizationSettingsClientGetOptions) (resp azfake.Responder[armdatashare.SynchronizationSettingsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySharePager is the fake for method SynchronizationSettingsClient.NewListBySharePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySharePager func(resourceGroupName string, accountName string, shareName string, options *armdatashare.SynchronizationSettingsClientListByShareOptions) (resp azfake.PagerResponder[armdatashare.SynchronizationSettingsClientListByShareResponse])
}

// NewSynchronizationSettingsServerTransport creates a new instance of SynchronizationSettingsServerTransport with the provided implementation.
// The returned SynchronizationSettingsServerTransport instance is connected to an instance of armdatashare.SynchronizationSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSynchronizationSettingsServerTransport(srv *SynchronizationSettingsServer) *SynchronizationSettingsServerTransport {
	return &SynchronizationSettingsServerTransport{
		srv:                 srv,
		beginDelete:         newTracker[azfake.PollerResponder[armdatashare.SynchronizationSettingsClientDeleteResponse]](),
		newListBySharePager: newTracker[azfake.PagerResponder[armdatashare.SynchronizationSettingsClientListByShareResponse]](),
	}
}

// SynchronizationSettingsServerTransport connects instances of armdatashare.SynchronizationSettingsClient to instances of SynchronizationSettingsServer.
// Don't use this type directly, use NewSynchronizationSettingsServerTransport instead.
type SynchronizationSettingsServerTransport struct {
	srv                 *SynchronizationSettingsServer
	beginDelete         *tracker[azfake.PollerResponder[armdatashare.SynchronizationSettingsClientDeleteResponse]]
	newListBySharePager *tracker[azfake.PagerResponder[armdatashare.SynchronizationSettingsClientListByShareResponse]]
}

// Do implements the policy.Transporter interface for SynchronizationSettingsServerTransport.
func (s *SynchronizationSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SynchronizationSettingsClient.Create":
		resp, err = s.dispatchCreate(req)
	case "SynchronizationSettingsClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SynchronizationSettingsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SynchronizationSettingsClient.NewListBySharePager":
		resp, err = s.dispatchNewListBySharePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SynchronizationSettingsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/synchronizationSettings/(?P<synchronizationSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalSynchronizationSettingClassification(raw)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	synchronizationSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("synchronizationSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, synchronizationSettingNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SynchronizationSettingClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SynchronizationSettingsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/synchronizationSettings/(?P<synchronizationSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		synchronizationSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("synchronizationSettingName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, synchronizationSettingNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SynchronizationSettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/synchronizationSettings/(?P<synchronizationSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	synchronizationSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("synchronizationSettingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, synchronizationSettingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SynchronizationSettingClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SynchronizationSettingsServerTransport) dispatchNewListBySharePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySharePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySharePager not implemented")}
	}
	newListBySharePager := s.newListBySharePager.get(req)
	if newListBySharePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/synchronizationSettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armdatashare.SynchronizationSettingsClientListByShareOptions
		if skipTokenParam != nil {
			options = &armdatashare.SynchronizationSettingsClientListByShareOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := s.srv.NewListBySharePager(resourceGroupNameParam, accountNameParam, shareNameParam, options)
		newListBySharePager = &resp
		s.newListBySharePager.add(req, newListBySharePager)
		server.PagerResponderInjectNextLinks(newListBySharePager, req, func(page *armdatashare.SynchronizationSettingsClientListByShareResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySharePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySharePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySharePager) {
		s.newListBySharePager.remove(req)
	}
	return resp, nil
}
