//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatashare

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ProviderShareSubscriptionsClient contains the methods for the ProviderShareSubscriptions group.
// Don't use this type directly, use NewProviderShareSubscriptionsClient() instead.
type ProviderShareSubscriptionsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewProviderShareSubscriptionsClient creates a new instance of ProviderShareSubscriptionsClient with the specified values.
//   - subscriptionID - The subscription identifier
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewProviderShareSubscriptionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ProviderShareSubscriptionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ProviderShareSubscriptionsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Adjust - Adjust a share subscription's expiration date in a provider share
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-09-01
//   - resourceGroupName - The resource group name.
//   - accountName - The name of the share account.
//   - shareName - The name of the share.
//   - providerShareSubscriptionID - To locate shareSubscription
//   - providerShareSubscription - The provider share subscription
//   - options - ProviderShareSubscriptionsClientAdjustOptions contains the optional parameters for the ProviderShareSubscriptionsClient.Adjust
//     method.
func (client *ProviderShareSubscriptionsClient) Adjust(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, providerShareSubscription ProviderShareSubscription, options *ProviderShareSubscriptionsClientAdjustOptions) (ProviderShareSubscriptionsClientAdjustResponse, error) {
	var err error
	const operationName = "ProviderShareSubscriptionsClient.Adjust"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.adjustCreateRequest(ctx, resourceGroupName, accountName, shareName, providerShareSubscriptionID, providerShareSubscription, options)
	if err != nil {
		return ProviderShareSubscriptionsClientAdjustResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ProviderShareSubscriptionsClientAdjustResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ProviderShareSubscriptionsClientAdjustResponse{}, err
	}
	resp, err := client.adjustHandleResponse(httpResp)
	return resp, err
}

// adjustCreateRequest creates the Adjust request.
func (client *ProviderShareSubscriptionsClient) adjustCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, providerShareSubscription ProviderShareSubscription, options *ProviderShareSubscriptionsClientAdjustOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/adjust"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if providerShareSubscriptionID == "" {
		return nil, errors.New("parameter providerShareSubscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerShareSubscriptionId}", url.PathEscape(providerShareSubscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, providerShareSubscription); err != nil {
		return nil, err
	}
	return req, nil
}

// adjustHandleResponse handles the Adjust response.
func (client *ProviderShareSubscriptionsClient) adjustHandleResponse(resp *http.Response) (ProviderShareSubscriptionsClientAdjustResponse, error) {
	result := ProviderShareSubscriptionsClientAdjustResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProviderShareSubscription); err != nil {
		return ProviderShareSubscriptionsClientAdjustResponse{}, err
	}
	return result, nil
}

// GetByShare - Get share subscription in a provider share
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-09-01
//   - resourceGroupName - The resource group name.
//   - accountName - The name of the share account.
//   - shareName - The name of the share.
//   - providerShareSubscriptionID - To locate shareSubscription
//   - options - ProviderShareSubscriptionsClientGetByShareOptions contains the optional parameters for the ProviderShareSubscriptionsClient.GetByShare
//     method.
func (client *ProviderShareSubscriptionsClient) GetByShare(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, options *ProviderShareSubscriptionsClientGetByShareOptions) (ProviderShareSubscriptionsClientGetByShareResponse, error) {
	var err error
	const operationName = "ProviderShareSubscriptionsClient.GetByShare"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getByShareCreateRequest(ctx, resourceGroupName, accountName, shareName, providerShareSubscriptionID, options)
	if err != nil {
		return ProviderShareSubscriptionsClientGetByShareResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ProviderShareSubscriptionsClientGetByShareResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ProviderShareSubscriptionsClientGetByShareResponse{}, err
	}
	resp, err := client.getByShareHandleResponse(httpResp)
	return resp, err
}

// getByShareCreateRequest creates the GetByShare request.
func (client *ProviderShareSubscriptionsClient) getByShareCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, options *ProviderShareSubscriptionsClientGetByShareOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if providerShareSubscriptionID == "" {
		return nil, errors.New("parameter providerShareSubscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerShareSubscriptionId}", url.PathEscape(providerShareSubscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getByShareHandleResponse handles the GetByShare response.
func (client *ProviderShareSubscriptionsClient) getByShareHandleResponse(resp *http.Response) (ProviderShareSubscriptionsClientGetByShareResponse, error) {
	result := ProviderShareSubscriptionsClientGetByShareResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProviderShareSubscription); err != nil {
		return ProviderShareSubscriptionsClientGetByShareResponse{}, err
	}
	return result, nil
}

// NewListBySharePager - List share subscriptions in a provider share
//
// Generated from API version 2020-09-01
//   - resourceGroupName - The resource group name.
//   - accountName - The name of the share account.
//   - shareName - The name of the share.
//   - options - ProviderShareSubscriptionsClientListByShareOptions contains the optional parameters for the ProviderShareSubscriptionsClient.NewListBySharePager
//     method.
func (client *ProviderShareSubscriptionsClient) NewListBySharePager(resourceGroupName string, accountName string, shareName string, options *ProviderShareSubscriptionsClientListByShareOptions) *runtime.Pager[ProviderShareSubscriptionsClientListByShareResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderShareSubscriptionsClientListByShareResponse]{
		More: func(page ProviderShareSubscriptionsClientListByShareResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderShareSubscriptionsClientListByShareResponse) (ProviderShareSubscriptionsClientListByShareResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderShareSubscriptionsClient.NewListBySharePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByShareCreateRequest(ctx, resourceGroupName, accountName, shareName, options)
			}, nil)
			if err != nil {
				return ProviderShareSubscriptionsClientListByShareResponse{}, err
			}
			return client.listByShareHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByShareCreateRequest creates the ListByShare request.
func (client *ProviderShareSubscriptionsClient) listByShareCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareName string, options *ProviderShareSubscriptionsClientListByShareOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByShareHandleResponse handles the ListByShare response.
func (client *ProviderShareSubscriptionsClient) listByShareHandleResponse(resp *http.Response) (ProviderShareSubscriptionsClientListByShareResponse, error) {
	result := ProviderShareSubscriptionsClientListByShareResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProviderShareSubscriptionList); err != nil {
		return ProviderShareSubscriptionsClientListByShareResponse{}, err
	}
	return result, nil
}

// Reinstate - Reinstate share subscription in a provider share
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-09-01
//   - resourceGroupName - The resource group name.
//   - accountName - The name of the share account.
//   - shareName - The name of the share.
//   - providerShareSubscriptionID - To locate shareSubscription
//   - providerShareSubscription - The provider share subscription
//   - options - ProviderShareSubscriptionsClientReinstateOptions contains the optional parameters for the ProviderShareSubscriptionsClient.Reinstate
//     method.
func (client *ProviderShareSubscriptionsClient) Reinstate(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, providerShareSubscription ProviderShareSubscription, options *ProviderShareSubscriptionsClientReinstateOptions) (ProviderShareSubscriptionsClientReinstateResponse, error) {
	var err error
	const operationName = "ProviderShareSubscriptionsClient.Reinstate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.reinstateCreateRequest(ctx, resourceGroupName, accountName, shareName, providerShareSubscriptionID, providerShareSubscription, options)
	if err != nil {
		return ProviderShareSubscriptionsClientReinstateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ProviderShareSubscriptionsClientReinstateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ProviderShareSubscriptionsClientReinstateResponse{}, err
	}
	resp, err := client.reinstateHandleResponse(httpResp)
	return resp, err
}

// reinstateCreateRequest creates the Reinstate request.
func (client *ProviderShareSubscriptionsClient) reinstateCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, providerShareSubscription ProviderShareSubscription, options *ProviderShareSubscriptionsClientReinstateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/reinstate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if providerShareSubscriptionID == "" {
		return nil, errors.New("parameter providerShareSubscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerShareSubscriptionId}", url.PathEscape(providerShareSubscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, providerShareSubscription); err != nil {
		return nil, err
	}
	return req, nil
}

// reinstateHandleResponse handles the Reinstate response.
func (client *ProviderShareSubscriptionsClient) reinstateHandleResponse(resp *http.Response) (ProviderShareSubscriptionsClientReinstateResponse, error) {
	result := ProviderShareSubscriptionsClientReinstateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProviderShareSubscription); err != nil {
		return ProviderShareSubscriptionsClientReinstateResponse{}, err
	}
	return result, nil
}

// BeginRevoke - Revoke share subscription in a provider share
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-09-01
//   - resourceGroupName - The resource group name.
//   - accountName - The name of the share account.
//   - shareName - The name of the share.
//   - providerShareSubscriptionID - To locate shareSubscription
//   - options - ProviderShareSubscriptionsClientBeginRevokeOptions contains the optional parameters for the ProviderShareSubscriptionsClient.BeginRevoke
//     method.
func (client *ProviderShareSubscriptionsClient) BeginRevoke(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, options *ProviderShareSubscriptionsClientBeginRevokeOptions) (*runtime.Poller[ProviderShareSubscriptionsClientRevokeResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.revoke(ctx, resourceGroupName, accountName, shareName, providerShareSubscriptionID, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ProviderShareSubscriptionsClientRevokeResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ProviderShareSubscriptionsClientRevokeResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Revoke - Revoke share subscription in a provider share
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-09-01
func (client *ProviderShareSubscriptionsClient) revoke(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, options *ProviderShareSubscriptionsClientBeginRevokeOptions) (*http.Response, error) {
	var err error
	const operationName = "ProviderShareSubscriptionsClient.BeginRevoke"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.revokeCreateRequest(ctx, resourceGroupName, accountName, shareName, providerShareSubscriptionID, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// revokeCreateRequest creates the Revoke request.
func (client *ProviderShareSubscriptionsClient) revokeCreateRequest(ctx context.Context, resourceGroupName string, accountName string, shareName string, providerShareSubscriptionID string, options *ProviderShareSubscriptionsClientBeginRevokeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/revoke"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if providerShareSubscriptionID == "" {
		return nil, errors.New("parameter providerShareSubscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerShareSubscriptionId}", url.PathEscape(providerShareSubscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
