//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdeploymentmanager_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/deploymentmanager/armdeploymentmanager"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/deploymentmanager/resource-manager/Microsoft.DeploymentManager/preview/2019-11-01-preview/examples/step_health_check_createorupdate.json
func ExampleStepsClient_CreateOrUpdate_createHealthCheckStep() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewStepsClient().CreateOrUpdate(ctx, "myResourceGroup", "healthCheckStep", &armdeploymentmanager.StepsClientCreateOrUpdateOptions{StepInfo: &armdeploymentmanager.StepResource{
		Location: to.Ptr("centralus"),
		Tags:     map[string]*string{},
		Properties: &armdeploymentmanager.HealthCheckStepProperties{
			StepType: to.Ptr(armdeploymentmanager.StepTypeHealthCheck),
			Attributes: &armdeploymentmanager.RestHealthCheckStepAttributes{
				Type:                 to.Ptr("REST"),
				HealthyStateDuration: to.Ptr("PT2H"),
				MaxElasticDuration:   to.Ptr("PT30M"),
				WaitDuration:         to.Ptr("PT15M"),
				Properties: &armdeploymentmanager.RestParameters{
					HealthChecks: []*armdeploymentmanager.RestHealthCheck{
						{
							Name: to.Ptr("appHealth"),
							Response: &armdeploymentmanager.RestResponse{
								Regex: &armdeploymentmanager.RestResponseRegex{
									MatchQuantifier: to.Ptr(armdeploymentmanager.RestMatchQuantifierAll),
									Matches: []*string{
										to.Ptr("(?i)Contoso-App"),
										to.Ptr("(?i)\"health_status\":((.|\n)*)\"(green|yellow)\""),
										to.Ptr("(?mi)^(\"application_host\": 94781052)$")},
								},
								SuccessStatusCodes: []*string{
									to.Ptr("OK")},
							},
							Request: &armdeploymentmanager.RestRequest{
								Method: to.Ptr(armdeploymentmanager.RestRequestMethodGET),
								Authentication: &armdeploymentmanager.APIKeyAuthentication{
									Type:  to.Ptr(armdeploymentmanager.RestAuthTypeAPIKey),
									Name:  to.Ptr("Code"),
									In:    to.Ptr(armdeploymentmanager.RestAuthLocationQuery),
									Value: to.Ptr("NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg=="),
								},
								URI: to.Ptr("https://resthealth.healthservice.com/api/applications/contosoApp/healthStatus"),
							},
						},
						{
							Name: to.Ptr("serviceHealth"),
							Response: &armdeploymentmanager.RestResponse{
								Regex: &armdeploymentmanager.RestResponseRegex{
									MatchQuantifier: to.Ptr(armdeploymentmanager.RestMatchQuantifierAll),
									Matches: []*string{
										to.Ptr("(?i)Contoso-Service-EndToEnd"),
										to.Ptr("(?i)\"health_status\":((.|\n)*)\"(green)\"")},
								},
								SuccessStatusCodes: []*string{
									to.Ptr("OK")},
							},
							Request: &armdeploymentmanager.RestRequest{
								Method: to.Ptr(armdeploymentmanager.RestRequestMethodGET),
								Authentication: &armdeploymentmanager.APIKeyAuthentication{
									Type:  to.Ptr(armdeploymentmanager.RestAuthTypeAPIKey),
									Name:  to.Ptr("code"),
									In:    to.Ptr(armdeploymentmanager.RestAuthLocationHeader),
									Value: to.Ptr("NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg=="),
								},
								URI: to.Ptr("https://resthealth.healthservice.com/api/services/contosoService/healthStatus"),
							},
						}},
				},
			},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/deploymentmanager/resource-manager/Microsoft.DeploymentManager/preview/2019-11-01-preview/examples/step_wait_createorupdate.json
func ExampleStepsClient_CreateOrUpdate_createWaitStep() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewStepsClient().CreateOrUpdate(ctx, "myResourceGroup", "waitStep", &armdeploymentmanager.StepsClientCreateOrUpdateOptions{StepInfo: &armdeploymentmanager.StepResource{
		Location: to.Ptr("centralus"),
		Tags:     map[string]*string{},
		Properties: &armdeploymentmanager.WaitStepProperties{
			StepType: to.Ptr(armdeploymentmanager.StepTypeWait),
			Attributes: &armdeploymentmanager.WaitStepAttributes{
				Duration: to.Ptr("PT20M"),
			},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/deploymentmanager/resource-manager/Microsoft.DeploymentManager/preview/2019-11-01-preview/examples/step_get.json
func ExampleStepsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStepsClient().Get(ctx, "myResourceGroup", "waitStep", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StepResource = armdeploymentmanager.StepResource{
	// 	Name: to.Ptr("deploymentStep1"),
	// 	Type: to.Ptr("Microsoft.DeploymentManager/steps"),
	// 	Location: to.Ptr("centralus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armdeploymentmanager.WaitStepProperties{
	// 		StepType: to.Ptr(armdeploymentmanager.StepTypeWait),
	// 		Attributes: &armdeploymentmanager.WaitStepAttributes{
	// 			Duration: to.Ptr("PT20M"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/deploymentmanager/resource-manager/Microsoft.DeploymentManager/preview/2019-11-01-preview/examples/step_delete.json
func ExampleStepsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewStepsClient().Delete(ctx, "myResourceGroup", "deploymentStep1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/deploymentmanager/resource-manager/Microsoft.DeploymentManager/preview/2019-11-01-preview/examples/steps_list.json
func ExampleStepsClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStepsClient().List(ctx, "myResourceGroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StepResourceArray = []*armdeploymentmanager.StepResource{
	// 	{
	// 		Name: to.Ptr("waitStepfrontEnd"),
	// 		Type: to.Ptr("Microsoft.DeploymentManager/steps"),
	// 		Location: to.Ptr("centralus"),
	// 		Tags: map[string]*string{
	// 		},
	// 		Properties: &armdeploymentmanager.WaitStepProperties{
	// 			StepType: to.Ptr(armdeploymentmanager.StepTypeWait),
	// 			Attributes: &armdeploymentmanager.WaitStepAttributes{
	// 				Duration: to.Ptr("PT10M"),
	// 			},
	// 		},
	// 	},
	// 	{
	// 		Name: to.Ptr("waitStepBackEnd"),
	// 		Type: to.Ptr("Microsoft.DeploymentManager/steps"),
	// 		Location: to.Ptr("centralus"),
	// 		Tags: map[string]*string{
	// 		},
	// 		Properties: &armdeploymentmanager.WaitStepProperties{
	// 			StepType: to.Ptr(armdeploymentmanager.StepTypeWait),
	// 			Attributes: &armdeploymentmanager.WaitStepAttributes{
	// 				Duration: to.Ptr("PT30M"),
	// 			},
	// 		},
	// }}
}
