//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevhub

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devhub/armdevhub"
	moduleVersion = "v0.5.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AuthorizationStatus - Determines the authorization status of requests.
type AuthorizationStatus string

const (
	// AuthorizationStatusAuthorized - Requests authorized successfully
	AuthorizationStatusAuthorized AuthorizationStatus = "Authorized"
	// AuthorizationStatusError - Requests returned other error response
	AuthorizationStatusError AuthorizationStatus = "Error"
	// AuthorizationStatusNotFound - Requests returned NotFound response
	AuthorizationStatusNotFound AuthorizationStatus = "NotFound"
)

// PossibleAuthorizationStatusValues returns the possible values for the AuthorizationStatus const type.
func PossibleAuthorizationStatusValues() []AuthorizationStatus {
	return []AuthorizationStatus{
		AuthorizationStatusAuthorized,
		AuthorizationStatusError,
		AuthorizationStatusNotFound,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DockerfileGenerationMode - The mode of generation to be used for generating Dockerfiles.
type DockerfileGenerationMode string

const (
	// DockerfileGenerationModeDisabled - Dockerfiles will not be generated
	DockerfileGenerationModeDisabled DockerfileGenerationMode = "disabled"
	// DockerfileGenerationModeEnabled - Dockerfiles will be generated
	DockerfileGenerationModeEnabled DockerfileGenerationMode = "enabled"
)

// PossibleDockerfileGenerationModeValues returns the possible values for the DockerfileGenerationMode const type.
func PossibleDockerfileGenerationModeValues() []DockerfileGenerationMode {
	return []DockerfileGenerationMode{
		DockerfileGenerationModeDisabled,
		DockerfileGenerationModeEnabled,
	}
}

// GenerationLanguage - The programming language used.
type GenerationLanguage string

const (
	// GenerationLanguageClojure - clojure language
	GenerationLanguageClojure GenerationLanguage = "clojure"
	// GenerationLanguageCsharp - csharp language
	GenerationLanguageCsharp GenerationLanguage = "csharp"
	// GenerationLanguageErlang - erlang language
	GenerationLanguageErlang GenerationLanguage = "erlang"
	// GenerationLanguageGo - go language
	GenerationLanguageGo GenerationLanguage = "go"
	// GenerationLanguageGomodule - gomodule language
	GenerationLanguageGomodule GenerationLanguage = "gomodule"
	// GenerationLanguageGradle - gradle language
	GenerationLanguageGradle GenerationLanguage = "gradle"
	// GenerationLanguageJava - java language
	GenerationLanguageJava GenerationLanguage = "java"
	// GenerationLanguageJavascript - javascript language
	GenerationLanguageJavascript GenerationLanguage = "javascript"
	// GenerationLanguagePhp - php language
	GenerationLanguagePhp GenerationLanguage = "php"
	// GenerationLanguagePython - python language
	GenerationLanguagePython GenerationLanguage = "python"
	// GenerationLanguageRuby - ruby language
	GenerationLanguageRuby GenerationLanguage = "ruby"
	// GenerationLanguageRust - rust language
	GenerationLanguageRust GenerationLanguage = "rust"
	// GenerationLanguageSwift - swift language
	GenerationLanguageSwift GenerationLanguage = "swift"
)

// PossibleGenerationLanguageValues returns the possible values for the GenerationLanguage const type.
func PossibleGenerationLanguageValues() []GenerationLanguage {
	return []GenerationLanguage{
		GenerationLanguageClojure,
		GenerationLanguageCsharp,
		GenerationLanguageErlang,
		GenerationLanguageGo,
		GenerationLanguageGomodule,
		GenerationLanguageGradle,
		GenerationLanguageJava,
		GenerationLanguageJavascript,
		GenerationLanguagePhp,
		GenerationLanguagePython,
		GenerationLanguageRuby,
		GenerationLanguageRust,
		GenerationLanguageSwift,
	}
}

// GenerationManifestType - Determines the type of manifests to be generated.
type GenerationManifestType string

const (
	// GenerationManifestTypeHelm - Helm manifests
	GenerationManifestTypeHelm GenerationManifestType = "helm"
	// GenerationManifestTypeKube - Kubernetes manifests
	GenerationManifestTypeKube GenerationManifestType = "kube"
)

// PossibleGenerationManifestTypeValues returns the possible values for the GenerationManifestType const type.
func PossibleGenerationManifestTypeValues() []GenerationManifestType {
	return []GenerationManifestType{
		GenerationManifestTypeHelm,
		GenerationManifestTypeKube,
	}
}

// ManifestGenerationMode - The mode of generation to be used for generating Manifest.
type ManifestGenerationMode string

const (
	// ManifestGenerationModeDisabled - Manifests will not be generated
	ManifestGenerationModeDisabled ManifestGenerationMode = "disabled"
	// ManifestGenerationModeEnabled - Manifests will be generated
	ManifestGenerationModeEnabled ManifestGenerationMode = "enabled"
)

// PossibleManifestGenerationModeValues returns the possible values for the ManifestGenerationMode const type.
func PossibleManifestGenerationModeValues() []ManifestGenerationMode {
	return []ManifestGenerationMode{
		ManifestGenerationModeDisabled,
		ManifestGenerationModeEnabled,
	}
}

// ManifestType - Determines the type of manifests within the repository.
type ManifestType string

const (
	// ManifestTypeHelm - Repositories using helm
	ManifestTypeHelm ManifestType = "helm"
	// ManifestTypeKube - Repositories using kubernetes manifests
	ManifestTypeKube ManifestType = "kube"
)

// PossibleManifestTypeValues returns the possible values for the ManifestType const type.
func PossibleManifestTypeValues() []ManifestType {
	return []ManifestType{
		ManifestTypeHelm,
		ManifestTypeKube,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// PullRequestStatus - The status of the Pull Request submitted against the users repository.
type PullRequestStatus string

const (
	// PullRequestStatusMerged - Pull Request merged into repository.
	PullRequestStatusMerged PullRequestStatus = "merged"
	// PullRequestStatusRemoved - Workflow no longer found within repository.
	PullRequestStatusRemoved PullRequestStatus = "removed"
	// PullRequestStatusSubmitted - Pull Request submitted to repository.
	PullRequestStatusSubmitted PullRequestStatus = "submitted"
	// PullRequestStatusUnknown - Pull Request state unknown.
	PullRequestStatusUnknown PullRequestStatus = "unknown"
)

// PossiblePullRequestStatusValues returns the possible values for the PullRequestStatus const type.
func PossiblePullRequestStatusValues() []PullRequestStatus {
	return []PullRequestStatus{
		PullRequestStatusMerged,
		PullRequestStatusRemoved,
		PullRequestStatusSubmitted,
		PullRequestStatusUnknown,
	}
}

// WorkflowRunStatus - Describes the status of the workflow run
type WorkflowRunStatus string

const (
	// WorkflowRunStatusCompleted - Workflow run is completed
	WorkflowRunStatusCompleted WorkflowRunStatus = "completed"
	// WorkflowRunStatusInprogress - Workflow run is inprogress
	WorkflowRunStatusInprogress WorkflowRunStatus = "inprogress"
	// WorkflowRunStatusQueued - Workflow run is queued
	WorkflowRunStatusQueued WorkflowRunStatus = "queued"
)

// PossibleWorkflowRunStatusValues returns the possible values for the WorkflowRunStatus const type.
func PossibleWorkflowRunStatusValues() []WorkflowRunStatus {
	return []WorkflowRunStatus{
		WorkflowRunStatusCompleted,
		WorkflowRunStatusInprogress,
		WorkflowRunStatusQueued,
	}
}
