//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevtestlabs_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devtestlabs/armdevtestlabs"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/GalleryImages_List.json
func ExampleGalleryImagesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewGalleryImagesClient().NewListPager("resourceGroupName", "{labName}", &armdevtestlabs.GalleryImagesClientListOptions{Expand: nil,
		Filter:  nil,
		Top:     nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.GalleryImageList = armdevtestlabs.GalleryImageList{
		// 	Value: []*armdevtestlabs.GalleryImage{
		// 		{
		// 			Name: to.Ptr("Ubuntu Server 20.04 LTS"),
		// 			Type: to.Ptr("Microsoft.DevTestLab/labs/galleryImages"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/galleryimages/ubuntu server 20.04 lts"),
		// 			Location: to.Ptr("{location}"),
		// 			Tags: map[string]*string{
		// 				"tagName1": to.Ptr("tagValue1"),
		// 			},
		// 			Properties: &armdevtestlabs.GalleryImageProperties{
		// 				Description: to.Ptr("Ubuntu Server is the world's most popular Linux for cloud environments. Updates and patches for Ubuntu Server 20.04 LTS will be available until April 2025. Ubuntu Server is the perfect virtual machine (VM) platform for all workloads from web applications to NoSQL databases and Hadoop. For more information see <a href='https://ubuntu.com/azure' target='_blank'>Ubuntu on Azure</a> and <a href='http://juju.ubuntu.com' target='_blank'>using Juju to deploy your workloads</a>.<p><h3 class='msportalfx-text-header'>Legal Terms</h3></p><p>By clicking the Create button, I acknowledge that I am getting this software from Canonical and that the <a href='http://www.ubuntu.com/project/about-ubuntu/licensing' target='_blank'>legal terms</a> of Canonical apply to it. Microsoft does not provide rights for third-party software. Also see the <a href='http://www.ubuntu.com/aboutus/privacypolicy' target='_blank'>privacy statement</a> from Canonical.</p>"),
		// 				Author: to.Ptr("Canonical"),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-14T23:43:43.764Z"); return t}()),
		// 				Enabled: to.Ptr(true),
		// 				Icon: to.Ptr("https://106c4.wpc.azureedge.net/80106C4/Gallery-Prod/cdn/2015-02-24/prod20161101-microsoft-windowsazure-gallery/canonical.0001-com-ubuntu-server-focal20_04-lts-ARM.1.0.22/Icons/Small.png"),
		// 				ImageReference: &armdevtestlabs.GalleryImageReference{
		// 					Offer: to.Ptr("0001-com-ubuntu-server-focal"),
		// 					OSType: to.Ptr("Linux"),
		// 					Publisher: to.Ptr("canonical"),
		// 					SKU: to.Ptr("20_04-lts"),
		// 					Version: to.Ptr("latest"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Windows 10 Enterprise, Version 20H2"),
		// 			Type: to.Ptr("Microsoft.DevTestLab/labs/galleryImages"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/galleryimages/windows 10 enterprise, version 20h2"),
		// 			Location: to.Ptr("{location}"),
		// 			Tags: map[string]*string{
		// 				"tagName1": to.Ptr("tagValue1"),
		// 			},
		// 			Properties: &armdevtestlabs.GalleryImageProperties{
		// 				Description: to.Ptr("<p>This software is provided by Microsoft. Use of this software in Microsoft Azure is not permitted except under a volume licensing agreement with Microsoft. By clicking Create, I acknowledge that I or the company I work for is licensed to use this software under a volume licensing agreement with Microsoft and that the right to use it will be subject to that agreement.</p> <p><h3 class='msportalfx-text-header'>Legal Terms</h3></p><p>By clicking the Create button, I acknowledge that I am getting this software from Microsoft and that the <a href='https://www.microsoft.com/en-us/Useterms/Retail/Windows/10/UseTerms_Retail_Windows_10_English.htm' target='_blank'>legal terms</a> of Microsoft apply to it. Microsoft does not provide rights for third-party software. Also see the <a href='https://go.microsoft.com/fwlink/?LinkId=529552' target='_blank'>privacy statement</a> from Microsoft.</p>"),
		// 				Author: to.Ptr("Microsoft"),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-14T21:33:33.246Z"); return t}()),
		// 				Enabled: to.Ptr(true),
		// 				Icon: to.Ptr("https://106c4.wpc.azureedge.net/80106C4/Gallery-Prod/cdn/2015-02-24/prod20161101-microsoft-windowsazure-gallery/microsoftwindowsdesktop.windows-1020h2-ent.1.0.238/Icons/Small.png"),
		// 				ImageReference: &armdevtestlabs.GalleryImageReference{
		// 					Offer: to.Ptr("Windows-10"),
		// 					OSType: to.Ptr("Windows"),
		// 					Publisher: to.Ptr("MicrosoftWindowsDesktop"),
		// 					SKU: to.Ptr("20h2-ent"),
		// 					Version: to.Ptr("latest"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}
