//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdigitaltwins_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/digitaltwins/armdigitaltwins"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointsGet_example.json
func ExampleEndpointClient_NewListPager_getADigitalTwinsInstanceEndpoints() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEndpointClient().NewListPager("resRg", "myDigitalTwinsService", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EndpointResourceListResult = armdigitaltwins.EndpointResourceListResult{
		// 	Value: []*armdigitaltwins.EndpointResource{
		// 		{
		// 			Name: to.Ptr("myendpoint1"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
		// 			SystemData: &armdigitaltwins.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@example.com"),
		// 				CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@example.com"),
		// 				LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdigitaltwins.ServiceBus{
		// 				AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeKeyBased),
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
		// 				EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
		// 				PrimaryConnectionString: to.Ptr("Endpoint=sb://***/;SharedAccessKeyName=***;SharedAccessKey=***;EntityPath=***"),
		// 				SecondaryConnectionString: to.Ptr("Endpoint=sb://***/;SharedAccessKeyName=***;SharedAccessKey=***;EntityPath=***"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myendpoint2"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
		// 			SystemData: &armdigitaltwins.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@example.com"),
		// 				CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@example.com"),
		// 				LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdigitaltwins.EventHub{
		// 				AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeKeyBased),
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
		// 				EndpointType: to.Ptr(armdigitaltwins.EndpointTypeEventHub),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
		// 				ConnectionStringPrimaryKey: to.Ptr("************"),
		// 				ConnectionStringSecondaryKey: to.Ptr("************"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointsGet_WithIdentity_example.json
func ExampleEndpointClient_NewListPager_getADigitalTwinsInstanceEndpointsWithIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEndpointClient().NewListPager("resRg", "myDigitalTwinsService", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EndpointResourceListResult = armdigitaltwins.EndpointResourceListResult{
		// 	Value: []*armdigitaltwins.EndpointResource{
		// 		{
		// 			Name: to.Ptr("myServiceBus"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
		// 			SystemData: &armdigitaltwins.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@example.com"),
		// 				CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@example.com"),
		// 				LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdigitaltwins.ServiceBus{
		// 				AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeIdentityBased),
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
		// 				EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
		// 				EndpointURI: to.Ptr("sb://mysb.servicebus.windows.net/"),
		// 				EntityPath: to.Ptr("mysbtopic"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myServiceBus"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
		// 			SystemData: &armdigitaltwins.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@example.com"),
		// 				CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@example.com"),
		// 				LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdigitaltwins.EventHub{
		// 				AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeKeyBased),
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
		// 				EndpointType: to.Ptr(armdigitaltwins.EndpointTypeEventHub),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
		// 				ConnectionStringPrimaryKey: to.Ptr("************"),
		// 				ConnectionStringSecondaryKey: to.Ptr("************"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointGet_example.json
func ExampleEndpointClient_Get_getADigitalTwinsInstanceEndpoint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEndpointClient().Get(ctx, "resRg", "myDigitalTwinsService", "myServiceBus", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EndpointResource = armdigitaltwins.EndpointResource{
	// 	Name: to.Ptr("myServiceBus"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.ServiceBus{
	// 		AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeKeyBased),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
	// 		EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
	// 		PrimaryConnectionString: to.Ptr("Endpoint=sb://***/;SharedAccessKeyName=***;SharedAccessKey=***;EntityPath=***"),
	// 		SecondaryConnectionString: to.Ptr("Endpoint=sb://***/;SharedAccessKeyName=***;SharedAccessKey=***;EntityPath=***"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointGet_WithIdentity_example.json
func ExampleEndpointClient_Get_getADigitalTwinsInstanceEndpointWithIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEndpointClient().Get(ctx, "resRg", "myDigitalTwinsService", "myServiceBus", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EndpointResource = armdigitaltwins.EndpointResource{
	// 	Name: to.Ptr("myServiceBus"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.ServiceBus{
	// 		AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeIdentityBased),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
	// 		EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
	// 		EndpointURI: to.Ptr("sb://mysb.servicebus.windows.net/"),
	// 		EntityPath: to.Ptr("mysbtopic"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointPut_example.json
func ExampleEndpointClient_BeginCreateOrUpdate_putADigitalTwinsEndpointResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointClient().BeginCreateOrUpdate(ctx, "resRg", "myDigitalTwinsService", "myServiceBus", armdigitaltwins.EndpointResource{
		Properties: &armdigitaltwins.ServiceBus{
			AuthenticationType:        to.Ptr(armdigitaltwins.AuthenticationTypeKeyBased),
			EndpointType:              to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
			PrimaryConnectionString:   to.Ptr("Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc"),
			SecondaryConnectionString: to.Ptr("Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EndpointResource = armdigitaltwins.EndpointResource{
	// 	Name: to.Ptr("myServiceBus"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.ServiceBus{
	// 		AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeKeyBased),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
	// 		EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
	// 		PrimaryConnectionString: to.Ptr("Endpoint=sb://***/;SharedAccessKeyName=***;SharedAccessKey=***;EntityPath=***"),
	// 		SecondaryConnectionString: to.Ptr("Endpoint=sb://***/;SharedAccessKeyName=***;SharedAccessKey=***;EntityPath=***"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointPut_WithIdentity_example.json
func ExampleEndpointClient_BeginCreateOrUpdate_putADigitalTwinsEndpointResourceWithIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointClient().BeginCreateOrUpdate(ctx, "resRg", "myDigitalTwinsService", "myServiceBus", armdigitaltwins.EndpointResource{
		Properties: &armdigitaltwins.ServiceBus{
			AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeIdentityBased),
			EndpointType:       to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
			EndpointURI:        to.Ptr("sb://mysb.servicebus.windows.net/"),
			EntityPath:         to.Ptr("mysbtopic"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EndpointResource = armdigitaltwins.EndpointResource{
	// 	Name: to.Ptr("myServiceBus"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.ServiceBus{
	// 		AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeIdentityBased),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
	// 		EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
	// 		EndpointURI: to.Ptr("sb://mysb.servicebus.windows.net/"),
	// 		EntityPath: to.Ptr("mysbtopic"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointPut_WithUserIdentity_example.json
func ExampleEndpointClient_BeginCreateOrUpdate_putADigitalTwinsEndpointResourceWithUserAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointClient().BeginCreateOrUpdate(ctx, "resRg", "myDigitalTwinsService", "myServiceBus", armdigitaltwins.EndpointResource{
		Properties: &armdigitaltwins.ServiceBus{
			AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeIdentityBased),
			EndpointType:       to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
			Identity: &armdigitaltwins.ManagedIdentityReference{
				Type:                 to.Ptr(armdigitaltwins.IdentityTypeUserAssigned),
				UserAssignedIdentity: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity"),
			},
			EndpointURI: to.Ptr("sb://mysb.servicebus.windows.net/"),
			EntityPath:  to.Ptr("mysbtopic"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EndpointResource = armdigitaltwins.EndpointResource{
	// 	Name: to.Ptr("myServiceBus"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.ServiceBus{
	// 		AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeIdentityBased),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
	// 		EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
	// 		Identity: &armdigitaltwins.ManagedIdentityReference{
	// 			Type: to.Ptr(armdigitaltwins.IdentityTypeUserAssigned),
	// 			UserAssignedIdentity: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity"),
	// 		},
	// 		ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
	// 		EndpointURI: to.Ptr("sb://mysb.servicebus.windows.net/"),
	// 		EntityPath: to.Ptr("mysbtopic"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointDelete_example.json
func ExampleEndpointClient_BeginDelete_deleteADigitalTwinsInstanceEndpoint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointClient().BeginDelete(ctx, "resRg", "myDigitalTwinsService", "myendpoint", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EndpointResource = armdigitaltwins.EndpointResource{
	// 	Name: to.Ptr("myendpoint"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.ServiceBus{
	// 		AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeKeyBased),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
	// 		EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
	// 		PrimaryConnectionString: to.Ptr("Endpoint=sb://***/;SharedAccessKeyName=***;SharedAccessKey=***;EntityPath=***"),
	// 		SecondaryConnectionString: to.Ptr("Endpoint=sb://***/;SharedAccessKeyName=***;SharedAccessKey=***;EntityPath=***"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsEndpointDelete_WithIdentity_example.json
func ExampleEndpointClient_BeginDelete_deleteADigitalTwinsInstanceEndpointWithIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointClient().BeginDelete(ctx, "resRg", "myDigitalTwinsService", "myendpoint", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EndpointResource = armdigitaltwins.EndpointResource{
	// 	Name: to.Ptr("myendpoint"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances/endpoints"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/endpoints/myServiceBus"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.ServiceBus{
	// 		AuthenticationType: to.Ptr(armdigitaltwins.AuthenticationTypeKeyBased),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T01:10:34.350Z"); return t}()),
	// 		EndpointType: to.Ptr(armdigitaltwins.EndpointTypeServiceBus),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.EndpointProvisioningStateSucceeded),
	// 		EndpointURI: to.Ptr("sb://mysb.servicebus.windows.net/"),
	// 		EntityPath: to.Ptr("mysbtopic"),
	// 	},
	// }
}
