//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdnsresolver

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// ForwardingRulesClient contains the methods for the ForwardingRules group.
// Don't use this type directly, use NewForwardingRulesClient() instead.
type ForwardingRulesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewForwardingRulesClient creates a new instance of ForwardingRulesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewForwardingRulesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ForwardingRulesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ForwardingRulesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a forwarding rule in a DNS forwarding ruleset.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-07-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dnsForwardingRulesetName - The name of the DNS forwarding ruleset.
//   - forwardingRuleName - The name of the forwarding rule.
//   - parameters - Parameters supplied to the CreateOrUpdate operation.
//   - options - ForwardingRulesClientCreateOrUpdateOptions contains the optional parameters for the ForwardingRulesClient.CreateOrUpdate
//     method.
func (client *ForwardingRulesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, forwardingRuleName string, parameters ForwardingRule, options *ForwardingRulesClientCreateOrUpdateOptions) (ForwardingRulesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ForwardingRulesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, parameters, options)
	if err != nil {
		return ForwardingRulesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ForwardingRulesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ForwardingRulesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ForwardingRulesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, forwardingRuleName string, parameters ForwardingRule, options *ForwardingRulesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dnsForwardingRulesetName == "" {
		return nil, errors.New("parameter dnsForwardingRulesetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dnsForwardingRulesetName}", url.PathEscape(dnsForwardingRulesetName))
	if forwardingRuleName == "" {
		return nil, errors.New("parameter forwardingRuleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{forwardingRuleName}", url.PathEscape(forwardingRuleName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ForwardingRulesClient) createOrUpdateHandleResponse(resp *http.Response) (ForwardingRulesClientCreateOrUpdateResponse, error) {
	result := ForwardingRulesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ForwardingRule); err != nil {
		return ForwardingRulesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a forwarding rule in a DNS forwarding ruleset. WARNING: This operation cannot be undone.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-07-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dnsForwardingRulesetName - The name of the DNS forwarding ruleset.
//   - forwardingRuleName - The name of the forwarding rule.
//   - options - ForwardingRulesClientDeleteOptions contains the optional parameters for the ForwardingRulesClient.Delete method.
func (client *ForwardingRulesClient) Delete(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, forwardingRuleName string, options *ForwardingRulesClientDeleteOptions) (ForwardingRulesClientDeleteResponse, error) {
	var err error
	const operationName = "ForwardingRulesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, options)
	if err != nil {
		return ForwardingRulesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ForwardingRulesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ForwardingRulesClientDeleteResponse{}, err
	}
	return ForwardingRulesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ForwardingRulesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, forwardingRuleName string, options *ForwardingRulesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dnsForwardingRulesetName == "" {
		return nil, errors.New("parameter dnsForwardingRulesetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dnsForwardingRulesetName}", url.PathEscape(dnsForwardingRulesetName))
	if forwardingRuleName == "" {
		return nil, errors.New("parameter forwardingRuleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{forwardingRuleName}", url.PathEscape(forwardingRuleName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets properties of a forwarding rule in a DNS forwarding ruleset.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-07-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dnsForwardingRulesetName - The name of the DNS forwarding ruleset.
//   - forwardingRuleName - The name of the forwarding rule.
//   - options - ForwardingRulesClientGetOptions contains the optional parameters for the ForwardingRulesClient.Get method.
func (client *ForwardingRulesClient) Get(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, forwardingRuleName string, options *ForwardingRulesClientGetOptions) (ForwardingRulesClientGetResponse, error) {
	var err error
	const operationName = "ForwardingRulesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, options)
	if err != nil {
		return ForwardingRulesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ForwardingRulesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ForwardingRulesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ForwardingRulesClient) getCreateRequest(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, forwardingRuleName string, options *ForwardingRulesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dnsForwardingRulesetName == "" {
		return nil, errors.New("parameter dnsForwardingRulesetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dnsForwardingRulesetName}", url.PathEscape(dnsForwardingRulesetName))
	if forwardingRuleName == "" {
		return nil, errors.New("parameter forwardingRuleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{forwardingRuleName}", url.PathEscape(forwardingRuleName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ForwardingRulesClient) getHandleResponse(resp *http.Response) (ForwardingRulesClientGetResponse, error) {
	result := ForwardingRulesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ForwardingRule); err != nil {
		return ForwardingRulesClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists forwarding rules in a DNS forwarding ruleset.
//
// Generated from API version 2022-07-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dnsForwardingRulesetName - The name of the DNS forwarding ruleset.
//   - options - ForwardingRulesClientListOptions contains the optional parameters for the ForwardingRulesClient.NewListPager
//     method.
func (client *ForwardingRulesClient) NewListPager(resourceGroupName string, dnsForwardingRulesetName string, options *ForwardingRulesClientListOptions) *runtime.Pager[ForwardingRulesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ForwardingRulesClientListResponse]{
		More: func(page ForwardingRulesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ForwardingRulesClientListResponse) (ForwardingRulesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ForwardingRulesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, dnsForwardingRulesetName, options)
			}, nil)
			if err != nil {
				return ForwardingRulesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ForwardingRulesClient) listCreateRequest(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, options *ForwardingRulesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dnsForwardingRulesetName == "" {
		return nil, errors.New("parameter dnsForwardingRulesetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dnsForwardingRulesetName}", url.PathEscape(dnsForwardingRulesetName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-07-01")
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ForwardingRulesClient) listHandleResponse(resp *http.Response) (ForwardingRulesClientListResponse, error) {
	result := ForwardingRulesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ForwardingRuleListResult); err != nil {
		return ForwardingRulesClientListResponse{}, err
	}
	return result, nil
}

// Update - Updates a forwarding rule in a DNS forwarding ruleset.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-07-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dnsForwardingRulesetName - The name of the DNS forwarding ruleset.
//   - forwardingRuleName - The name of the forwarding rule.
//   - parameters - Parameters supplied to the Update operation.
//   - options - ForwardingRulesClientUpdateOptions contains the optional parameters for the ForwardingRulesClient.Update method.
func (client *ForwardingRulesClient) Update(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, forwardingRuleName string, parameters ForwardingRulePatch, options *ForwardingRulesClientUpdateOptions) (ForwardingRulesClientUpdateResponse, error) {
	var err error
	const operationName = "ForwardingRulesClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, parameters, options)
	if err != nil {
		return ForwardingRulesClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ForwardingRulesClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ForwardingRulesClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *ForwardingRulesClient) updateCreateRequest(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, forwardingRuleName string, parameters ForwardingRulePatch, options *ForwardingRulesClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dnsForwardingRulesetName == "" {
		return nil, errors.New("parameter dnsForwardingRulesetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dnsForwardingRulesetName}", url.PathEscape(dnsForwardingRulesetName))
	if forwardingRuleName == "" {
		return nil, errors.New("parameter forwardingRuleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{forwardingRuleName}", url.PathEscape(forwardingRuleName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ForwardingRulesClient) updateHandleResponse(resp *http.Response) (ForwardingRulesClientUpdateResponse, error) {
	result := ForwardingRulesClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ForwardingRule); err != nil {
		return ForwardingRulesClientUpdateResponse{}, err
	}
	return result, nil
}
