//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/elastic/armelastic"
	"net/http"
	"net/url"
	"regexp"
)

// AssociateTrafficFilterServer is a fake server for instances of the armelastic.AssociateTrafficFilterClient type.
type AssociateTrafficFilterServer struct {
	// BeginAssociate is the fake for method AssociateTrafficFilterClient.BeginAssociate
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginAssociate func(ctx context.Context, resourceGroupName string, monitorName string, options *armelastic.AssociateTrafficFilterClientBeginAssociateOptions) (resp azfake.PollerResponder[armelastic.AssociateTrafficFilterClientAssociateResponse], errResp azfake.ErrorResponder)
}

// NewAssociateTrafficFilterServerTransport creates a new instance of AssociateTrafficFilterServerTransport with the provided implementation.
// The returned AssociateTrafficFilterServerTransport instance is connected to an instance of armelastic.AssociateTrafficFilterClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAssociateTrafficFilterServerTransport(srv *AssociateTrafficFilterServer) *AssociateTrafficFilterServerTransport {
	return &AssociateTrafficFilterServerTransport{
		srv:            srv,
		beginAssociate: newTracker[azfake.PollerResponder[armelastic.AssociateTrafficFilterClientAssociateResponse]](),
	}
}

// AssociateTrafficFilterServerTransport connects instances of armelastic.AssociateTrafficFilterClient to instances of AssociateTrafficFilterServer.
// Don't use this type directly, use NewAssociateTrafficFilterServerTransport instead.
type AssociateTrafficFilterServerTransport struct {
	srv            *AssociateTrafficFilterServer
	beginAssociate *tracker[azfake.PollerResponder[armelastic.AssociateTrafficFilterClientAssociateResponse]]
}

// Do implements the policy.Transporter interface for AssociateTrafficFilterServerTransport.
func (a *AssociateTrafficFilterServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AssociateTrafficFilterClient.BeginAssociate":
		resp, err = a.dispatchBeginAssociate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AssociateTrafficFilterServerTransport) dispatchBeginAssociate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginAssociate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAssociate not implemented")}
	}
	beginAssociate := a.beginAssociate.get(req)
	if beginAssociate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Elastic/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/associateTrafficFilter`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		rulesetIDUnescaped, err := url.QueryUnescape(qp.Get("rulesetId"))
		if err != nil {
			return nil, err
		}
		rulesetIDParam := getOptional(rulesetIDUnescaped)
		var options *armelastic.AssociateTrafficFilterClientBeginAssociateOptions
		if rulesetIDParam != nil {
			options = &armelastic.AssociateTrafficFilterClientBeginAssociateOptions{
				RulesetID: rulesetIDParam,
			}
		}
		respr, errRespr := a.srv.BeginAssociate(req.Context(), resourceGroupNameParam, monitorNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAssociate = &respr
		a.beginAssociate.add(req, beginAssociate)
	}

	resp, err := server.PollerResponderNext(beginAssociate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		a.beginAssociate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAssociate) {
		a.beginAssociate.remove(req)
	}

	return resp, nil
}
