//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
	"net/http"
	"net/url"
	"regexp"
)

// NetworkSecurityPerimeterConfigurationsServer is a fake server for instances of the armeventgrid.NetworkSecurityPerimeterConfigurationsClient type.
type NetworkSecurityPerimeterConfigurationsServer struct {
	// Get is the fake for method NetworkSecurityPerimeterConfigurationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceType armeventgrid.NetworkSecurityPerimeterResourceType, resourceName string, perimeterGUID string, associationName string, options *armeventgrid.NetworkSecurityPerimeterConfigurationsClientGetOptions) (resp azfake.Responder[armeventgrid.NetworkSecurityPerimeterConfigurationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method NetworkSecurityPerimeterConfigurationsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, resourceType armeventgrid.NetworkSecurityPerimeterResourceType, resourceName string, options *armeventgrid.NetworkSecurityPerimeterConfigurationsClientListOptions) (resp azfake.PagerResponder[armeventgrid.NetworkSecurityPerimeterConfigurationsClientListResponse])

	// BeginReconcile is the fake for method NetworkSecurityPerimeterConfigurationsClient.BeginReconcile
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReconcile func(ctx context.Context, resourceGroupName string, resourceType armeventgrid.NetworkSecurityPerimeterResourceType, resourceName string, perimeterGUID string, associationName string, options *armeventgrid.NetworkSecurityPerimeterConfigurationsClientBeginReconcileOptions) (resp azfake.PollerResponder[armeventgrid.NetworkSecurityPerimeterConfigurationsClientReconcileResponse], errResp azfake.ErrorResponder)
}

// NewNetworkSecurityPerimeterConfigurationsServerTransport creates a new instance of NetworkSecurityPerimeterConfigurationsServerTransport with the provided implementation.
// The returned NetworkSecurityPerimeterConfigurationsServerTransport instance is connected to an instance of armeventgrid.NetworkSecurityPerimeterConfigurationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNetworkSecurityPerimeterConfigurationsServerTransport(srv *NetworkSecurityPerimeterConfigurationsServer) *NetworkSecurityPerimeterConfigurationsServerTransport {
	return &NetworkSecurityPerimeterConfigurationsServerTransport{
		srv:            srv,
		newListPager:   newTracker[azfake.PagerResponder[armeventgrid.NetworkSecurityPerimeterConfigurationsClientListResponse]](),
		beginReconcile: newTracker[azfake.PollerResponder[armeventgrid.NetworkSecurityPerimeterConfigurationsClientReconcileResponse]](),
	}
}

// NetworkSecurityPerimeterConfigurationsServerTransport connects instances of armeventgrid.NetworkSecurityPerimeterConfigurationsClient to instances of NetworkSecurityPerimeterConfigurationsServer.
// Don't use this type directly, use NewNetworkSecurityPerimeterConfigurationsServerTransport instead.
type NetworkSecurityPerimeterConfigurationsServerTransport struct {
	srv            *NetworkSecurityPerimeterConfigurationsServer
	newListPager   *tracker[azfake.PagerResponder[armeventgrid.NetworkSecurityPerimeterConfigurationsClientListResponse]]
	beginReconcile *tracker[azfake.PollerResponder[armeventgrid.NetworkSecurityPerimeterConfigurationsClientReconcileResponse]]
}

// Do implements the policy.Transporter interface for NetworkSecurityPerimeterConfigurationsServerTransport.
func (n *NetworkSecurityPerimeterConfigurationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NetworkSecurityPerimeterConfigurationsClient.Get":
		resp, err = n.dispatchGet(req)
	case "NetworkSecurityPerimeterConfigurationsClient.NewListPager":
		resp, err = n.dispatchNewListPager(req)
	case "NetworkSecurityPerimeterConfigurationsClient.BeginReconcile":
		resp, err = n.dispatchBeginReconcile(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NetworkSecurityPerimeterConfigurationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if n.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkSecurityPerimeterConfigurations/(?P<perimeterGuid>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)\.(?P<associationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := parseWithCast(matches[regex.SubexpIndex("resourceType")], func(v string) (armeventgrid.NetworkSecurityPerimeterResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armeventgrid.NetworkSecurityPerimeterResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	perimeterGUIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("perimeterGuid")])
	if err != nil {
		return nil, err
	}
	associationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("associationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Get(req.Context(), resourceGroupNameParam, resourceTypeParam, resourceNameParam, perimeterGUIDParam, associationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkSecurityPerimeterConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NetworkSecurityPerimeterConfigurationsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if n.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := n.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkSecurityPerimeterConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := parseWithCast(matches[regex.SubexpIndex("resourceType")], func(v string) (armeventgrid.NetworkSecurityPerimeterResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armeventgrid.NetworkSecurityPerimeterResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := n.srv.NewListPager(resourceGroupNameParam, resourceTypeParam, resourceNameParam, nil)
		newListPager = &resp
		n.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		n.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		n.newListPager.remove(req)
	}
	return resp, nil
}

func (n *NetworkSecurityPerimeterConfigurationsServerTransport) dispatchBeginReconcile(req *http.Request) (*http.Response, error) {
	if n.srv.BeginReconcile == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReconcile not implemented")}
	}
	beginReconcile := n.beginReconcile.get(req)
	if beginReconcile == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkSecurityPerimeterConfigurations/(?P<perimeterGuid>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)\.(?P<associationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reconcile`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := parseWithCast(matches[regex.SubexpIndex("resourceType")], func(v string) (armeventgrid.NetworkSecurityPerimeterResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armeventgrid.NetworkSecurityPerimeterResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		perimeterGUIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("perimeterGuid")])
		if err != nil {
			return nil, err
		}
		associationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("associationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginReconcile(req.Context(), resourceGroupNameParam, resourceTypeParam, resourceNameParam, perimeterGUIDParam, associationNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReconcile = &respr
		n.beginReconcile.add(req, beginReconcile)
	}

	resp, err := server.PollerResponderNext(beginReconcile, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginReconcile.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReconcile) {
		n.beginReconcile.remove(req)
	}

	return resp, nil
}
