//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// SystemTopicEventSubscriptionsServer is a fake server for instances of the armeventgrid.SystemTopicEventSubscriptionsClient type.
type SystemTopicEventSubscriptionsServer struct {
	// BeginCreateOrUpdate is the fake for method SystemTopicEventSubscriptionsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, systemTopicName string, eventSubscriptionName string, eventSubscriptionInfo armeventgrid.EventSubscription, options *armeventgrid.SystemTopicEventSubscriptionsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SystemTopicEventSubscriptionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, systemTopicName string, eventSubscriptionName string, options *armeventgrid.SystemTopicEventSubscriptionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SystemTopicEventSubscriptionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, systemTopicName string, eventSubscriptionName string, options *armeventgrid.SystemTopicEventSubscriptionsClientGetOptions) (resp azfake.Responder[armeventgrid.SystemTopicEventSubscriptionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetDeliveryAttributes is the fake for method SystemTopicEventSubscriptionsClient.GetDeliveryAttributes
	// HTTP status codes to indicate success: http.StatusOK
	GetDeliveryAttributes func(ctx context.Context, resourceGroupName string, systemTopicName string, eventSubscriptionName string, options *armeventgrid.SystemTopicEventSubscriptionsClientGetDeliveryAttributesOptions) (resp azfake.Responder[armeventgrid.SystemTopicEventSubscriptionsClientGetDeliveryAttributesResponse], errResp azfake.ErrorResponder)

	// GetFullURL is the fake for method SystemTopicEventSubscriptionsClient.GetFullURL
	// HTTP status codes to indicate success: http.StatusOK
	GetFullURL func(ctx context.Context, resourceGroupName string, systemTopicName string, eventSubscriptionName string, options *armeventgrid.SystemTopicEventSubscriptionsClientGetFullURLOptions) (resp azfake.Responder[armeventgrid.SystemTopicEventSubscriptionsClientGetFullURLResponse], errResp azfake.ErrorResponder)

	// NewListBySystemTopicPager is the fake for method SystemTopicEventSubscriptionsClient.NewListBySystemTopicPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySystemTopicPager func(resourceGroupName string, systemTopicName string, options *armeventgrid.SystemTopicEventSubscriptionsClientListBySystemTopicOptions) (resp azfake.PagerResponder[armeventgrid.SystemTopicEventSubscriptionsClientListBySystemTopicResponse])

	// BeginUpdate is the fake for method SystemTopicEventSubscriptionsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	BeginUpdate func(ctx context.Context, resourceGroupName string, systemTopicName string, eventSubscriptionName string, eventSubscriptionUpdateParameters armeventgrid.EventSubscriptionUpdateParameters, options *armeventgrid.SystemTopicEventSubscriptionsClientBeginUpdateOptions) (resp azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSystemTopicEventSubscriptionsServerTransport creates a new instance of SystemTopicEventSubscriptionsServerTransport with the provided implementation.
// The returned SystemTopicEventSubscriptionsServerTransport instance is connected to an instance of armeventgrid.SystemTopicEventSubscriptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSystemTopicEventSubscriptionsServerTransport(srv *SystemTopicEventSubscriptionsServer) *SystemTopicEventSubscriptionsServerTransport {
	return &SystemTopicEventSubscriptionsServerTransport{
		srv:                       srv,
		beginCreateOrUpdate:       newTracker[azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientCreateOrUpdateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientDeleteResponse]](),
		newListBySystemTopicPager: newTracker[azfake.PagerResponder[armeventgrid.SystemTopicEventSubscriptionsClientListBySystemTopicResponse]](),
		beginUpdate:               newTracker[azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientUpdateResponse]](),
	}
}

// SystemTopicEventSubscriptionsServerTransport connects instances of armeventgrid.SystemTopicEventSubscriptionsClient to instances of SystemTopicEventSubscriptionsServer.
// Don't use this type directly, use NewSystemTopicEventSubscriptionsServerTransport instead.
type SystemTopicEventSubscriptionsServerTransport struct {
	srv                       *SystemTopicEventSubscriptionsServer
	beginCreateOrUpdate       *tracker[azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientCreateOrUpdateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientDeleteResponse]]
	newListBySystemTopicPager *tracker[azfake.PagerResponder[armeventgrid.SystemTopicEventSubscriptionsClientListBySystemTopicResponse]]
	beginUpdate               *tracker[azfake.PollerResponder[armeventgrid.SystemTopicEventSubscriptionsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for SystemTopicEventSubscriptionsServerTransport.
func (s *SystemTopicEventSubscriptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SystemTopicEventSubscriptionsClient.BeginCreateOrUpdate":
		resp, err = s.dispatchBeginCreateOrUpdate(req)
	case "SystemTopicEventSubscriptionsClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SystemTopicEventSubscriptionsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SystemTopicEventSubscriptionsClient.GetDeliveryAttributes":
		resp, err = s.dispatchGetDeliveryAttributes(req)
	case "SystemTopicEventSubscriptionsClient.GetFullURL":
		resp, err = s.dispatchGetFullURL(req)
	case "SystemTopicEventSubscriptionsClient.NewListBySystemTopicPager":
		resp, err = s.dispatchNewListBySystemTopicPager(req)
	case "SystemTopicEventSubscriptionsClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SystemTopicEventSubscriptionsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := s.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/systemTopics/(?P<systemTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armeventgrid.EventSubscription](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		systemTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("systemTopicName")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, systemTopicNameParam, eventSubscriptionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		s.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		s.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		s.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (s *SystemTopicEventSubscriptionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/systemTopics/(?P<systemTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		systemTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("systemTopicName")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, systemTopicNameParam, eventSubscriptionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SystemTopicEventSubscriptionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/systemTopics/(?P<systemTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	systemTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("systemTopicName")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, systemTopicNameParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSubscription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SystemTopicEventSubscriptionsServerTransport) dispatchGetDeliveryAttributes(req *http.Request) (*http.Response, error) {
	if s.srv.GetDeliveryAttributes == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeliveryAttributes not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/systemTopics/(?P<systemTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getDeliveryAttributes`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	systemTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("systemTopicName")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetDeliveryAttributes(req.Context(), resourceGroupNameParam, systemTopicNameParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeliveryAttributeListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SystemTopicEventSubscriptionsServerTransport) dispatchGetFullURL(req *http.Request) (*http.Response, error) {
	if s.srv.GetFullURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFullURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/systemTopics/(?P<systemTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getFullUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	systemTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("systemTopicName")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetFullURL(req.Context(), resourceGroupNameParam, systemTopicNameParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSubscriptionFullURL, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SystemTopicEventSubscriptionsServerTransport) dispatchNewListBySystemTopicPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySystemTopicPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySystemTopicPager not implemented")}
	}
	newListBySystemTopicPager := s.newListBySystemTopicPager.get(req)
	if newListBySystemTopicPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/systemTopics/(?P<systemTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		systemTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("systemTopicName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.SystemTopicEventSubscriptionsClientListBySystemTopicOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.SystemTopicEventSubscriptionsClientListBySystemTopicOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := s.srv.NewListBySystemTopicPager(resourceGroupNameParam, systemTopicNameParam, options)
		newListBySystemTopicPager = &resp
		s.newListBySystemTopicPager.add(req, newListBySystemTopicPager)
		server.PagerResponderInjectNextLinks(newListBySystemTopicPager, req, func(page *armeventgrid.SystemTopicEventSubscriptionsClientListBySystemTopicResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySystemTopicPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySystemTopicPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySystemTopicPager) {
		s.newListBySystemTopicPager.remove(req)
	}
	return resp, nil
}

func (s *SystemTopicEventSubscriptionsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/systemTopics/(?P<systemTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armeventgrid.EventSubscriptionUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		systemTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("systemTopicName")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, systemTopicNameParam, eventSubscriptionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}
