//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventgrid

import "time"

// AdvancedFilter - This is the base type that represents an advanced filter. To configure an advanced filter, do not directly
// instantiate an object of this class. Instead, instantiate an object of a derived class such
// as BoolEqualsAdvancedFilter, NumberInAdvancedFilter, StringEqualsAdvancedFilter etc. depending on the type of the key based
// on which you want to filter.
type AdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type AdvancedFilter.
func (a *AdvancedFilter) GetAdvancedFilter() *AdvancedFilter { return a }

// AzureADPartnerClientAuthentication - Azure Active Directory Partner Client Authentication
type AzureADPartnerClientAuthentication struct {
	// REQUIRED; Type of client authentication
	ClientAuthenticationType *PartnerClientAuthenticationType

	// AzureAD ClientAuthentication Properties
	Properties *AzureADPartnerClientAuthenticationProperties
}

// GetPartnerClientAuthentication implements the PartnerClientAuthenticationClassification interface for type AzureADPartnerClientAuthentication.
func (a *AzureADPartnerClientAuthentication) GetPartnerClientAuthentication() *PartnerClientAuthentication {
	return &PartnerClientAuthentication{
		ClientAuthenticationType: a.ClientAuthenticationType,
	}
}

// AzureADPartnerClientAuthenticationProperties - Properties of an Azure Active Directory Partner Client Authentication.
type AzureADPartnerClientAuthenticationProperties struct {
	// The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery
	// requests.
	AzureActiveDirectoryApplicationIDOrURI *string

	// The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
	AzureActiveDirectoryTenantID *string
}

// AzureFunctionEventSubscriptionDestination - Information about the azure function destination for an event subscription.
type AzureFunctionEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Azure Function Properties of the event subscription destination.
	Properties *AzureFunctionEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type AzureFunctionEventSubscriptionDestination.
func (a *AzureFunctionEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: a.EndpointType,
	}
}

// AzureFunctionEventSubscriptionDestinationProperties - The properties that represent the Azure Function destination of an
// event subscription.
type AzureFunctionEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification

	// Maximum number of events per batch.
	MaxEventsPerBatch *int32

	// Preferred batch size in Kilobytes.
	PreferredBatchSizeInKilobytes *int32

	// The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
	ResourceID *string
}

// BoolEqualsAdvancedFilter - BoolEquals Advanced Filter.
type BoolEqualsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The boolean filter value.
	Value *bool
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type BoolEqualsAdvancedFilter.
func (b *BoolEqualsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          b.Key,
		OperatorType: b.OperatorType,
	}
}

// BoolEqualsFilter - BoolEquals Filter.
type BoolEqualsFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The boolean filter value.
	Value *bool
}

// GetFilter implements the FilterClassification interface for type BoolEqualsFilter.
func (b *BoolEqualsFilter) GetFilter() *Filter {
	return &Filter{
		Key:          b.Key,
		OperatorType: b.OperatorType,
	}
}

// CaCertificate - The CA Certificate resource.
type CaCertificate struct {
	// The properties of CA certificate.
	Properties *CaCertificateProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to the CaCertificate resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// CaCertificateProperties - The properties of CA certificate.
type CaCertificateProperties struct {
	// Description for the CA Certificate resource.
	Description *string

	// Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
	EncodedCertificate *string

	// READ-ONLY; Certificate expiry time in UTC. This is a read-only field.
	ExpiryTimeInUTC *time.Time

	// READ-ONLY; Certificate issue time in UTC. This is a read-only field.
	IssueTimeInUTC *time.Time

	// READ-ONLY; Provisioning state of the CA Certificate resource.
	ProvisioningState *CaCertificateProvisioningState
}

// CaCertificatesListResult - Result of the List CA Certificate operation.
type CaCertificatesListResult struct {
	// A link for the next page of CA Certificate.
	NextLink *string

	// A collection of CA Certificate.
	Value []*CaCertificate
}

// Channel info.
type Channel struct {
	// Properties of the Channel.
	Properties *ChannelProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Channel resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// ChannelProperties - Properties of the Channel.
type ChannelProperties struct {
	// The type of the event channel which represents the direction flow of events.
	ChannelType *ChannelType

	// Expiration time of the channel. If this timer expires while the corresponding partner topic is never activated, the channel
	// and corresponding partner topic are deleted.
	ExpirationTimeIfNotActivatedUTC *time.Time

	// Context or helpful message that can be used during the approval process by the subscriber.
	MessageForActivation *string

	// This property should be populated when channelType is PartnerDestination and represents information about the partner destination
	// resource corresponding to the channel.
	PartnerDestinationInfo PartnerDestinationInfoClassification

	// This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource
	// corresponding to the channel.
	PartnerTopicInfo *PartnerTopicInfo

	// Provisioning state of the channel.
	ProvisioningState *ChannelProvisioningState

	// The readiness state of the corresponding partner topic.
	ReadinessState *ReadinessState
}

// ChannelUpdateParameters - Properties of the Channel update.
type ChannelUpdateParameters struct {
	// Properties of the channel update parameters.
	Properties *ChannelUpdateParametersProperties
}

// ChannelUpdateParametersProperties - Properties of the channel update parameters.
type ChannelUpdateParametersProperties struct {
	// Expiration time of the channel. If this timer expires while the corresponding partner topic or partner destination is never
	// activated, the channel and corresponding partner topic or partner
	// destination are deleted.
	ExpirationTimeIfNotActivatedUTC *time.Time

	// Partner destination properties which can be updated if the channel is of type PartnerDestination.
	PartnerDestinationInfo PartnerUpdateDestinationInfoClassification

	// Partner topic properties which can be updated if the channel is of type PartnerTopic.
	PartnerTopicInfo *PartnerUpdateTopicInfo
}

// ChannelsListResult - Result of the List Channels operation
type ChannelsListResult struct {
	// A link for the next page of channels.
	NextLink *string

	// A collection of Channels.
	Value []*Channel
}

// Client - The Client resource.
type Client struct {
	// The properties of client.
	Properties *ClientProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to the Client resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// ClientAuthenticationSettings - Client authentication settings for namespace resource.
type ClientAuthenticationSettings struct {
	// Alternative authentication name sources related to client authentication settings for namespace resource.
	AlternativeAuthenticationNameSources []*AlternativeAuthenticationNameSource

	// Custom JWT authentication settings for namespace resource.
	CustomJwtAuthentication *CustomJwtAuthenticationSettings
}

// ClientCertificateAuthentication - The certificate authentication properties for the client.
type ClientCertificateAuthentication struct {
	// The list of thumbprints that are allowed during client authentication. This property is required only if the validationScheme
	// is 'ThumbprintMatch'.
	AllowedThumbprints []*string

	// The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
	ValidationScheme *ClientCertificateValidationScheme
}

// ClientGroup - The Client group resource.
type ClientGroup struct {
	// The properties of client group.
	Properties *ClientGroupProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to the ClientGroup resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// ClientGroupProperties - The properties of client group.
type ClientGroupProperties struct {
	// Description for the Client Group resource.
	Description *string

	// The grouping query for the clients. Example : attributes.keyName IN ['a', 'b', 'c'].
	Query *string

	// READ-ONLY; Provisioning state of the ClientGroup resource.
	ProvisioningState *ClientGroupProvisioningState
}

// ClientGroupsListResult - Result of the List Client Group operation.
type ClientGroupsListResult struct {
	// A link for the next page of Client Group.
	NextLink *string

	// A collection of Client Group.
	Value []*ClientGroup
}

// ClientProperties - The properties of client.
type ClientProperties struct {
	// Attributes for the client. Supported values are int, bool, string, string[]. Example: "attributes": { "room": "345", "floor":
	// 12, "deviceTypes": ["Fan", "Light"] }
	Attributes map[string]any

	// The name presented by the client for authentication. The default value is the name of the resource.
	AuthenticationName *string

	// The client certificate authentication information.
	ClientCertificateAuthentication *ClientCertificateAuthentication

	// Description for the Client resource.
	Description *string

	// Indicates if the client is enabled or not. Default value is Enabled.
	State *ClientState

	// READ-ONLY; Provisioning state of the Client resource.
	ProvisioningState *ClientProvisioningState
}

// ClientsListResult - Result of the List Client operation.
type ClientsListResult struct {
	// A link for the next page of Client.
	NextLink *string

	// A collection of Client.
	Value []*Client
}

// ConnectionState information.
type ConnectionState struct {
	// Actions required (if any).
	ActionsRequired *string

	// Description of the connection state.
	Description *string

	// Status of the connection.
	Status *PersistedConnectionStatus
}

// CustomDomainConfiguration - A custom domain configuration that allows users to publish to their own domain name.
type CustomDomainConfiguration struct {
	// REQUIRED; Fully Qualified Domain Name (FQDN) for the custom domain.
	FullyQualifiedDomainName *string

	// The URL for the certificate that is used for publishing to the custom domain. We currently support certificates stored
	// in Azure Key Vault only. While certificate URL can be either versioned URL of the
	// following format https://{key-vault-name}.vault.azure.net/certificates/{certificate-name}/{version-id}, or unversioned
	// URL of the following format (e.g.,
	// https://contosovault.vault.azure.net/certificates/contosocert, we support unversioned certificate URL only (e.g., https://contosovault.vault.azure.net/certificates/contosocert)
	CertificateURL *string

	// Expected DNS TXT record name. Event Grid will check for a TXT record with this name in the DNS record set of the custom
	// domain name to prove ownership over the domain. The values under this TXT record
	// must contain the expected TXT record value.
	ExpectedTxtRecordName *string

	// Expected DNS TXT record value. Event Grid will check for a TXT record with this value in the DNS record set of the custom
	// domain name to prove ownership over the domain.
	ExpectedTxtRecordValue *string

	// Identity info for accessing the certificate for the custom domain. This identity info must match an identity that has been
	// set on the namespace.
	Identity *CustomDomainIdentity

	// Validation state for the custom domain. This is a read only property and is initially set to 'Pending' and will be updated
	// to 'Approved' by Event Grid only after ownership of the domain name has been
	// successfully validated.
	ValidationState *CustomDomainValidationState
}

// CustomDomainIdentity - The identity information for retrieving the certificate for the custom domain.
type CustomDomainIdentity struct {
	// The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
	Type *CustomDomainIdentityType

	// The user identity associated with the resource.
	UserAssignedIdentity *string
}

// CustomDomainOwnershipValidationResult - Namespace custom domain ownership validation result.
type CustomDomainOwnershipValidationResult struct {
	// List of custom domain configurations for the namespace under topic spaces configuration.
	CustomDomainsForTopicSpacesConfiguration []*CustomDomainConfiguration

	// List of custom domain configurations for the namespace under topics configuration.
	CustomDomainsForTopicsConfiguration []*CustomDomainConfiguration
}

// CustomJwtAuthenticationManagedIdentity - The identity information for retrieving the certificate for custom JWT authentication.
type CustomJwtAuthenticationManagedIdentity struct {
	// REQUIRED; The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
	Type *CustomJwtAuthenticationManagedIdentityType

	// The user identity associated with the resource.
	UserAssignedIdentity *string
}

// CustomJwtAuthenticationSettings - Custom JWT authentication settings for namespace resource.
type CustomJwtAuthenticationSettings struct {
	// Information about the certificate that is used for token validation. We currently support maximum 2 certificates.
	IssuerCertificates []*IssuerCertificateInfo

	// Expected JWT token issuer.
	TokenIssuer *string
}

// DeadLetterDestination - Information about the dead letter destination for an event subscription. To configure a deadletter
// destination, do not directly instantiate an object of this class. Instead, instantiate an object of a
// derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from this class.
type DeadLetterDestination struct {
	// REQUIRED; Type of the endpoint for the dead letter destination
	EndpointType *DeadLetterEndPointType
}

// GetDeadLetterDestination implements the DeadLetterDestinationClassification interface for type DeadLetterDestination.
func (d *DeadLetterDestination) GetDeadLetterDestination() *DeadLetterDestination { return d }

// DeadLetterWithResourceIdentity - Information about the deadletter destination with resource identity.
type DeadLetterWithResourceIdentity struct {
	// Information about the destination where events have to be delivered for the event subscription. Uses the managed identity
	// setup on the parent resource (namely, topic or domain) to acquire the
	// authentication tokens being used during dead-lettering.
	DeadLetterDestination DeadLetterDestinationClassification

	// The identity to use when dead-lettering events.
	Identity *EventSubscriptionIdentity
}

// DeliveryAttributeListResult - Result of the Get delivery attributes operation.
type DeliveryAttributeListResult struct {
	// A collection of DeliveryAttributeMapping
	Value []DeliveryAttributeMappingClassification
}

// DeliveryAttributeMapping - Delivery attribute mapping details.
type DeliveryAttributeMapping struct {
	// REQUIRED; Type of the delivery attribute or header name.
	Type *DeliveryAttributeMappingType

	// Name of the delivery attribute or header.
	Name *string
}

// GetDeliveryAttributeMapping implements the DeliveryAttributeMappingClassification interface for type DeliveryAttributeMapping.
func (d *DeliveryAttributeMapping) GetDeliveryAttributeMapping() *DeliveryAttributeMapping { return d }

// DeliveryConfiguration - Properties of the delivery configuration information of the event subscription.
type DeliveryConfiguration struct {
	// Delivery mode of the event subscription.
	DeliveryMode *DeliveryMode

	// This property should be populated when deliveryMode is push and represents information about the push subscription.
	Push *PushInfo

	// This property should be populated when deliveryMode is queue and represents information about the queue subscription.
	Queue *QueueInfo
}

// DeliveryWithResourceIdentity - Information about the delivery for an event subscription with resource identity.
type DeliveryWithResourceIdentity struct {
	// Information about the destination where events have to be delivered for the event subscription. Uses the managed identity
	// setup on the parent resource (namely, topic or domain) to acquire the
	// authentication tokens being used during delivery.
	Destination EventSubscriptionDestinationClassification

	// The identity to use when delivering events.
	Identity *EventSubscriptionIdentity
}

// Domain - EventGrid Domain.
type Domain struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Identity information for the Event Grid Domain resource.
	Identity *IdentityInfo

	// Properties of the Event Grid Domain resource.
	Properties *DomainProperties

	// The Sku pricing tier for the Event Grid Domain resource.
	SKU *ResourceSKU

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to the Event Grid Domain resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// DomainProperties - Properties of the Event Grid Domain Resource.
type DomainProperties struct {
	// This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event
	// Grid Domain resource. In this context, creation of domain topic can be
	// auto-managed (when true) or self-managed (when false). The default value for this property is true. When this property
	// is null or set to true, Event Grid is responsible of automatically creating the
	// domain topic when the first event subscription is created at the scope of the domain topic. If this property is set to
	// false, then creating the first event subscription will require creating a domain
	// topic by the user. The self-management mode can be used if the user wants full control of when the domain topic is created,
	// while auto-managed mode provides the flexibility to perform less operations
	// and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the domain
	// topic on demand if needed.
	AutoCreateTopicWithFirstSubscription *bool

	// This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event
	// Grid Domain resource. In this context, deletion of domain topic can be
	// auto-managed (when true) or self-managed (when false). The default value for this property is true. When this property
	// is set to true, Event Grid is responsible of automatically deleting the domain
	// topic when the last event subscription at the scope of the domain topic is deleted. If this property is set to false, then
	// the user needs to manually delete the domain topic when it is no longer
	// needed (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode
	// can be used if the user wants full control of when the domain topic needs to be
	// deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer resources by the
	// user.
	AutoDeleteTopicWithLastSubscription *bool

	// Data Residency Boundary of the resource.
	DataResidencyBoundary *DataResidencyBoundary

	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the domain.
	DisableLocalAuth *bool

	// Event Type Information for the domain. This information is provided by the publisher and can be used by the subscriber
	// to view different types of events that are published.
	EventTypeInfo *EventTypeInfo

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule

	// This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
	InputSchema *InputSchema

	// Information about the InputSchemaMapping which specified the info about mapping event payload.
	InputSchemaMapping InputSchemaMappingClassification

	// Minimum TLS version of the publisher allowed to publish to this domain
	MinimumTLSVersionAllowed *TLSVersion

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess

	// READ-ONLY; Endpoint for the Event Grid Domain Resource which is used for publishing the events.
	Endpoint *string

	// READ-ONLY; Metric resource id for the Event Grid Domain Resource.
	MetricResourceID *string

	// READ-ONLY; List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Provisioning state of the Event Grid Domain Resource.
	ProvisioningState *DomainProvisioningState
}

// DomainRegenerateKeyRequest - Domain regenerate share access key request.
type DomainRegenerateKeyRequest struct {
	// REQUIRED; Key name to regenerate key1 or key2.
	KeyName *string
}

// DomainSharedAccessKeys - Shared access keys of the Domain.
type DomainSharedAccessKeys struct {
	// Shared access key1 for the domain.
	Key1 *string

	// Shared access key2 for the domain.
	Key2 *string
}

// DomainTopic - Domain Topic.
type DomainTopic struct {
	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; Properties of the Domain Topic.
	Properties *DomainTopicProperties

	// READ-ONLY; The system metadata relating to Domain Topic resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// DomainTopicProperties - Properties of the Domain Topic.
type DomainTopicProperties struct {
	// READ-ONLY; Provisioning state of the domain topic.
	ProvisioningState *DomainTopicProvisioningState
}

// DomainTopicsListResult - Result of the List Domain Topics operation.
type DomainTopicsListResult struct {
	// A link for the next page of domain topics.
	NextLink *string

	// A collection of Domain Topics.
	Value []*DomainTopic
}

// DomainUpdateParameterProperties - Information of domain update parameter properties.
type DomainUpdateParameterProperties struct {
	// This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event
	// Grid Domain resource. In this context, creation of domain topic can be
	// auto-managed (when true) or self-managed (when false). The default value for this property is true. When this property
	// is null or set to true, Event Grid is responsible of automatically creating the
	// domain topic when the first event subscription is created at the scope of the domain topic. If this property is set to
	// false, then creating the first event subscription will require creating a domain
	// topic by the user. The self-management mode can be used if the user wants full control of when the domain topic is created,
	// while auto-managed mode provides the flexibility to perform less operations
	// and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the domain
	// topic on demand if needed.
	AutoCreateTopicWithFirstSubscription *bool

	// This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event
	// Grid Domain resource. In this context, deletion of domain topic can be
	// auto-managed (when true) or self-managed (when false). The default value for this property is true. When this property
	// is set to true, Event Grid is responsible of automatically deleting the domain
	// topic when the last event subscription at the scope of the domain topic is deleted. If this property is set to false, then
	// the user needs to manually delete the domain topic when it is no longer
	// needed (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode
	// can be used if the user wants full control of when the domain topic needs to be
	// deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer resources by the
	// user.
	AutoDeleteTopicWithLastSubscription *bool

	// The data residency boundary for the domain.
	DataResidencyBoundary *DataResidencyBoundary

	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the domain.
	DisableLocalAuth *bool

	// The eventTypeInfo for the domain.
	EventTypeInfo *EventTypeInfo

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule

	// Minimum TLS version of the publisher allowed to publish to this domain
	MinimumTLSVersionAllowed *TLSVersion

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess
}

// DomainUpdateParameters - Properties of the Domain update.
type DomainUpdateParameters struct {
	// Identity information for the resource.
	Identity *IdentityInfo

	// Properties of the resource.
	Properties *DomainUpdateParameterProperties

	// The Sku pricing tier for the domain.
	SKU *ResourceSKU

	// Tags of the domains resource.
	Tags map[string]*string
}

// DomainsListResult - Result of the List Domains operation.
type DomainsListResult struct {
	// A link for the next page of domains.
	NextLink *string

	// A collection of Domains.
	Value []*Domain
}

// DynamicDeliveryAttributeMapping - Dynamic delivery attribute mapping details.
type DynamicDeliveryAttributeMapping struct {
	// REQUIRED; Type of the delivery attribute or header name.
	Type *DeliveryAttributeMappingType

	// Name of the delivery attribute or header.
	Name *string

	// Properties of dynamic delivery attribute mapping.
	Properties *DynamicDeliveryAttributeMappingProperties
}

// GetDeliveryAttributeMapping implements the DeliveryAttributeMappingClassification interface for type DynamicDeliveryAttributeMapping.
func (d *DynamicDeliveryAttributeMapping) GetDeliveryAttributeMapping() *DeliveryAttributeMapping {
	return &DeliveryAttributeMapping{
		Name: d.Name,
		Type: d.Type,
	}
}

// DynamicDeliveryAttributeMappingProperties - Properties of dynamic delivery attribute mapping.
type DynamicDeliveryAttributeMappingProperties struct {
	// JSON path in the event which contains attribute value.
	SourceField *string
}

type DynamicRoutingEnrichment struct {
	// Dynamic routing enrichment key.
	Key *string

	// Dynamic routing enrichment value.
	Value *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// EventHubEventSubscriptionDestination - Information about the event hub destination for an event subscription.
type EventHubEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Event Hub Properties of the event subscription destination.
	Properties *EventHubEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type EventHubEventSubscriptionDestination.
func (e *EventHubEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: e.EndpointType,
	}
}

// EventHubEventSubscriptionDestinationProperties - The properties for a event hub destination.
type EventHubEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification

	// The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
	ResourceID *string
}

// EventSubscription - Event Subscription.
type EventSubscription struct {
	// Properties of the event subscription.
	Properties *EventSubscriptionProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Event Subscription resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// EventSubscriptionDestination - Information about the destination for an event subscription.
type EventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type EventSubscriptionDestination.
func (e *EventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return e
}

// EventSubscriptionFilter - Filter for the Event Subscription.
type EventSubscriptionFilter struct {
	// An array of advanced filters that are used for filtering event subscriptions.
	AdvancedFilters []AdvancedFilterClassification

	// Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
	EnableAdvancedFilteringOnArrays *bool

	// A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default
	// event types, set the IncludedEventTypes to null.
	IncludedEventTypes []*string

	// Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter should be compared in a case sensitive
	// manner.
	IsSubjectCaseSensitive *bool

	// An optional string to filter events for an event subscription based on a resource path prefix. The format of this depends
	// on the publisher of the events. Wildcard characters are not supported in this
	// path.
	SubjectBeginsWith *string

	// An optional string to filter events for an event subscription based on a resource path suffix. Wildcard characters are
	// not supported in this path.
	SubjectEndsWith *string
}

// EventSubscriptionFullURL - Full endpoint URL of an event subscription
type EventSubscriptionFullURL struct {
	// The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string
}

// EventSubscriptionIdentity - The identity information with the event subscription.
type EventSubscriptionIdentity struct {
	// The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
	Type *EventSubscriptionIdentityType

	// The user identity associated with the resource.
	UserAssignedIdentity *string
}

// EventSubscriptionProperties - Properties of the Event Subscription.
type EventSubscriptionProperties struct {
	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses Azure Event Grid's identity to acquire the
	// authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestination DeadLetterDestinationClassification

	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses the managed identity setup on the parent
	// resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterWithResourceIdentity *DeadLetterWithResourceIdentity

	// Information about the destination where events have to be delivered for the event subscription. Uses the managed identity
	// setup on the parent resource (namely, topic or domain) to acquire the
	// authentication tokens being used during delivery / dead-lettering.
	DeliveryWithResourceIdentity *DeliveryWithResourceIdentity

	// Information about the destination where events have to be delivered for the event subscription. Uses Azure Event Grid's
	// identity to acquire the authentication tokens being used during delivery /
	// dead-lettering.
	Destination EventSubscriptionDestinationClassification

	// The event delivery schema for the event subscription.
	EventDeliverySchema *EventDeliverySchema

	// Expiration time of the event subscription.
	ExpirationTimeUTC *time.Time

	// Information about the filter for the event subscription.
	Filter *EventSubscriptionFilter

	// List of user defined labels.
	Labels []*string

	// The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
	RetryPolicy *RetryPolicy

	// READ-ONLY; Provisioning state of the event subscription.
	ProvisioningState *EventSubscriptionProvisioningState

	// READ-ONLY; Name of the topic of the event subscription.
	Topic *string
}

// EventSubscriptionUpdateParameters - Properties of the Event Subscription update.
type EventSubscriptionUpdateParameters struct {
	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses Azure Event Grid's identity to acquire the
	// authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestination DeadLetterDestinationClassification

	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses the managed identity setup on the parent
	// resource (topic / domain) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterWithResourceIdentity *DeadLetterWithResourceIdentity

	// Information about the destination where events have to be delivered for the event subscription. Uses the managed identity
	// setup on the parent resource (topic / domain) to acquire the authentication
	// tokens being used during delivery / dead-lettering.
	DeliveryWithResourceIdentity *DeliveryWithResourceIdentity

	// Information about the destination where events have to be delivered for the event subscription. Uses Azure Event Grid's
	// identity to acquire the authentication tokens being used during delivery /
	// dead-lettering.
	Destination EventSubscriptionDestinationClassification

	// The event delivery schema for the event subscription.
	EventDeliverySchema *EventDeliverySchema

	// Information about the expiration time for the event subscription.
	ExpirationTimeUTC *time.Time

	// Information about the filter for the event subscription.
	Filter *EventSubscriptionFilter

	// List of user defined labels.
	Labels []*string

	// The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
	RetryPolicy *RetryPolicy
}

// EventSubscriptionsListResult - Result of the List EventSubscriptions operation
type EventSubscriptionsListResult struct {
	// A link for the next page of event subscriptions
	NextLink *string

	// A collection of EventSubscriptions
	Value []*EventSubscription
}

// EventType - Event Type for a subject under a topic
type EventType struct {
	// Properties of the event type.
	Properties *EventTypeProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// EventTypeInfo - The event type information for Channels.
type EventTypeInfo struct {
	// A collection of inline event types for the resource. The inline event type keys are of type string which represents the
	// name of the event. An example of a valid inline event name is
	// "Contoso.OrderCreated". The inline event type values are of type InlineEventProperties and will contain additional information
	// for every inline event type.
	InlineEventTypes map[string]*InlineEventProperties

	// The kind of event type used.
	Kind *EventDefinitionKind
}

// EventTypeProperties - Properties of the event type
type EventTypeProperties struct {
	// Description of the event type.
	Description *string

	// Display name of the event type.
	DisplayName *string

	// IsInDefaultSet flag of the event type.
	IsInDefaultSet *bool

	// Url of the schema for this event type.
	SchemaURL *string
}

// EventTypesListResult - Result of the List Event Types operation
type EventTypesListResult struct {
	// A collection of event types
	Value []*EventType
}

// ExtendedLocation - Definition of an Extended Location
type ExtendedLocation struct {
	// Fully qualified name of the extended location.
	Name *string

	// Type of the extended location.
	Type *string
}

// ExtensionTopic - Event grid Extension Topic. This is used for getting Event Grid related metrics for Azure resources.
type ExtensionTopic struct {
	// Properties of the extension topic.
	Properties *ExtensionTopicProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Extension Topic resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// ExtensionTopicProperties - Properties of the Extension Topic
type ExtensionTopicProperties struct {
	// Description of the extension topic.
	Description *string

	// System topic resource id which is mapped to the source.
	SystemTopic *string
}

// Filter - This is the base type that represents a filter. To configure a filter, do not directly instantiate an object of
// this class. Instead, instantiate an object of a derived class such as BoolEqualsFilter,
// NumberInFilter, StringEqualsFilter etc depending on the type of the key based on which you want to filter.
type Filter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string
}

// GetFilter implements the FilterClassification interface for type Filter.
func (f *Filter) GetFilter() *Filter { return f }

// FiltersConfiguration - Filters configuration for the Event Subscription.
type FiltersConfiguration struct {
	// An array of filters that are used for filtering event subscriptions.
	Filters []FilterClassification

	// A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default
	// event types, set the IncludedEventTypes to null.
	IncludedEventTypes []*string
}

// HybridConnectionEventSubscriptionDestination - Information about the HybridConnection destination for an event subscription.
type HybridConnectionEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Hybrid connection Properties of the event subscription destination.
	Properties *HybridConnectionEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type HybridConnectionEventSubscriptionDestination.
func (h *HybridConnectionEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: h.EndpointType,
	}
}

// HybridConnectionEventSubscriptionDestinationProperties - The properties for a hybrid connection destination.
type HybridConnectionEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification

	// The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
	ResourceID *string
}

// IdentityInfo - The identity information for the resource.
type IdentityInfo struct {
	// The principal ID of resource identity.
	PrincipalID *string

	// The tenant ID of resource.
	TenantID *string

	// The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity
	// and a set of user-assigned identities. The type 'None' will remove any identity.
	Type *IdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	// This property is currently not used and reserved for
	// future usage.
	UserAssignedIdentities map[string]*UserIdentityProperties
}

type InboundIPRule struct {
	// Action to perform based on the match or no match of the IpMask.
	Action *IPActionType

	// IP Address in CIDR notation e.g., 10.0.0.0/8.
	IPMask *string
}

// InlineEventProperties - Additional information about every inline event.
type InlineEventProperties struct {
	// The dataSchemaUrl for the inline event.
	DataSchemaURL *string

	// The description for the inline event.
	Description *string

	// The displayName for the inline event.
	DisplayName *string

	// The documentationUrl for the inline event.
	DocumentationURL *string
}

// InputSchemaMapping - By default, Event Grid expects events to be in the Event Grid event schema. Specifying an input schema
// mapping enables publishing to Event Grid using a custom input schema. Currently, the only
// supported type of InputSchemaMapping is 'JsonInputSchemaMapping'.
type InputSchemaMapping struct {
	// REQUIRED; Type of the custom mapping
	InputSchemaMappingType *InputSchemaMappingType
}

// GetInputSchemaMapping implements the InputSchemaMappingClassification interface for type InputSchemaMapping.
func (i *InputSchemaMapping) GetInputSchemaMapping() *InputSchemaMapping { return i }

// IsNotNullAdvancedFilter - IsNotNull Advanced Filter.
type IsNotNullAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type IsNotNullAdvancedFilter.
func (i *IsNotNullAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          i.Key,
		OperatorType: i.OperatorType,
	}
}

// IsNotNullFilter - IsNotNull Filter.
type IsNotNullFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string
}

// GetFilter implements the FilterClassification interface for type IsNotNullFilter.
func (i *IsNotNullFilter) GetFilter() *Filter {
	return &Filter{
		Key:          i.Key,
		OperatorType: i.OperatorType,
	}
}

// IsNullOrUndefinedAdvancedFilter - IsNullOrUndefined Advanced Filter.
type IsNullOrUndefinedAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type IsNullOrUndefinedAdvancedFilter.
func (i *IsNullOrUndefinedAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          i.Key,
		OperatorType: i.OperatorType,
	}
}

// IsNullOrUndefinedFilter - IsNullOrUndefined Filter.
type IsNullOrUndefinedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string
}

// GetFilter implements the FilterClassification interface for type IsNullOrUndefinedFilter.
func (i *IsNullOrUndefinedFilter) GetFilter() *Filter {
	return &Filter{
		Key:          i.Key,
		OperatorType: i.OperatorType,
	}
}

// IssuerCertificateInfo - Information about the certificate that is used for token validation.
type IssuerCertificateInfo struct {
	// REQUIRED; Keyvault certificate URL in https://keyvaultname.vault.azure.net/certificates/certificateName/certificateVersion
	// format.
	CertificateURL *string

	// The identity that will be used to access the certificate.
	Identity *CustomJwtAuthenticationManagedIdentity
}

// JSONField - This is used to express the source of an input schema mapping for a single target field in the Event Grid Event
// schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime'
// properties. This represents a field in the input event schema.
type JSONField struct {
	// Name of a field in the input event schema that's to be used as the source of a mapping.
	SourceField *string
}

// JSONFieldWithDefault - This is used to express the source of an input schema mapping for a single target field in the Event
// Grid Event schema. This is currently used in the mappings for the 'subject', 'eventtype' and
// 'dataversion' properties. This represents a field in the input event schema along with a default value to be used, and
// at least one of these two properties should be provided.
type JSONFieldWithDefault struct {
	// The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified
	// name in the published JSON event payload.
	DefaultValue *string

	// Name of a field in the input event schema that's to be used as the source of a mapping.
	SourceField *string
}

// JSONInputSchemaMapping - This enables publishing to Event Grid using a custom input schema. This can be used to map properties
// from a custom input JSON schema to the Event Grid event schema.
type JSONInputSchemaMapping struct {
	// REQUIRED; Type of the custom mapping
	InputSchemaMappingType *InputSchemaMappingType

	// JSON Properties of the input schema mapping
	Properties *JSONInputSchemaMappingProperties
}

// GetInputSchemaMapping implements the InputSchemaMappingClassification interface for type JSONInputSchemaMapping.
func (j *JSONInputSchemaMapping) GetInputSchemaMapping() *InputSchemaMapping {
	return &InputSchemaMapping{
		InputSchemaMappingType: j.InputSchemaMappingType,
	}
}

// JSONInputSchemaMappingProperties - This can be used to map properties of a source schema (or default values, for certain
// supported properties) to properties of the EventGridEvent schema.
type JSONInputSchemaMappingProperties struct {
	// The mapping information for the DataVersion property of the Event Grid Event.
	DataVersion *JSONFieldWithDefault

	// The mapping information for the EventTime property of the Event Grid Event.
	EventTime *JSONField

	// The mapping information for the EventType property of the Event Grid Event.
	EventType *JSONFieldWithDefault

	// The mapping information for the Id property of the Event Grid Event.
	ID *JSONField

	// The mapping information for the Subject property of the Event Grid Event.
	Subject *JSONFieldWithDefault

	// The mapping information for the Topic property of the Event Grid Event.
	Topic *JSONField
}

// MonitorAlertEventSubscriptionDestination - Information about the Monitor Alert destination for an event subscription.
type MonitorAlertEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Monitor Alert properties of the event subscription destination.
	Properties *MonitorAlertEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type MonitorAlertEventSubscriptionDestination.
func (m *MonitorAlertEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: m.EndpointType,
	}
}

// MonitorAlertEventSubscriptionDestinationProperties - The properties that represent the Monitor Alert destination of an
// event subscription.
type MonitorAlertEventSubscriptionDestinationProperties struct {
	// The list of ARM Ids of Action Groups that will be triggered on every Alert fired through this event subscription. Each
	// resource ARM Id should follow this pattern:
	// /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Insights/actionGroups/{ActionGroupName}.
	ActionGroups []*string

	// The description that will be attached to every Alert fired through this event subscription.
	Description *string

	// The severity that will be attached to every Alert fired through this event subscription. This field must be provided.
	Severity *MonitorAlertSeverity
}

// Namespace resource.
type Namespace struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Identity information for the Namespace resource.
	Identity *IdentityInfo

	// Properties of the Namespace resource.
	Properties *NamespaceProperties

	// Represents available Sku pricing tiers.
	SKU *NamespaceSKU

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to the namespace resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// NamespaceProperties - Properties of the namespace resource.
type NamespaceProperties struct {
	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule

	// This is an optional property and it allows the user to specify if the namespace resource supports zone-redundancy capability
	// or not. If this property is not specified explicitly by the user, its
	// default value depends on the following conditions: a. For Availability Zones enabled regions - The default property value
	// would be true. b. For non-Availability Zones enabled regions - The default
	// property value would be false. Once specified, this property cannot be updated.
	IsZoneRedundant *bool

	// Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
	MinimumTLSVersionAllowed *TLSVersion

	// List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess

	// Topic spaces configuration information for the namespace resource
	TopicSpacesConfiguration *TopicSpacesConfiguration

	// Topics configuration information for the namespace resource
	TopicsConfiguration *TopicsConfiguration

	// READ-ONLY; Provisioning state of the namespace resource.
	ProvisioningState *NamespaceProvisioningState
}

// NamespaceRegenerateKeyRequest - Namespace regenerate share access key request.
type NamespaceRegenerateKeyRequest struct {
	// REQUIRED; Key name to regenerate key1 or key2.
	KeyName *string
}

// NamespaceSKU - Represents available Sku pricing tiers.
type NamespaceSKU struct {
	// Specifies the number of Throughput Units that defines the capacity for the namespace. The property default value is 1 which
	// signifies 1 Throughput Unit = 1MB/s ingress and 2MB/s egress per namespace.
	// Min capacity is 1 and max allowed capacity is 20.
	Capacity *int32

	// The name of the SKU.
	Name *SKUName
}

// NamespaceSharedAccessKeys - Shared access keys of the Namespace.
type NamespaceSharedAccessKeys struct {
	// Shared access key1 for the namespace.
	Key1 *string

	// Shared access key2 for the namespace.
	Key2 *string
}

// NamespaceTopic - Namespace topic details.
type NamespaceTopic struct {
	// Properties of the namespace topic.
	Properties *NamespaceTopicProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to namespace topic resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// NamespaceTopicEventSubscriptionDestination - Information about the Namespace Topic destination for an event subscription.
type NamespaceTopicEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Namespace Topic properties of the event subscription destination.
	Properties *NamespaceTopicEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type NamespaceTopicEventSubscriptionDestination.
func (n *NamespaceTopicEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: n.EndpointType,
	}
}

// NamespaceTopicEventSubscriptionDestinationProperties - The properties that represent the Event Grid Namespace Topic destination
// of an event subscription.
type NamespaceTopicEventSubscriptionDestinationProperties struct {
	// The Azure resource Id that represents the endpoint of the Event Grid Namespace Topic destination of an event subscription.
	// This field is required and the Namespace Topic resource listed must already
	// exist. The resource ARM Id should follow this pattern:
	// /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.EventGrid/namespaces/{NamespaceName}/topics/{TopicName}.
	ResourceID *string
}

// NamespaceTopicProperties - Properties of the namespace topic.
type NamespaceTopicProperties struct {
	// Event retention for the namespace topic expressed in days. The property default value is 1 day. Min event retention duration
	// value is 1 day and max event retention duration value is 1 day.
	EventRetentionInDays *int32

	// This determines the format that is expected for incoming events published to the topic.
	InputSchema *EventInputSchema

	// Publisher type of the namespace topic.
	PublisherType *PublisherType

	// READ-ONLY; Provisioning state of the namespace topic.
	ProvisioningState *NamespaceTopicProvisioningState
}

// NamespaceTopicUpdateParameterProperties - Information of namespace topic update parameter properties.
type NamespaceTopicUpdateParameterProperties struct {
	// Event retention for the namespace topic expressed in days. The property default value is 1 day. Min event retention duration
	// value is 1 day and max event retention duration value is 1 day.
	EventRetentionInDays *int32
}

// NamespaceTopicUpdateParameters - Properties of the namespace topic update.
type NamespaceTopicUpdateParameters struct {
	// Properties of the namespace topic resource.
	Properties *NamespaceTopicUpdateParameterProperties
}

// NamespaceTopicsListResult - Result of the List namespace topics operation.
type NamespaceTopicsListResult struct {
	// A link for the next page of namespace topics.
	NextLink *string

	// A collection of namespace topics.
	Value []*NamespaceTopic
}

// NamespaceUpdateParameterProperties - Information of namespace update parameter properties.
type NamespaceUpdateParameterProperties struct {
	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess

	// Topic spaces configuration properties that can be updated.
	TopicSpacesConfiguration *UpdateTopicSpacesConfigurationInfo

	// Topics configuration properties that can be updated.
	TopicsConfiguration *UpdateTopicsConfigurationInfo
}

// NamespaceUpdateParameters - Properties to update namespace.
type NamespaceUpdateParameters struct {
	// Namespace resource identity information.
	Identity *IdentityInfo

	// Properties of the namespace resource.
	Properties *NamespaceUpdateParameterProperties

	// Represents available Sku pricing tiers.
	SKU *NamespaceSKU

	// Tags of the namespace resource.
	Tags map[string]*string
}

// NamespacesListResult - Result of the List Namespaces operation.
type NamespacesListResult struct {
	// A link for the next page of namespaces.
	NextLink *string

	// A collection of namespaces.
	Value []*Namespace
}

// NetworkSecurityPerimeterConfiguration - Network security perimeter configuration.
type NetworkSecurityPerimeterConfiguration struct {
	// Properties of the network security perimeter configuration.
	Properties *NetworkSecurityPerimeterConfigurationProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// NetworkSecurityPerimeterConfigurationIssues - Network security perimeter configuration issues.
type NetworkSecurityPerimeterConfigurationIssues struct {
	// Provisioning issue name.
	Name *string

	// Provisioning issue properties.
	Properties *NetworkSecurityPerimeterConfigurationIssuesProperties
}

// NetworkSecurityPerimeterConfigurationIssuesProperties - Network security perimeter configuration issues properties.
type NetworkSecurityPerimeterConfigurationIssuesProperties struct {
	// Provisioning issue description.
	Description *string

	// Provisioning issue type.
	IssueType *NetworkSecurityPerimeterConfigurationIssueType

	// Provisioning issue severity.
	Severity *NetworkSecurityPerimeterConfigurationIssueSeverity

	// Access rules that can be added to the same profile to remediate the issue.
	SuggestedAccessRules []*string

	// ARM IDs of resources that can be associated to the same perimeter to remediate the issue.
	SuggestedResourceIDs []*string
}

// NetworkSecurityPerimeterConfigurationList - Network security perimeter configuration List.
type NetworkSecurityPerimeterConfigurationList struct {
	// A link for the next page of Network Security Perimeter Configuration.
	NextLink *string

	// List of all network security parameter configurations.
	Value []*NetworkSecurityPerimeterConfiguration
}

// NetworkSecurityPerimeterConfigurationProfile - Nsp configuration with profile information.
type NetworkSecurityPerimeterConfigurationProfile struct {
	// List of inbound or outbound access rule setup on the nsp profile.
	AccessRules []*NetworkSecurityPerimeterProfileAccessRule

	// Access rules version number for nsp profile.
	AccessRulesVersion *string

	// Diagnostic settings version number for nsp profile.
	DiagnosticSettingsVersion *string

	// Enabled log categories for nsp profile.
	EnabledLogCategories []*string

	// Nsp configuration profile name.
	Name *string
}

// NetworkSecurityPerimeterConfigurationProperties - Network security perimeter configuration information to reflect latest
// association and nsp profile configuration.
type NetworkSecurityPerimeterConfigurationProperties struct {
	// Perimeter info for nsp association.
	NetworkSecurityPerimeter *NetworkSecurityPerimeterInfo

	// Nsp profile configuration, access rules and diagnostic settings.
	Profile *NetworkSecurityPerimeterConfigurationProfile

	// Provisioning issues to reflect status when attempting to retrieve nsp profile configuration.
	ProvisioningIssues []*NetworkSecurityPerimeterConfigurationIssues

	// Provisioning state to reflect configuration state and indicate status of nsp profile configuration retrieval.
	ProvisioningState *NetworkSecurityPerimeterConfigProvisioningState

	// Nsp association name and access mode of association.
	ResourceAssociation *ResourceAssociation
}

// NetworkSecurityPerimeterInfo - Network security perimeter info.
type NetworkSecurityPerimeterInfo struct {
	// Arm id for network security perimeter.
	ID *string

	// Network security perimeter location.
	Location *string

	// Network security perimeter guid.
	PerimeterGUID *string
}

// NetworkSecurityPerimeterProfileAccessRule - Network security perimeter profile access rule.
type NetworkSecurityPerimeterProfileAccessRule struct {
	// Fully Qualified Arm id for network security perimeter profile access rule.
	FullyQualifiedArmID *string

	// Name for nsp access rule.
	Name *string

	// NSP access rule properties.
	Properties *NetworkSecurityPerimeterProfileAccessRuleProperties

	// nsp access rule type.
	Type *string
}

// NetworkSecurityPerimeterProfileAccessRuleProperties - Network security perimeter profile access rule properties.
type NetworkSecurityPerimeterProfileAccessRuleProperties struct {
	// Address prefixes.
	AddressPrefixes []*string

	// NSP access rule direction.
	Direction *NetworkSecurityPerimeterProfileAccessRuleDirection

	// List of email addresses.
	EmailAddresses []*string

	// Fully qualified domain names.
	FullyQualifiedDomainNames []*string

	// Network security perimeters.
	NetworkSecurityPerimeters []*NetworkSecurityPerimeterInfo

	// List of phone numbers.
	PhoneNumbers []*string

	// List of subscriptions.
	Subscriptions []*NetworkSecurityPerimeterSubscription
}

// NetworkSecurityPerimeterSubscription - Network security perimeter subscription inbound access rule.
type NetworkSecurityPerimeterSubscription struct {
	// Subscription id.
	ID *string
}

// NumberGreaterThanAdvancedFilter - NumberGreaterThan Advanced Filter.
type NumberGreaterThanAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The filter value.
	Value *float64
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberGreaterThanAdvancedFilter.
func (n *NumberGreaterThanAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberGreaterThanFilter - NumberGreaterThan Filter.
type NumberGreaterThanFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The filter value.
	Value *float64
}

// GetFilter implements the FilterClassification interface for type NumberGreaterThanFilter.
func (n *NumberGreaterThanFilter) GetFilter() *Filter {
	return &Filter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberGreaterThanOrEqualsAdvancedFilter - NumberGreaterThanOrEquals Advanced Filter.
type NumberGreaterThanOrEqualsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The filter value.
	Value *float64
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberGreaterThanOrEqualsAdvancedFilter.
func (n *NumberGreaterThanOrEqualsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberGreaterThanOrEqualsFilter - NumberGreaterThanOrEquals Filter.
type NumberGreaterThanOrEqualsFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The filter value.
	Value *float64
}

// GetFilter implements the FilterClassification interface for type NumberGreaterThanOrEqualsFilter.
func (n *NumberGreaterThanOrEqualsFilter) GetFilter() *Filter {
	return &Filter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberInAdvancedFilter - NumberIn Advanced Filter.
type NumberInAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*float64
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberInAdvancedFilter.
func (n *NumberInAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberInFilter - NumberIn Filter.
type NumberInFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*float64
}

// GetFilter implements the FilterClassification interface for type NumberInFilter.
func (n *NumberInFilter) GetFilter() *Filter {
	return &Filter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberInRangeAdvancedFilter - NumberInRange Advanced Filter.
type NumberInRangeAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values [][]*float64
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberInRangeAdvancedFilter.
func (n *NumberInRangeAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberInRangeFilter - NumberInRange Filter.
type NumberInRangeFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values [][]*float64
}

// GetFilter implements the FilterClassification interface for type NumberInRangeFilter.
func (n *NumberInRangeFilter) GetFilter() *Filter {
	return &Filter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberLessThanAdvancedFilter - NumberLessThan Advanced Filter.
type NumberLessThanAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The filter value.
	Value *float64
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberLessThanAdvancedFilter.
func (n *NumberLessThanAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberLessThanFilter - NumberLessThan Filter.
type NumberLessThanFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The filter value.
	Value *float64
}

// GetFilter implements the FilterClassification interface for type NumberLessThanFilter.
func (n *NumberLessThanFilter) GetFilter() *Filter {
	return &Filter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberLessThanOrEqualsAdvancedFilter - NumberLessThanOrEquals Advanced Filter.
type NumberLessThanOrEqualsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The filter value.
	Value *float64
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberLessThanOrEqualsAdvancedFilter.
func (n *NumberLessThanOrEqualsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberLessThanOrEqualsFilter - NumberLessThanOrEquals Filter.
type NumberLessThanOrEqualsFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The filter value.
	Value *float64
}

// GetFilter implements the FilterClassification interface for type NumberLessThanOrEqualsFilter.
func (n *NumberLessThanOrEqualsFilter) GetFilter() *Filter {
	return &Filter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberNotInAdvancedFilter - NumberNotIn Advanced Filter.
type NumberNotInAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*float64
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberNotInAdvancedFilter.
func (n *NumberNotInAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberNotInFilter - NumberNotIn Filter.
type NumberNotInFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*float64
}

// GetFilter implements the FilterClassification interface for type NumberNotInFilter.
func (n *NumberNotInFilter) GetFilter() *Filter {
	return &Filter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberNotInRangeAdvancedFilter - NumberNotInRange Advanced Filter.
type NumberNotInRangeAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values [][]*float64
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type NumberNotInRangeAdvancedFilter.
func (n *NumberNotInRangeAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// NumberNotInRangeFilter - NumberNotInRange Filter.
type NumberNotInRangeFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values [][]*float64
}

// GetFilter implements the FilterClassification interface for type NumberNotInRangeFilter.
func (n *NumberNotInRangeFilter) GetFilter() *Filter {
	return &Filter{
		Key:          n.Key,
		OperatorType: n.OperatorType,
	}
}

// Operation - Represents an operation returned by the GetOperations request.
type Operation struct {
	// Display name of the operation.
	Display *OperationInfo

	// This Boolean is used to determine if the operation is a data plane action or not.
	IsDataAction *bool

	// Name of the operation.
	Name *string

	// Origin of the operation.
	Origin *string

	// Properties of the operation.
	Properties any
}

// OperationInfo - Information about an operation
type OperationInfo struct {
	// Description of the operation
	Description *string

	// Name of the operation
	Operation *string

	// Name of the provider
	Provider *string

	// Name of the resource type
	Resource *string
}

// OperationsListResult - Result of the List Operations operation
type OperationsListResult struct {
	// A collection of operations
	Value []*Operation
}

// Partner - Information about the partner.
type Partner struct {
	// Expiration time of the partner authorization. If this timer expires, any request from this partner to create, update or
	// delete resources in subscriber's context will fail. If specified, the allowed
	// values are between 1 to the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration. If not specified,
	// the default value will be the value of defaultMaximumExpirationTimeInDays
	// specified in PartnerConfiguration or 7 if this value is not specified.
	AuthorizationExpirationTimeInUTC *time.Time

	// The partner name.
	PartnerName *string

	// The immutableId of the corresponding partner registration.
	PartnerRegistrationImmutableID *string
}

// PartnerAuthorization - The partner authorization details.
type PartnerAuthorization struct {
	// The list of authorized partners.
	AuthorizedPartnersList []*Partner

	// Time used to validate the authorization expiration time for each authorized partner. If DefaultMaximumExpirationTimeInDays
	// is not specified, the default is 7 days. Otherwise, allowed values are
	// between 1 and 365 days.
	DefaultMaximumExpirationTimeInDays *int32
}

// PartnerClientAuthentication - Partner client authentication
type PartnerClientAuthentication struct {
	// REQUIRED; Type of client authentication
	ClientAuthenticationType *PartnerClientAuthenticationType
}

// GetPartnerClientAuthentication implements the PartnerClientAuthenticationClassification interface for type PartnerClientAuthentication.
func (p *PartnerClientAuthentication) GetPartnerClientAuthentication() *PartnerClientAuthentication {
	return p
}

// PartnerConfiguration - Partner configuration information
type PartnerConfiguration struct {
	// Location of the resource.
	Location *string

	// Properties of the partner configuration.
	Properties *PartnerConfigurationProperties

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to partner configuration resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// PartnerConfigurationProperties - Properties of the partner configuration.
type PartnerConfigurationProperties struct {
	// The details of authorized partners.
	PartnerAuthorization *PartnerAuthorization

	// Provisioning state of the partner configuration.
	ProvisioningState *PartnerConfigurationProvisioningState
}

// PartnerConfigurationUpdateParameterProperties - Information of partner configuration update parameter properties.
type PartnerConfigurationUpdateParameterProperties struct {
	// The default time used to validate the maximum expiration time for each authorized partners in days. Allowed values ar between
	// 1 and 365 days.
	DefaultMaximumExpirationTimeInDays *int32
}

// PartnerConfigurationUpdateParameters - Properties of the partner configuration update.
type PartnerConfigurationUpdateParameters struct {
	// Properties of the Topic resource.
	Properties *PartnerConfigurationUpdateParameterProperties

	// Tags of the partner configuration resource.
	Tags map[string]*string
}

// PartnerConfigurationsListResult - Result of the List partner configurations operation
type PartnerConfigurationsListResult struct {
	// A link for the next page of partner configurations.
	NextLink *string

	// A collection of partner configurations.
	Value []*PartnerConfiguration
}

// PartnerDestination - Event Grid Partner Destination.
type PartnerDestination struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Properties of the Partner Destination.
	Properties *PartnerDestinationProperties

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Partner Destination resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// PartnerDestinationInfo - Properties of the corresponding partner destination of a Channel.
type PartnerDestinationInfo struct {
	// REQUIRED; Type of the endpoint for the partner destination
	EndpointType *PartnerEndpointType

	// Azure subscription ID of the subscriber. The partner destination associated with the channel will be created under this
	// Azure subscription.
	AzureSubscriptionID *string

	// Additional context of the partner destination endpoint.
	EndpointServiceContext *string

	// Name of the partner destination associated with the channel.
	Name *string

	// Azure Resource Group of the subscriber. The partner destination associated with the channel will be created under this
	// resource group.
	ResourceGroupName *string

	// Change history of the resource move.
	ResourceMoveChangeHistory []*ResourceMoveChangeHistory
}

// GetPartnerDestinationInfo implements the PartnerDestinationInfoClassification interface for type PartnerDestinationInfo.
func (p *PartnerDestinationInfo) GetPartnerDestinationInfo() *PartnerDestinationInfo { return p }

// PartnerDestinationProperties - Properties of the Partner Destination.
type PartnerDestinationProperties struct {
	// Activation state of the partner destination.
	ActivationState *PartnerDestinationActivationState

	// Endpoint Base URL of the partner destination
	EndpointBaseURL *string

	// Endpoint context associated with this partner destination.
	EndpointServiceContext *string

	// Expiration time of the partner destination. If this timer expires and the partner destination was never activated, the
	// partner destination and corresponding channel are deleted.
	ExpirationTimeIfNotActivatedUTC *time.Time

	// Context or helpful message that can be used during the approval process.
	MessageForActivation *string

	// The immutable Id of the corresponding partner registration.
	PartnerRegistrationImmutableID *string

	// READ-ONLY; Provisioning state of the partner destination.
	ProvisioningState *PartnerDestinationProvisioningState
}

// PartnerDestinationUpdateParameters - Properties of the Partner Destination that can be updated.
type PartnerDestinationUpdateParameters struct {
	// Tags of the Partner Destination resource.
	Tags map[string]*string
}

// PartnerDestinationsListResult - Result of the List Partner Destinations operation.
type PartnerDestinationsListResult struct {
	// A link for the next page of partner destinations.
	NextLink *string

	// A collection of partner destinations.
	Value []*PartnerDestination
}

// PartnerDetails - Information about the partner.
type PartnerDetails struct {
	// This is short description about the partner. The length of this description should not exceed 256 characters.
	Description *string

	// Long description for the partner's scenarios and integration.Length of this description should not exceed 2048 characters.
	LongDescription *string

	// URI of the partner website that can be used by Azure customers to setup Event Grid integration on an event source.
	SetupURI *string
}

type PartnerEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Partner Destination Properties of the event subscription destination.
	Properties *PartnerEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type PartnerEventSubscriptionDestination.
func (p *PartnerEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: p.EndpointType,
	}
}

type PartnerEventSubscriptionDestinationProperties struct {
	// The Azure Resource Id that represents the endpoint of a Partner Destination of an event subscription.
	ResourceID *string
}

// PartnerNamespace - EventGrid Partner Namespace.
type PartnerNamespace struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Properties of the Partner Namespace.
	Properties *PartnerNamespaceProperties

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Partner Namespace resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// PartnerNamespaceProperties - Properties of the partner namespace.
type PartnerNamespaceProperties struct {
	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the partner
	// namespace.
	DisableLocalAuth *bool

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule

	// Minimum TLS version of the publisher allowed to publish to this partner namespace
	MinimumTLSVersionAllowed *TLSVersion

	// The fully qualified ARM Id of the partner registration that should be associated with this partner namespace. This takes
	// the following format:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
	PartnerRegistrationFullyQualifiedID *string

	// This determines if events published to this partner namespace should use the source attribute in the event payload or use
	// the channel name in the header when matching to the partner topic. If none is
	// specified, source attribute routing will be used to match the partner topic.
	PartnerTopicRoutingMode *PartnerTopicRoutingMode

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess

	// READ-ONLY; Endpoint for the partner namespace.
	Endpoint *string

	// READ-ONLY; List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Provisioning state of the partner namespace.
	ProvisioningState *PartnerNamespaceProvisioningState
}

// PartnerNamespaceRegenerateKeyRequest - PartnerNamespace regenerate shared access key request.
type PartnerNamespaceRegenerateKeyRequest struct {
	// REQUIRED; Key name to regenerate (key1 or key2).
	KeyName *string
}

// PartnerNamespaceSharedAccessKeys - Shared access keys of the partner namespace.
type PartnerNamespaceSharedAccessKeys struct {
	// Shared access key1 for the partner namespace.
	Key1 *string

	// Shared access key2 for the partner namespace.
	Key2 *string
}

// PartnerNamespaceUpdateParameterProperties - Information of Partner Namespace update parameter properties.
type PartnerNamespaceUpdateParameterProperties struct {
	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the partner
	// namespace.
	DisableLocalAuth *bool

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule

	// Minimum TLS version of the publisher allowed to publish to this domain
	MinimumTLSVersionAllowed *TLSVersion

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess
}

// PartnerNamespaceUpdateParameters - Properties of the Partner Namespace update.
type PartnerNamespaceUpdateParameters struct {
	// Properties of the Partner Namespace.
	Properties *PartnerNamespaceUpdateParameterProperties

	// Tags of the Partner Namespace.
	Tags map[string]*string
}

// PartnerNamespacesListResult - Result of the List Partner Namespaces operation
type PartnerNamespacesListResult struct {
	// A link for the next page of partner namespaces.
	NextLink *string

	// A collection of partner namespaces.
	Value []*PartnerNamespace
}

// PartnerRegistration - Information about a partner registration.
type PartnerRegistration struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Properties of the partner registration.
	Properties *PartnerRegistrationProperties

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Partner Registration resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// PartnerRegistrationProperties - Properties of the partner registration.
type PartnerRegistrationProperties struct {
	// The immutableId of the corresponding partner registration. Note: This property is marked for deprecation and is not supported
	// in any future GA API version
	PartnerRegistrationImmutableID *string

	// READ-ONLY; Provisioning state of the partner registration.
	ProvisioningState *PartnerRegistrationProvisioningState
}

// PartnerRegistrationUpdateParameters - Properties of the Partner Registration update.
type PartnerRegistrationUpdateParameters struct {
	// Tags of the partner registration resource.
	Tags map[string]*string
}

// PartnerRegistrationsListResult - Result of the List Partner Registrations operation.
type PartnerRegistrationsListResult struct {
	// A link for the next page of partner registrations.
	NextLink *string

	// A collection of partner registrations.
	Value []*PartnerRegistration
}

// PartnerTopic - Event Grid Partner Topic.
type PartnerTopic struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Identity information for the Partner Topic resource.
	Identity *IdentityInfo

	// Properties of the Partner Topic.
	Properties *PartnerTopicProperties

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Partner Topic resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// PartnerTopicInfo - Properties of the corresponding partner topic of a Channel.
type PartnerTopicInfo struct {
	// Azure subscription ID of the subscriber. The partner topic associated with the channel will be created under this Azure
	// subscription.
	AzureSubscriptionID *string

	// Event Type Information for the partner topic. This information is provided by the publisher and can be used by the subscriber
	// to view different types of events that are published.
	EventTypeInfo *EventTypeInfo

	// Name of the partner topic associated with the channel.
	Name *string

	// Azure Resource Group of the subscriber. The partner topic associated with the channel will be created under this resource
	// group.
	ResourceGroupName *string

	// The source information is provided by the publisher to determine the scope or context from which the events are originating.
	// This information can be used by the subscriber during the approval process
	// of the created partner topic.
	Source *string
}

// PartnerTopicProperties - Properties of the Partner Topic.
type PartnerTopicProperties struct {
	// Activation state of the partner topic.
	ActivationState *PartnerTopicActivationState

	// Event Type information from the corresponding event channel.
	EventTypeInfo *EventTypeInfo

	// Expiration time of the partner topic. If this timer expires while the partner topic is still never activated, the partner
	// topic and corresponding event channel are deleted.
	ExpirationTimeIfNotActivatedUTC *time.Time

	// Context or helpful message that can be used during the approval process by the subscriber.
	MessageForActivation *string

	// The immutableId of the corresponding partner registration.
	PartnerRegistrationImmutableID *string

	// Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer
	// partner topic. This will be helpful to remove any ambiguity of the origin of
	// creation of the partner topic for the customer.
	PartnerTopicFriendlyDescription *string

	// Source associated with this partner topic. This represents a unique partner resource.
	Source *string

	// READ-ONLY; Provisioning state of the partner topic.
	ProvisioningState *PartnerTopicProvisioningState
}

// PartnerTopicUpdateParameters - Properties of the Partner Topic update.
type PartnerTopicUpdateParameters struct {
	// Identity information for the Partner Topic resource.
	Identity *IdentityInfo

	// Tags of the Partner Topic resource.
	Tags map[string]*string
}

// PartnerTopicsListResult - Result of the List Partner Topics operation.
type PartnerTopicsListResult struct {
	// A link for the next page of partner topics.
	NextLink *string

	// A collection of partner topics.
	Value []*PartnerTopic
}

// PartnerUpdateDestinationInfo - Properties of the corresponding partner destination of a Channel.
type PartnerUpdateDestinationInfo struct {
	// REQUIRED; Type of the endpoint for the partner destination
	EndpointType *PartnerEndpointType
}

// GetPartnerUpdateDestinationInfo implements the PartnerUpdateDestinationInfoClassification interface for type PartnerUpdateDestinationInfo.
func (p *PartnerUpdateDestinationInfo) GetPartnerUpdateDestinationInfo() *PartnerUpdateDestinationInfo {
	return p
}

// PartnerUpdateTopicInfo - Update properties for the corresponding partner topic of a channel.
type PartnerUpdateTopicInfo struct {
	// Event type info for the partner topic
	EventTypeInfo *EventTypeInfo
}

// PermissionBinding - The Permission binding resource.
type PermissionBinding struct {
	// The properties of permission binding.
	Properties *PermissionBindingProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to the PermissionBinding resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// PermissionBindingProperties - The properties of permission binding.
type PermissionBindingProperties struct {
	// The name of the client group resource that the permission is bound to. The client group needs to be a resource under the
	// same namespace the permission binding is a part of.
	ClientGroupName *string

	// Description for the Permission Binding resource.
	Description *string

	// The allowed permission.
	Permission *PermissionType

	// The name of the Topic Space resource that the permission is bound to. The Topic space needs to be a resource under the
	// same namespace the permission binding is a part of.
	TopicSpaceName *string

	// READ-ONLY; Provisioning state of the PermissionBinding resource.
	ProvisioningState *PermissionBindingProvisioningState
}

// PermissionBindingsListResult - Result of the List Permission Binding operation.
type PermissionBindingsListResult struct {
	// A link for the next page of Permission Binding.
	NextLink *string

	// A collection of Permission Binding.
	Value []*PermissionBinding
}

// PrivateEndpoint information.
type PrivateEndpoint struct {
	// The ARM identifier for Private Endpoint.
	ID *string
}

type PrivateEndpointConnection struct {
	// Properties of the PrivateEndpointConnection.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// PrivateEndpointConnectionListResult - Result of the list of all private endpoint connections operation.
type PrivateEndpointConnectionListResult struct {
	// A link for the next page of private endpoint connection resources.
	NextLink *string

	// A collection of private endpoint connection resources.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// GroupIds from the private link service resource.
	GroupIDs []*string

	// The Private Endpoint resource for this Connection.
	PrivateEndpoint *PrivateEndpoint

	// Details about the state of the connection.
	PrivateLinkServiceConnectionState *ConnectionState

	// Provisioning state of the Private Endpoint Connection.
	ProvisioningState *ResourceProvisioningState
}

// PrivateLinkResource - Information of the private link resource.
type PrivateLinkResource struct {
	// Fully qualified identifier of the resource.
	ID *string

	// Name of the resource.
	Name *string

	// Properties of the private link resource.
	Properties *PrivateLinkResourceProperties

	// Type of the resource.
	Type *string
}

type PrivateLinkResourceProperties struct {
	DisplayName       *string
	GroupID           *string
	RequiredMembers   []*string
	RequiredZoneNames []*string
}

// PrivateLinkResourcesListResult - Result of the List private link resources operation.
type PrivateLinkResourcesListResult struct {
	// A link for the next page of private link resources.
	NextLink *string

	// A collection of private link resources
	Value []*PrivateLinkResource
}

// PushInfo - Properties of the destination info for event subscription supporting push.
type PushInfo struct {
	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses the managed identity setup on the parent
	// resource (namely, namespace) to acquire the authentication tokens being used during dead-lettering.
	DeadLetterDestinationWithResourceIdentity *DeadLetterWithResourceIdentity

	// Information about the destination where events have to be delivered for the event subscription. Uses the managed identity
	// setup on the parent resource (namely, topic or domain) to acquire the
	// authentication tokens being used during delivery.
	DeliveryWithResourceIdentity *DeliveryWithResourceIdentity

	// Information about the destination where events have to be delivered for the event subscription. Uses Azure Event Grid's
	// identity to acquire the authentication tokens being used during delivery.
	Destination EventSubscriptionDestinationClassification

	// Time span duration in ISO 8601 format that determines how long messages are available to the subscription from the time
	// the message was published. This duration value is expressed using the following
	// format: \'P(n)Y(n)M(n)DT(n)H(n)M(n)S\', where: - (n) is replaced by the value of each time element that follows the (n).
	// - P is the duration (or Period) designator and is always placed at the
	// beginning of the duration. - Y is the year designator, and it follows the value for the number of years. - M is the month
	// designator, and it follows the value for the number of months. - W is the week
	// designator, and it follows the value for the number of weeks. - D is the day designator, and it follows the value for the
	// number of days. - T is the time designator, and it precedes the time
	// components. - H is the hour designator, and it follows the value for the number of hours. - M is the minute designator,
	// and it follows the value for the number of minutes. - S is the second
	// designator, and it follows the value for the number of seconds. This duration value cannot be set greater than the topic’s
	// EventRetentionInDays. It is is an optional field where its minimum value is 1
	// minute, and its maximum is determined by topic’s EventRetentionInDays value. The followings are examples of valid values:
	// - \'P0DT23H12M\' or \'PT23H12M\': for duration of 23 hours and 12 minutes. -
	// \'P1D\' or \'P1DT0H0M0S\': for duration of 1 day.
	EventTimeToLive *string

	// The maximum delivery count of the events.
	MaxDeliveryCount *int32
}

// QueueInfo - Properties of the Queue info for event subscription.
type QueueInfo struct {
	// The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to
	// the dead letter destination. Uses the managed identity setup on the parent
	// resource (namely, topic) to acquire the authentication tokens being used during delivery / dead-lettering.
	DeadLetterDestinationWithResourceIdentity *DeadLetterWithResourceIdentity

	// Time span duration in ISO 8601 format that determines how long messages are available to the subscription from the time
	// the message was published. This duration value is expressed using the following
	// format: \'P(n)Y(n)M(n)DT(n)H(n)M(n)S\', where: - (n) is replaced by the value of each time element that follows the (n).
	// - P is the duration (or Period) designator and is always placed at the
	// beginning of the duration. - Y is the year designator, and it follows the value for the number of years. - M is the month
	// designator, and it follows the value for the number of months. - W is the week
	// designator, and it follows the value for the number of weeks. - D is the day designator, and it follows the value for the
	// number of days. - T is the time designator, and it precedes the time
	// components. - H is the hour designator, and it follows the value for the number of hours. - M is the minute designator,
	// and it follows the value for the number of minutes. - S is the second
	// designator, and it follows the value for the number of seconds. This duration value cannot be set greater than the topic’s
	// EventRetentionInDays. It is is an optional field where its minimum value is 1
	// minute, and its maximum is determined by topic’s EventRetentionInDays value. The followings are examples of valid values:
	// - \'P0DT23H12M\' or \'PT23H12M\': for duration of 23 hours and 12 minutes. -
	// \'P1D\' or \'P1DT0H0M0S\': for duration of 1 day.
	EventTimeToLive *string

	// The maximum delivery count of the events.
	MaxDeliveryCount *int32

	// Maximum period in seconds in which once the message is in received (by the client) state and waiting to be accepted, released
	// or rejected. If this time elapsed after a message has been received by the
	// client and not transitioned into accepted (not processed), released or rejected, the message is available for redelivery.
	// This is an optional field, where default is 60 seconds, minimum is 60 seconds
	// and maximum is 300 seconds.
	ReceiveLockDurationInSeconds *int32
}

// Resource - Definition of a Resource.
type Resource struct {
	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ResourceAssociation - Nsp resource association
type ResourceAssociation struct {
	// Network security perimeter access mode.
	AccessMode *NetworkSecurityPerimeterAssociationAccessMode

	// Association name
	Name *string
}

// ResourceMoveChangeHistory - The change history of the resource move.
type ResourceMoveChangeHistory struct {
	// Azure subscription ID of the resource.
	AzureSubscriptionID *string

	// UTC timestamp of when the resource was changed.
	ChangedTimeUTC *time.Time

	// Azure Resource Group of the resource.
	ResourceGroupName *string
}

// ResourceSKU - Describes an EventGrid Resource Sku.
type ResourceSKU struct {
	// The Sku name of the resource. The possible values are: Basic or Premium.
	Name *SKU
}

// RetryPolicy - Information about the retry policy for an event subscription.
type RetryPolicy struct {
	// Time To Live (in minutes) for events.
	EventTimeToLiveInMinutes *int32

	// Maximum number of delivery retry attempts for events.
	MaxDeliveryAttempts *int32
}

type RoutingEnrichments struct {
	Dynamic []*DynamicRoutingEnrichment
	Static  []StaticRoutingEnrichmentClassification
}

// RoutingIdentityInfo - Routing identity info for topic spaces configuration.
type RoutingIdentityInfo struct {
	// Routing identity type for topic spaces configuration.
	Type                 *RoutingIdentityType
	UserAssignedIdentity *string
}

// ServiceBusQueueEventSubscriptionDestination - Information about the service bus destination for an event subscription.
type ServiceBusQueueEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Service Bus Properties of the event subscription destination.
	Properties *ServiceBusQueueEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type ServiceBusQueueEventSubscriptionDestination.
func (s *ServiceBusQueueEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: s.EndpointType,
	}
}

// ServiceBusQueueEventSubscriptionDestinationProperties - The properties that represent the Service Bus destination of an
// event subscription.
type ServiceBusQueueEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification

	// The Azure Resource Id that represents the endpoint of the Service Bus destination of an event subscription.
	ResourceID *string
}

// ServiceBusTopicEventSubscriptionDestination - Information about the service bus topic destination for an event subscription.
type ServiceBusTopicEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Service Bus Topic Properties of the event subscription destination.
	Properties *ServiceBusTopicEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type ServiceBusTopicEventSubscriptionDestination.
func (s *ServiceBusTopicEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: s.EndpointType,
	}
}

// ServiceBusTopicEventSubscriptionDestinationProperties - The properties that represent the Service Bus Topic destination
// of an event subscription.
type ServiceBusTopicEventSubscriptionDestinationProperties struct {
	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification

	// The Azure Resource Id that represents the endpoint of the Service Bus Topic destination of an event subscription.
	ResourceID *string
}

// StaticDeliveryAttributeMapping - Static delivery attribute mapping details.
type StaticDeliveryAttributeMapping struct {
	// REQUIRED; Type of the delivery attribute or header name.
	Type *DeliveryAttributeMappingType

	// Name of the delivery attribute or header.
	Name *string

	// Properties of static delivery attribute mapping.
	Properties *StaticDeliveryAttributeMappingProperties
}

// GetDeliveryAttributeMapping implements the DeliveryAttributeMappingClassification interface for type StaticDeliveryAttributeMapping.
func (s *StaticDeliveryAttributeMapping) GetDeliveryAttributeMapping() *DeliveryAttributeMapping {
	return &DeliveryAttributeMapping{
		Name: s.Name,
		Type: s.Type,
	}
}

// StaticDeliveryAttributeMappingProperties - Properties of static delivery attribute mapping.
type StaticDeliveryAttributeMappingProperties struct {
	// Boolean flag to tell if the attribute contains sensitive information .
	IsSecret *bool

	// Value of the delivery attribute.
	Value *string
}

// StaticRoutingEnrichment - Static routing enrichment details.
type StaticRoutingEnrichment struct {
	// REQUIRED; Static routing enrichment value type. For e.g. this property value can be 'String'.
	ValueType *StaticRoutingEnrichmentType

	// Static routing enrichment key.
	Key *string
}

// GetStaticRoutingEnrichment implements the StaticRoutingEnrichmentClassification interface for type StaticRoutingEnrichment.
func (s *StaticRoutingEnrichment) GetStaticRoutingEnrichment() *StaticRoutingEnrichment { return s }

type StaticStringRoutingEnrichment struct {
	// REQUIRED; Static routing enrichment value type. For e.g. this property value can be 'String'.
	ValueType *StaticRoutingEnrichmentType

	// Static routing enrichment key.
	Key *string

	// String type routing enrichment value.
	Value *string
}

// GetStaticRoutingEnrichment implements the StaticRoutingEnrichmentClassification interface for type StaticStringRoutingEnrichment.
func (s *StaticStringRoutingEnrichment) GetStaticRoutingEnrichment() *StaticRoutingEnrichment {
	return &StaticRoutingEnrichment{
		Key:       s.Key,
		ValueType: s.ValueType,
	}
}

// StorageBlobDeadLetterDestination - Information about the storage blob based dead letter destination.
type StorageBlobDeadLetterDestination struct {
	// REQUIRED; Type of the endpoint for the dead letter destination
	EndpointType *DeadLetterEndPointType

	// The properties of the Storage Blob based deadletter destination
	Properties *StorageBlobDeadLetterDestinationProperties
}

// GetDeadLetterDestination implements the DeadLetterDestinationClassification interface for type StorageBlobDeadLetterDestination.
func (s *StorageBlobDeadLetterDestination) GetDeadLetterDestination() *DeadLetterDestination {
	return &DeadLetterDestination{
		EndpointType: s.EndpointType,
	}
}

// StorageBlobDeadLetterDestinationProperties - Properties of the storage blob based dead letter destination.
type StorageBlobDeadLetterDestinationProperties struct {
	// The name of the Storage blob container that is the destination of the deadletter events
	BlobContainerName *string

	// The Azure Resource ID of the storage account that is the destination of the deadletter events
	ResourceID *string
}

// StorageQueueEventSubscriptionDestination - Information about the storage queue destination for an event subscription.
type StorageQueueEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// Storage Queue Properties of the event subscription destination.
	Properties *StorageQueueEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type StorageQueueEventSubscriptionDestination.
func (s *StorageQueueEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: s.EndpointType,
	}
}

// StorageQueueEventSubscriptionDestinationProperties - The properties for a storage queue destination.
type StorageQueueEventSubscriptionDestinationProperties struct {
	// Storage queue message time to live in seconds. This value cannot be zero or negative with the exception of using -1 to
	// indicate that the Time To Live of the message is Infinite.
	QueueMessageTimeToLiveInSeconds *int64

	// The name of the Storage queue under a storage account that is the destination of an event subscription.
	QueueName *string

	// The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
	ResourceID *string
}

// StringBeginsWithAdvancedFilter - StringBeginsWith Advanced Filter.
type StringBeginsWithAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringBeginsWithAdvancedFilter.
func (s *StringBeginsWithAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringBeginsWithFilter - StringBeginsWith Filter.
type StringBeginsWithFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetFilter implements the FilterClassification interface for type StringBeginsWithFilter.
func (s *StringBeginsWithFilter) GetFilter() *Filter {
	return &Filter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringContainsAdvancedFilter - StringContains Advanced Filter.
type StringContainsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringContainsAdvancedFilter.
func (s *StringContainsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringContainsFilter - StringContains Filter.
type StringContainsFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetFilter implements the FilterClassification interface for type StringContainsFilter.
func (s *StringContainsFilter) GetFilter() *Filter {
	return &Filter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringEndsWithAdvancedFilter - StringEndsWith Advanced Filter.
type StringEndsWithAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringEndsWithAdvancedFilter.
func (s *StringEndsWithAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringEndsWithFilter - StringEndsWith Filter.
type StringEndsWithFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetFilter implements the FilterClassification interface for type StringEndsWithFilter.
func (s *StringEndsWithFilter) GetFilter() *Filter {
	return &Filter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringInAdvancedFilter - StringIn Advanced Filter.
type StringInAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringInAdvancedFilter.
func (s *StringInAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringInFilter - StringIn Filter.
type StringInFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetFilter implements the FilterClassification interface for type StringInFilter.
func (s *StringInFilter) GetFilter() *Filter {
	return &Filter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringNotBeginsWithAdvancedFilter - StringNotBeginsWith Advanced Filter.
type StringNotBeginsWithAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringNotBeginsWithAdvancedFilter.
func (s *StringNotBeginsWithAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringNotBeginsWithFilter - StringNotBeginsWith Filter.
type StringNotBeginsWithFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetFilter implements the FilterClassification interface for type StringNotBeginsWithFilter.
func (s *StringNotBeginsWithFilter) GetFilter() *Filter {
	return &Filter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringNotContainsAdvancedFilter - StringNotContains Advanced Filter.
type StringNotContainsAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringNotContainsAdvancedFilter.
func (s *StringNotContainsAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringNotContainsFilter - StringNotContains Filter.
type StringNotContainsFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetFilter implements the FilterClassification interface for type StringNotContainsFilter.
func (s *StringNotContainsFilter) GetFilter() *Filter {
	return &Filter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringNotEndsWithAdvancedFilter - StringNotEndsWith Advanced Filter.
type StringNotEndsWithAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringNotEndsWithAdvancedFilter.
func (s *StringNotEndsWithAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringNotEndsWithFilter - StringNotEndsWith Filter.
type StringNotEndsWithFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetFilter implements the FilterClassification interface for type StringNotEndsWithFilter.
func (s *StringNotEndsWithFilter) GetFilter() *Filter {
	return &Filter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringNotInAdvancedFilter - StringNotIn Advanced Filter.
type StringNotInAdvancedFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *AdvancedFilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetAdvancedFilter implements the AdvancedFilterClassification interface for type StringNotInAdvancedFilter.
func (s *StringNotInAdvancedFilter) GetAdvancedFilter() *AdvancedFilter {
	return &AdvancedFilter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// StringNotInFilter - StringNotIn Filter.
type StringNotInFilter struct {
	// REQUIRED; The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
	OperatorType *FilterOperatorType

	// The field/property in the event based on which you want to filter.
	Key *string

	// The set of filter values.
	Values []*string
}

// GetFilter implements the FilterClassification interface for type StringNotInFilter.
func (s *StringNotInFilter) GetFilter() *Filter {
	return &Filter{
		Key:          s.Key,
		OperatorType: s.OperatorType,
	}
}

// Subscription - Event Subscription.
type Subscription struct {
	// Properties of the event subscription.
	Properties *SubscriptionProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Event Subscription resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// SubscriptionFullURL - Full endpoint URL of an event subscription
type SubscriptionFullURL struct {
	// The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string
}

// SubscriptionProperties - Properties of the event subscription.
type SubscriptionProperties struct {
	// Information about the delivery configuration of the event subscription.
	DeliveryConfiguration *DeliveryConfiguration

	// The event delivery schema for the event subscription.
	EventDeliverySchema *DeliverySchema

	// Expiration time of the event subscription.
	ExpirationTimeUTC *time.Time

	// Information about the filter for the event subscription.
	FiltersConfiguration *FiltersConfiguration

	// READ-ONLY; Provisioning state of the event subscription.
	ProvisioningState *SubscriptionProvisioningState
}

// SubscriptionUpdateParameters - Properties of the Event Subscription update.
type SubscriptionUpdateParameters struct {
	// Properties of the Event Subscription update parameters.
	Properties *SubscriptionUpdateParametersProperties
}

// SubscriptionUpdateParametersProperties - Properties of the Event Subscription update parameters.
type SubscriptionUpdateParametersProperties struct {
	// Information about the delivery configuration of the event subscription.
	DeliveryConfiguration *DeliveryConfiguration

	// The event delivery schema for the event subscription.
	EventDeliverySchema *DeliverySchema

	// Expiration time of the event subscription.
	ExpirationTimeUTC *time.Time

	// Information about the filter for the event subscription.
	FiltersConfiguration *FiltersConfiguration
}

// SubscriptionsListResult - Result of the List event subscriptions operation.
type SubscriptionsListResult struct {
	// A link for the next page of event subscriptions
	NextLink *string

	// A collection of Subscriptions.
	Value []*Subscription
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// SystemTopic - EventGrid System Topic.
type SystemTopic struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Identity information for the resource.
	Identity *IdentityInfo

	// Properties of the system topic.
	Properties *SystemTopicProperties

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to System Topic resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// SystemTopicProperties - Properties of the System Topic.
type SystemTopicProperties struct {
	// Source for the system topic.
	Source *string

	// TopicType for the system topic.
	TopicType *string

	// READ-ONLY; Metric resource id for the system topic.
	MetricResourceID *string

	// READ-ONLY; Provisioning state of the system topic.
	ProvisioningState *ResourceProvisioningState
}

// SystemTopicUpdateParameters - Properties of the System Topic update.
type SystemTopicUpdateParameters struct {
	// Resource identity information.
	Identity *IdentityInfo

	// Tags of the system topic.
	Tags map[string]*string
}

// SystemTopicsListResult - Result of the List System topics operation.
type SystemTopicsListResult struct {
	// A link for the next page of topics.
	NextLink *string

	// A collection of system Topics.
	Value []*SystemTopic
}

// Topic - EventGrid Topic
type Topic struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Extended location of the resource.
	ExtendedLocation *ExtendedLocation

	// Identity information for the resource.
	Identity *IdentityInfo

	// Kind of the resource.
	Kind *ResourceKind

	// Properties of the topic.
	Properties *TopicProperties

	// The Sku pricing tier for the topic.
	SKU *ResourceSKU

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Topic resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// TopicProperties - Properties of the Topic.
type TopicProperties struct {
	// Data Residency Boundary of the resource.
	DataResidencyBoundary *DataResidencyBoundary

	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the topic.
	DisableLocalAuth *bool

	// Event Type Information for the user topic. This information is provided by the publisher and can be used by the subscriber
	// to view different types of events that are published.
	EventTypeInfo *EventTypeInfo

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule

	// This determines the format that Event Grid should expect for incoming events published to the topic.
	InputSchema *InputSchema

	// This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of
	// a source schema to various required properties of the EventGridEvent schema.
	InputSchemaMapping InputSchemaMappingClassification

	// Minimum TLS version of the publisher allowed to publish to this topic
	MinimumTLSVersionAllowed *TLSVersion

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess

	// READ-ONLY; Endpoint for the topic.
	Endpoint *string

	// READ-ONLY; Metric resource id for the topic.
	MetricResourceID *string

	// READ-ONLY; List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Provisioning state of the topic.
	ProvisioningState *TopicProvisioningState
}

// TopicRegenerateKeyRequest - Topic regenerate share access key request
type TopicRegenerateKeyRequest struct {
	// REQUIRED; Key name to regenerate key1 or key2
	KeyName *string
}

// TopicSharedAccessKeys - Shared access keys of the Topic
type TopicSharedAccessKeys struct {
	// Shared access key1 for the topic.
	Key1 *string

	// Shared access key2 for the topic.
	Key2 *string
}

// TopicSpace - The Topic space resource.
type TopicSpace struct {
	// The properties of topic space.
	Properties *TopicSpaceProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to the TopicSpace resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// TopicSpaceProperties - The properties of topic space.
type TopicSpaceProperties struct {
	// Description for the Topic Space resource.
	Description *string

	// The topic filters in the topic space. Example: "topicTemplates": [ "devices/foo/bar", "devices/topic1/+", "devices/${principal.name}/${principal.attributes.keyName}"
	// ].
	TopicTemplates []*string

	// READ-ONLY; Provisioning state of the TopicSpace resource.
	ProvisioningState *TopicSpaceProvisioningState
}

// TopicSpacesConfiguration - Properties of the Topic Spaces Configuration.
type TopicSpacesConfiguration struct {
	// Client authentication settings for topic spaces configuration.
	ClientAuthentication *ClientAuthenticationSettings

	// List of custom domain configurations for the namespace.
	CustomDomains []*CustomDomainConfiguration

	// The maximum number of sessions per authentication name. The property default value is 1. Min allowed value is 1 and max
	// allowed value is 100.
	MaximumClientSessionsPerAuthenticationName *int32

	// The maximum session expiry in hours. The property default value is 1 hour. Min allowed value is 1 hour and max allowed
	// value is 8 hours.
	MaximumSessionExpiryInHours *int32

	// Fully qualified Azure Resource Id for the Event Grid Topic to which events will be routed to from TopicSpaces under a namespace.
	// This property should be in the following format
	// '/subscriptions/{subId}/resourcegroups/{resourceGroupName}/providers/microsoft.EventGrid/topics/{topicName}'. This topic
	// should reside in the same region where namespace is located.
	RouteTopicResourceID *string

	// Routing enrichments for topic spaces configuration
	RoutingEnrichments *RoutingEnrichments

	// Routing identity info for topic spaces configuration.
	RoutingIdentityInfo *RoutingIdentityInfo

	// Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
	State *TopicSpacesConfigurationState

	// READ-ONLY; The endpoint for the topic spaces configuration. This is a read-only property.
	Hostname *string
}

// TopicSpacesListResult - Result of the List Topic Space operation.
type TopicSpacesListResult struct {
	// A link for the next page of Topic Space.
	NextLink *string

	// A collection of Topic Space.
	Value []*TopicSpace
}

type TopicTypeAdditionalEnforcedPermission struct {
	IsDataAction   *bool
	PermissionName *string
}

// TopicTypeInfo - Properties of a topic type info.
type TopicTypeInfo struct {
	// Properties of the topic type info
	Properties *TopicTypeProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// TopicTypeProperties - Properties of a topic type.
type TopicTypeProperties struct {
	// Permissions which are enforced for creating and updating system topics of this this topic type.
	AdditionalEnforcedPermissions []*TopicTypeAdditionalEnforcedPermission

	// Flag to indicate that a topic type can support both regional or global system topics.
	AreRegionalAndGlobalSourcesSupported *bool

	// Description of the topic type.
	Description *string

	// Display Name for the topic type.
	DisplayName *string

	// Namespace of the provider of the topic type.
	Provider *string

	// Provisioning state of the topic type.
	ProvisioningState *TopicTypeProvisioningState

	// Region type of the resource.
	ResourceRegionType *ResourceRegionType

	// Source resource format.
	SourceResourceFormat *string

	// List of locations supported by this topic type.
	SupportedLocations []*string

	// Supported source scopes.
	SupportedScopesForSource []*TopicTypeSourceScope
}

// TopicTypesListResult - Result of the List Topic Types operation
type TopicTypesListResult struct {
	// A collection of topic types
	Value []*TopicTypeInfo
}

// TopicUpdateParameterProperties - Information of topic update parameter properties.
type TopicUpdateParameterProperties struct {
	// The data residency boundary for the topic.
	DataResidencyBoundary *DataResidencyBoundary

	// This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD
	// token will be used to authenticate if user is allowed to publish to the topic.
	DisableLocalAuth *bool

	// The eventTypeInfo for the topic.
	EventTypeInfo *EventTypeInfo

	// This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess
	// is enabled.
	InboundIPRules []*InboundIPRule

	// Minimum TLS version of the publisher allowed to publish to this domain
	MinimumTLSVersionAllowed *TLSVersion

	// This determines if traffic is allowed over public network. By default it is enabled. You can further restrict to specific
	// IPs by configuring
	PublicNetworkAccess *PublicNetworkAccess
}

// TopicUpdateParameters - Properties of the Topic update
type TopicUpdateParameters struct {
	// Topic resource identity information.
	Identity *IdentityInfo

	// Properties of the Topic resource.
	Properties *TopicUpdateParameterProperties

	// The Sku pricing tier for the topic.
	SKU *ResourceSKU

	// Tags of the Topic resource.
	Tags map[string]*string
}

// TopicsConfiguration - Properties of the Topics Configuration.
type TopicsConfiguration struct {
	// List of custom domain configurations for the namespace.
	CustomDomains []*CustomDomainConfiguration

	// READ-ONLY; The hostname for the topics configuration. This is a read-only property.
	Hostname *string
}

// TopicsListResult - Result of the List Topics operation
type TopicsListResult struct {
	// A link for the next page of topics
	NextLink *string

	// A collection of Topics
	Value []*Topic
}

// TrackedResource - Definition of a Tracked Resource.
type TrackedResource struct {
	// REQUIRED; Location of the resource.
	Location *string

	// Tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// UpdateTopicSpacesConfigurationInfo - Properties of the topic spaces configuration info of a namespace.
type UpdateTopicSpacesConfigurationInfo struct {
	// Client authentication settings for topic spaces configuration.
	ClientAuthentication *ClientAuthenticationSettings

	// Custom domain info for topic spaces configuration.
	CustomDomains []*CustomDomainConfiguration

	// The maximum number of sessions per authentication name. The property default value is 1. Min allowed value is 1 and max
	// allowed value is 100.
	MaximumClientSessionsPerAuthenticationName *int32

	// The maximum session expiry in hours. The property default value is 1 hour. Min allowed value is 1 hour and max allowed
	// value is 8 hours.
	MaximumSessionExpiryInHours *int32

	// This property is used to specify custom topic to which events will be routed to from topic spaces configuration under namespace.
	RouteTopicResourceID *string

	// Routing enrichments for topic spaces configuration.
	RoutingEnrichments *RoutingEnrichments

	// Routing identity info for topic spaces configuration.
	RoutingIdentityInfo *RoutingIdentityInfo

	// Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
	State *TopicSpacesConfigurationState
}

// UpdateTopicsConfigurationInfo - Properties of the topics configuration info of a namespace.
type UpdateTopicsConfigurationInfo struct {
	// Custom domain info for topics configuration.
	CustomDomains []*CustomDomainConfiguration
}

// UserIdentityProperties - The information about the user identity.
type UserIdentityProperties struct {
	// The client id of user assigned identity.
	ClientID *string

	// The principal id of user assigned identity.
	PrincipalID *string
}

// VerifiedPartner - Verified partner information
type VerifiedPartner struct {
	// Properties of the verified partner.
	Properties *VerifiedPartnerProperties

	// READ-ONLY; Fully qualified identifier of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The system metadata relating to Verified Partner resource.
	SystemData *SystemData

	// READ-ONLY; Type of the resource.
	Type *string
}

// VerifiedPartnerProperties - Properties of the verified partner.
type VerifiedPartnerProperties struct {
	// Official name of the Partner.
	OrganizationName *string

	// Details of the partner destination scenario.
	PartnerDestinationDetails *PartnerDetails

	// Display name of the verified partner.
	PartnerDisplayName *string

	// ImmutableId of the corresponding partner registration.
	PartnerRegistrationImmutableID *string

	// Details of the partner topic scenario.
	PartnerTopicDetails *PartnerDetails

	// Provisioning state of the verified partner.
	ProvisioningState *VerifiedPartnerProvisioningState
}

// VerifiedPartnersListResult - Result of the List verified partners operation
type VerifiedPartnersListResult struct {
	// A link for the next page of verified partners if any.
	NextLink *string

	// A collection of verified partners.
	Value []*VerifiedPartner
}

// WebHookEventSubscriptionDestination - Information about the webhook destination for an event subscription.
type WebHookEventSubscriptionDestination struct {
	// REQUIRED; Type of the endpoint for the event subscription destination.
	EndpointType *EndpointType

	// WebHook Properties of the event subscription destination.
	Properties *WebHookEventSubscriptionDestinationProperties
}

// GetEventSubscriptionDestination implements the EventSubscriptionDestinationClassification interface for type WebHookEventSubscriptionDestination.
func (w *WebHookEventSubscriptionDestination) GetEventSubscriptionDestination() *EventSubscriptionDestination {
	return &EventSubscriptionDestination{
		EndpointType: w.EndpointType,
	}
}

// WebHookEventSubscriptionDestinationProperties - Information about the webhook destination properties for an event subscription.
type WebHookEventSubscriptionDestinationProperties struct {
	// The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery
	// requests.
	AzureActiveDirectoryApplicationIDOrURI *string

	// The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
	AzureActiveDirectoryTenantID *string

	// Delivery attribute details.
	DeliveryAttributeMappings []DeliveryAttributeMappingClassification

	// The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string

	// Maximum number of events per batch.
	MaxEventsPerBatch *int32

	// Minimum TLS version that should be supported by webhook endpoint
	MinimumTLSVersionAllowed *TLSVersion

	// Preferred batch size in Kilobytes.
	PreferredBatchSizeInKilobytes *int32

	// READ-ONLY; The base URL that represents the endpoint of the destination of an event subscription.
	EndpointBaseURL *string
}

// WebhookPartnerDestinationInfo - Information about the WebHook of the partner destination.
type WebhookPartnerDestinationInfo struct {
	// REQUIRED; Type of the endpoint for the partner destination
	EndpointType *PartnerEndpointType

	// Azure subscription ID of the subscriber. The partner destination associated with the channel will be created under this
	// Azure subscription.
	AzureSubscriptionID *string

	// Additional context of the partner destination endpoint.
	EndpointServiceContext *string

	// Name of the partner destination associated with the channel.
	Name *string

	// WebHook Properties of the partner destination.
	Properties *WebhookPartnerDestinationProperties

	// Azure Resource Group of the subscriber. The partner destination associated with the channel will be created under this
	// resource group.
	ResourceGroupName *string

	// Change history of the resource move.
	ResourceMoveChangeHistory []*ResourceMoveChangeHistory
}

// GetPartnerDestinationInfo implements the PartnerDestinationInfoClassification interface for type WebhookPartnerDestinationInfo.
func (w *WebhookPartnerDestinationInfo) GetPartnerDestinationInfo() *PartnerDestinationInfo {
	return &PartnerDestinationInfo{
		AzureSubscriptionID:       w.AzureSubscriptionID,
		EndpointServiceContext:    w.EndpointServiceContext,
		EndpointType:              w.EndpointType,
		Name:                      w.Name,
		ResourceGroupName:         w.ResourceGroupName,
		ResourceMoveChangeHistory: w.ResourceMoveChangeHistory,
	}
}

// WebhookPartnerDestinationProperties - Properties of a partner destination webhook.
type WebhookPartnerDestinationProperties struct {
	// Partner client authentication
	ClientAuthentication PartnerClientAuthenticationClassification

	// The base URL that represents the endpoint of the partner destination.
	EndpointBaseURL *string

	// The URL that represents the endpoint of the partner destination.
	EndpointURL *string
}

// WebhookUpdatePartnerDestinationInfo - Information about the update of the WebHook of the partner destination.
type WebhookUpdatePartnerDestinationInfo struct {
	// REQUIRED; Type of the endpoint for the partner destination
	EndpointType *PartnerEndpointType

	// WebHook Properties of the partner destination.
	Properties *WebhookPartnerDestinationProperties
}

// GetPartnerUpdateDestinationInfo implements the PartnerUpdateDestinationInfoClassification interface for type WebhookUpdatePartnerDestinationInfo.
func (w *WebhookUpdatePartnerDestinationInfo) GetPartnerUpdateDestinationInfo() *PartnerUpdateDestinationInfo {
	return &PartnerUpdateDestinationInfo{
		EndpointType: w.EndpointType,
	}
}
