//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hardwaresecuritymodules/armhardwaresecuritymodules/v2"
	"net/http"
	"net/url"
	"regexp"
)

// CloudHsmClusterPrivateLinkResourcesServer is a fake server for instances of the armhardwaresecuritymodules.CloudHsmClusterPrivateLinkResourcesClient type.
type CloudHsmClusterPrivateLinkResourcesServer struct {
	// ListByCloudHsmCluster is the fake for method CloudHsmClusterPrivateLinkResourcesClient.ListByCloudHsmCluster
	// HTTP status codes to indicate success: http.StatusOK
	ListByCloudHsmCluster func(ctx context.Context, resourceGroupName string, cloudHsmClusterName string, options *armhardwaresecuritymodules.CloudHsmClusterPrivateLinkResourcesClientListByCloudHsmClusterOptions) (resp azfake.Responder[armhardwaresecuritymodules.CloudHsmClusterPrivateLinkResourcesClientListByCloudHsmClusterResponse], errResp azfake.ErrorResponder)
}

// NewCloudHsmClusterPrivateLinkResourcesServerTransport creates a new instance of CloudHsmClusterPrivateLinkResourcesServerTransport with the provided implementation.
// The returned CloudHsmClusterPrivateLinkResourcesServerTransport instance is connected to an instance of armhardwaresecuritymodules.CloudHsmClusterPrivateLinkResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCloudHsmClusterPrivateLinkResourcesServerTransport(srv *CloudHsmClusterPrivateLinkResourcesServer) *CloudHsmClusterPrivateLinkResourcesServerTransport {
	return &CloudHsmClusterPrivateLinkResourcesServerTransport{srv: srv}
}

// CloudHsmClusterPrivateLinkResourcesServerTransport connects instances of armhardwaresecuritymodules.CloudHsmClusterPrivateLinkResourcesClient to instances of CloudHsmClusterPrivateLinkResourcesServer.
// Don't use this type directly, use NewCloudHsmClusterPrivateLinkResourcesServerTransport instead.
type CloudHsmClusterPrivateLinkResourcesServerTransport struct {
	srv *CloudHsmClusterPrivateLinkResourcesServer
}

// Do implements the policy.Transporter interface for CloudHsmClusterPrivateLinkResourcesServerTransport.
func (c *CloudHsmClusterPrivateLinkResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CloudHsmClusterPrivateLinkResourcesClient.ListByCloudHsmCluster":
		resp, err = c.dispatchListByCloudHsmCluster(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CloudHsmClusterPrivateLinkResourcesServerTransport) dispatchListByCloudHsmCluster(req *http.Request) (*http.Response, error) {
	if c.srv.ListByCloudHsmCluster == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByCloudHsmCluster not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HardwareSecurityModules/cloudHsmClusters/(?P<cloudHsmClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	cloudHsmClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cloudHsmClusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.ListByCloudHsmCluster(req.Context(), resourceGroupNameParam, cloudHsmClusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkResourceListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
