//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridcontainerservice/armhybridcontainerservice"
	"net/http"
	"net/url"
	"regexp"
)

// ProvisionedClusterInstancesServer is a fake server for instances of the armhybridcontainerservice.ProvisionedClusterInstancesClient type.
type ProvisionedClusterInstancesServer struct {
	// BeginCreateOrUpdate is the fake for method ProvisionedClusterInstancesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, connectedClusterResourceURI string, provisionedClusterInstance armhybridcontainerservice.ProvisionedCluster, options *armhybridcontainerservice.ProvisionedClusterInstancesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ProvisionedClusterInstancesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, connectedClusterResourceURI string, options *armhybridcontainerservice.ProvisionedClusterInstancesClientBeginDeleteOptions) (resp azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ProvisionedClusterInstancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, connectedClusterResourceURI string, options *armhybridcontainerservice.ProvisionedClusterInstancesClientGetOptions) (resp azfake.Responder[armhybridcontainerservice.ProvisionedClusterInstancesClientGetResponse], errResp azfake.ErrorResponder)

	// GetUpgradeProfile is the fake for method ProvisionedClusterInstancesClient.GetUpgradeProfile
	// HTTP status codes to indicate success: http.StatusOK
	GetUpgradeProfile func(ctx context.Context, connectedClusterResourceURI string, options *armhybridcontainerservice.ProvisionedClusterInstancesClientGetUpgradeProfileOptions) (resp azfake.Responder[armhybridcontainerservice.ProvisionedClusterInstancesClientGetUpgradeProfileResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ProvisionedClusterInstancesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(connectedClusterResourceURI string, options *armhybridcontainerservice.ProvisionedClusterInstancesClientListOptions) (resp azfake.PagerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListResponse])

	// BeginListAdminKubeconfig is the fake for method ProvisionedClusterInstancesClient.BeginListAdminKubeconfig
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListAdminKubeconfig func(ctx context.Context, connectedClusterResourceURI string, options *armhybridcontainerservice.ProvisionedClusterInstancesClientBeginListAdminKubeconfigOptions) (resp azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListAdminKubeconfigResponse], errResp azfake.ErrorResponder)

	// BeginListUserKubeconfig is the fake for method ProvisionedClusterInstancesClient.BeginListUserKubeconfig
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListUserKubeconfig func(ctx context.Context, connectedClusterResourceURI string, options *armhybridcontainerservice.ProvisionedClusterInstancesClientBeginListUserKubeconfigOptions) (resp azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListUserKubeconfigResponse], errResp azfake.ErrorResponder)
}

// NewProvisionedClusterInstancesServerTransport creates a new instance of ProvisionedClusterInstancesServerTransport with the provided implementation.
// The returned ProvisionedClusterInstancesServerTransport instance is connected to an instance of armhybridcontainerservice.ProvisionedClusterInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProvisionedClusterInstancesServerTransport(srv *ProvisionedClusterInstancesServer) *ProvisionedClusterInstancesServerTransport {
	return &ProvisionedClusterInstancesServerTransport{
		srv:                      srv,
		beginCreateOrUpdate:      newTracker[azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientCreateOrUpdateResponse]](),
		beginDelete:              newTracker[azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientDeleteResponse]](),
		newListPager:             newTracker[azfake.PagerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListResponse]](),
		beginListAdminKubeconfig: newTracker[azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListAdminKubeconfigResponse]](),
		beginListUserKubeconfig:  newTracker[azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListUserKubeconfigResponse]](),
	}
}

// ProvisionedClusterInstancesServerTransport connects instances of armhybridcontainerservice.ProvisionedClusterInstancesClient to instances of ProvisionedClusterInstancesServer.
// Don't use this type directly, use NewProvisionedClusterInstancesServerTransport instead.
type ProvisionedClusterInstancesServerTransport struct {
	srv                      *ProvisionedClusterInstancesServer
	beginCreateOrUpdate      *tracker[azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientCreateOrUpdateResponse]]
	beginDelete              *tracker[azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientDeleteResponse]]
	newListPager             *tracker[azfake.PagerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListResponse]]
	beginListAdminKubeconfig *tracker[azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListAdminKubeconfigResponse]]
	beginListUserKubeconfig  *tracker[azfake.PollerResponder[armhybridcontainerservice.ProvisionedClusterInstancesClientListUserKubeconfigResponse]]
}

// Do implements the policy.Transporter interface for ProvisionedClusterInstancesServerTransport.
func (p *ProvisionedClusterInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProvisionedClusterInstancesClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "ProvisionedClusterInstancesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "ProvisionedClusterInstancesClient.Get":
		resp, err = p.dispatchGet(req)
	case "ProvisionedClusterInstancesClient.GetUpgradeProfile":
		resp, err = p.dispatchGetUpgradeProfile(req)
	case "ProvisionedClusterInstancesClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	case "ProvisionedClusterInstancesClient.BeginListAdminKubeconfig":
		resp, err = p.dispatchBeginListAdminKubeconfig(req)
	case "ProvisionedClusterInstancesClient.BeginListUserKubeconfig":
		resp, err = p.dispatchBeginListUserKubeconfig(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProvisionedClusterInstancesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhybridcontainerservice.ProvisionedCluster](req)
		if err != nil {
			return nil, err
		}
		connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), connectedClusterResourceURIParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *ProvisionedClusterInstancesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), connectedClusterResourceURIParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *ProvisionedClusterInstancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), connectedClusterResourceURIParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProvisionedCluster, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProvisionedClusterInstancesServerTransport) dispatchGetUpgradeProfile(req *http.Request) (*http.Response, error) {
	if p.srv.GetUpgradeProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetUpgradeProfile not implemented")}
	}
	const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default/upgradeProfiles/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetUpgradeProfile(req.Context(), connectedClusterResourceURIParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProvisionedClusterUpgradeProfile, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProvisionedClusterInstancesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(connectedClusterResourceURIParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armhybridcontainerservice.ProvisionedClusterInstancesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}

func (p *ProvisionedClusterInstancesServerTransport) dispatchBeginListAdminKubeconfig(req *http.Request) (*http.Response, error) {
	if p.srv.BeginListAdminKubeconfig == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListAdminKubeconfig not implemented")}
	}
	beginListAdminKubeconfig := p.beginListAdminKubeconfig.get(req)
	if beginListAdminKubeconfig == nil {
		const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default/listAdminKubeconfig`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginListAdminKubeconfig(req.Context(), connectedClusterResourceURIParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListAdminKubeconfig = &respr
		p.beginListAdminKubeconfig.add(req, beginListAdminKubeconfig)
	}

	resp, err := server.PollerResponderNext(beginListAdminKubeconfig, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginListAdminKubeconfig.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListAdminKubeconfig) {
		p.beginListAdminKubeconfig.remove(req)
	}

	return resp, nil
}

func (p *ProvisionedClusterInstancesServerTransport) dispatchBeginListUserKubeconfig(req *http.Request) (*http.Response, error) {
	if p.srv.BeginListUserKubeconfig == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListUserKubeconfig not implemented")}
	}
	beginListUserKubeconfig := p.beginListUserKubeconfig.get(req)
	if beginListUserKubeconfig == nil {
		const regexStr = `/(?P<connectedClusterResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/provisionedClusterInstances/default/listUserKubeconfig`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		connectedClusterResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedClusterResourceUri")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginListUserKubeconfig(req.Context(), connectedClusterResourceURIParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListUserKubeconfig = &respr
		p.beginListUserKubeconfig.add(req, beginListUserKubeconfig)
	}

	resp, err := server.PollerResponderNext(beginListUserKubeconfig, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginListUserKubeconfig.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListUserKubeconfig) {
		p.beginListUserKubeconfig.remove(req)
	}

	return resp, nil
}
