//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armhybridcontainerservice.ClientFactory type.
type ServerFactory struct {
	AgentPoolServer                   AgentPoolServer
	Server                            Server
	HybridIdentityMetadataServer      HybridIdentityMetadataServer
	KubernetesVersionsServer          KubernetesVersionsServer
	OperationsServer                  OperationsServer
	ProvisionedClusterInstancesServer ProvisionedClusterInstancesServer
	VMSKUsServer                      VMSKUsServer
	VirtualNetworksServer             VirtualNetworksServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armhybridcontainerservice.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armhybridcontainerservice.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                 *ServerFactory
	trMu                                sync.Mutex
	trAgentPoolServer                   *AgentPoolServerTransport
	trServer                            *ServerTransport
	trHybridIdentityMetadataServer      *HybridIdentityMetadataServerTransport
	trKubernetesVersionsServer          *KubernetesVersionsServerTransport
	trOperationsServer                  *OperationsServerTransport
	trProvisionedClusterInstancesServer *ProvisionedClusterInstancesServerTransport
	trVMSKUsServer                      *VMSKUsServerTransport
	trVirtualNetworksServer             *VirtualNetworksServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AgentPoolClient":
		initServer(s, &s.trAgentPoolServer, func() *AgentPoolServerTransport { return NewAgentPoolServerTransport(&s.srv.AgentPoolServer) })
		resp, err = s.trAgentPoolServer.Do(req)
	case "Client":
		initServer(s, &s.trServer, func() *ServerTransport { return NewServerTransport(&s.srv.Server) })
		resp, err = s.trServer.Do(req)
	case "HybridIdentityMetadataClient":
		initServer(s, &s.trHybridIdentityMetadataServer, func() *HybridIdentityMetadataServerTransport {
			return NewHybridIdentityMetadataServerTransport(&s.srv.HybridIdentityMetadataServer)
		})
		resp, err = s.trHybridIdentityMetadataServer.Do(req)
	case "KubernetesVersionsClient":
		initServer(s, &s.trKubernetesVersionsServer, func() *KubernetesVersionsServerTransport {
			return NewKubernetesVersionsServerTransport(&s.srv.KubernetesVersionsServer)
		})
		resp, err = s.trKubernetesVersionsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "ProvisionedClusterInstancesClient":
		initServer(s, &s.trProvisionedClusterInstancesServer, func() *ProvisionedClusterInstancesServerTransport {
			return NewProvisionedClusterInstancesServerTransport(&s.srv.ProvisionedClusterInstancesServer)
		})
		resp, err = s.trProvisionedClusterInstancesServer.Do(req)
	case "VMSKUsClient":
		initServer(s, &s.trVMSKUsServer, func() *VMSKUsServerTransport { return NewVMSKUsServerTransport(&s.srv.VMSKUsServer) })
		resp, err = s.trVMSKUsServer.Do(req)
	case "VirtualNetworksClient":
		initServer(s, &s.trVirtualNetworksServer, func() *VirtualNetworksServerTransport {
			return NewVirtualNetworksServerTransport(&s.srv.VirtualNetworksServer)
		})
		resp, err = s.trVirtualNetworksServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
