//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridcontainerservice/armhybridcontainerservice"
	"net/http"
	"net/url"
	"regexp"
)

// VMSKUsServer is a fake server for instances of the armhybridcontainerservice.VMSKUsClient type.
type VMSKUsServer struct {
	// NewListPager is the fake for method VMSKUsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(customLocationResourceURI string, options *armhybridcontainerservice.VMSKUsClientListOptions) (resp azfake.PagerResponder[armhybridcontainerservice.VMSKUsClientListResponse])
}

// NewVMSKUsServerTransport creates a new instance of VMSKUsServerTransport with the provided implementation.
// The returned VMSKUsServerTransport instance is connected to an instance of armhybridcontainerservice.VMSKUsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVMSKUsServerTransport(srv *VMSKUsServer) *VMSKUsServerTransport {
	return &VMSKUsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armhybridcontainerservice.VMSKUsClientListResponse]](),
	}
}

// VMSKUsServerTransport connects instances of armhybridcontainerservice.VMSKUsClient to instances of VMSKUsServer.
// Don't use this type directly, use NewVMSKUsServerTransport instead.
type VMSKUsServerTransport struct {
	srv          *VMSKUsServer
	newListPager *tracker[azfake.PagerResponder[armhybridcontainerservice.VMSKUsClientListResponse]]
}

// Do implements the policy.Transporter interface for VMSKUsServerTransport.
func (v *VMSKUsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VMSKUsClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VMSKUsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<customLocationResourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridContainerService/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		customLocationResourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("customLocationResourceUri")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(customLocationResourceURIParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armhybridcontainerservice.VMSKUsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}
