//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridnetwork/armhybridnetwork/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkFunctionDefinitionVersionDelete.json
func ExampleNetworkFunctionDefinitionVersionsClient_BeginDelete_deleteANetworkFunctionDefinitionVersion() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().BeginDelete(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/AzureCore/VirtualNetworkFunctionDefinitionVersionDelete.json
func ExampleNetworkFunctionDefinitionVersionsClient_BeginDelete_deleteANetworkFunctionDefinitionVersionForAzureCoreVnf() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().BeginDelete(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/AzureOperatorNexus/VirtualNetworkFunctionDefinitionVersionDelete.json
func ExampleNetworkFunctionDefinitionVersionsClient_BeginDelete_deleteANetworkFunctionDefinitionVersionForAzureOperatorNexusVnf() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().BeginDelete(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkFunctionDefinitionVersionCreate.json
func ExampleNetworkFunctionDefinitionVersionsClient_BeginCreateOrUpdate_createOrUpdateANetworkFunctionDefinitionVersionResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().BeginCreateOrUpdate(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", armhybridnetwork.NetworkFunctionDefinitionVersion{
		Location: to.Ptr("eastus"),
		Properties: &armhybridnetwork.ContainerizedNetworkFunctionDefinitionVersion{
			DeployParameters:    to.Ptr("{\"type\":\"object\",\"properties\":{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}}"),
			NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeContainerizedNetworkFunction),
			VersionState:        to.Ptr(armhybridnetwork.VersionStateActive),
			NetworkFunctionTemplate: &armhybridnetwork.AzureArcKubernetesNetworkFunctionTemplate{
				NfviType: to.Ptr(armhybridnetwork.ContainerizedNetworkFunctionNFVITypeAzureArcKubernetes),
				NetworkFunctionApplications: []armhybridnetwork.AzureArcKubernetesNetworkFunctionApplicationClassification{
					&armhybridnetwork.AzureArcKubernetesHelmApplication{
						Name: to.Ptr("fedrbac"),
						DependsOnProfile: &armhybridnetwork.DependsOnProfile{
							InstallDependsOn:   []*string{},
							UninstallDependsOn: []*string{},
							UpdateDependsOn:    []*string{},
						},
						ArtifactType: to.Ptr(armhybridnetwork.AzureArcKubernetesArtifactTypeHelmPackage),
						ArtifactProfile: &armhybridnetwork.AzureArcKubernetesArtifactProfile{
							ArtifactStore: &armhybridnetwork.ReferencedResource{
								ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore"),
							},
							HelmArtifactProfile: &armhybridnetwork.HelmArtifactProfile{
								HelmPackageName:         to.Ptr("fed-rbac"),
								HelmPackageVersionRange: to.Ptr("~2.1.3"),
								ImagePullSecretsValuesPaths: []*string{
									to.Ptr("global.imagePullSecrets")},
								RegistryValuesPaths: []*string{
									to.Ptr("global.registry.docker.repoPath")},
							},
						},
						DeployParametersMappingRuleProfile: &armhybridnetwork.AzureArcKubernetesDeployMappingRuleProfile{
							ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementEnabled),
							HelmMappingRuleProfile: &armhybridnetwork.HelmMappingRuleProfile{
								HelmPackageVersion: to.Ptr("2.1.3"),
								Options: &armhybridnetwork.HelmMappingRuleProfileOptions{
									InstallOptions: &armhybridnetwork.HelmInstallOptions{
										Atomic:  to.Ptr("true"),
										Timeout: to.Ptr("30"),
										Wait:    to.Ptr("waitValue"),
									},
									UpgradeOptions: &armhybridnetwork.HelmUpgradeOptions{
										Atomic:  to.Ptr("true"),
										Timeout: to.Ptr("30"),
										Wait:    to.Ptr("waitValue"),
									},
								},
								ReleaseName:      to.Ptr("{deployParameters.releaseName}"),
								ReleaseNamespace: to.Ptr("{deployParameters.namesapce}"),
								Values:           to.Ptr(""),
							},
						},
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkFunctionDefinitionVersion = armhybridnetwork.NetworkFunctionDefinitionVersion{
	// 	Name: to.Ptr("TestVersion"),
	// 	Type: to.Ptr("Microsoft.HybridNetwork/publishers/networkFunctionDefinitionGroups/networkFunctionDefinitionVersions"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkFunctionDefinitionGroups/TestNetworkFunctionDefinitionGroupName/networkFunctionDefinitionVersions/1.0.0"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armhybridnetwork.ContainerizedNetworkFunctionDefinitionVersion{
	// 		DeployParameters: to.Ptr("{\"type\":\"object\",\"properties\":{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}}"),
	// 		NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeContainerizedNetworkFunction),
	// 		VersionState: to.Ptr(armhybridnetwork.VersionStateActive),
	// 		NetworkFunctionTemplate: &armhybridnetwork.AzureArcKubernetesNetworkFunctionTemplate{
	// 			NfviType: to.Ptr(armhybridnetwork.ContainerizedNetworkFunctionNFVITypeAzureArcKubernetes),
	// 			NetworkFunctionApplications: []armhybridnetwork.AzureArcKubernetesNetworkFunctionApplicationClassification{
	// 				&armhybridnetwork.AzureArcKubernetesHelmApplication{
	// 					Name: to.Ptr("fedrbac"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 						},
	// 						UninstallDependsOn: []*string{
	// 						},
	// 						UpdateDependsOn: []*string{
	// 						},
	// 					},
	// 					ArtifactType: to.Ptr(armhybridnetwork.AzureArcKubernetesArtifactTypeHelmPackage),
	// 					ArtifactProfile: &armhybridnetwork.AzureArcKubernetesArtifactProfile{
	// 						ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/artifactStores/testStore"),
	// 						},
	// 						HelmArtifactProfile: &armhybridnetwork.HelmArtifactProfile{
	// 							HelmPackageName: to.Ptr("fed-rbac"),
	// 							HelmPackageVersionRange: to.Ptr("~2.1.3"),
	// 							ImagePullSecretsValuesPaths: []*string{
	// 								to.Ptr("global.imagePullSecrets")},
	// 								RegistryValuesPaths: []*string{
	// 									to.Ptr("global.registry.docker.repoPath")},
	// 								},
	// 							},
	// 							DeployParametersMappingRuleProfile: &armhybridnetwork.AzureArcKubernetesDeployMappingRuleProfile{
	// 								ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementEnabled),
	// 								HelmMappingRuleProfile: &armhybridnetwork.HelmMappingRuleProfile{
	// 									HelmPackageVersion: to.Ptr("2.1.3"),
	// 									Options: &armhybridnetwork.HelmMappingRuleProfileOptions{
	// 										InstallOptions: &armhybridnetwork.HelmInstallOptions{
	// 											Atomic: to.Ptr("true"),
	// 											Timeout: to.Ptr("30"),
	// 											Wait: to.Ptr("waitValue"),
	// 										},
	// 										UpgradeOptions: &armhybridnetwork.HelmUpgradeOptions{
	// 											Atomic: to.Ptr("true"),
	// 											Timeout: to.Ptr("30"),
	// 											Wait: to.Ptr("waitValue"),
	// 										},
	// 									},
	// 									ReleaseName: to.Ptr("{deployParameters.releaseName}"),
	// 									ReleaseNamespace: to.Ptr("{deployParameters.namesapce}"),
	// 									Values: to.Ptr(""),
	// 								},
	// 							},
	// 					}},
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/AzureCore/VirtualNetworkFunctionDefinitionVersionCreate.json
func ExampleNetworkFunctionDefinitionVersionsClient_BeginCreateOrUpdate_createOrUpdateANetworkFunctionDefinitionVersionResourceForAzureCoreVnf() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().BeginCreateOrUpdate(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", armhybridnetwork.NetworkFunctionDefinitionVersion{
		Location: to.Ptr("eastus"),
		Properties: &armhybridnetwork.VirtualNetworkFunctionDefinitionVersion{
			Description:         to.Ptr("test NFDV for AzureCore"),
			DeployParameters:    to.Ptr("{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}"),
			NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeVirtualNetworkFunction),
			VersionState:        to.Ptr(armhybridnetwork.VersionStatePreview),
			NetworkFunctionTemplate: &armhybridnetwork.AzureCoreNetworkFunctionTemplate{
				NfviType: to.Ptr(armhybridnetwork.VirtualNetworkFunctionNFVITypeAzureCore),
				NetworkFunctionApplications: []armhybridnetwork.AzureCoreNetworkFunctionApplicationClassification{
					&armhybridnetwork.AzureCoreNetworkFunctionVhdApplication{
						Name: to.Ptr("testImageRole"),
						DependsOnProfile: &armhybridnetwork.DependsOnProfile{
							InstallDependsOn:   []*string{},
							UninstallDependsOn: []*string{},
							UpdateDependsOn:    []*string{},
						},
						ArtifactType: to.Ptr(armhybridnetwork.AzureCoreArtifactTypeVhdImageFile),
						ArtifactProfile: &armhybridnetwork.AzureCoreVhdImageArtifactProfile{
							ArtifactStore: &armhybridnetwork.ReferencedResource{
								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
							},
							VhdArtifactProfile: &armhybridnetwork.VhdImageArtifactProfile{
								VhdName:    to.Ptr("test-image"),
								VhdVersion: to.Ptr("1-0-0"),
							},
						},
						DeployParametersMappingRuleProfile: &armhybridnetwork.AzureCoreVhdImageDeployMappingRuleProfile{
							ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
							VhdImageMappingRuleProfile: &armhybridnetwork.VhdImageMappingRuleProfile{
								UserConfiguration: to.Ptr(""),
							},
						},
					},
					&armhybridnetwork.AzureCoreNetworkFunctionArmTemplateApplication{
						Name: to.Ptr("testTemplateRole"),
						DependsOnProfile: &armhybridnetwork.DependsOnProfile{
							InstallDependsOn: []*string{
								to.Ptr("testImageRole")},
							UninstallDependsOn: []*string{
								to.Ptr("testImageRole")},
							UpdateDependsOn: []*string{
								to.Ptr("testImageRole")},
						},
						ArtifactType: to.Ptr(armhybridnetwork.AzureCoreArtifactTypeArmTemplate),
						ArtifactProfile: &armhybridnetwork.AzureCoreArmTemplateArtifactProfile{
							ArtifactStore: &armhybridnetwork.ReferencedResource{
								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
							},
							TemplateArtifactProfile: &armhybridnetwork.ArmTemplateArtifactProfile{
								TemplateName:    to.Ptr("test-template"),
								TemplateVersion: to.Ptr("1.0.0"),
							},
						},
						DeployParametersMappingRuleProfile: &armhybridnetwork.AzureCoreArmTemplateDeployMappingRuleProfile{
							ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
							TemplateMappingRuleProfile: &armhybridnetwork.ArmTemplateMappingRuleProfile{
								TemplateParameters: to.Ptr("{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}"),
							},
						},
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkFunctionDefinitionVersion = armhybridnetwork.NetworkFunctionDefinitionVersion{
	// 	Name: to.Ptr("TestVersion"),
	// 	Type: to.Ptr("Microsoft.HybridNetwork/publishers/networkFunctionDefinitionGroups/networkFunctionDefinitionVersions"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkFunctionDefinitionGroups/TestNetworkFunctionDefinitionGroupName/networkFunctionDefinitionVersions/1.0.0"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armhybridnetwork.VirtualNetworkFunctionDefinitionVersion{
	// 		Description: to.Ptr("test NFDV for AzureCore"),
	// 		DeployParameters: to.Ptr("{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}"),
	// 		NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeVirtualNetworkFunction),
	// 		VersionState: to.Ptr(armhybridnetwork.VersionStatePreview),
	// 		NetworkFunctionTemplate: &armhybridnetwork.AzureCoreNetworkFunctionTemplate{
	// 			NfviType: to.Ptr(armhybridnetwork.VirtualNetworkFunctionNFVITypeAzureCore),
	// 			NetworkFunctionApplications: []armhybridnetwork.AzureCoreNetworkFunctionApplicationClassification{
	// 				&armhybridnetwork.AzureCoreNetworkFunctionVhdApplication{
	// 					Name: to.Ptr("testImageRole"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 						},
	// 						UninstallDependsOn: []*string{
	// 						},
	// 						UpdateDependsOn: []*string{
	// 						},
	// 					},
	// 					ArtifactType: to.Ptr(armhybridnetwork.AzureCoreArtifactTypeVhdImageFile),
	// 					ArtifactProfile: &armhybridnetwork.AzureCoreVhdImageArtifactProfile{
	// 						ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
	// 						},
	// 						VhdArtifactProfile: &armhybridnetwork.VhdImageArtifactProfile{
	// 							VhdName: to.Ptr("test-image"),
	// 							VhdVersion: to.Ptr("1-0-0"),
	// 						},
	// 					},
	// 					DeployParametersMappingRuleProfile: &armhybridnetwork.AzureCoreVhdImageDeployMappingRuleProfile{
	// 						ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
	// 						VhdImageMappingRuleProfile: &armhybridnetwork.VhdImageMappingRuleProfile{
	// 							UserConfiguration: to.Ptr(""),
	// 						},
	// 					},
	// 				},
	// 				&armhybridnetwork.AzureCoreNetworkFunctionArmTemplateApplication{
	// 					Name: to.Ptr("testTemplateRole"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 							to.Ptr("testImageRole")},
	// 							UninstallDependsOn: []*string{
	// 								to.Ptr("testImageRole")},
	// 								UpdateDependsOn: []*string{
	// 									to.Ptr("testImageRole")},
	// 								},
	// 								ArtifactType: to.Ptr(armhybridnetwork.AzureCoreArtifactTypeArmTemplate),
	// 								ArtifactProfile: &armhybridnetwork.AzureCoreArmTemplateArtifactProfile{
	// 									ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
	// 									},
	// 									TemplateArtifactProfile: &armhybridnetwork.ArmTemplateArtifactProfile{
	// 										TemplateName: to.Ptr("test-template"),
	// 										TemplateVersion: to.Ptr("1.0.0"),
	// 									},
	// 								},
	// 								DeployParametersMappingRuleProfile: &armhybridnetwork.AzureCoreArmTemplateDeployMappingRuleProfile{
	// 									ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
	// 									TemplateMappingRuleProfile: &armhybridnetwork.ArmTemplateMappingRuleProfile{
	// 										TemplateParameters: to.Ptr("{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}"),
	// 									},
	// 								},
	// 						}},
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/AzureOperatorNexus/VirtualNetworkFunctionDefinitionVersionCreate.json
func ExampleNetworkFunctionDefinitionVersionsClient_BeginCreateOrUpdate_createOrUpdateANetworkFunctionDefinitionVersionResourceForAzureOperatorNexusVnf() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().BeginCreateOrUpdate(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", armhybridnetwork.NetworkFunctionDefinitionVersion{
		Location: to.Ptr("eastus"),
		Properties: &armhybridnetwork.VirtualNetworkFunctionDefinitionVersion{
			Description:         to.Ptr("test NFDV for AzureOperatorNexus"),
			DeployParameters:    to.Ptr("{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}"),
			NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeVirtualNetworkFunction),
			VersionState:        to.Ptr(armhybridnetwork.VersionStatePreview),
			NetworkFunctionTemplate: &armhybridnetwork.AzureOperatorNexusNetworkFunctionTemplate{
				NfviType: to.Ptr(armhybridnetwork.VirtualNetworkFunctionNFVITypeAzureOperatorNexus),
				NetworkFunctionApplications: []armhybridnetwork.AzureOperatorNexusNetworkFunctionApplicationClassification{
					&armhybridnetwork.AzureOperatorNexusNetworkFunctionImageApplication{
						Name: to.Ptr("testImageRole"),
						DependsOnProfile: &armhybridnetwork.DependsOnProfile{
							InstallDependsOn:   []*string{},
							UninstallDependsOn: []*string{},
							UpdateDependsOn:    []*string{},
						},
						ArtifactType: to.Ptr(armhybridnetwork.AzureOperatorNexusArtifactTypeImageFile),
						ArtifactProfile: &armhybridnetwork.AzureOperatorNexusImageArtifactProfile{
							ArtifactStore: &armhybridnetwork.ReferencedResource{
								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
							},
							ImageArtifactProfile: &armhybridnetwork.ImageArtifactProfile{
								ImageName:    to.Ptr("test-image"),
								ImageVersion: to.Ptr("1.0.0"),
							},
						},
						DeployParametersMappingRuleProfile: &armhybridnetwork.AzureOperatorNexusImageDeployMappingRuleProfile{
							ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
							ImageMappingRuleProfile: &armhybridnetwork.ImageMappingRuleProfile{
								UserConfiguration: to.Ptr(""),
							},
						},
					},
					&armhybridnetwork.AzureOperatorNexusNetworkFunctionArmTemplateApplication{
						Name: to.Ptr("testTemplateRole"),
						DependsOnProfile: &armhybridnetwork.DependsOnProfile{
							InstallDependsOn: []*string{
								to.Ptr("testImageRole")},
							UninstallDependsOn: []*string{
								to.Ptr("testImageRole")},
							UpdateDependsOn: []*string{
								to.Ptr("testImageRole")},
						},
						ArtifactType: to.Ptr(armhybridnetwork.AzureOperatorNexusArtifactTypeArmTemplate),
						ArtifactProfile: &armhybridnetwork.AzureOperatorNexusArmTemplateArtifactProfile{
							ArtifactStore: &armhybridnetwork.ReferencedResource{
								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
							},
							TemplateArtifactProfile: &armhybridnetwork.ArmTemplateArtifactProfile{
								TemplateName:    to.Ptr("test-template"),
								TemplateVersion: to.Ptr("1.0.0"),
							},
						},
						DeployParametersMappingRuleProfile: &armhybridnetwork.AzureOperatorNexusArmTemplateDeployMappingRuleProfile{
							ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
							TemplateMappingRuleProfile: &armhybridnetwork.ArmTemplateMappingRuleProfile{
								TemplateParameters: to.Ptr("{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}"),
							},
						},
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkFunctionDefinitionVersion = armhybridnetwork.NetworkFunctionDefinitionVersion{
	// 	Name: to.Ptr("TestVersion"),
	// 	Type: to.Ptr("Microsoft.HybridNetwork/publishers/networkFunctionDefinitionGroups/networkFunctionDefinitionVersions"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkFunctionDefinitionGroups/TestNetworkFunctionDefinitionGroupName/networkFunctionDefinitionVersions/1.0.0"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armhybridnetwork.VirtualNetworkFunctionDefinitionVersion{
	// 		Description: to.Ptr("test NFDV for AzureOperatorNexus"),
	// 		DeployParameters: to.Ptr("{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}"),
	// 		NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeVirtualNetworkFunction),
	// 		VersionState: to.Ptr(armhybridnetwork.VersionStatePreview),
	// 		NetworkFunctionTemplate: &armhybridnetwork.AzureOperatorNexusNetworkFunctionTemplate{
	// 			NfviType: to.Ptr(armhybridnetwork.VirtualNetworkFunctionNFVITypeAzureOperatorNexus),
	// 			NetworkFunctionApplications: []armhybridnetwork.AzureOperatorNexusNetworkFunctionApplicationClassification{
	// 				&armhybridnetwork.AzureOperatorNexusNetworkFunctionImageApplication{
	// 					Name: to.Ptr("testImageRole"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 						},
	// 						UninstallDependsOn: []*string{
	// 						},
	// 						UpdateDependsOn: []*string{
	// 						},
	// 					},
	// 					ArtifactType: to.Ptr(armhybridnetwork.AzureOperatorNexusArtifactTypeImageFile),
	// 					ArtifactProfile: &armhybridnetwork.AzureOperatorNexusImageArtifactProfile{
	// 						ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
	// 						},
	// 						ImageArtifactProfile: &armhybridnetwork.ImageArtifactProfile{
	// 							ImageName: to.Ptr("test-image"),
	// 							ImageVersion: to.Ptr("1.0.0"),
	// 						},
	// 					},
	// 					DeployParametersMappingRuleProfile: &armhybridnetwork.AzureOperatorNexusImageDeployMappingRuleProfile{
	// 						ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
	// 						ImageMappingRuleProfile: &armhybridnetwork.ImageMappingRuleProfile{
	// 							UserConfiguration: to.Ptr(""),
	// 						},
	// 					},
	// 				},
	// 				&armhybridnetwork.AzureOperatorNexusNetworkFunctionArmTemplateApplication{
	// 					Name: to.Ptr("testTemplateRole"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 							to.Ptr("testImageRole")},
	// 							UninstallDependsOn: []*string{
	// 								to.Ptr("testImageRole")},
	// 								UpdateDependsOn: []*string{
	// 									to.Ptr("testImageRole")},
	// 								},
	// 								ArtifactType: to.Ptr(armhybridnetwork.AzureOperatorNexusArtifactTypeArmTemplate),
	// 								ArtifactProfile: &armhybridnetwork.AzureOperatorNexusArmTemplateArtifactProfile{
	// 									ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
	// 									},
	// 									TemplateArtifactProfile: &armhybridnetwork.ArmTemplateArtifactProfile{
	// 										TemplateName: to.Ptr("test-template"),
	// 										TemplateVersion: to.Ptr("1.0.0"),
	// 									},
	// 								},
	// 								DeployParametersMappingRuleProfile: &armhybridnetwork.AzureOperatorNexusArmTemplateDeployMappingRuleProfile{
	// 									ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
	// 									TemplateMappingRuleProfile: &armhybridnetwork.ArmTemplateMappingRuleProfile{
	// 										TemplateParameters: to.Ptr("{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}"),
	// 									},
	// 								},
	// 						}},
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkFunctionDefinitionVersionGet.json
func ExampleNetworkFunctionDefinitionVersionsClient_Get_getANetworkFunctionDefinitionVersionResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().Get(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkFunctionDefinitionVersion = armhybridnetwork.NetworkFunctionDefinitionVersion{
	// 	Name: to.Ptr("TestVersion"),
	// 	Type: to.Ptr("Microsoft.HybridNetwork/publishers/networkFunctionDefinitionGroups/networkFunctionDefinitionVersions"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkFunctionDefinitionGroups/TestNetworkFunctionDefinitionGroupName/networkFunctionDefinitionVersions/1.0.0"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armhybridnetwork.ContainerizedNetworkFunctionDefinitionVersion{
	// 		DeployParameters: to.Ptr("{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}"),
	// 		NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeContainerizedNetworkFunction),
	// 		VersionState: to.Ptr(armhybridnetwork.VersionStateActive),
	// 		NetworkFunctionTemplate: &armhybridnetwork.AzureArcKubernetesNetworkFunctionTemplate{
	// 			NfviType: to.Ptr(armhybridnetwork.ContainerizedNetworkFunctionNFVITypeAzureArcKubernetes),
	// 			NetworkFunctionApplications: []armhybridnetwork.AzureArcKubernetesNetworkFunctionApplicationClassification{
	// 				&armhybridnetwork.AzureArcKubernetesHelmApplication{
	// 					Name: to.Ptr("fedrbac"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 						},
	// 						UninstallDependsOn: []*string{
	// 						},
	// 						UpdateDependsOn: []*string{
	// 						},
	// 					},
	// 					ArtifactType: to.Ptr(armhybridnetwork.AzureArcKubernetesArtifactTypeHelmPackage),
	// 					ArtifactProfile: &armhybridnetwork.AzureArcKubernetesArtifactProfile{
	// 						ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore"),
	// 						},
	// 						HelmArtifactProfile: &armhybridnetwork.HelmArtifactProfile{
	// 							HelmPackageName: to.Ptr("fed-rbac"),
	// 							HelmPackageVersionRange: to.Ptr("~2.1.3"),
	// 							ImagePullSecretsValuesPaths: []*string{
	// 								to.Ptr("global.imagePullSecrets")},
	// 								RegistryValuesPaths: []*string{
	// 									to.Ptr("global.registry.docker.repoPath")},
	// 								},
	// 							},
	// 							DeployParametersMappingRuleProfile: &armhybridnetwork.AzureArcKubernetesDeployMappingRuleProfile{
	// 								ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementEnabled),
	// 								HelmMappingRuleProfile: &armhybridnetwork.HelmMappingRuleProfile{
	// 									HelmPackageVersion: to.Ptr("2.1.3"),
	// 									ReleaseName: to.Ptr("{deployParameters.releaseName}"),
	// 									ReleaseNamespace: to.Ptr("{deployParameters.namesapce}"),
	// 									Values: to.Ptr(""),
	// 								},
	// 							},
	// 					}},
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/AzureCore/VirtualNetworkFunctionDefinitionVersionGet.json
func ExampleNetworkFunctionDefinitionVersionsClient_Get_getNetworkFunctionDefinitionVersionResourceForAzureCoreVnf() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().Get(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkFunctionDefinitionVersion = armhybridnetwork.NetworkFunctionDefinitionVersion{
	// 	Name: to.Ptr("TestVersion"),
	// 	Type: to.Ptr("Microsoft.HybridNetwork/publishers/networkFunctionDefinitionGroups/networkFunctionDefinitionVersions"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkFunctionDefinitionGroups/TestNetworkFunctionDefinitionGroupName/networkFunctionDefinitionVersions/1.0.0"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armhybridnetwork.VirtualNetworkFunctionDefinitionVersion{
	// 		Description: to.Ptr("test NFDV for AzureCore"),
	// 		DeployParameters: to.Ptr("{\"virtualMachineName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}"),
	// 		NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeVirtualNetworkFunction),
	// 		VersionState: to.Ptr(armhybridnetwork.VersionStatePreview),
	// 		NetworkFunctionTemplate: &armhybridnetwork.AzureCoreNetworkFunctionTemplate{
	// 			NfviType: to.Ptr(armhybridnetwork.VirtualNetworkFunctionNFVITypeAzureCore),
	// 			NetworkFunctionApplications: []armhybridnetwork.AzureCoreNetworkFunctionApplicationClassification{
	// 				&armhybridnetwork.AzureCoreNetworkFunctionVhdApplication{
	// 					Name: to.Ptr("testImageRole"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 						},
	// 						UninstallDependsOn: []*string{
	// 						},
	// 						UpdateDependsOn: []*string{
	// 						},
	// 					},
	// 					ArtifactType: to.Ptr(armhybridnetwork.AzureCoreArtifactTypeVhdImageFile),
	// 					ArtifactProfile: &armhybridnetwork.AzureCoreVhdImageArtifactProfile{
	// 						ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
	// 						},
	// 						VhdArtifactProfile: &armhybridnetwork.VhdImageArtifactProfile{
	// 							VhdName: to.Ptr("test-image"),
	// 							VhdVersion: to.Ptr("1-0-0"),
	// 						},
	// 					},
	// 					DeployParametersMappingRuleProfile: &armhybridnetwork.AzureCoreVhdImageDeployMappingRuleProfile{
	// 						ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
	// 						VhdImageMappingRuleProfile: &armhybridnetwork.VhdImageMappingRuleProfile{
	// 							UserConfiguration: to.Ptr(""),
	// 						},
	// 					},
	// 				},
	// 				&armhybridnetwork.AzureCoreNetworkFunctionArmTemplateApplication{
	// 					Name: to.Ptr("testTemplateRole"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 							to.Ptr("testImageRole")},
	// 							UninstallDependsOn: []*string{
	// 								to.Ptr("testImageRole")},
	// 								UpdateDependsOn: []*string{
	// 									to.Ptr("testImageRole")},
	// 								},
	// 								ArtifactType: to.Ptr(armhybridnetwork.AzureCoreArtifactTypeArmTemplate),
	// 								ArtifactProfile: &armhybridnetwork.AzureCoreArmTemplateArtifactProfile{
	// 									ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
	// 									},
	// 									TemplateArtifactProfile: &armhybridnetwork.ArmTemplateArtifactProfile{
	// 										TemplateName: to.Ptr("test-template"),
	// 										TemplateVersion: to.Ptr("1.0.0"),
	// 									},
	// 								},
	// 								DeployParametersMappingRuleProfile: &armhybridnetwork.AzureCoreArmTemplateDeployMappingRuleProfile{
	// 									ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
	// 									TemplateMappingRuleProfile: &armhybridnetwork.ArmTemplateMappingRuleProfile{
	// 										TemplateParameters: to.Ptr("{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}"),
	// 									},
	// 								},
	// 						}},
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/AzureOperatorNexus/VirtualNetworkFunctionDefinitionVersionGet.json
func ExampleNetworkFunctionDefinitionVersionsClient_Get_getNetworkFunctionDefinitionVersionResourceForAzureOperatorNexusVnf() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().Get(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkFunctionDefinitionVersion = armhybridnetwork.NetworkFunctionDefinitionVersion{
	// 	Name: to.Ptr("TestVersion"),
	// 	Type: to.Ptr("Microsoft.HybridNetwork/publishers/networkFunctionDefinitionGroups/networkFunctionDefinitionVersions"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkFunctionDefinitionGroups/TestNetworkFunctionDefinitionGroupName/networkFunctionDefinitionVersions/1.0.0"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armhybridnetwork.VirtualNetworkFunctionDefinitionVersion{
	// 		Description: to.Ptr("test NFDV for AzureOperatorNexus"),
	// 		DeployParameters: to.Ptr("{\"virtualMachineName\":{\"type\":\"string\"},\"extendedLocationName\":{\"type\":\"string\"},\"cpuCores\":{\"type\":\"int\"},\"memorySizeGB\":{\"type\":\"int\"},\"cloudServicesNetworkAttachment\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]},\"networkAttachments\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"networkAttachmentName\":{\"type\":\"string\"},\"attachedNetworkId\":{\"type\":\"string\"},\"ipAllocationMethod\":{\"type\":\"string\"},\"ipv4Address\":{\"type\":\"string\"},\"ipv6Address\":{\"type\":\"string\"},\"defaultGateway\":{\"type\":\"string\"}},\"required\":[\"attachedNetworkId\",\"ipAllocationMethod\"]}},\"storageProfile\":{\"type\":\"object\",\"properties\":{\"osDisk\":{\"type\":\"object\",\"properties\":{\"createOption\":{\"type\":\"string\"},\"deleteOption\":{\"type\":\"string\"},\"diskSizeGB\":{\"type\":\"integer\"}},\"required\":[\"diskSizeGB\"]}},\"required\":[\"osDisk\"]},\"sshPublicKeys\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"keyData\":{\"type\":\"string\"}},\"required\":[\"keyData\"]}},\"userData\":{\"type\":\"string\"},\"adminUsername\":{\"type\":\"string\"},\"bootMethod\":{\"type\":\"string\",\"default\":\"UEFI\",\"enum\":[\"UEFI\",\"BIOS\"]},\"isolateEmulatorThread\":{\"type\":\"string\"},\"virtioInterface\":{\"type\":\"string\"},\"placementHints\":{\"type\":\"array\",\"items\":{\"type\":\"object\",\"properties\":{\"hintType\":{\"type\":\"string\",\"enum\":[\"Affinity\",\"AntiAffinity\"]},\"resourceId\":{\"type\":\"string\"},\"schedulingExecution\":{\"type\":\"string\",\"enum\":[\"Soft\",\"Hard\"]},\"scope\":{\"type\":\"string\"}},\"required\":[\"hintType\",\"schedulingExecution\",\"resourceId\",\"scope\"]}}}"),
	// 		NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeVirtualNetworkFunction),
	// 		VersionState: to.Ptr(armhybridnetwork.VersionStatePreview),
	// 		NetworkFunctionTemplate: &armhybridnetwork.AzureOperatorNexusNetworkFunctionTemplate{
	// 			NfviType: to.Ptr(armhybridnetwork.VirtualNetworkFunctionNFVITypeAzureOperatorNexus),
	// 			NetworkFunctionApplications: []armhybridnetwork.AzureOperatorNexusNetworkFunctionApplicationClassification{
	// 				&armhybridnetwork.AzureOperatorNexusNetworkFunctionImageApplication{
	// 					Name: to.Ptr("testImageRole"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 						},
	// 						UninstallDependsOn: []*string{
	// 						},
	// 						UpdateDependsOn: []*string{
	// 						},
	// 					},
	// 					ArtifactType: to.Ptr(armhybridnetwork.AzureOperatorNexusArtifactTypeImageFile),
	// 					ArtifactProfile: &armhybridnetwork.AzureOperatorNexusImageArtifactProfile{
	// 						ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
	// 						},
	// 						ImageArtifactProfile: &armhybridnetwork.ImageArtifactProfile{
	// 							ImageName: to.Ptr("test-image"),
	// 							ImageVersion: to.Ptr("1.0.0"),
	// 						},
	// 					},
	// 					DeployParametersMappingRuleProfile: &armhybridnetwork.AzureOperatorNexusImageDeployMappingRuleProfile{
	// 						ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
	// 						ImageMappingRuleProfile: &armhybridnetwork.ImageMappingRuleProfile{
	// 							UserConfiguration: to.Ptr(""),
	// 						},
	// 					},
	// 				},
	// 				&armhybridnetwork.AzureOperatorNexusNetworkFunctionArmTemplateApplication{
	// 					Name: to.Ptr("testTemplateRole"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 							to.Ptr("testImageRole")},
	// 							UninstallDependsOn: []*string{
	// 								to.Ptr("testImageRole")},
	// 								UpdateDependsOn: []*string{
	// 									to.Ptr("testImageRole")},
	// 								},
	// 								ArtifactType: to.Ptr(armhybridnetwork.AzureOperatorNexusArtifactTypeArmTemplate),
	// 								ArtifactProfile: &armhybridnetwork.AzureOperatorNexusArmTemplateArtifactProfile{
	// 									ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore"),
	// 									},
	// 									TemplateArtifactProfile: &armhybridnetwork.ArmTemplateArtifactProfile{
	// 										TemplateName: to.Ptr("test-template"),
	// 										TemplateVersion: to.Ptr("1.0.0"),
	// 									},
	// 								},
	// 								DeployParametersMappingRuleProfile: &armhybridnetwork.AzureOperatorNexusArmTemplateDeployMappingRuleProfile{
	// 									ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementUnknown),
	// 									TemplateMappingRuleProfile: &armhybridnetwork.ArmTemplateMappingRuleProfile{
	// 										TemplateParameters: to.Ptr("{\"virtualMachineName\":\"{deployParameters.virtualMachineName}\",\"extendedLocationName\":\"{deployParameters.extendedLocationName}\",\"cpuCores\":\"{deployParameters.cpuCores}\",\"memorySizeGB\":\"{deployParameters.memorySizeGB}\",\"cloudServicesNetworkAttachment\":\"{deployParameters.cloudServicesNetworkAttachment}\",\"networkAttachments\":\"{deployParameters.networkAttachments}\",\"sshPublicKeys\":\"{deployParameters.sshPublicKeys}\",\"storageProfile\":\"{deployParameters.storageProfile}\",\"isolateEmulatorThread\":\"{deployParameters.isolateEmulatorThread}\",\"virtioInterface\":\"{deployParameters.virtioInterface}\",\"userData\":\"{deployParameters.userData}\",\"adminUsername\":\"{deployParameters.adminUsername}\",\"bootMethod\":\"{deployParameters.bootMethod}\",\"placementHints\":\"{deployParameters.placementHints}\"}"),
	// 									},
	// 								},
	// 						}},
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkFunctionDefinitionVersionUpdateTags.json
func ExampleNetworkFunctionDefinitionVersionsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().Update(ctx, "rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupName", "1.0.0", armhybridnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkFunctionDefinitionVersion = armhybridnetwork.NetworkFunctionDefinitionVersion{
	// 	Name: to.Ptr("TestVersion"),
	// 	Type: to.Ptr("Microsoft.HybridNetwork/publishers/networkFunctionDefinitionGroups/networkFunctionDefinitionVersions"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkFunctionDefinitionGroups/TestNetworkFunctionDefinitionGroupName/networkFunctionDefinitionVersions/1.0.0"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armhybridnetwork.ContainerizedNetworkFunctionDefinitionVersion{
	// 		DeployParameters: to.Ptr("{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}"),
	// 		NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeContainerizedNetworkFunction),
	// 		VersionState: to.Ptr(armhybridnetwork.VersionStateActive),
	// 		NetworkFunctionTemplate: &armhybridnetwork.AzureArcKubernetesNetworkFunctionTemplate{
	// 			NfviType: to.Ptr(armhybridnetwork.ContainerizedNetworkFunctionNFVITypeAzureArcKubernetes),
	// 			NetworkFunctionApplications: []armhybridnetwork.AzureArcKubernetesNetworkFunctionApplicationClassification{
	// 				&armhybridnetwork.AzureArcKubernetesHelmApplication{
	// 					Name: to.Ptr("fedrbac"),
	// 					DependsOnProfile: &armhybridnetwork.DependsOnProfile{
	// 						InstallDependsOn: []*string{
	// 						},
	// 						UninstallDependsOn: []*string{
	// 						},
	// 						UpdateDependsOn: []*string{
	// 						},
	// 					},
	// 					ArtifactType: to.Ptr(armhybridnetwork.AzureArcKubernetesArtifactTypeHelmPackage),
	// 					ArtifactProfile: &armhybridnetwork.AzureArcKubernetesArtifactProfile{
	// 						ArtifactStore: &armhybridnetwork.ReferencedResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore"),
	// 						},
	// 						HelmArtifactProfile: &armhybridnetwork.HelmArtifactProfile{
	// 							HelmPackageName: to.Ptr("fed-rbac"),
	// 							HelmPackageVersionRange: to.Ptr("~2.1.3"),
	// 							ImagePullSecretsValuesPaths: []*string{
	// 								to.Ptr("global.imagePullSecrets")},
	// 								RegistryValuesPaths: []*string{
	// 									to.Ptr("global.registry.docker.repoPath")},
	// 								},
	// 							},
	// 							DeployParametersMappingRuleProfile: &armhybridnetwork.AzureArcKubernetesDeployMappingRuleProfile{
	// 								ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementEnabled),
	// 								HelmMappingRuleProfile: &armhybridnetwork.HelmMappingRuleProfile{
	// 									HelmPackageVersion: to.Ptr("2.1.3"),
	// 									ReleaseName: to.Ptr("{deployParameters.releaseName}"),
	// 									ReleaseNamespace: to.Ptr("{deployParameters.namesapce}"),
	// 									Values: to.Ptr(""),
	// 								},
	// 							},
	// 					}},
	// 				},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkFunctionDefinitionVersionListByNetworkFunctionDefinitionGroup.json
func ExampleNetworkFunctionDefinitionVersionsClient_NewListByNetworkFunctionDefinitionGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNetworkFunctionDefinitionVersionsClient().NewListByNetworkFunctionDefinitionGroupPager("rg", "TestPublisher", "TestNetworkFunctionDefinitionGroupNameName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NetworkFunctionDefinitionVersionListResult = armhybridnetwork.NetworkFunctionDefinitionVersionListResult{
		// 	Value: []*armhybridnetwork.NetworkFunctionDefinitionVersion{
		// 		{
		// 			Name: to.Ptr("networkFunctionDefinitionVersionName"),
		// 			Type: to.Ptr("Microsoft.HybridNetwork/publishers/publisherskugroups/publisherskuversions"),
		// 			ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/publisherskuGroups/networkFunctionDefinitionGroupName/networkFunctionDefinitionVersions/TestVersion"),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armhybridnetwork.ContainerizedNetworkFunctionDefinitionVersion{
		// 				DeployParameters: to.Ptr("{\"releaseName\":{\"type\":\"string\"},\"namespace\":{\"type\":\"string\"}}"),
		// 				NetworkFunctionType: to.Ptr(armhybridnetwork.NetworkFunctionTypeContainerizedNetworkFunction),
		// 				VersionState: to.Ptr(armhybridnetwork.VersionStateActive),
		// 				NetworkFunctionTemplate: &armhybridnetwork.AzureArcKubernetesNetworkFunctionTemplate{
		// 					NfviType: to.Ptr(armhybridnetwork.ContainerizedNetworkFunctionNFVITypeAzureArcKubernetes),
		// 					NetworkFunctionApplications: []armhybridnetwork.AzureArcKubernetesNetworkFunctionApplicationClassification{
		// 						&armhybridnetwork.AzureArcKubernetesHelmApplication{
		// 							Name: to.Ptr("fedrbac"),
		// 							DependsOnProfile: &armhybridnetwork.DependsOnProfile{
		// 								InstallDependsOn: []*string{
		// 								},
		// 								UninstallDependsOn: []*string{
		// 								},
		// 								UpdateDependsOn: []*string{
		// 								},
		// 							},
		// 							ArtifactType: to.Ptr(armhybridnetwork.AzureArcKubernetesArtifactTypeHelmPackage),
		// 							ArtifactProfile: &armhybridnetwork.AzureArcKubernetesArtifactProfile{
		// 								ArtifactStore: &armhybridnetwork.ReferencedResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/testArtifactStore"),
		// 								},
		// 								HelmArtifactProfile: &armhybridnetwork.HelmArtifactProfile{
		// 									HelmPackageName: to.Ptr("fed-rbac"),
		// 									HelmPackageVersionRange: to.Ptr("~2.1.3"),
		// 									ImagePullSecretsValuesPaths: []*string{
		// 										to.Ptr("global.imagePullSecrets")},
		// 										RegistryValuesPaths: []*string{
		// 											to.Ptr("global.registry.docker.repoPath")},
		// 										},
		// 									},
		// 									DeployParametersMappingRuleProfile: &armhybridnetwork.AzureArcKubernetesDeployMappingRuleProfile{
		// 										ApplicationEnablement: to.Ptr(armhybridnetwork.ApplicationEnablementEnabled),
		// 										HelmMappingRuleProfile: &armhybridnetwork.HelmMappingRuleProfile{
		// 											HelmPackageVersion: to.Ptr("2.1.3"),
		// 											Options: &armhybridnetwork.HelmMappingRuleProfileOptions{
		// 												InstallOptions: &armhybridnetwork.HelmInstallOptions{
		// 													Atomic: to.Ptr("true"),
		// 													Timeout: to.Ptr("30"),
		// 													Wait: to.Ptr("waitValue"),
		// 												},
		// 												UpgradeOptions: &armhybridnetwork.HelmUpgradeOptions{
		// 													Atomic: to.Ptr("true"),
		// 													Timeout: to.Ptr("30"),
		// 													Wait: to.Ptr("waitValue"),
		// 												},
		// 											},
		// 											ReleaseName: to.Ptr("{deployParameters.releaseName}"),
		// 											ReleaseNamespace: to.Ptr("{deployParameters.namesapce}"),
		// 											Values: to.Ptr(""),
		// 										},
		// 									},
		// 							}},
		// 						},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/NetworkFunctionDefinitionVersionUpdateState.json
func ExampleNetworkFunctionDefinitionVersionsClient_BeginUpdateState() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNetworkFunctionDefinitionVersionsClient().BeginUpdateState(ctx, "rg", "TestPublisher", "TestSkuGroup", "1.0.0", armhybridnetwork.NetworkFunctionDefinitionVersionUpdateState{
		VersionState: to.Ptr(armhybridnetwork.VersionStateActive),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkFunctionDefinitionVersionUpdateState = armhybridnetwork.NetworkFunctionDefinitionVersionUpdateState{
	// 	VersionState: to.Ptr(armhybridnetwork.VersionStateActive),
	// }
}
