//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armiothub_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iothub/armiothub"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/32c178f2467f792a322f56174be244135d2c907f/specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_operations.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiothub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armiothub.OperationListResult{
		// 	Value: []*armiothub.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/register/action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Register the subscription for the IotHub resource provider and enables the creation of IotHub resources"),
		// 				Operation: to.Ptr("Register Resource Provider"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/IotHubs/diagnosticSettings/read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Gets the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Get Diagnostic Setting"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/IotHubs/diagnosticSettings/write"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Set Diagnostic Setting"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/IotHubs/metricDefinitions/read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for the IotHub service"),
		// 				Operation: to.Ptr("Read IotHub service metric definitions"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/IotHubs/logDefinitions/read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Gets the available log definitions for the IotHub Service"),
		// 				Operation: to.Ptr("Read IotHub service log definitions"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/operations/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get All ResourceProvider Operations"),
		// 				Operation: to.Ptr("Get All ResourceProvider Operations"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/checkNameAvailability/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Check If IotHub name is available"),
		// 				Operation: to.Ptr("Check If IotHub name is available"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/usages/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get subscription usage details for this provider."),
		// 				Operation: to.Ptr("Get Subscription Usages"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Gets the IotHub resource(s)"),
		// 				Operation: to.Ptr("Get IotHub(s)"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/Write"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Create or update IotHub Resource"),
		// 				Operation: to.Ptr("Create or update IotHub Resource"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/Delete"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Delete IotHub Resource"),
		// 				Operation: to.Ptr("Delete IotHub Resource"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/iotHubStats/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get IotHub Statistics"),
		// 				Operation: to.Ptr("Get IotHub Statistics"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/skus/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get valid IotHub Skus"),
		// 				Operation: to.Ptr("Get valid IotHub Skus"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/listkeys/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get all IotHub Keys"),
		// 				Operation: to.Ptr("Get all IotHub Keys"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/iotHubKeys/listkeys/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get IotHub Key for the given name"),
		// 				Operation: to.Ptr("Get IotHub Key for the given name"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/eventHubEndpoints/consumerGroups/Write"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Create EventHub Consumer Group"),
		// 				Operation: to.Ptr("Create EventHub Consumer Group"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/eventHubEndpoints/consumerGroups/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get EventHub Consumer Group(s)"),
		// 				Operation: to.Ptr("Get EventHub Consumer Group(s)"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/eventHubEndpoints/consumerGroups/Delete"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Delete EventHub Consumer Group"),
		// 				Operation: to.Ptr("Delete EventHub Consumer Group"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/exportDevices/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Export Devices"),
		// 				Operation: to.Ptr("Export Devices"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/importDevices/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Import Devices"),
		// 				Operation: to.Ptr("Import Devices"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/jobs/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get Job(s) details submitted on given IotHub"),
		// 				Operation: to.Ptr("Get the Job(s) on IotHub"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/quotaMetrics/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get Quota Metrics"),
		// 				Operation: to.Ptr("Get Quota Metrics"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/routing/routes/$testall/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Test a message against all existing Routes"),
		// 				Operation: to.Ptr("Routing Rule Test All"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/routing/routes/$testnew/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Test a message against a provided test Route"),
		// 				Operation: to.Ptr("Routing Rule Test Route"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/iotHubs/routingEndpointsHealth/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Gets the health of all routing Endpoints for an IotHub"),
		// 				Operation: to.Ptr("Get Endpoint Health"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/ProvisioningServices/diagnosticSettings/read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Gets the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Get Diagnostic Setting"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/ProvisioningServices/diagnosticSettings/write"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Set Diagnostic Setting"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/ProvisioningServices/metricDefinitions/read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for the DPS service"),
		// 				Operation: to.Ptr("Read DPS service metric definitions"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/ProvisioningServices/logDefinitions/read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Gets the available log definitions for the DPS Service"),
		// 				Operation: to.Ptr("Read DPS service log definitions"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("IotHubs"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/checkProvisioningServiceNameAvailability/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Check If Provisioning Service name is available"),
		// 				Operation: to.Ptr("Check If Provisioning Service name is available"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("ProvisioningServives"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/provisioningServices/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Get Provisioning Service resource"),
		// 				Operation: to.Ptr("Get Provisioning Service resource"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("ProvisioningServices"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/provisioningServices/Write"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Create Provisioning Service resource"),
		// 				Operation: to.Ptr("Create Provisioning Service resource"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("ProvisioningServices"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/provisioningServices/Delete"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Delete Provisioning Service resource"),
		// 				Operation: to.Ptr("Delete Provisioning Service resource"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("ProvisioningServices"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/provisioningServices/skus/Read"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("Delete Provisioning Service resource"),
		// 				Operation: to.Ptr("Delete Provisioning Service resource"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("ProvisioningServices"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.Devices/provisioningServices/listkeys/Action"),
		// 			Display: &armiothub.OperationDisplay{
		// 				Description: to.Ptr("get security related metadata"),
		// 				Operation: to.Ptr("get security related metadata"),
		// 				Provider: to.Ptr("Microsoft Devices"),
		// 				Resource: to.Ptr("ProvisioningServices"),
		// 			},
		// 	}},
		// }
	}
}
