//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkusto

import "time"

// AcceptedAudiences - Represents an accepted audience trusted by the cluster.
type AcceptedAudiences struct {
	// GUID or valid URL representing an accepted audience.
	Value *string
}

// AttachedDatabaseConfiguration - Class representing an attached database configuration.
type AttachedDatabaseConfiguration struct {
	// Resource location.
	Location *string

	// The properties of the attached database configuration.
	Properties *AttachedDatabaseConfigurationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AttachedDatabaseConfigurationListResult - The list attached database configurations operation response.
type AttachedDatabaseConfigurationListResult struct {
	// The list of attached database configurations.
	Value []*AttachedDatabaseConfiguration
}

// AttachedDatabaseConfigurationProperties - Class representing the an attached database configuration properties of kind
// specific.
type AttachedDatabaseConfigurationProperties struct {
	// REQUIRED; The resource id of the cluster where the databases you would like to attach reside.
	ClusterResourceID *string

	// REQUIRED; The name of the database which you would like to attach, use * if you want to follow all current and future databases.
	DatabaseName *string

	// REQUIRED; The default principals modification kind
	DefaultPrincipalsModificationKind *DefaultPrincipalsModificationKind

	// Overrides the original database name. Relevant only when attaching to a specific database.
	DatabaseNameOverride *string

	// Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the
	// databases original names from leader cluster.
	DatabaseNamePrefix *string

	// Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties

	// READ-ONLY; The list of databases from the clusterResourceId which are currently attached to the cluster.
	AttachedDatabaseNames []*string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// AttachedDatabaseConfigurationsCheckNameRequest - The result returned from a AttachedDatabaseConfigurations check name availability
// request.
type AttachedDatabaseConfigurationsCheckNameRequest struct {
	// REQUIRED; Attached database resource name.
	Name *string

	// CONSTANT; The type of resource, for instance Microsoft.Kusto/clusters/attachedDatabaseConfigurations.
	// Field has constant value "Microsoft.Kusto/clusters/attachedDatabaseConfigurations", any specified value is ignored.
	Type *string
}

// AzureCapacity - Azure capacity definition.
type AzureCapacity struct {
	// REQUIRED; The default capacity that would be used.
	Default *int32

	// REQUIRED; Maximum allowed capacity.
	Maximum *int32

	// REQUIRED; Minimum allowed capacity.
	Minimum *int32

	// REQUIRED; Scale type.
	ScaleType *AzureScaleType
}

// AzureResourceSKU - Azure resource SKU definition.
type AzureResourceSKU struct {
	// The number of instances of the cluster.
	Capacity *AzureCapacity

	// Resource Namespace and Type.
	ResourceType *string

	// The SKU details.
	SKU *AzureSKU
}

// AzureSKU - Azure SKU definition.
type AzureSKU struct {
	// REQUIRED; SKU name.
	Name *AzureSKUName

	// REQUIRED; SKU tier.
	Tier *AzureSKUTier

	// The number of instances of the cluster.
	Capacity *int32
}

// CheckNameRequest - The result returned from a database check name availability request.
type CheckNameRequest struct {
	// REQUIRED; Resource name.
	Name *string

	// REQUIRED; The type of resource, for instance Microsoft.Kusto/clusters/databases.
	Type *Type
}

// CheckNameResult - The result returned from a check name availability request.
type CheckNameResult struct {
	// Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string

	// The name that was checked.
	Name *string

	// Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool

	// Message providing the reason why the given name is invalid.
	Reason *Reason
}

// Cluster - Class representing a Kusto cluster.
type Cluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The SKU of the cluster.
	SKU *AzureSKU

	// The identity of the cluster, if configured.
	Identity *Identity

	// The cluster properties.
	Properties *ClusterProperties

	// Resource tags.
	Tags map[string]*string

	// The availability zones of the cluster.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterCheckNameRequest - The result returned from a cluster check name availability request.
type ClusterCheckNameRequest struct {
	// REQUIRED; Cluster name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters.
	// Field has constant value "Microsoft.Kusto/clusters", any specified value is ignored.
	Type *string
}

// ClusterListResult - The list Kusto clusters operation response.
type ClusterListResult struct {
	// The list of Kusto clusters.
	Value []*Cluster
}

// ClusterMigrateRequest - A cluster migrate request.
type ClusterMigrateRequest struct {
	// REQUIRED; Resource ID of the destination cluster or kusto pool.
	ClusterResourceID *string
}

// ClusterPrincipalAssignment - Class representing a cluster principal assignment.
type ClusterPrincipalAssignment struct {
	// The cluster principal.
	Properties *ClusterPrincipalProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterPrincipalAssignmentCheckNameRequest - A principal assignment check name availability request.
type ClusterPrincipalAssignmentCheckNameRequest struct {
	// REQUIRED; Principal Assignment resource name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters/principalAssignments.
	// Field has constant value "Microsoft.Kusto/clusters/principalAssignments", any specified value is ignored.
	Type *string
}

// ClusterPrincipalAssignmentListResult - The list Kusto cluster principal assignments operation response.
type ClusterPrincipalAssignmentListResult struct {
	// The list of Kusto cluster principal assignments.
	Value []*ClusterPrincipalAssignment
}

// ClusterPrincipalProperties - A class representing cluster principal property.
type ClusterPrincipalProperties struct {
	// REQUIRED; The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group
	// name.
	PrincipalID *string

	// REQUIRED; Principal type.
	PrincipalType *PrincipalType

	// REQUIRED; Cluster principal role.
	Role *ClusterPrincipalRole

	// The tenant id of the principal
	TenantID *string

	// READ-ONLY; The service principal object id in AAD (Azure active directory)
	AADObjectID *string

	// READ-ONLY; The principal name
	PrincipalName *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The tenant name of the principal
	TenantName *string
}

// ClusterProperties - Class representing the Kusto cluster properties.
type ClusterProperties struct {
	// The cluster's accepted audiences.
	AcceptedAudiences []*AcceptedAudiences

	// List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
	AllowedFqdnList []*string

	// The list of ips in the format of CIDR allowed to connect to the cluster.
	AllowedIPRangeList []*string

	// A boolean value that indicates if the cluster could be automatically stopped (due to lack of data or no activity for many
	// days).
	EnableAutoStop *bool

	// A boolean value that indicates if the cluster's disks are encrypted.
	EnableDiskEncryption *bool

	// A boolean value that indicates if double encryption is enabled.
	EnableDoubleEncryption *bool

	// A boolean value that indicates if the purge operations are enabled.
	EnablePurge *bool

	// A boolean value that indicates if the streaming ingest is enabled.
	EnableStreamingIngest *bool

	// The engine type
	EngineType *EngineType

	// KeyVault properties for the cluster encryption.
	KeyVaultProperties *KeyVaultProperties

	// List of the cluster's language extensions.
	LanguageExtensions *LanguageExtensionsList

	// Optimized auto scale definition.
	OptimizedAutoscale *OptimizedAutoscale

	// Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
	PublicIPType *PublicIPType

	// Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster
	// is allowed
	PublicNetworkAccess *PublicNetworkAccess

	// Whether or not to restrict outbound network access. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
	RestrictOutboundNetworkAccess *ClusterNetworkAccessFlag

	// The cluster's external tenants.
	TrustedExternalTenants []*TrustedExternalTenant

	// Virtual Cluster graduation properties
	VirtualClusterGraduationProperties *string

	// Virtual network definition.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration

	// READ-ONLY; The cluster data ingestion URI.
	DataIngestionURI *string

	// READ-ONLY; Properties of the peer cluster involved in a migration to/from this cluster.
	MigrationCluster *MigrationClusterProperties

	// READ-ONLY; A list of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The state of the resource.
	State *State

	// READ-ONLY; The reason for the cluster's current state.
	StateReason *string

	// READ-ONLY; The cluster URI.
	URI *string
}

// ClusterUpdate - Class representing an update to a Kusto cluster.
type ClusterUpdate struct {
	// The identity of the cluster, if configured.
	Identity *Identity

	// Resource location.
	Location *string

	// The cluster properties.
	Properties *ClusterProperties

	// The SKU of the cluster.
	SKU *AzureSKU

	// Resource tags.
	Tags map[string]*string

	// The availability zones of the cluster.
	Zones []*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

// CosmosDbDataConnection - Class representing a CosmosDb data connection.
type CosmosDbDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// The properties of the CosmosDb data connection.
	Properties *CosmosDbDataConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type CosmosDbDataConnection.
func (c *CosmosDbDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		ID:       c.ID,
		Kind:     c.Kind,
		Location: c.Location,
		Name:     c.Name,
		Type:     c.Type,
	}
}

// CosmosDbDataConnectionProperties - Class representing the Kusto CosmosDb data connection properties.
type CosmosDbDataConnectionProperties struct {
	// REQUIRED; The resource ID of the Cosmos DB account used to create the data connection.
	CosmosDbAccountResourceID *string

	// REQUIRED; The name of an existing container in the Cosmos DB database.
	CosmosDbContainer *string

	// REQUIRED; The name of an existing database in the Cosmos DB account.
	CosmosDbDatabase *string

	// REQUIRED; The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos
	// DB.
	ManagedIdentityResourceID *string

	// REQUIRED; The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table.
	TableName *string

	// The name of an existing mapping rule to use when ingesting the retrieved data.
	MappingRuleName *string

	// Optional. If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval
	// start date.
	RetrievalStartDate *time.Time

	// READ-ONLY; The object ID of the managed identity resource.
	ManagedIdentityObjectID *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// DataConnection - Class representing an data connection.
type DataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type DataConnection.
func (d *DataConnection) GetDataConnection() *DataConnection { return d }

// DataConnectionCheckNameRequest - A data connection check name availability request.
type DataConnectionCheckNameRequest struct {
	// REQUIRED; Data Connection name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters/databases/dataConnections.
	// Field has constant value "Microsoft.Kusto/clusters/databases/dataConnections", any specified value is ignored.
	Type *string
}

// DataConnectionListResult - The list Kusto data connections operation response.
type DataConnectionListResult struct {
	// The list of Kusto data connections.
	Value []DataConnectionClassification
}

// DataConnectionValidation - Class representing an data connection validation.
type DataConnectionValidation struct {
	// The name of the data connection.
	DataConnectionName *string

	// The data connection properties to validate.
	Properties DataConnectionClassification
}

// DataConnectionValidationListResult - The list Kusto data connection validation result.
type DataConnectionValidationListResult struct {
	// The list of Kusto data connection validation errors.
	Value []*DataConnectionValidationResult
}

// DataConnectionValidationResult - The result returned from a data connection validation request.
type DataConnectionValidationResult struct {
	// A message which indicates a problem in data connection validation.
	ErrorMessage *string
}

// Database - Class representing a Kusto database.
type Database struct {
	// REQUIRED; Kind of the database
	Kind *Kind

	// Resource location.
	Location *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDatabase implements the DatabaseClassification interface for type Database.
func (d *Database) GetDatabase() *Database { return d }

// DatabaseInviteFollowerRequest - The request to invite a follower to a database.
type DatabaseInviteFollowerRequest struct {
	// REQUIRED; The email of the invited user for which the follower invitation is generated.
	InviteeEmail *string

	// Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties
}

// DatabaseInviteFollowerResult - The result returned from a follower invitation generation request.
type DatabaseInviteFollowerResult struct {
	// The generated invitation token.
	GeneratedInvitation *string
}

// DatabaseListResult - The list Kusto databases operation response.
type DatabaseListResult struct {
	// Link to the next page of results
	NextLink *string

	// The list of Kusto databases.
	Value []DatabaseClassification
}

// DatabasePrincipal - A class representing database principal entity.
type DatabasePrincipal struct {
	// REQUIRED; Database principal name.
	Name *string

	// REQUIRED; Database principal role.
	Role *DatabasePrincipalRole

	// REQUIRED; Database principal type.
	Type *DatabasePrincipalType

	// Application id - relevant only for application principal type.
	AppID *string

	// Database principal email if exists.
	Email *string

	// Database principal fully qualified name.
	Fqn *string

	// READ-ONLY; The tenant name of the principal
	TenantName *string
}

// DatabasePrincipalAssignment - Class representing a database principal assignment.
type DatabasePrincipalAssignment struct {
	// The database principal.
	Properties *DatabasePrincipalProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DatabasePrincipalAssignmentCheckNameRequest - A principal assignment check name availability request.
type DatabasePrincipalAssignmentCheckNameRequest struct {
	// REQUIRED; Principal Assignment resource name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters/databases/principalAssignments.
	// Field has constant value "Microsoft.Kusto/clusters/databases/principalAssignments", any specified value is ignored.
	Type *string
}

// DatabasePrincipalAssignmentListResult - The list Kusto database principal assignments operation response.
type DatabasePrincipalAssignmentListResult struct {
	// The list of Kusto database principal assignments.
	Value []*DatabasePrincipalAssignment
}

// DatabasePrincipalListRequest - The list Kusto database principals operation request.
type DatabasePrincipalListRequest struct {
	// The list of Kusto database principals.
	Value []*DatabasePrincipal
}

// DatabasePrincipalListResult - The list Kusto database principals operation response.
type DatabasePrincipalListResult struct {
	// The list of Kusto database principals.
	Value []*DatabasePrincipal
}

// DatabasePrincipalProperties - A class representing database principal property.
type DatabasePrincipalProperties struct {
	// REQUIRED; The principal ID assigned to the database principal. It can be a user email, application ID, or security group
	// name.
	PrincipalID *string

	// REQUIRED; Principal type.
	PrincipalType *PrincipalType

	// REQUIRED; Database principal role.
	Role *DatabasePrincipalRole

	// The tenant id of the principal
	TenantID *string

	// READ-ONLY; The service principal object id in AAD (Azure active directory)
	AADObjectID *string

	// READ-ONLY; The principal name
	PrincipalName *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The tenant name of the principal
	TenantName *string
}

// DatabaseStatistics - A class that contains database statistics information.
type DatabaseStatistics struct {
	// The database size - the total size of compressed data and index in bytes.
	Size *float32
}

type DiagnoseVirtualNetworkResult struct {
	// The list of network connectivity diagnostic finding
	Findings []*string
}

// EndpointDependency - A domain name that a service is reached at, including details of the current connection status.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string

	// The ports used when connecting to DomainName.
	EndpointDetails []*EndpointDetail
}

// EndpointDetail - Current TCP connectivity information from the Kusto cluster to a single endpoint.
type EndpointDetail struct {
	// The ip address of the endpoint.
	IPAddress *string

	// The port an endpoint is connected to.
	Port *int32
}

// EventGridConnectionProperties - Class representing the Kusto event grid connection properties.
type EventGridConnectionProperties struct {
	// REQUIRED; The event hub consumer group.
	ConsumerGroup *string

	// REQUIRED; The resource ID where the event grid is configured to send events.
	EventHubResourceID *string

	// REQUIRED; The resource ID of the storage account where the data resides.
	StorageAccountResourceID *string

	// The name of blob storage event type to process.
	BlobStorageEventType *BlobStorageEventType

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *EventGridDataFormat

	// Indication for database routing information from the data connection, by default only database routing information is allowed
	DatabaseRouting *DatabaseRouting

	// The resource ID of the event grid that is subscribed to the storage account events.
	EventGridResourceID *string

	// A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
	IgnoreFirstRecord *bool

	// The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub and storage account.
	ManagedIdentityResourceID *string

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string

	// READ-ONLY; The object ID of managedIdentityResourceId
	ManagedIdentityObjectID *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// EventGridDataConnection - Class representing an Event Grid data connection.
type EventGridDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// The properties of the Event Grid data connection.
	Properties *EventGridConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type EventGridDataConnection.
func (e *EventGridDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		ID:       e.ID,
		Kind:     e.Kind,
		Location: e.Location,
		Name:     e.Name,
		Type:     e.Type,
	}
}

// EventHubConnectionProperties - Class representing the Kusto event hub connection properties.
type EventHubConnectionProperties struct {
	// REQUIRED; The event hub consumer group.
	ConsumerGroup *string

	// REQUIRED; The resource ID of the event hub to be used to create a data connection.
	EventHubResourceID *string

	// The event hub messages compression type
	Compression *Compression

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *EventHubDataFormat

	// Indication for database routing information from the data connection, by default only database routing information is allowed
	DatabaseRouting *DatabaseRouting

	// System properties of the event hub
	EventSystemProperties []*string

	// The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
	ManagedIdentityResourceID *string

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string

	// When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only
	// retrieve events retained by the Event hub, based on its retention period.
	RetrievalStartDate *time.Time

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string

	// READ-ONLY; The object ID of the managedIdentityResourceId
	ManagedIdentityObjectID *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// EventHubDataConnection - Class representing an event hub data connection.
type EventHubDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// The Event Hub data connection properties to validate.
	Properties *EventHubConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type EventHubDataConnection.
func (e *EventHubDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		ID:       e.ID,
		Kind:     e.Kind,
		Location: e.Location,
		Name:     e.Name,
		Type:     e.Type,
	}
}

// FollowerDatabaseDefinition - A class representing follower database request.
type FollowerDatabaseDefinition struct {
	// REQUIRED; Resource name of the attached database configuration in the follower cluster.
	AttachedDatabaseConfigurationName *string

	// REQUIRED; Resource id of the cluster that follows a database owned by this cluster.
	ClusterResourceID *string

	// READ-ONLY; The database name owned by this cluster that was followed. * in case following all databases.
	DatabaseName *string

	// READ-ONLY; The origin of the following setup.
	DatabaseShareOrigin *DatabaseShareOrigin

	// READ-ONLY; Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties
}

// FollowerDatabaseListResult - The list Kusto database principals operation response.
type FollowerDatabaseListResult struct {
	// The list of follower database result.
	Value []*FollowerDatabaseDefinition
}

// Identity for the resource.
type Identity struct {
	// REQUIRED; The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
	// identity and a set of user-assigned identities. The type 'None' will remove all
	// identities.
	Type *IdentityType

	// The list of user identities associated with the Kusto cluster. The user identity dictionary key references will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// IotHubConnectionProperties - Class representing the Kusto Iot hub connection properties.
type IotHubConnectionProperties struct {
	// REQUIRED; The iot hub consumer group.
	ConsumerGroup *string

	// REQUIRED; The resource ID of the Iot hub to be used to create a data connection.
	IotHubResourceID *string

	// REQUIRED; The name of the share access policy
	SharedAccessPolicyName *string

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *IotHubDataFormat

	// Indication for database routing information from the data connection, by default only database routing information is allowed
	DatabaseRouting *DatabaseRouting

	// System properties of the iot hub
	EventSystemProperties []*string

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string

	// When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only
	// retrieve events retained by the Event hub, based on its retention period.
	RetrievalStartDate *time.Time

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// IotHubDataConnection - Class representing an iot hub data connection.
type IotHubDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind

	// Resource location.
	Location *string

	// The Iot Hub data connection properties.
	Properties *IotHubConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnection implements the DataConnectionClassification interface for type IotHubDataConnection.
func (i *IotHubDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		ID:       i.ID,
		Kind:     i.Kind,
		Location: i.Location,
		Name:     i.Name,
		Type:     i.Type,
	}
}

// KeyVaultProperties - Properties of the key vault.
type KeyVaultProperties struct {
	// The name of the key vault key.
	KeyName *string

	// The Uri of the key vault.
	KeyVaultURI *string

	// The version of the key vault key.
	KeyVersion *string

	// The user assigned identity (ARM resource id) that has access to the key.
	UserIdentity *string
}

// LanguageExtension - The language extension object.
type LanguageExtension struct {
	// The language extension custom image name.
	LanguageExtensionCustomImageName *string

	// The language extension image name.
	LanguageExtensionImageName *LanguageExtensionImageName

	// The language extension name.
	LanguageExtensionName *LanguageExtensionName
}

// LanguageExtensionsList - The list of language extension objects.
type LanguageExtensionsList struct {
	// The list of language extensions.
	Value []*LanguageExtension
}

// ListResourceSKUsResult - List of available SKUs for a Kusto Cluster.
type ListResourceSKUsResult struct {
	// The collection of available SKUs for an existing resource.
	Value []*AzureResourceSKU
}

// ManagedPrivateEndpoint - Class representing a managed private endpoint.
type ManagedPrivateEndpoint struct {
	// A managed private endpoint.
	Properties *ManagedPrivateEndpointProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedPrivateEndpointListResult - The list managed private endpoints operation response.
type ManagedPrivateEndpointListResult struct {
	// The list of managed private endpoints.
	Value []*ManagedPrivateEndpoint
}

// ManagedPrivateEndpointProperties - A class representing the properties of a managed private endpoint object.
type ManagedPrivateEndpointProperties struct {
	// REQUIRED; The groupId in which the managed private endpoint is created.
	GroupID *string

	// REQUIRED; The ARM resource ID of the resource for which the managed private endpoint is created.
	PrivateLinkResourceID *string

	// The region of the resource to which the managed private endpoint is created.
	PrivateLinkResourceRegion *string

	// The user request message.
	RequestMessage *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// ManagedPrivateEndpointsCheckNameRequest - The result returned from a managedPrivateEndpoints check name availability request.
type ManagedPrivateEndpointsCheckNameRequest struct {
	// REQUIRED; Managed private endpoint resource name.
	Name *string

	// CONSTANT; The type of resource, for instance Microsoft.Kusto/clusters/managedPrivateEndpoints.
	// Field has constant value "Microsoft.Kusto/clusters/managedPrivateEndpoints", any specified value is ignored.
	Type *string
}

// MigrationClusterProperties - Represents a properties of a cluster that is part of a migration.
type MigrationClusterProperties struct {
	// READ-ONLY; The public data ingestion URL of the cluster.
	DataIngestionURI *string

	// READ-ONLY; The resource ID of the cluster.
	ID *string

	// READ-ONLY; The role of the cluster in the migration process.
	Role *MigrationClusterRole

	// READ-ONLY; The public URL of the cluster.
	URI *string
}

// Operation - A REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay

	// This is of the format {provider}/{resource}/{operation}.
	Name *string

	// The intended executor of the operation.
	Origin *string

	// Properties of the operation.
	Properties any
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// The friendly name of the operation.
	Description *string

	// For example: read, write, delete.
	Operation *string

	// Friendly name of the resource provider.
	Provider *string

	// The resource type on which the operation is performed.
	Resource *string
}

// OperationListResult - Result of the request to list REST API operations. It contains a list of operations and a URL nextLink
// to get the next set of results.
type OperationListResult struct {
	// The URL to get the next set of operation list results if there are any.
	NextLink *string

	// The list of operations supported by the resource provider.
	Value []*Operation
}

// OperationResult - Operation Result Entity.
type OperationResult struct {
	// The operation end time
	EndTime *time.Time

	// Object that contains the error code and message if the operation failed.
	Error *OperationResultErrorProperties

	// Percentage completed.
	PercentComplete *float64

	// Properties of the operation results
	Properties *OperationResultProperties

	// The operation start time
	StartTime *time.Time

	// READ-ONLY; ID of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; status of the Operation result.
	Status *Status
}

// OperationResultErrorProperties - Operation result error properties
type OperationResultErrorProperties struct {
	// The code of the error.
	Code *string

	// The error message.
	Message *string
}

// OperationResultProperties - Operation result properties
type OperationResultProperties struct {
	// The kind of the operation.
	OperationKind *string

	// The state of the operation.
	OperationState *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// OptimizedAutoscale - A class that contains the optimized auto scale definition.
type OptimizedAutoscale struct {
	// REQUIRED; A boolean value that indicate if the optimized autoscale feature is enabled or not.
	IsEnabled *bool

	// REQUIRED; Maximum allowed instances count.
	Maximum *int32

	// REQUIRED; Minimum allowed instances count.
	Minimum *int32

	// REQUIRED; The version of the template defined, for instance 1.
	Version *int32
}

// OutboundNetworkDependenciesEndpoint - Endpoints accessed for a common purpose that the Kusto Service Environment requires
// outbound network access to.
type OutboundNetworkDependenciesEndpoint struct {
	// The outbound environment endpoint properties.
	Properties *OutboundNetworkDependenciesEndpointProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// OutboundNetworkDependenciesEndpointListResult - Collection of Outbound Environment Endpoints
type OutboundNetworkDependenciesEndpointListResult struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundNetworkDependenciesEndpoint

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// OutboundNetworkDependenciesEndpointProperties - Endpoints accessed for a common purpose that the Kusto Service Environment
// requires outbound network access to.
type OutboundNetworkDependenciesEndpointProperties struct {
	// The type of service accessed by the Kusto Service Environment, e.g., Azure Storage, Azure SQL Database, and Azure Active
	// Directory.
	Category *string

	// The endpoints that the Kusto Service Environment reaches the service at.
	Endpoints []*EndpointDependency

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty

	// READ-ONLY; Group id of the private endpoint.
	GroupID *string

	// READ-ONLY; Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty

	// READ-ONLY; Provisioning state of the private endpoint.
	ProvisioningState *string
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// READ-ONLY; Resource id of the private endpoint.
	ID *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string

	// READ-ONLY; The private link resource required zone names.
	RequiredZoneNames []*string
}

// PrivateLinkServiceConnectionStateProperty - Connection State of the Private Endpoint Connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// The private link service connection description.
	Description *string

	// The private link service connection status.
	Status *string

	// READ-ONLY; Any action that is required beyond basic workflow (approve/ reject/ disconnect)
	ActionsRequired *string
}

// ReadOnlyFollowingDatabase - Class representing a read only following database.
type ReadOnlyFollowingDatabase struct {
	// REQUIRED; Kind of the database
	Kind *Kind

	// Resource location.
	Location *string

	// The database properties.
	Properties *ReadOnlyFollowingDatabaseProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDatabase implements the DatabaseClassification interface for type ReadOnlyFollowingDatabase.
func (r *ReadOnlyFollowingDatabase) GetDatabase() *Database {
	return &Database{
		ID:       r.ID,
		Kind:     r.Kind,
		Location: r.Location,
		Name:     r.Name,
		Type:     r.Type,
	}
}

// ReadOnlyFollowingDatabaseProperties - Class representing the Kusto database properties.
type ReadOnlyFollowingDatabaseProperties struct {
	// The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string

	// READ-ONLY; The name of the attached database configuration cluster
	AttachedDatabaseConfigurationName *string

	// READ-ONLY; The origin of the following setup.
	DatabaseShareOrigin *DatabaseShareOrigin

	// READ-ONLY; The name of the leader cluster
	LeaderClusterResourceID *string

	// READ-ONLY; The original database name, before databaseNameOverride or databaseNamePrefix where applied.
	OriginalDatabaseName *string

	// READ-ONLY; The principals modification kind of the database
	PrincipalsModificationKind *PrincipalsModificationKind

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string

	// READ-ONLY; The statistics of the database.
	Statistics *DatabaseStatistics

	// READ-ONLY; The database suspension details. If the database is suspended, this object contains information related to the
	// database's suspension state.
	SuspensionDetails *SuspensionDetails

	// READ-ONLY; Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties
}

// ReadWriteDatabase - Class representing a read write database.
type ReadWriteDatabase struct {
	// REQUIRED; Kind of the database
	Kind *Kind

	// Resource location.
	Location *string

	// The database properties.
	Properties *ReadWriteDatabaseProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDatabase implements the DatabaseClassification interface for type ReadWriteDatabase.
func (r *ReadWriteDatabase) GetDatabase() *Database {
	return &Database{
		ID:       r.ID,
		Kind:     r.Kind,
		Location: r.Location,
		Name:     r.Name,
		Type:     r.Type,
	}
}

// ReadWriteDatabaseProperties - Class representing the Kusto database properties.
type ReadWriteDatabaseProperties struct {
	// The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string

	// KeyVault properties for the database encryption.
	KeyVaultProperties *KeyVaultProperties

	// The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string

	// READ-ONLY; Indicates whether the database is followed.
	IsFollowed *bool

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The statistics of the database.
	Statistics *DatabaseStatistics

	// READ-ONLY; The database suspension details. If the database is suspended, this object contains information related to the
	// database's suspension state.
	SuspensionDetails *SuspensionDetails
}

// ResourceSKUCapabilities - Describes The SKU capabilities object.
type ResourceSKUCapabilities struct {
	// READ-ONLY; An invariant to describe the feature.
	Name *string

	// READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string
}

// ResourceSKUZoneDetails - Describes The zonal capabilities of a SKU.
type ResourceSKUZoneDetails struct {
	// READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities []*ResourceSKUCapabilities

	// READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name []*string
}

// SKUDescription - The Kusto SKU description of given resource type
type SKUDescription struct {
	// READ-ONLY; Locations and zones
	LocationInfo []*SKULocationInfoItem

	// READ-ONLY; The set of locations that the SKU is available
	Locations []*string

	// READ-ONLY; The name of the SKU
	Name *string

	// READ-ONLY; The resource type
	ResourceType *string

	// READ-ONLY; The restrictions because of which SKU cannot be used
	Restrictions []any

	// READ-ONLY; The tier of the SKU
	Tier *string
}

// SKUDescriptionList - The list of the EngagementFabric SKU descriptions
type SKUDescriptionList struct {
	// READ-ONLY; SKU descriptions
	Value []*SKUDescription
}

// SKULocationInfoItem - The locations and zones info for SKU.
type SKULocationInfoItem struct {
	// REQUIRED; The available location of the SKU.
	Location *string

	// Gets details of capabilities available to a SKU in specific zones.
	ZoneDetails []*ResourceSKUZoneDetails

	// The available zone of the SKU.
	Zones []*string
}

// SandboxCustomImage - Class representing a Kusto sandbox custom image.
type SandboxCustomImage struct {
	// A sandbox custom image.
	Properties *SandboxCustomImageProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SandboxCustomImageProperties - A class representing the properties of a sandbox custom image object.
type SandboxCustomImageProperties struct {
	// REQUIRED; The language name, for example Python.
	Language *Language

	// REQUIRED; The version of the language.
	LanguageVersion *string

	// The requirements file content.
	RequirementsFileContent *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// SandboxCustomImagesCheckNameRequest - The result returned from a sandboxCustomImage check name availability request.
type SandboxCustomImagesCheckNameRequest struct {
	// REQUIRED; Sandbox custom image resource name.
	Name *string

	// CONSTANT; The type of resource, for instance Microsoft.Kusto/clusters/sandboxCustomImages.
	// Field has constant value "Microsoft.Kusto/clusters/sandboxCustomImages", any specified value is ignored.
	Type *string
}

// SandboxCustomImagesListResult - The list Kusto sandbox custom images operation response.
type SandboxCustomImagesListResult struct {
	// Link to the next page of results
	NextLink *string

	// The list of Kusto sandbox custom images.
	Value []*SandboxCustomImage
}

// Script - Class representing a database script.
type Script struct {
	// The database script.
	Properties *ScriptProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ScriptCheckNameRequest - A script name availability request.
type ScriptCheckNameRequest struct {
	// REQUIRED; Script name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters/databases/scripts.
	// Field has constant value "Microsoft.Kusto/clusters/databases/scripts", any specified value is ignored.
	Type *string
}

// ScriptListResult - The list Kusto database script operation response.
type ScriptListResult struct {
	// The list of Kusto scripts.
	Value []*Script
}

// ScriptProperties - A class representing database script property.
type ScriptProperties struct {
	// Flag that indicates whether to continue if one of the command fails.
	ContinueOnErrors *bool

	// A unique string. If changed the script will be applied again.
	ForceUpdateTag *string

	// The script content. This property should be used when the script is provide inline and not through file in a SA. Must not
	// be used together with scriptUrl and scriptUrlSasToken properties.
	ScriptContent *string

	// The url to the KQL script blob file. Must not be used together with scriptContent property
	ScriptURL *string

	// The SaS token that provide read access to the file which contain the script. Must be provided when using scriptUrl property.
	ScriptURLSasToken *string

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState
}

// SuspensionDetails - The database suspension details. If the database is suspended, this object contains information related
// to the database's suspension state.
type SuspensionDetails struct {
	// The starting date and time of the suspension state.
	SuspensionStartDate *time.Time
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TableLevelSharingProperties - Tables that will be included and excluded in the follower database
type TableLevelSharingProperties struct {
	// List of external tables to exclude from the follower database
	ExternalTablesToExclude []*string

	// List of external tables to include in the follower database
	ExternalTablesToInclude []*string

	// List of functions to exclude from the follower database
	FunctionsToExclude []*string

	// List of functions to include in the follower database
	FunctionsToInclude []*string

	// List of materialized views to exclude from the follower database
	MaterializedViewsToExclude []*string

	// List of materialized views to include in the follower database
	MaterializedViewsToInclude []*string

	// List of tables to exclude from the follower database
	TablesToExclude []*string

	// List of tables to include in the follower database
	TablesToInclude []*string
}

// TrustedExternalTenant - Represents a tenant ID that is trusted by the cluster.
type TrustedExternalTenant struct {
	// GUID representing an external tenant.
	Value *string
}

// VirtualNetworkConfiguration - A class that contains virtual network definition.
type VirtualNetworkConfiguration struct {
	// REQUIRED; Data management's service public IP address resource id.
	DataManagementPublicIPID *string

	// REQUIRED; Engine service's public IP address resource id.
	EnginePublicIPID *string

	// REQUIRED; The subnet resource id.
	SubnetID *string

	// When enabled, the cluster is deployed into the configured subnet, when disabled it will be removed from the subnet.
	State *VnetState
}
