//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogz

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// MonitorClient contains the methods for the Monitor group.
// Don't use this type directly, use NewMonitorClient() instead.
type MonitorClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewMonitorClient creates a new instance of MonitorClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewMonitorClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*MonitorClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &MonitorClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListVMHostUpdatePager - Sending request to update the collection when Logz.io agent has been installed on a VM for a
// given monitor.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - options - MonitorClientListVMHostUpdateOptions contains the optional parameters for the MonitorClient.NewListVMHostUpdatePager
//     method.
func (client *MonitorClient) NewListVMHostUpdatePager(resourceGroupName string, monitorName string, options *MonitorClientListVMHostUpdateOptions) *runtime.Pager[MonitorClientListVMHostUpdateResponse] {
	return runtime.NewPager(runtime.PagingHandler[MonitorClientListVMHostUpdateResponse]{
		More: func(page MonitorClientListVMHostUpdateResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *MonitorClientListVMHostUpdateResponse) (MonitorClientListVMHostUpdateResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "MonitorClient.NewListVMHostUpdatePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listVMHostUpdateCreateRequest(ctx, resourceGroupName, monitorName, options)
			}, nil)
			if err != nil {
				return MonitorClientListVMHostUpdateResponse{}, err
			}
			return client.listVMHostUpdateHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listVMHostUpdateCreateRequest creates the ListVMHostUpdate request.
func (client *MonitorClient) listVMHostUpdateCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, options *MonitorClientListVMHostUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/vmHostUpdate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		if err := runtime.MarshalAsJSON(req, *options.Body); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// listVMHostUpdateHandleResponse handles the ListVMHostUpdate response.
func (client *MonitorClient) listVMHostUpdateHandleResponse(resp *http.Response) (MonitorClientListVMHostUpdateResponse, error) {
	result := MonitorClientListVMHostUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMResourcesListResponse); err != nil {
		return MonitorClientListVMHostUpdateResponse{}, err
	}
	return result, nil
}

// NewListVMHostsPager - List the compute resources currently being monitored by the Logz main account resource.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - options - MonitorClientListVMHostsOptions contains the optional parameters for the MonitorClient.NewListVMHostsPager method.
func (client *MonitorClient) NewListVMHostsPager(resourceGroupName string, monitorName string, options *MonitorClientListVMHostsOptions) *runtime.Pager[MonitorClientListVMHostsResponse] {
	return runtime.NewPager(runtime.PagingHandler[MonitorClientListVMHostsResponse]{
		More: func(page MonitorClientListVMHostsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *MonitorClientListVMHostsResponse) (MonitorClientListVMHostsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "MonitorClient.NewListVMHostsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listVMHostsCreateRequest(ctx, resourceGroupName, monitorName, options)
			}, nil)
			if err != nil {
				return MonitorClientListVMHostsResponse{}, err
			}
			return client.listVMHostsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listVMHostsCreateRequest creates the ListVMHosts request.
func (client *MonitorClient) listVMHostsCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, options *MonitorClientListVMHostsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/listVMHosts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listVMHostsHandleResponse handles the ListVMHosts response.
func (client *MonitorClient) listVMHostsHandleResponse(resp *http.Response) (MonitorClientListVMHostsResponse, error) {
	result := MonitorClientListVMHostsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMResourcesListResponse); err != nil {
		return MonitorClientListVMHostsResponse{}, err
	}
	return result, nil
}

// VMHostPayload - Returns the payload that needs to be passed in the request body for installing Logz.io agent on a VM.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - options - MonitorClientVMHostPayloadOptions contains the optional parameters for the MonitorClient.VMHostPayload method.
func (client *MonitorClient) VMHostPayload(ctx context.Context, resourceGroupName string, monitorName string, options *MonitorClientVMHostPayloadOptions) (MonitorClientVMHostPayloadResponse, error) {
	var err error
	const operationName = "MonitorClient.VMHostPayload"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.vmHostPayloadCreateRequest(ctx, resourceGroupName, monitorName, options)
	if err != nil {
		return MonitorClientVMHostPayloadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return MonitorClientVMHostPayloadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return MonitorClientVMHostPayloadResponse{}, err
	}
	resp, err := client.vmHostPayloadHandleResponse(httpResp)
	return resp, err
}

// vmHostPayloadCreateRequest creates the VMHostPayload request.
func (client *MonitorClient) vmHostPayloadCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, options *MonitorClientVMHostPayloadOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/vmHostPayload"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// vmHostPayloadHandleResponse handles the VMHostPayload response.
func (client *MonitorClient) vmHostPayloadHandleResponse(resp *http.Response) (MonitorClientVMHostPayloadResponse, error) {
	result := MonitorClientVMHostPayloadResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMExtensionPayload); err != nil {
		return MonitorClientVMHostPayloadResponse{}, err
	}
	return result, nil
}
