//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagednetworkfabric

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// NetworkFabricsClient contains the methods for the NetworkFabrics group.
// Don't use this type directly, use NewNetworkFabricsClient() instead.
type NetworkFabricsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewNetworkFabricsClient creates a new instance of NetworkFabricsClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewNetworkFabricsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*NetworkFabricsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &NetworkFabricsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCommitConfiguration - Atomic update of the given Network Fabric instance. Sync update of NFA resources at Fabric level.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - options - NetworkFabricsClientBeginCommitConfigurationOptions contains the optional parameters for the NetworkFabricsClient.BeginCommitConfiguration
//     method.
func (client *NetworkFabricsClient) BeginCommitConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginCommitConfigurationOptions) (*runtime.Poller[NetworkFabricsClientCommitConfigurationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.commitConfiguration(ctx, resourceGroupName, networkFabricName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientCommitConfigurationResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientCommitConfigurationResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CommitConfiguration - Atomic update of the given Network Fabric instance. Sync update of NFA resources at Fabric level.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) commitConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginCommitConfigurationOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginCommitConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.commitConfigurationCreateRequest(ctx, resourceGroupName, networkFabricName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// commitConfigurationCreateRequest creates the CommitConfiguration request.
func (client *NetworkFabricsClient) commitConfigurationCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginCommitConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/commitConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginCreate - Create Network Fabric resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - body - Request payload.
//   - options - NetworkFabricsClientBeginCreateOptions contains the optional parameters for the NetworkFabricsClient.BeginCreate
//     method.
func (client *NetworkFabricsClient) BeginCreate(ctx context.Context, resourceGroupName string, networkFabricName string, body NetworkFabric, options *NetworkFabricsClientBeginCreateOptions) (*runtime.Poller[NetworkFabricsClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, networkFabricName, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create Network Fabric resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) create(ctx context.Context, resourceGroupName string, networkFabricName string, body NetworkFabric, options *NetworkFabricsClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, networkFabricName, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *NetworkFabricsClient) createCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, body NetworkFabric, options *NetworkFabricsClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Delete Network Fabric resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - options - NetworkFabricsClientBeginDeleteOptions contains the optional parameters for the NetworkFabricsClient.BeginDelete
//     method.
func (client *NetworkFabricsClient) BeginDelete(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginDeleteOptions) (*runtime.Poller[NetworkFabricsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, networkFabricName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete Network Fabric resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) deleteOperation(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, networkFabricName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *NetworkFabricsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeprovision - Deprovisions the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - options - NetworkFabricsClientBeginDeprovisionOptions contains the optional parameters for the NetworkFabricsClient.BeginDeprovision
//     method.
func (client *NetworkFabricsClient) BeginDeprovision(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginDeprovisionOptions) (*runtime.Poller[NetworkFabricsClientDeprovisionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deprovision(ctx, resourceGroupName, networkFabricName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientDeprovisionResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientDeprovisionResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Deprovision - Deprovisions the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) deprovision(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginDeprovisionOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginDeprovision"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deprovisionCreateRequest(ctx, resourceGroupName, networkFabricName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deprovisionCreateRequest creates the Deprovision request.
func (client *NetworkFabricsClient) deprovisionCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginDeprovisionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/deprovision"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get Network Fabric resource details.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - options - NetworkFabricsClientGetOptions contains the optional parameters for the NetworkFabricsClient.Get method.
func (client *NetworkFabricsClient) Get(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientGetOptions) (NetworkFabricsClientGetResponse, error) {
	var err error
	const operationName = "NetworkFabricsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, networkFabricName, options)
	if err != nil {
		return NetworkFabricsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return NetworkFabricsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return NetworkFabricsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *NetworkFabricsClient) getCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *NetworkFabricsClient) getHandleResponse(resp *http.Response) (NetworkFabricsClientGetResponse, error) {
	result := NetworkFabricsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkFabric); err != nil {
		return NetworkFabricsClientGetResponse{}, err
	}
	return result, nil
}

// BeginGetTopology - Gets Topology of the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - options - NetworkFabricsClientBeginGetTopologyOptions contains the optional parameters for the NetworkFabricsClient.BeginGetTopology
//     method.
func (client *NetworkFabricsClient) BeginGetTopology(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginGetTopologyOptions) (*runtime.Poller[NetworkFabricsClientGetTopologyResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.getTopology(ctx, resourceGroupName, networkFabricName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientGetTopologyResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientGetTopologyResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// GetTopology - Gets Topology of the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) getTopology(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginGetTopologyOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginGetTopology"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getTopologyCreateRequest(ctx, resourceGroupName, networkFabricName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// getTopologyCreateRequest creates the GetTopology request.
func (client *NetworkFabricsClient) getTopologyCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginGetTopologyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/getTopology"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// NewListByResourceGroupPager - List all the Network Fabric resources in the given resource group.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - NetworkFabricsClientListByResourceGroupOptions contains the optional parameters for the NetworkFabricsClient.NewListByResourceGroupPager
//     method.
func (client *NetworkFabricsClient) NewListByResourceGroupPager(resourceGroupName string, options *NetworkFabricsClientListByResourceGroupOptions) *runtime.Pager[NetworkFabricsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[NetworkFabricsClientListByResourceGroupResponse]{
		More: func(page NetworkFabricsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *NetworkFabricsClientListByResourceGroupResponse) (NetworkFabricsClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "NetworkFabricsClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return NetworkFabricsClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *NetworkFabricsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *NetworkFabricsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *NetworkFabricsClient) listByResourceGroupHandleResponse(resp *http.Response) (NetworkFabricsClientListByResourceGroupResponse, error) {
	result := NetworkFabricsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkFabricsListResult); err != nil {
		return NetworkFabricsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List all the Network Fabric resources in the given subscription.
//
// Generated from API version 2023-06-15
//   - options - NetworkFabricsClientListBySubscriptionOptions contains the optional parameters for the NetworkFabricsClient.NewListBySubscriptionPager
//     method.
func (client *NetworkFabricsClient) NewListBySubscriptionPager(options *NetworkFabricsClientListBySubscriptionOptions) *runtime.Pager[NetworkFabricsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[NetworkFabricsClientListBySubscriptionResponse]{
		More: func(page NetworkFabricsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *NetworkFabricsClientListBySubscriptionResponse) (NetworkFabricsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "NetworkFabricsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return NetworkFabricsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *NetworkFabricsClient) listBySubscriptionCreateRequest(ctx context.Context, options *NetworkFabricsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ManagedNetworkFabric/networkFabrics"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *NetworkFabricsClient) listBySubscriptionHandleResponse(resp *http.Response) (NetworkFabricsClientListBySubscriptionResponse, error) {
	result := NetworkFabricsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkFabricsListResult); err != nil {
		return NetworkFabricsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginProvision - Provisions the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - options - NetworkFabricsClientBeginProvisionOptions contains the optional parameters for the NetworkFabricsClient.BeginProvision
//     method.
func (client *NetworkFabricsClient) BeginProvision(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginProvisionOptions) (*runtime.Poller[NetworkFabricsClientProvisionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.provision(ctx, resourceGroupName, networkFabricName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientProvisionResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientProvisionResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Provision - Provisions the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) provision(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginProvisionOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginProvision"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.provisionCreateRequest(ctx, resourceGroupName, networkFabricName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// provisionCreateRequest creates the Provision request.
func (client *NetworkFabricsClient) provisionCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginProvisionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/provision"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginRefreshConfiguration - Refreshes the configuration of the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - options - NetworkFabricsClientBeginRefreshConfigurationOptions contains the optional parameters for the NetworkFabricsClient.BeginRefreshConfiguration
//     method.
func (client *NetworkFabricsClient) BeginRefreshConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginRefreshConfigurationOptions) (*runtime.Poller[NetworkFabricsClientRefreshConfigurationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.refreshConfiguration(ctx, resourceGroupName, networkFabricName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientRefreshConfigurationResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientRefreshConfigurationResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// RefreshConfiguration - Refreshes the configuration of the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) refreshConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginRefreshConfigurationOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginRefreshConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.refreshConfigurationCreateRequest(ctx, resourceGroupName, networkFabricName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// refreshConfigurationCreateRequest creates the RefreshConfiguration request.
func (client *NetworkFabricsClient) refreshConfigurationCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, options *NetworkFabricsClientBeginRefreshConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/refreshConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginUpdate - Update certain properties of the Network Fabric resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - body - Network Fabric properties to update.
//   - options - NetworkFabricsClientBeginUpdateOptions contains the optional parameters for the NetworkFabricsClient.BeginUpdate
//     method.
func (client *NetworkFabricsClient) BeginUpdate(ctx context.Context, resourceGroupName string, networkFabricName string, body NetworkFabricPatch, options *NetworkFabricsClientBeginUpdateOptions) (*runtime.Poller[NetworkFabricsClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, networkFabricName, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Update certain properties of the Network Fabric resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) update(ctx context.Context, resourceGroupName string, networkFabricName string, body NetworkFabricPatch, options *NetworkFabricsClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, networkFabricName, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *NetworkFabricsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, body NetworkFabricPatch, options *NetworkFabricsClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginUpdateInfraManagementBfdConfiguration - Updates the Infra Management BFD Configuration of the underlying resources
// in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - body - Request payload.
//   - options - NetworkFabricsClientBeginUpdateInfraManagementBfdConfigurationOptions contains the optional parameters for the
//     NetworkFabricsClient.BeginUpdateInfraManagementBfdConfiguration method.
func (client *NetworkFabricsClient) BeginUpdateInfraManagementBfdConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateAdministrativeState, options *NetworkFabricsClientBeginUpdateInfraManagementBfdConfigurationOptions) (*runtime.Poller[NetworkFabricsClientUpdateInfraManagementBfdConfigurationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateInfraManagementBfdConfiguration(ctx, resourceGroupName, networkFabricName, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientUpdateInfraManagementBfdConfigurationResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientUpdateInfraManagementBfdConfigurationResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateInfraManagementBfdConfiguration - Updates the Infra Management BFD Configuration of the underlying resources in the
// given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) updateInfraManagementBfdConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateAdministrativeState, options *NetworkFabricsClientBeginUpdateInfraManagementBfdConfigurationOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginUpdateInfraManagementBfdConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateInfraManagementBfdConfigurationCreateRequest(ctx, resourceGroupName, networkFabricName, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateInfraManagementBfdConfigurationCreateRequest creates the UpdateInfraManagementBfdConfiguration request.
func (client *NetworkFabricsClient) updateInfraManagementBfdConfigurationCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateAdministrativeState, options *NetworkFabricsClientBeginUpdateInfraManagementBfdConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/updateInfraManagementBfdConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginUpdateWorkloadManagementBfdConfiguration - Updates the Workload Management BFD Configuration of the underlying resources
// in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - body - Request payload.
//   - options - NetworkFabricsClientBeginUpdateWorkloadManagementBfdConfigurationOptions contains the optional parameters for
//     the NetworkFabricsClient.BeginUpdateWorkloadManagementBfdConfiguration method.
func (client *NetworkFabricsClient) BeginUpdateWorkloadManagementBfdConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateAdministrativeState, options *NetworkFabricsClientBeginUpdateWorkloadManagementBfdConfigurationOptions) (*runtime.Poller[NetworkFabricsClientUpdateWorkloadManagementBfdConfigurationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateWorkloadManagementBfdConfiguration(ctx, resourceGroupName, networkFabricName, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientUpdateWorkloadManagementBfdConfigurationResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientUpdateWorkloadManagementBfdConfigurationResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateWorkloadManagementBfdConfiguration - Updates the Workload Management BFD Configuration of the underlying resources
// in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) updateWorkloadManagementBfdConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateAdministrativeState, options *NetworkFabricsClientBeginUpdateWorkloadManagementBfdConfigurationOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginUpdateWorkloadManagementBfdConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateWorkloadManagementBfdConfigurationCreateRequest(ctx, resourceGroupName, networkFabricName, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateWorkloadManagementBfdConfigurationCreateRequest creates the UpdateWorkloadManagementBfdConfiguration request.
func (client *NetworkFabricsClient) updateWorkloadManagementBfdConfigurationCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateAdministrativeState, options *NetworkFabricsClientBeginUpdateWorkloadManagementBfdConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/updateWorkloadManagementBfdConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginUpgrade - Upgrades the version of the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - body - Network Fabric properties to update.
//   - options - NetworkFabricsClientBeginUpgradeOptions contains the optional parameters for the NetworkFabricsClient.BeginUpgrade
//     method.
func (client *NetworkFabricsClient) BeginUpgrade(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateVersion, options *NetworkFabricsClientBeginUpgradeOptions) (*runtime.Poller[NetworkFabricsClientUpgradeResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.upgrade(ctx, resourceGroupName, networkFabricName, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientUpgradeResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientUpgradeResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Upgrade - Upgrades the version of the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) upgrade(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateVersion, options *NetworkFabricsClientBeginUpgradeOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginUpgrade"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.upgradeCreateRequest(ctx, resourceGroupName, networkFabricName, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// upgradeCreateRequest creates the Upgrade request.
func (client *NetworkFabricsClient) upgradeCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, body UpdateVersion, options *NetworkFabricsClientBeginUpgradeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/upgrade"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginValidateConfiguration - Validates the configuration of the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFabricName - Name of the Network Fabric.
//   - body - Validate configuration properties.
//   - options - NetworkFabricsClientBeginValidateConfigurationOptions contains the optional parameters for the NetworkFabricsClient.BeginValidateConfiguration
//     method.
func (client *NetworkFabricsClient) BeginValidateConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, body ValidateConfigurationProperties, options *NetworkFabricsClientBeginValidateConfigurationOptions) (*runtime.Poller[NetworkFabricsClientValidateConfigurationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.validateConfiguration(ctx, resourceGroupName, networkFabricName, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[NetworkFabricsClientValidateConfigurationResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[NetworkFabricsClientValidateConfigurationResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ValidateConfiguration - Validates the configuration of the underlying resources in the given Network Fabric instance.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
func (client *NetworkFabricsClient) validateConfiguration(ctx context.Context, resourceGroupName string, networkFabricName string, body ValidateConfigurationProperties, options *NetworkFabricsClientBeginValidateConfigurationOptions) (*http.Response, error) {
	var err error
	const operationName = "NetworkFabricsClient.BeginValidateConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateConfigurationCreateRequest(ctx, resourceGroupName, networkFabricName, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// validateConfigurationCreateRequest creates the ValidateConfiguration request.
func (client *NetworkFabricsClient) validateConfigurationCreateRequest(ctx context.Context, resourceGroupName string, networkFabricName string, body ValidateConfigurationProperties, options *NetworkFabricsClientBeginValidateConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/validateConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFabricName == "" {
		return nil, errors.New("parameter networkFabricName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricName}", url.PathEscape(networkFabricName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}
