//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagedservices

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	credential azcore.TokenCredential
	options    *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		credential: credential,
		options:    options.Clone(),
	}, nil
}

// NewMarketplaceRegistrationDefinitionsClient creates a new instance of MarketplaceRegistrationDefinitionsClient.
func (c *ClientFactory) NewMarketplaceRegistrationDefinitionsClient() *MarketplaceRegistrationDefinitionsClient {
	subClient, _ := NewMarketplaceRegistrationDefinitionsClient(c.credential, c.options)
	return subClient
}

// NewMarketplaceRegistrationDefinitionsWithoutScopeClient creates a new instance of MarketplaceRegistrationDefinitionsWithoutScopeClient.
func (c *ClientFactory) NewMarketplaceRegistrationDefinitionsWithoutScopeClient() *MarketplaceRegistrationDefinitionsWithoutScopeClient {
	subClient, _ := NewMarketplaceRegistrationDefinitionsWithoutScopeClient(c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewOperationsWithScopeClient creates a new instance of OperationsWithScopeClient.
func (c *ClientFactory) NewOperationsWithScopeClient() *OperationsWithScopeClient {
	subClient, _ := NewOperationsWithScopeClient(c.credential, c.options)
	return subClient
}

// NewRegistrationAssignmentsClient creates a new instance of RegistrationAssignmentsClient.
func (c *ClientFactory) NewRegistrationAssignmentsClient() *RegistrationAssignmentsClient {
	subClient, _ := NewRegistrationAssignmentsClient(c.credential, c.options)
	return subClient
}

// NewRegistrationDefinitionsClient creates a new instance of RegistrationDefinitionsClient.
func (c *ClientFactory) NewRegistrationDefinitionsClient() *RegistrationDefinitionsClient {
	subClient, _ := NewRegistrationDefinitionsClient(c.credential, c.options)
	return subClient
}
