//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmarketplace_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/marketplace/armmarketplace"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetPrivateStoreOffers.json
func ExamplePrivateStoreCollectionOfferClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateStoreCollectionOfferClient().NewListPager("a0e28e55-90c4-41d8-8e34-bb7ef7775406", "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OfferListResponse = armmarketplace.OfferListResponse{
		// 	Value: []*armmarketplace.Offer{
		// 		{
		// 			Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
		// 			Type: to.Ptr("Microsoft.Marketplace/privateStores/collections/offers"),
		// 			ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/collections/56a1a02d-8cf8-45df-bf37-d5f7120fcb3d/offers/marketplacetestthirdparty.md-test-third-party-2"),
		// 			Properties: &armmarketplace.OfferProperties{
		// 				CreatedAt: to.Ptr("05/28/2015 5:50"),
		// 				ETag: to.Ptr("\"9301f4fd-0000-0100-0000-5e248b350000\""),
		// 				ModifiedAt: to.Ptr("05/29/2015 5:50"),
		// 				OfferDisplayName: to.Ptr("md-test-third-party-2"),
		// 				PrivateStoreID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
		// 				PublisherDisplayName: to.Ptr("Marketplace Test Third Party"),
		// 				SpecificPlanIDsLimitation: []*string{
		// 					to.Ptr("0001"),
		// 					to.Ptr("0002"),
		// 					to.Ptr("0003")},
		// 					UniqueOfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
		// 				Type: to.Ptr("Microsoft.Marketplace/privateStores/collections/offers"),
		// 				ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/collections/56a1a02d-8cf8-45df-bf37-d5f7120fcb3d/offers/marketplacetestthirdparty.md-test-third-party-3"),
		// 				Properties: &armmarketplace.OfferProperties{
		// 					CreatedAt: to.Ptr("05/28/2015 5:50"),
		// 					ETag: to.Ptr("\"9301f4fd-0000-0100-0304-5e248b350043\""),
		// 					ModifiedAt: to.Ptr("05/29/2015 5:50"),
		// 					OfferDisplayName: to.Ptr("md-test-third-party-3"),
		// 					PrivateStoreID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
		// 					PublisherDisplayName: to.Ptr("Marketplace Test Third Party"),
		// 					SpecificPlanIDsLimitation: []*string{
		// 						to.Ptr("0001"),
		// 						to.Ptr("0002")},
		// 						UniqueOfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-3"),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetPrivateStoreCollectionOffer.json
func ExamplePrivateStoreCollectionOfferClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreCollectionOfferClient().Get(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Offer = armmarketplace.Offer{
	// 	Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 	Type: to.Ptr("Microsoft.Marketplace/privateStores/collections/offers"),
	// 	ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/collections/56a1a02d-8cf8-45df-bf37-d5f7120fcb3d/offers/marketplacetestthirdparty.md-test-third-party-2"),
	// 	Properties: &armmarketplace.OfferProperties{
	// 		CreatedAt: to.Ptr("05/28/2015 5:50"),
	// 		ETag: to.Ptr("\"9301f4fd-0000-0100-0000-5e248b350000\""),
	// 		ModifiedAt: to.Ptr("05/29/2015 5:50"),
	// 		OfferDisplayName: to.Ptr("md-test-third-party-2"),
	// 		PrivateStoreID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
	// 		PublisherDisplayName: to.Ptr("Marketplace Test Third Party"),
	// 		SpecificPlanIDsLimitation: []*string{
	// 			to.Ptr("0001"),
	// 			to.Ptr("0002"),
	// 			to.Ptr("0003")},
	// 			UniqueOfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/PrivateStoreOffer_update.json
func ExamplePrivateStoreCollectionOfferClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreCollectionOfferClient().CreateOrUpdate(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d", &armmarketplace.PrivateStoreCollectionOfferClientCreateOrUpdateOptions{Payload: &armmarketplace.Offer{
		Properties: &armmarketplace.OfferProperties{
			ETag: to.Ptr("\"9301f4fd-0000-0100-0000-5e248b350666\""),
			SpecificPlanIDsLimitation: []*string{
				to.Ptr("0001"),
				to.Ptr("0002")},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Offer = armmarketplace.Offer{
	// 	Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 	Type: to.Ptr("Microsoft.Marketplace/privateStores/collections/offers"),
	// 	ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/collections/56a1a02d-8cf8-45df-bf37-d5f7120fcb3d/offers/marketplacetestthirdparty.md-test-third-party-2"),
	// 	Properties: &armmarketplace.OfferProperties{
	// 		CreatedAt: to.Ptr("05/28/2015 5:50"),
	// 		ETag: to.Ptr("\"9301f4fd-0000-0100-0000-5e248b350666\""),
	// 		ModifiedAt: to.Ptr("05/29/2015 5:50"),
	// 		OfferDisplayName: to.Ptr("md-test-third-party-2"),
	// 		PrivateStoreID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
	// 		PublisherDisplayName: to.Ptr("Marketplace Test Third Party"),
	// 		SpecificPlanIDsLimitation: []*string{
	// 			to.Ptr("0001"),
	// 			to.Ptr("0002")},
	// 			UniqueOfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/DeletePrivateStoreOffer.json
func ExamplePrivateStoreCollectionOfferClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPrivateStoreCollectionOfferClient().Delete(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/PostPrivateStoreCollectionOffer.json
func ExamplePrivateStoreCollectionOfferClient_Post() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPrivateStoreCollectionOfferClient().Post(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", "56a1a02d-8cf8-45df-bf37-d5f7120fcb3d", &armmarketplace.PrivateStoreCollectionOfferClientPostOptions{Payload: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
