//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmarketplaceordering

import "time"

// AgreementProperties - Agreement Terms definition
type AgreementProperties struct {
	// If any version of the terms have been accepted, otherwise false.
	Accepted *bool

	// Link to HTML with Microsoft and Publisher terms.
	LicenseTextLink *string

	// Link to HTML with Azure Marketplace terms.
	MarketplaceTermsLink *string

	// Plan identifier string of image being deployed.
	Plan *string

	// Link to the privacy policy of the publisher.
	PrivacyPolicyLink *string

	// Offer identifier string of image being deployed.
	Product *string

	// Publisher identifier string of image being deployed.
	Publisher *string

	// Date and time in UTC of when the terms were accepted. This is empty if Accepted is false.
	RetrieveDatetime *time.Time

	// Terms signature.
	Signature *string
}

// AgreementTerms - Terms properties for provided Publisher/Offer/Plan tuple
type AgreementTerms struct {
	// Represents the properties of the resource.
	Properties *AgreementProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ErrorResponse - Error response indicates Microsoft.MarketplaceOrdering service is not able to process the incoming request.
// The reason is provided in the error message.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorResponseError
}

// ErrorResponseError - The details of the error.
type ErrorResponseError struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// Operation - Microsoft.MarketplaceOrdering REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation description.
	Description *string

	// Operation type: Get Agreement, Sign Agreement, Cancel Agreement etc.
	Operation *string

	// Service provider: Microsoft.MarketplaceOrdering
	Provider *string

	// Resource on which the operation is performed: Agreement, virtualmachine, etc.
	Resource *string
}

// OperationListResult - Result of the request to list MarketplaceOrdering operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// List of Microsoft.MarketplaceOrdering operations supported by the Microsoft.MarketplaceOrdering resource provider.
	Value []*Operation

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string
}

// Resource - ARM resource.
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}
