//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmixedreality

import "time"

// AccountKeyRegenerateRequest - Request for account key regeneration
type AccountKeyRegenerateRequest struct {
	// Serial of key to be regenerated
	Serial *Serial
}

// AccountKeys - Developer Keys of account
type AccountKeys struct {
	// READ-ONLY; value of primary key.
	PrimaryKey *string

	// READ-ONLY; value of secondary key.
	SecondaryKey *string
}

// AccountProperties - Common Properties shared by Mixed Reality Accounts
type AccountProperties struct {
	// The name of the storage account associated with this accountId
	StorageAccountName *string

	// READ-ONLY; Correspond domain name of certain Spatial Anchors Account
	AccountDomain *string

	// READ-ONLY; unique id of certain account.
	AccountID *string
}

// CheckNameAvailabilityRequest - Check Name Availability Request
type CheckNameAvailabilityRequest struct {
	// REQUIRED; Resource Name To Verify
	Name *string

	// REQUIRED; Fully qualified resource type which includes provider namespace
	Type *string
}

// CheckNameAvailabilityResponse - Check Name Availability Response
type CheckNameAvailabilityResponse struct {
	// REQUIRED; if name Available
	NameAvailable *bool

	// detail message
	Message *string

	// Resource Name To Verify
	Reason *NameUnavailableReason
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// LogSpecification - Specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Blob duration of the log
	BlobDuration *string

	// Localized friendly display name of the log
	DisplayName *string

	// Name of the log
	Name *string
}

// MetricDimension - Specifications of the Dimension of metrics
type MetricDimension struct {
	// Localized friendly display name of the dimension
	DisplayName *string

	// Internal name of the dimension.
	InternalName *string

	// Name of the dimension
	Name *string

	// Flag to indicate export for Shoebox
	ToBeExportedForShoebox *bool
}

// MetricSpecification - Specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string

	// Metric category
	Category *string

	// Dimensions of the metric
	Dimensions []*MetricDimension

	// Localized friendly description of the metric
	DisplayDescription *string

	// Localized friendly display name of the metric
	DisplayName *string

	// Flag to indicate use of regional Mdm accounts
	EnableRegionalMdmAccount *bool

	// Flag to determine is Zero is returned for time duration where no metric is emitted
	FillGapWithZero *bool

	// Internal metric name.
	InternalMetricName *string

	// Locked aggregation type of the metric
	LockedAggregationType *string

	// Metric filter regex pattern
	MetricFilterPattern *string

	// Name of the metric
	Name *string

	// Source mdm account
	SourceMdmAccount *string

	// Source mdm namespace
	SourceMdmNamespace *string

	// Supported aggregation types. Valid values: Average, Minimum, Maximum, Total, Count.
	SupportedAggregationTypes []*string

	// Supported time grains. Valid values: PT1M, PT5M, PT15M, PT30M, PT1H, PT6H, PT12H, P1D
	SupportedTimeGrainTypes []*string

	// Unit that makes sense for the metric
	Unit *string
}

// ObjectAnchorsAccount Response.
type ObjectAnchorsAccount struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string
	Identity *ObjectAnchorsAccountIdentity

	// The kind of account, if supported
	Kind *SKU

	// The plan associated with this account
	Plan *Identity

	// Property bag.
	Properties *AccountProperties

	// The sku associated with this account
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata related to an object anchors account.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ObjectAnchorsAccountIdentity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// ObjectAnchorsAccountPage - Result of the request to get resource collection. It contains a list of resources and a URL
// link to get the next set of results.
type ObjectAnchorsAccountPage struct {
	// URL to get the next set of resource list results if there are any.
	NextLink *string

	// List of resources supported by the Resource Provider.
	Value []*ObjectAnchorsAccount
}

// Operation - REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Whether or not this is a data plane operation
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// The origin
	Origin *string

	// Properties of the operation
	Properties *OperationProperties
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// REQUIRED; Description of operation
	Description *string

	// REQUIRED; Operation type: Read, write, delete, etc.
	Operation *string

	// REQUIRED; Service provider: Microsoft.ResourceProvider
	Provider *string

	// REQUIRED; Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string
}

// OperationPage - Result of the request to list Resource Provider operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationPage struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of operations supported by the Resource Provider.
	Value []*Operation
}

// OperationProperties - Operation properties.
type OperationProperties struct {
	// Service specification.
	ServiceSpecification *ServiceSpecification
}

// RemoteRenderingAccount Response.
type RemoteRenderingAccount struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The identity associated with this account
	Identity *Identity

	// The kind of account, if supported
	Kind *SKU

	// The plan associated with this account
	Plan *Identity

	// Property bag.
	Properties *AccountProperties

	// The sku associated with this account
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; System metadata for this account
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RemoteRenderingAccountPage - Result of the request to get resource collection. It contains a list of resources and a URL
// link to get the next set of results.
type RemoteRenderingAccountPage struct {
	// URL to get the next set of resource list results if there are any.
	NextLink *string

	// List of resources supported by the Resource Provider.
	Value []*RemoteRenderingAccount
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

// ServiceSpecification - Service specification payload
type ServiceSpecification struct {
	// Specifications of the Log for Azure Monitoring
	LogSpecifications []*LogSpecification

	// Specifications of the Metrics for Azure Monitoring
	MetricSpecifications []*MetricSpecification
}

// SpatialAnchorsAccount Response.
type SpatialAnchorsAccount struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The identity associated with this account
	Identity *Identity

	// The kind of account, if supported
	Kind *SKU

	// The plan associated with this account
	Plan *Identity

	// Property bag.
	Properties *AccountProperties

	// The sku associated with this account
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; System metadata for this account
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpatialAnchorsAccountPage - Result of the request to get resource collection. It contains a list of resources and a URL
// link to get the next set of results.
type SpatialAnchorsAccountPage struct {
	// URL to get the next set of resource list results if there are any.
	NextLink *string

	// List of resources supported by the Resource Provider.
	Value []*SpatialAnchorsAccount
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}
