//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmixedreality_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mixedreality/armmixedreality"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/mixedreality/resource-manager/Microsoft.MixedReality/preview/2021-03-01-preview/examples/object-anchors/GetBySubscription.json
func ExampleObjectAnchorsAccountsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmixedreality.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewObjectAnchorsAccountsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ObjectAnchorsAccountPage = armmixedreality.ObjectAnchorsAccountPage{
		// 	Value: []*armmixedreality.ObjectAnchorsAccount{
		// 		{
		// 			Name: to.Ptr("alpha"),
		// 			Type: to.Ptr("Microsoft.MixedReality/objectAnchorsAccounts"),
		// 			ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/MyResourceGroup/providers/Microsoft.MixedReality/objectAnchorsAccounts/alpha"),
		// 			Location: to.Ptr("eastus2euap"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
		// 				Type: to.Ptr("SystemAssigned"),
		// 			},
		// 			Properties: &armmixedreality.AccountProperties{
		// 				AccountDomain: to.Ptr("mixedreality.azure.com"),
		// 				AccountID: to.Ptr("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("omega"),
		// 			Type: to.Ptr("Microsoft.MixedReality/objectAnchorsAccounts"),
		// 			ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/MyResourceGroup/providers/Microsoft.MixedReality/objectAnchorsAccounts/omega"),
		// 			Location: to.Ptr("eastus2euap"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
		// 				Type: to.Ptr("SystemAssigned"),
		// 			},
		// 			Properties: &armmixedreality.AccountProperties{
		// 				AccountDomain: to.Ptr("mixedreality.azure.com"),
		// 				AccountID: to.Ptr("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/mixedreality/resource-manager/Microsoft.MixedReality/preview/2021-03-01-preview/examples/object-anchors/GetByResourceGroup.json
func ExampleObjectAnchorsAccountsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmixedreality.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewObjectAnchorsAccountsClient().NewListByResourceGroupPager("MyResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ObjectAnchorsAccountPage = armmixedreality.ObjectAnchorsAccountPage{
		// 	Value: []*armmixedreality.ObjectAnchorsAccount{
		// 		{
		// 			Name: to.Ptr("alpha"),
		// 			Type: to.Ptr("Microsoft.MixedReality/objectAnchorsAccounts"),
		// 			ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/MyResourceGroup/providers/Microsoft.MixedReality/objectAnchorsAccounts/alpha"),
		// 			Location: to.Ptr("eastus2euap"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
		// 				Type: to.Ptr("SystemAssigned"),
		// 			},
		// 			Properties: &armmixedreality.AccountProperties{
		// 				AccountDomain: to.Ptr("mixedreality.azure.com"),
		// 				AccountID: to.Ptr("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("omega"),
		// 			Type: to.Ptr("Microsoft.MixedReality/objectAnchorsAccounts"),
		// 			ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/MyResourceGroup/providers/Microsoft.MixedReality/objectAnchorsAccounts/omega"),
		// 			Location: to.Ptr("eastus2euap"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
		// 				Type: to.Ptr("SystemAssigned"),
		// 			},
		// 			Properties: &armmixedreality.AccountProperties{
		// 				AccountDomain: to.Ptr("mixedreality.azure.com"),
		// 				AccountID: to.Ptr("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/mixedreality/resource-manager/Microsoft.MixedReality/preview/2021-03-01-preview/examples/object-anchors/Delete.json
func ExampleObjectAnchorsAccountsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmixedreality.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewObjectAnchorsAccountsClient().Delete(ctx, "MyResourceGroup", "MyAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/mixedreality/resource-manager/Microsoft.MixedReality/preview/2021-03-01-preview/examples/object-anchors/Get.json
func ExampleObjectAnchorsAccountsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmixedreality.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewObjectAnchorsAccountsClient().Get(ctx, "MyResourceGroup", "MyAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ObjectAnchorsAccount = armmixedreality.ObjectAnchorsAccount{
	// 	Name: to.Ptr("MyAccount"),
	// 	Type: to.Ptr("Microsoft.MixedReality/objectAnchorsAccounts"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/MyResourceGroup/providers/Microsoft.MixedReality/objectAnchorsAccounts/MyAccount"),
	// 	Location: to.Ptr("eastus2euap"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
	// 		Type: to.Ptr("SystemAssigned"),
	// 	},
	// 	Properties: &armmixedreality.AccountProperties{
	// 		AccountDomain: to.Ptr("mixedreality.azure.com"),
	// 		AccountID: to.Ptr("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/mixedreality/resource-manager/Microsoft.MixedReality/preview/2021-03-01-preview/examples/object-anchors/Patch.json
func ExampleObjectAnchorsAccountsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmixedreality.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewObjectAnchorsAccountsClient().Update(ctx, "MyResourceGroup", "MyAccount", armmixedreality.ObjectAnchorsAccount{
		Location: to.Ptr("eastus2euap"),
		Tags: map[string]*string{
			"hero":    to.Ptr("romeo"),
			"heroine": to.Ptr("juliet"),
		},
		Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
			Type: to.Ptr("SystemAssigned"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ObjectAnchorsAccount = armmixedreality.ObjectAnchorsAccount{
	// 	Name: to.Ptr("MyAccount"),
	// 	Type: to.Ptr("Microsoft.MixedReality/objectAnchorsAccounts"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/MyResourceGroup/providers/Microsoft.MixedReality/objectAnchorsAccounts/MyAccount"),
	// 	Location: to.Ptr("eastus2euap"),
	// 	Tags: map[string]*string{
	// 		"hero": to.Ptr("romeo"),
	// 		"heroine": to.Ptr("juliet"),
	// 	},
	// 	Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
	// 		Type: to.Ptr("SystemAssigned"),
	// 	},
	// 	Properties: &armmixedreality.AccountProperties{
	// 		AccountDomain: to.Ptr("mixedreality.azure.com"),
	// 		AccountID: to.Ptr("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/mixedreality/resource-manager/Microsoft.MixedReality/preview/2021-03-01-preview/examples/object-anchors/Put.json
func ExampleObjectAnchorsAccountsClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmixedreality.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewObjectAnchorsAccountsClient().Create(ctx, "MyResourceGroup", "MyAccount", armmixedreality.ObjectAnchorsAccount{
		Location: to.Ptr("eastus2euap"),
		Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
			Type: to.Ptr("SystemAssigned"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ObjectAnchorsAccount = armmixedreality.ObjectAnchorsAccount{
	// 	Name: to.Ptr("MyAccount"),
	// 	Type: to.Ptr("Microsoft.MixedReality/objectAnchorsAccounts"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/MyResourceGroup/providers/Microsoft.MixedReality/objectAnchorsAccounts/MyAccount"),
	// 	Location: to.Ptr("eastus2euap"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armmixedreality.ObjectAnchorsAccountIdentity{
	// 		Type: to.Ptr("SystemAssigned"),
	// 	},
	// 	Properties: &armmixedreality.AccountProperties{
	// 		AccountDomain: to.Ptr("mixedreality.azure.com"),
	// 		AccountID: to.Ptr("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/mixedreality/resource-manager/Microsoft.MixedReality/preview/2021-03-01-preview/examples/object-anchors/ListKeys.json
func ExampleObjectAnchorsAccountsClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmixedreality.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewObjectAnchorsAccountsClient().ListKeys(ctx, "MyResourceGroup", "MyAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountKeys = armmixedreality.AccountKeys{
	// 	PrimaryKey: to.Ptr("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"),
	// 	SecondaryKey: to.Ptr("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/mixedreality/resource-manager/Microsoft.MixedReality/preview/2021-03-01-preview/examples/object-anchors/RegenerateKey.json
func ExampleObjectAnchorsAccountsClient_RegenerateKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmixedreality.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewObjectAnchorsAccountsClient().RegenerateKeys(ctx, "MyResourceGroup", "MyAccount", armmixedreality.AccountKeyRegenerateRequest{
		Serial: to.Ptr(armmixedreality.SerialPrimary),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountKeys = armmixedreality.AccountKeys{
	// 	PrimaryKey: to.Ptr("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"),
	// 	SecondaryKey: to.Ptr("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"),
	// }
}
