//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mobilenetwork/armmobilenetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// PacketCoreControlPlaneVersionsServer is a fake server for instances of the armmobilenetwork.PacketCoreControlPlaneVersionsClient type.
type PacketCoreControlPlaneVersionsServer struct {
	// Get is the fake for method PacketCoreControlPlaneVersionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, versionName string, options *armmobilenetwork.PacketCoreControlPlaneVersionsClientGetOptions) (resp azfake.Responder[armmobilenetwork.PacketCoreControlPlaneVersionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetBySubscription is the fake for method PacketCoreControlPlaneVersionsClient.GetBySubscription
	// HTTP status codes to indicate success: http.StatusOK
	GetBySubscription func(ctx context.Context, versionName string, subscriptionID string, options *armmobilenetwork.PacketCoreControlPlaneVersionsClientGetBySubscriptionOptions) (resp azfake.Responder[armmobilenetwork.PacketCoreControlPlaneVersionsClientGetBySubscriptionResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PacketCoreControlPlaneVersionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armmobilenetwork.PacketCoreControlPlaneVersionsClientListOptions) (resp azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlaneVersionsClientListResponse])

	// NewListBySubscriptionPager is the fake for method PacketCoreControlPlaneVersionsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(subscriptionID string, options *armmobilenetwork.PacketCoreControlPlaneVersionsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlaneVersionsClientListBySubscriptionResponse])
}

// NewPacketCoreControlPlaneVersionsServerTransport creates a new instance of PacketCoreControlPlaneVersionsServerTransport with the provided implementation.
// The returned PacketCoreControlPlaneVersionsServerTransport instance is connected to an instance of armmobilenetwork.PacketCoreControlPlaneVersionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPacketCoreControlPlaneVersionsServerTransport(srv *PacketCoreControlPlaneVersionsServer) *PacketCoreControlPlaneVersionsServerTransport {
	return &PacketCoreControlPlaneVersionsServerTransport{
		srv:                        srv,
		newListPager:               newTracker[azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlaneVersionsClientListResponse]](),
		newListBySubscriptionPager: newTracker[azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlaneVersionsClientListBySubscriptionResponse]](),
	}
}

// PacketCoreControlPlaneVersionsServerTransport connects instances of armmobilenetwork.PacketCoreControlPlaneVersionsClient to instances of PacketCoreControlPlaneVersionsServer.
// Don't use this type directly, use NewPacketCoreControlPlaneVersionsServerTransport instead.
type PacketCoreControlPlaneVersionsServerTransport struct {
	srv                        *PacketCoreControlPlaneVersionsServer
	newListPager               *tracker[azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlaneVersionsClientListResponse]]
	newListBySubscriptionPager *tracker[azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlaneVersionsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for PacketCoreControlPlaneVersionsServerTransport.
func (p *PacketCoreControlPlaneVersionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PacketCoreControlPlaneVersionsClient.Get":
		resp, err = p.dispatchGet(req)
	case "PacketCoreControlPlaneVersionsClient.GetBySubscription":
		resp, err = p.dispatchGetBySubscription(req)
	case "PacketCoreControlPlaneVersionsClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	case "PacketCoreControlPlaneVersionsClient.NewListBySubscriptionPager":
		resp, err = p.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PacketCoreControlPlaneVersionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.MobileNetwork/packetCoreControlPlaneVersions/(?P<versionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	versionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), versionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PacketCoreControlPlaneVersion, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PacketCoreControlPlaneVersionsServerTransport) dispatchGetBySubscription(req *http.Request) (*http.Response, error) {
	if p.srv.GetBySubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBySubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlaneVersions/(?P<versionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	versionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionName")])
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetBySubscription(req.Context(), versionNameParam, subscriptionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PacketCoreControlPlaneVersion, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PacketCoreControlPlaneVersionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		resp := p.srv.NewListPager(nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmobilenetwork.PacketCoreControlPlaneVersionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}

func (p *PacketCoreControlPlaneVersionsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := p.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlaneVersions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListBySubscriptionPager(subscriptionIDParam, nil)
		newListBySubscriptionPager = &resp
		p.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armmobilenetwork.PacketCoreControlPlaneVersionsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		p.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
