//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmobilenetwork

import "time"

// Ambr - Aggregate maximum bit rate.
type Ambr struct {
	// REQUIRED; Downlink bit rate.
	Downlink *string

	// REQUIRED; Uplink bit rate.
	Uplink *string
}

// AmfID - AMF identifier
type AmfID struct {
	// REQUIRED; AMF pointer
	Pointer *int32

	// REQUIRED; AMF region identifier
	RegionID *int32

	// REQUIRED; AMF set identifier
	SetID *int32
}

// Arp - Allocation and Retention Priority (ARP) parameters.
type Arp struct {
	// REQUIRED; ARP preemption capability.
	PreemptCap *PreemptionCapability

	// REQUIRED; ARP preemption vulnerability
	PreemptVuln *PreemptionVulnerability

	// REQUIRED; ARP priority level.
	PriorityLevel *int32
}

// AsyncOperationID - Reference to an Azure Async Operation ID.
type AsyncOperationID struct {
	// REQUIRED; Azure Async Operation ID.
	ID *string
}

// AsyncOperationStatus - The current status of an async operation.
type AsyncOperationStatus struct {
	// REQUIRED; The operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// Percentage of the operation that is complete.
	PercentComplete *float64

	// Properties returned by the resource provider on a successful operation
	Properties any

	// Fully qualified ID for the resource that this async operation status relates to.
	ResourceID *string

	// The start time of the operation.
	StartTime *time.Time
}

// AttachedDataNetwork - Attached data network resource. Must be created in the same location as its parent packet core data
// plane.
type AttachedDataNetwork struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Attached data network properties.
	Properties *AttachedDataNetworkPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AttachedDataNetworkListResult - Response for attached data network API service call.
type AttachedDataNetworkListResult struct {
	// A list of data networks in a resource group.
	Value []*AttachedDataNetwork

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// AttachedDataNetworkPropertiesFormat - Data network properties.
type AttachedDataNetworkPropertiesFormat struct {
	// REQUIRED; The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if
	// you don't want DNS servers, you must provide an empty array.
	DNSAddresses []*string

	// REQUIRED; The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this
	// is the SGi interface.
	UserPlaneDataInterface *InterfaceProperties

	// The network address and port translation (NAPT) configuration. If this is not specified, the attached data network will
	// use a default NAPT configuration with NAPT enabled.
	NaptConfiguration *NaptConfiguration

	// The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically
	// assign IP addresses to UEs. The packet core instance assigns an IP
	// address to a UE when the UE sets up a PDU session. You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix.
	// If you define both, they must be of the same
	// size.
	UserEquipmentAddressPoolPrefix []*string

	// The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign
	// static IP addresses to UEs. The packet core instance assigns an IP address
	// to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the
	// corresponding SIM resource. At least one of userEquipmentAddressPoolPrefix and
	// userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
	UserEquipmentStaticAddressPoolPrefix []*string

	// READ-ONLY; The provisioning state of the attached data network resource.
	ProvisioningState *ProvisioningState
}

// AttachedDataNetworkResourceID - Reference to an attached data network resource.
type AttachedDataNetworkResourceID struct {
	// REQUIRED; Attached data network resource ID.
	ID *string
}

// AzureStackEdgeDeviceResourceID - Reference to an Azure Stack Edge device resource.
type AzureStackEdgeDeviceResourceID struct {
	// REQUIRED; Azure Stack Edge device resource ID.
	ID *string
}

// AzureStackHCIClusterResourceID - Reference to an Azure Stack HCI cluster resource.
type AzureStackHCIClusterResourceID struct {
	// REQUIRED; Azure Stack HCI cluster resource ID.
	ID *string
}

// CertificateProvisioning - Certificate provisioning state
type CertificateProvisioning struct {
	// READ-ONLY; Reason for certificate provisioning failure.
	Reason *string

	// READ-ONLY; The certificate's provisioning state
	State *CertificateProvisioningState
}

// CommonSimPropertiesFormat - Common SIM properties.
type CommonSimPropertiesFormat struct {
	// REQUIRED; The international mobile subscriber identity (IMSI) for the SIM.
	InternationalMobileSubscriberIdentity *string

	// An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video
	// camera'. The Azure portal allows SIMs to be grouped and filtered based on
	// this value.
	DeviceType *string

	// The integrated circuit card ID (ICCID) for the SIM.
	IntegratedCircuitCardIdentifier *string

	// The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
	SimPolicy *SimPolicyResourceID

	// A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached
	// data network, slice}.
	StaticIPConfiguration []*SimStaticIPProperties

	// READ-ONLY; The provisioning state of the SIM resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The state of the SIM resource.
	SimState *SimState

	// READ-ONLY; A dictionary of sites to the provisioning state of this SIM on that site.
	SiteProvisioningState map[string]*SiteProvisioningState

	// READ-ONLY; The public key fingerprint of the SIM vendor who provided this SIM, if any.
	VendorKeyFingerprint *string

	// READ-ONLY; The name of the SIM vendor who provided this SIM, if any.
	VendorName *string
}

// ConnectedClusterResourceID - Reference to an Azure Arc custom location resource.
type ConnectedClusterResourceID struct {
	// REQUIRED; Azure Arc connected cluster resource ID.
	ID *string
}

// CustomLocationResourceID - Reference to an Azure Arc custom location resource.
type CustomLocationResourceID struct {
	// REQUIRED; Azure Arc custom location resource ID.
	ID *string
}

// DataNetwork - Data network resource. Must be created in the same location as its parent mobile network.
type DataNetwork struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Data network properties.
	Properties *DataNetworkPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataNetworkConfiguration - Settings controlling data network use
type DataNetworkConfiguration struct {
	// REQUIRED; List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must
	// contain at least one item. The services must be in the same location as the SIM policy.
	AllowedServices []*ServiceResourceID

	// REQUIRED; A reference to the data network that these settings apply to. The data network must be in the same location as
	// the SIM policy.
	DataNetwork *DataNetworkResourceID

	// REQUIRED; Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6
	// for a full description of the Session-AMBR.
	SessionAmbr *Ambr

	// Allowed session types in addition to the default session type. Must not duplicate the default session type.
	AdditionalAllowedSessionTypes []*PduSessionType

	// Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority,
	// if the settings of preemptionCapability and preemptionVulnerability allow
	// it. 1 is the highest level of priority. If this field is not specified then 5qi is used to derive the ARP value. See 3GPP
	// TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
	AllocationAndRetentionPriorityLevel *int32

	// The default PDU session type, which is used if the UE does not request a specific session type.
	DefaultSessionType *PduSessionType

	// Default 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See
	// 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and
	// table 5.7.4-1 for the definition the 5QI values.
	FiveQi *int32

	// The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering.
	// See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum
	// is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
	MaximumNumberOfBufferedPackets *int32

	// Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another
	// QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a
	// full description of the ARP parameters.
	PreemptionCapability *PreemptionCapability

	// Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted
	// by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2
	// for a full description of the ARP parameters.
	PreemptionVulnerability *PreemptionVulnerability
}

// DataNetworkListResult - Response for data network API service call.
type DataNetworkListResult struct {
	// A list of data networks.
	Value []*DataNetwork

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// DataNetworkPropertiesFormat - Data network properties.
type DataNetworkPropertiesFormat struct {
	// An optional description for this data network.
	Description *string

	// READ-ONLY; The provisioning state of the data network resource.
	ProvisioningState *ProvisioningState
}

// DataNetworkResourceID - Reference to a data network resource.
type DataNetworkResourceID struct {
	// REQUIRED; Data network resource ID.
	ID *string
}

// DiagnosticsPackage - Diagnostics package resource.
type DiagnosticsPackage struct {
	// REQUIRED; Diagnostics package properties. A diagnostics package file derived from the name of this resource will be uploaded
	// to the Storage Account Container URL in the packet core control plane properties
	Properties *DiagnosticsPackagePropertiesFormat

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DiagnosticsPackageListResult - Response for diagnostics package API service call.
type DiagnosticsPackageListResult struct {
	// A list of diagnostics packages under a packet core control plane.
	Value []*DiagnosticsPackage

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// DiagnosticsPackagePropertiesFormat - Diagnostics package properties.
type DiagnosticsPackagePropertiesFormat struct {
	// READ-ONLY; The provisioning state of the diagnostics package resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The reason for the current state of the diagnostics package collection.
	Reason *string

	// READ-ONLY; The status of the diagnostics package collection.
	Status *DiagnosticsPackageStatus
}

// DiagnosticsUploadConfiguration - Configuration for uploading packet core diagnostics.
type DiagnosticsUploadConfiguration struct {
	// REQUIRED; The Storage Account Container URL to upload diagnostics to.
	StorageAccountContainerURL *string
}

// DnnIPPair - DNN and UE IP address
type DnnIPPair struct {
	// Data network name
	Dnn *string

	// UE IP address
	UeIPAddress *UeIPAddress
}

// EncryptedSimPropertiesFormat - Encrypted SIM properties.
type EncryptedSimPropertiesFormat struct {
	// REQUIRED; The international mobile subscriber identity (IMSI) for the SIM.
	InternationalMobileSubscriberIdentity *string

	// An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video
	// camera'. The Azure portal allows SIMs to be grouped and filtered based on
	// this value.
	DeviceType *string

	// The encrypted SIM credentials.
	EncryptedCredentials *string

	// The integrated circuit card ID (ICCID) for the SIM.
	IntegratedCircuitCardIdentifier *string

	// The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
	SimPolicy *SimPolicyResourceID

	// A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached
	// data network, slice}.
	StaticIPConfiguration []*SimStaticIPProperties

	// READ-ONLY; The provisioning state of the SIM resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The state of the SIM resource.
	SimState *SimState

	// READ-ONLY; A dictionary of sites to the provisioning state of this SIM on that site.
	SiteProvisioningState map[string]*SiteProvisioningState

	// READ-ONLY; The public key fingerprint of the SIM vendor who provided this SIM, if any.
	VendorKeyFingerprint *string

	// READ-ONLY; The name of the SIM vendor who provided this SIM, if any.
	VendorName *string
}

// EncryptedSimUploadList - The SIMs to upload. The SIM credentials must be encrypted.
type EncryptedSimUploadList struct {
	// REQUIRED; An identifier for the Azure SIM onboarding public key used for encrypted upload.
	AzureKeyIdentifier *int32

	// REQUIRED; The transport key used for encrypting SIM credentials, encrypted using the SIM onboarding public key.
	EncryptedTransportKey *string

	// REQUIRED; The encrypted transport key, signed using the SIM vendor private key.
	SignedTransportKey *string

	// REQUIRED; A list of SIMs to upload, with encrypted properties.
	Sims []*SimNameAndEncryptedProperties

	// REQUIRED; The fingerprint of the SIM vendor public key. The private counterpart is used for signing the encrypted transport
	// key.
	VendorKeyFingerprint *string

	// REQUIRED; The upload file format version.
	Version *int32
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// EventHubConfiguration - Configuration for sending packet core events to Azure Event Hub.
type EventHubConfiguration struct {
	// REQUIRED; Resource ID of Azure Event Hub to send packet core events to.
	ID *string

	// The duration (in seconds) between UE usage reports.
	ReportingInterval *int32
}

// ExtendedUeInfo - Extended User Equipment (UE) information.
type ExtendedUeInfo struct {
	// REQUIRED; Extended UE Information Properties.
	Properties ExtendedUeInfoPropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ExtendedUeInfoProperties - Extended UE Information Properties.
type ExtendedUeInfoProperties struct {
	// REQUIRED; RAT Type
	RatType *RatType

	// The timestamp of last UE info read from the packet core (UTC).
	LastReadAt *time.Time
}

// GetExtendedUeInfoProperties implements the ExtendedUeInfoPropertiesClassification interface for type ExtendedUeInfoProperties.
func (e *ExtendedUeInfoProperties) GetExtendedUeInfoProperties() *ExtendedUeInfoProperties { return e }

// GNbID - gNodeB identifier
type GNbID struct {
	BitLength *int32
	GNBValue  *string
}

// GlobalRanNodeID - Global RAN Node ID
type GlobalRanNodeID struct {
	// REQUIRED; PLMN Identifier
	PlmnID *PlmnID

	// eNodeB identifier
	ENbID *string

	// gNodeB identifier
	GNbID *GNbID

	// N3 IWF identifier
	N3IwfID *string

	// NG-eNodeB identifier
	NgeNbID *string

	// Network identifier
	Nid *string

	// TNGF identifier
	TngfID *string

	// W-AGF identifier
	WagfID *string
}

// Guti4G - Globally Unique Temporary Identifier (4G)
type Guti4G struct {
	// REQUIRED; MME Temporary Mobile Subscriber Identity
	MTmsi *int32

	// REQUIRED; MME identifier
	MmeID *MmeID

	// REQUIRED; Public land mobile network (PLMN) ID. This is made up of the mobile country code and mobile network code, as
	// defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used
	// for testing and the values 999-99 and 999-999 can be used on internal private networks.
	Plmn *PlmnID
}

// Guti5G - 5G GUTI
type Guti5G struct {
	// REQUIRED; AMF identifier
	AmfID *AmfID

	// REQUIRED; 5G Temporary Mobile Subscriber Identity
	FivegTmsi *int32

	// REQUIRED; Public land mobile network (PLMN) ID. This is made up of the mobile country code and mobile network code, as
	// defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used
	// for testing and the values 999-99 and 999-999 can be used on internal private networks.
	Plmn *PlmnID
}

// HTTPSServerCertificate - HTTPS server certificate configuration.
type HTTPSServerCertificate struct {
	// REQUIRED; The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
	CertificateURL *string

	// READ-ONLY; The provisioning state of the certificate.
	Provisioning *CertificateProvisioning
}

type HomeNetworkPrivateKeysProvisioning struct {
	// READ-ONLY; The provisioning state of the private keys for SUPI concealment.
	State *HomeNetworkPrivateKeysProvisioningState
}

// HomeNetworkPublicKey - A key used for SUPI concealment.
type HomeNetworkPublicKey struct {
	// REQUIRED; The Home Network Public Key Identifier determines which public key was used to generate the SUCI sent to the
	// AMF. See TS 23.003 Section 2.2B Section 5.
	ID *int32

	// The URL of Azure Key Vault secret containing the private key, versioned or unversioned. For example: https://contosovault.vault.azure.net/secrets/mySuciPrivateKey/562a4bb76b524a1493a6afe8e536ee78.
	URL *string
}

// IdentityAndTagsObject - Identity and Tags object for patch operations.
type IdentityAndTagsObject struct {
	// The managed service identity associated with this resource.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string
}

// Installation - The installation state of the packet core.
type Installation struct {
	// The desired installation state
	DesiredState *DesiredInstallationState

	// READ-ONLY; A reference to an in-progress installation operation
	Operation *AsyncOperationID

	// READ-ONLY; Reason(s) for the current installation state of the packet core.
	Reasons []*InstallationReason

	// READ-ONLY; Whether a reinstall of the packet core is required to pick up the latest configuration changes.
	ReinstallRequired *ReinstallRequired

	// READ-ONLY; Installation state
	State *InstallationState
}

// InterfaceProperties - Interface properties
type InterfaceProperties struct {
	// The IPv4 address.
	IPv4Address *string

	// The default IPv4 gateway (router).
	IPv4Gateway *string

	// The IPv4 subnet.
	IPv4Subnet *string

	// The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
	Name *string
}

// KeyVaultKey - An Azure key vault key.
type KeyVaultKey struct {
	// The key URL, unversioned. For example: https://contosovault.vault.azure.net/keys/azureKey.
	KeyURL *string
}

// ListResult - Response for mobile networks API service call.
type ListResult struct {
	// A list of mobile networks in a resource group.
	Value []*MobileNetwork

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// LocalDiagnosticsAccessConfiguration - The kubernetes ingress configuration to control access to packet core diagnostics
// over local APIs.
type LocalDiagnosticsAccessConfiguration struct {
	// REQUIRED; How to authenticate users who access local diagnostics APIs.
	AuthenticationType *AuthenticationType

	// The HTTPS server TLS certificate used to secure local access to diagnostics.
	HTTPSServerCertificate *HTTPSServerCertificate
}

// ManagedServiceIdentity - Managed service identity (User assigned identity)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (currently only UserAssigned allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity
}

// MmeID - MME identifier
type MmeID struct {
	// REQUIRED; MME code
	Code *int32

	// REQUIRED; MME group identifier
	GroupID *int32
}

// MobileNetwork - Mobile network resource.
type MobileNetwork struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Mobile network properties.
	Properties *PropertiesFormat

	// The identity used to retrieve any private keys used for SUPI concealment from Azure key vault.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NASRerouteConfiguration - Configuration enabling NAS reroute.
type NASRerouteConfiguration struct {
	// REQUIRED; The macro network's MME group ID. This is where unknown UEs are sent to via NAS reroute.
	MacroMmeGroupID *int32
}

// NaptConfiguration - The network address and port translation settings to use for the attached data network.
type NaptConfiguration struct {
	// Whether NAPT is enabled for connections to this attached data network.
	Enabled *NaptEnabled

	// Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is
	// the N6 interface. For 4G networks, this is the SGi interface.
	PinholeLimits *int32

	// Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
	PinholeTimeouts *PinholeTimeouts

	// Range of port numbers to use as translated ports on each translated address. If not specified and NAPT is enabled, this
	// range defaults to 1,024 - 49,999. (Ports under 1,024 should not be used because
	// these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
	PortRange *PortRange

	// The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by
	// another pinhole. All hold times must be at least 1 second.
	PortReuseHoldTime *PortReuseHoldTimes
}

// Operation - Object that describes a single Microsoft.MobileNetwork operation.
type Operation struct {
	// Indicates whether the operation applies to data-plane.
	IsDataAction *bool

	// READ-ONLY; The object that represents the operation.
	Display *OperationDisplay

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string

	// Operation type: Read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.MobileNetwork
	Provider *string

	// Resource on which the operation is performed: Registration definition, registration assignment etc.
	Resource *string
}

// OperationList - List of the operations.
type OperationList struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string

	// READ-ONLY; List of Microsoft.MobileNetwork operations.
	Value []*Operation
}

// PacketCapture - Packet capture session resource.
type PacketCapture struct {
	// REQUIRED; Packet capture session properties. Packet capture file(s) derived from the name of this session will be uploaded
	// to the Storage Account Container URL in the packet core control plane properties
	Properties *PacketCapturePropertiesFormat

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PacketCaptureListResult - Response for packet capture API service call.
type PacketCaptureListResult struct {
	// A list of packet capture sessions under a packet core control plane.
	Value []*PacketCapture

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PacketCapturePropertiesFormat - Packet capture session properties.
type PacketCapturePropertiesFormat struct {
	// Number of bytes captured per packet, the remaining bytes are truncated. The default "0" means the entire packet is captured.
	BytesToCapturePerPacket *int64

	// List of network interfaces to capture on.
	NetworkInterfaces []*string

	// Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32

	// Maximum size of the capture output.
	TotalBytesPerSession *int64

	// READ-ONLY; The start time of the packet capture session.
	CaptureStartTime *time.Time

	// READ-ONLY; The list of output files of a packet capture session.
	OutputFiles []*string

	// READ-ONLY; The provisioning state of the packet capture session resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The reason the current packet capture session state.
	Reason *string

	// READ-ONLY; The status of the packet capture session.
	Status *PacketCaptureStatus
}

// PacketCoreControlPlane - Packet core control plane resource.
type PacketCoreControlPlane struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Packet core control plane Properties.
	Properties *PacketCoreControlPlanePropertiesFormat

	// The identity used to retrieve the ingress certificate from Azure key vault.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PacketCoreControlPlaneCollectDiagnosticsPackage - Packet core control plane collect diagnostics package options
type PacketCoreControlPlaneCollectDiagnosticsPackage struct {
	// REQUIRED; The Storage Account Blob URL to upload the diagnostics package to.
	StorageAccountBlobURL *string
}

// PacketCoreControlPlaneListResult - Response for packet core control planes API service call.
type PacketCoreControlPlaneListResult struct {
	// A list of packet core control planes in a resource group.
	Value []*PacketCoreControlPlane

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PacketCoreControlPlanePropertiesFormat - Packet core control plane properties.
type PacketCoreControlPlanePropertiesFormat struct {
	// REQUIRED; The control plane interface on the access network. For 5G networks, this is the N2 interface. For 4G networks,
	// this is the S1-MME interface.
	ControlPlaneAccessInterface *InterfaceProperties

	// REQUIRED; The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
	LocalDiagnosticsAccess *LocalDiagnosticsAccessConfiguration

	// REQUIRED; The platform where the packet core is deployed.
	Platform *PlatformConfiguration

	// REQUIRED; The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
	SKU *BillingSKU

	// REQUIRED; Site(s) under which this packet core control plane should be deployed. The sites must be in the same location
	// as the packet core control plane.
	Sites []*SiteResourceID

	// The virtual IP address(es) for the control plane on the access network in a High Availability (HA) system. In an HA deployment
	// the access network router should be configured to anycast traffic for
	// this address to the control plane access interfaces on the active and standby nodes. In non-HA system this list should
	// be omitted or empty.
	ControlPlaneAccessVirtualIPv4Addresses []*string

	// The core network technology generation (5G core or EPC / 4G core).
	CoreNetworkTechnology *CoreNetworkType

	// Configuration for uploading packet core diagnostics
	DiagnosticsUpload *DiagnosticsUploadConfiguration

	// Configuration for sending packet core events to an Azure Event Hub.
	EventHub *EventHubConfiguration

	// The installation state of the packet core control plane resource.
	Installation *Installation

	// Settings to allow interoperability with third party components e.g. RANs and UEs.
	InteropSettings any

	// Signaling configuration for the packet core.
	Signaling *SignalingConfiguration

	// The MTU (in bytes) signaled to the UE. The same MTU is set on the user plane data links for all data networks. The MTU
	// set on the user plane access link is calculated to be 60 bytes greater than this
	// value to allow for GTP encapsulation.
	UeMtu *int32

	// The desired version of the packet core software.
	Version *string

	// READ-ONLY; The provisioning state of the secret containing private keys and keyIds for SUPI concealment.
	HomeNetworkPrivateKeysProvisioning *HomeNetworkPrivateKeysProvisioning

	// READ-ONLY; The currently installed version of the packet core software.
	InstalledVersion *string

	// READ-ONLY; The provisioning state of the packet core control plane resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The previous version of the packet core software that was deployed. Used when performing the rollback action.
	RollbackVersion *string
}

// PacketCoreControlPlaneResourceID - Reference to an packet core control plane resource.
type PacketCoreControlPlaneResourceID struct {
	// REQUIRED; Packet core control plane resource ID.
	ID *string
}

// PacketCoreControlPlaneVersion - Packet core control plane version resource.
type PacketCoreControlPlaneVersion struct {
	// REQUIRED; Packet core control plane version properties.
	Properties *PacketCoreControlPlaneVersionPropertiesFormat

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PacketCoreControlPlaneVersionListResult - Response for packet core control plane version API service call.
type PacketCoreControlPlaneVersionListResult struct {
	// A list of supported packet core control plane versions.
	Value []*PacketCoreControlPlaneVersion

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PacketCoreControlPlaneVersionPropertiesFormat - Packet core control plane version properties.
type PacketCoreControlPlaneVersionPropertiesFormat struct {
	// Platform specific packet core control plane version properties.
	Platforms []*Platform

	// READ-ONLY; The provisioning state of the packet core control plane version resource.
	ProvisioningState *ProvisioningState
}

// PacketCoreDataPlane - Packet core data plane resource. Must be created in the same location as its parent packet core control
// plane.
type PacketCoreDataPlane struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Packet core data plane Properties.
	Properties *PacketCoreDataPlanePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PacketCoreDataPlaneListResult - Response for packet core data planes API service call.
type PacketCoreDataPlaneListResult struct {
	// A list of packet core data planes in a resource group.
	Value []*PacketCoreDataPlane

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PacketCoreDataPlanePropertiesFormat - Packet core data plane properties.
type PacketCoreDataPlanePropertiesFormat struct {
	// REQUIRED; The user plane interface on the access network. For 5G networks, this is the N3 interface. For 4G networks, this
	// is the S1-U interface.
	UserPlaneAccessInterface *InterfaceProperties

	// The virtual IP address(es) for the user plane on the access network in a High Availability (HA) system. In an HA deployment
	// the access network router should be configured to forward traffic for this
	// address to the control plane access interface on the active or standby node. In non-HA system this list should be omitted
	// or empty.
	UserPlaneAccessVirtualIPv4Addresses []*string

	// READ-ONLY; The provisioning state of the packet core data plane resource.
	ProvisioningState *ProvisioningState
}

// PccRuleConfiguration - Data flow policy rule configuration
type PccRuleConfiguration struct {
	// REQUIRED; The name of the rule. This must be unique within the parent service. You must not use any of the following reserved
	// strings - default, requested or service.
	RuleName *string

	// REQUIRED; A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use
	// for a particular SIM. A lower value means a higher priority. This value should be unique
	// among all data flow policy rules configured in the mobile network.
	RulePrecedence *int32

	// REQUIRED; The set of data flow templates to use for this data flow policy rule.
	ServiceDataFlowTemplates []*ServiceDataFlowTemplate

	// The QoS policy to use for packets matching this rule. If this field is null then the parent service will define the QoS
	// settings.
	RuleQosPolicy *PccRuleQosPolicy

	// Determines whether flows that match this data flow policy rule are permitted.
	TrafficControl *TrafficControlPermission
}

// PccRuleQosPolicy - Data flow policy rule QoS policy
type PccRuleQosPolicy struct {
	// REQUIRED; The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
	MaximumBitRate *Ambr

	// QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if
	// the settings of preemptionCapability and preemptionVulnerability allow it. 1 is
	// the highest level of priority. If this field is not specified then 5qi is used to derive the ARP value. See 3GPP TS23.501
	// section 5.7.2.2 for a full description of the ARP parameters.
	AllocationAndRetentionPriorityLevel *int32

	// 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP
	// TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table
	// 5.7.4-1 for the definition the 5QI values.
	FiveQi *int32

	// The guaranteed bit rate (GBR) for all service data flows that use this data flow policy rule. This is an optional setting.
	// If you do not provide a value, there will be no GBR set for the data flow
	// policy rule that uses this QoS definition.
	GuaranteedBitRate *Ambr

	// QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow
	// with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full
	// description of the ARP parameters.
	PreemptionCapability *PreemptionCapability

	// QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a
	// QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a
	// full description of the ARP parameters.
	PreemptionVulnerability *PreemptionVulnerability
}

// PinholeTimeouts - Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
type PinholeTimeouts struct {
	// Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 30 seconds.
	Icmp *int32

	// Pinhole timeout for TCP pinholes in seconds. Default for TCP is 3 minutes.
	TCP *int32

	// Pinhole timeout for UDP pinholes in seconds. Default for UDP is 30 seconds.
	UDP *int32
}

// Platform specific packet core control plane version properties.
type Platform struct {
	// The maximum software version of the platform where this packet core version can be deployed.
	MaximumPlatformSoftwareVersion *string

	// The minimum software version of the platform where this packet core version can be deployed.
	MinimumPlatformSoftwareVersion *string

	// Indicates whether this version is obsoleted for this platform.
	ObsoleteVersion *ObsoleteVersion

	// The platform type where this version can be deployed.
	PlatformType *PlatformType

	// Indicates whether this is the recommended version for this platform.
	RecommendedVersion *RecommendedVersion

	// The state of this packet core control plane version on this platform.
	VersionState *VersionState
}

// PlatformConfiguration - The platform where the packet core is deployed.
type PlatformConfiguration struct {
	// REQUIRED; The platform type where packet core is deployed.
	Type *PlatformType

	// The Azure Stack Edge device where the packet core is deployed. If the device is part of a fault tolerant pair, either device
	// in the pair can be specified.
	AzureStackEdgeDevice *AzureStackEdgeDeviceResourceID

	// The Azure Stack HCI cluster where the packet core is deployed.
	AzureStackHciCluster *AzureStackHCIClusterResourceID

	// Azure Arc connected cluster where the packet core is deployed.
	ConnectedCluster *ConnectedClusterResourceID

	// Azure Arc custom location where the packet core is deployed.
	CustomLocation *CustomLocationResourceID

	// READ-ONLY; The Azure Stack Edge devices where the packet core is deployed. If the packet core is deployed across multiple
	// devices, all devices will appear in this list.
	AzureStackEdgeDevices []*AzureStackEdgeDeviceResourceID
}

// PlmnID - Public land mobile network (PLMN) ID. This is made up of the mobile country code and mobile network code, as defined
// in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used
// for testing and the values 999-99 and 999-999 can be used on internal private networks.
type PlmnID struct {
	// REQUIRED; Mobile country code (MCC).
	Mcc *string

	// REQUIRED; Mobile network code (MNC).
	Mnc *string
}

// PortRange - Range of port numbers to use as translated ports on each translated address. If not specified and NAPT is enabled,
// this range defaults to 1,024 - 49,999. (Ports under 1,024 should not be used because
// these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
type PortRange struct {
	// The maximum port number
	MaxPort *int32

	// The minimum port number
	MinPort *int32
}

// PortReuseHoldTimes - The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be
// recycled for use by another pinhole. All hold times must be minimum 1 second.
type PortReuseHoldTimes struct {
	// Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP
	// is 2 minutes.
	TCP *int32

	// Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP
	// is 1 minute.
	UDP *int32
}

// PropertiesFormat - Mobile network properties.
type PropertiesFormat struct {
	// REQUIRED; The unique public land mobile network identifier for the network. If both 'publicLandMobileNetworks' and 'publicLandMobileNetworkIdentifier'
	// are specified, then the 'publicLandMobileNetworks' will
	// take precedence.
	PublicLandMobileNetworkIdentifier *PlmnID

	// A list of public land mobile networks including their identifiers. If both 'publicLandMobileNetworks' and 'publicLandMobileNetworkIdentifier'
	// are specified, then the 'publicLandMobileNetworks' will
	// take precedence.
	PublicLandMobileNetworks []*PublicLandMobileNetwork

	// READ-ONLY; The provisioning state of the mobile network resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The mobile network resource identifier
	ServiceKey *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PublicLandMobileNetwork - Configuration relating to a particular PLMN
type PublicLandMobileNetwork struct {
	// REQUIRED; Mobile country code (MCC).
	Mcc *string

	// REQUIRED; Mobile network code (MNC).
	Mnc *string

	// Configuration relating to SUPI concealment.
	HomeNetworkPublicKeys *PublicLandMobileNetworkHomeNetworkPublicKeys
}

// PublicLandMobileNetworkHomeNetworkPublicKeys - Configuration relating to SUPI concealment.
type PublicLandMobileNetworkHomeNetworkPublicKeys struct {
	// This provides a mapping to identify which public key has been used for SUPI concealment using the Profile A Protection
	// Scheme.
	ProfileA []*HomeNetworkPublicKey

	// This provides a mapping to identify which public key has been used for SUPI concealment using the Profile B Protection
	// Scheme.
	ProfileB []*HomeNetworkPublicKey
}

// QosPolicy - QoS policy
type QosPolicy struct {
	// REQUIRED; The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
	MaximumBitRate *Ambr

	// QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if
	// the settings of preemptionCapability and preemptionVulnerability allow it. 1 is
	// the highest level of priority. If this field is not specified then 5qi is used to derive the ARP value. See 3GPP TS23.501
	// section 5.7.2.2 for a full description of the ARP parameters.
	AllocationAndRetentionPriorityLevel *int32

	// 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP
	// TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table
	// 5.7.4-1 for the definition the 5QI values.
	FiveQi *int32

	// QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow
	// with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full
	// description of the ARP parameters.
	PreemptionCapability *PreemptionCapability

	// QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a
	// QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a
	// full description of the ARP parameters.
	PreemptionVulnerability *PreemptionVulnerability
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceID - Reference to a mobile network resource.
type ResourceID struct {
	// REQUIRED; Mobile network resource ID.
	ID *string
}

// Service resource. Must be created in the same location as its parent mobile network.
type Service struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Service Properties.
	Properties *ServicePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServiceDataFlowTemplate - Data flow template
type ServiceDataFlowTemplate struct {
	// REQUIRED; The direction of this flow.
	Direction *SdfDirection

	// REQUIRED; A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within
	// the internet protocol suite, use the value ip. If you only want to allow a selection of
	// protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml.
	// For
	// example, for UDP, you must use 17. If you use the value ip then you must leave the field port unspecified.
	Protocol []*string

	// REQUIRED; The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP
	// address, use the value any. Otherwise, you must provide each of the remote IP addresses to
	// which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including
	// the netmask (for example, 192.0.2.54/24).
	RemoteIPList []*string

	// REQUIRED; The name of the data flow template. This must be unique within the parent data flow policy rule. You must not
	// use any of the following reserved strings - default, requested or service.
	TemplateName *string

	// The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify
	// one or more ports or port ranges then you must specify a value other than ip in
	// the protocol field. This is an optional setting. If you do not specify it then connections will be allowed on all ports.
	// Port ranges must be specified as -. For example: [8080, 8082-8085].
	Ports []*string
}

// ServiceListResult - Response for services API service call.
type ServiceListResult struct {
	// A list of services.
	Value []*Service

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ServicePropertiesFormat - Service properties.
type ServicePropertiesFormat struct {
	// REQUIRED; The set of data flow policy rules that make up this service.
	PccRules []*PccRuleConfiguration

	// REQUIRED; A precedence value that is used to decide between services when identifying the QoS values to use for a particular
	// SIM. A lower value means a higher priority. This value should be unique among all
	// services configured in the mobile network.
	ServicePrecedence *int32

	// The QoS policy to use for packets matching this service. This can be overridden for particular flows using the ruleQosPolicy
	// field in a PccRuleConfiguration. If this field is null then the UE's SIM
	// policy will define the QoS settings.
	ServiceQosPolicy *QosPolicy

	// READ-ONLY; The provisioning state of the service resource.
	ProvisioningState *ProvisioningState
}

// ServiceResourceID - Reference to a service resource.
type ServiceResourceID struct {
	// REQUIRED; Service resource ID.
	ID *string
}

// SignalingConfiguration - Signaling configuration for the packet core.
type SignalingConfiguration struct {
	// Configuration enabling 4G NAS reroute.
	NasReroute *NASRerouteConfiguration
}

// Sim - SIM resource.
type Sim struct {
	// REQUIRED; SIM Properties.
	Properties *SimPropertiesFormat

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SimDeleteList - The SIMs to delete.
type SimDeleteList struct {
	// REQUIRED; A list of SIM resource names to delete.
	Sims []*string
}

// SimGroup - SIM group resource.
type SimGroup struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; SIM group Properties.
	Properties *SimGroupPropertiesFormat

	// The identity used to retrieve the encryption key from Azure key vault.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SimGroupListResult - Response for list SIM groups API service call.
type SimGroupListResult struct {
	// A list of SIM groups in a resource group.
	Value []*SimGroup

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// SimGroupPropertiesFormat - SIM group properties.
type SimGroupPropertiesFormat struct {
	// A key to encrypt the SIM data that belongs to this SIM group.
	EncryptionKey *KeyVaultKey

	// Mobile network that this SIM group belongs to. The mobile network must be in the same location as the SIM group.
	MobileNetwork *ResourceID

	// READ-ONLY; The provisioning state of the SIM group resource.
	ProvisioningState *ProvisioningState
}

// SimGroupResourceID - Reference to a SIM group resource.
type SimGroupResourceID struct {
	// REQUIRED; SIM group resource ID.
	ID *string
}

// SimListResult - Response for list SIMs API service call.
type SimListResult struct {
	// A list of SIMs in a resource group.
	Value []*Sim

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// SimNameAndEncryptedProperties - SIM name and encrypted properties.
type SimNameAndEncryptedProperties struct {
	// REQUIRED; The name of the SIM.
	Name *string

	// REQUIRED; Encrypted SIM Properties.
	Properties *EncryptedSimPropertiesFormat
}

// SimNameAndProperties - SIM name and properties.
type SimNameAndProperties struct {
	// REQUIRED; The name of the SIM.
	Name *string

	// REQUIRED; SIM Properties.
	Properties *SimPropertiesFormat
}

// SimPolicy - SIM policy resource.
type SimPolicy struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; SIM policy Properties.
	Properties *SimPolicyPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SimPolicyListResult - Response for SIM policies API service call.
type SimPolicyListResult struct {
	// A list of SIM policies.
	Value []*SimPolicy

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// SimPolicyPropertiesFormat - SIM policy properties. Must be created in the same location as its parent mobile network.
type SimPolicyPropertiesFormat struct {
	// REQUIRED; The default slice to use if the UE does not explicitly specify it. This slice must exist in the sliceConfigurations
	// map. The slice must be in the same location as the SIM policy.
	DefaultSlice *SliceResourceID

	// REQUIRED; The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain
	// at least one item.
	SliceConfigurations []*SliceConfiguration

	// REQUIRED; Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a given UE. See 3GPP TS23.501
	// section 5.7.2.6 for a full description of the UE-AMBR.
	UeAmbr *Ambr

	// UE periodic registration update timer (5G) or UE periodic tracking area update timer (4G), in seconds.
	RegistrationTimer *int32

	// RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is an optional setting and by default is unspecified.
	RfspIndex *int32

	// READ-ONLY; The provisioning state of the SIM policy resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; A dictionary of sites to the provisioning state of this SIM policy on that site.
	SiteProvisioningState map[string]*SiteProvisioningState
}

// SimPolicyResourceID - Reference to a SIM policy resource.
type SimPolicyResourceID struct {
	// REQUIRED; SIM policy resource ID.
	ID *string
}

// SimPropertiesFormat - SIM properties.
type SimPropertiesFormat struct {
	// REQUIRED; The international mobile subscriber identity (IMSI) for the SIM.
	InternationalMobileSubscriberIdentity *string

	// The Ki value for the SIM.
	AuthenticationKey *string

	// An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video
	// camera'. The Azure portal allows SIMs to be grouped and filtered based on
	// this value.
	DeviceType *string

	// The integrated circuit card ID (ICCID) for the SIM.
	IntegratedCircuitCardIdentifier *string

	// The Opc value for the SIM.
	OperatorKeyCode *string

	// The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
	SimPolicy *SimPolicyResourceID

	// A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached
	// data network, slice}.
	StaticIPConfiguration []*SimStaticIPProperties

	// READ-ONLY; The provisioning state of the SIM resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The state of the SIM resource.
	SimState *SimState

	// READ-ONLY; A dictionary of sites to the provisioning state of this SIM on that site.
	SiteProvisioningState map[string]*SiteProvisioningState

	// READ-ONLY; The public key fingerprint of the SIM vendor who provided this SIM, if any.
	VendorKeyFingerprint *string

	// READ-ONLY; The name of the SIM vendor who provided this SIM, if any.
	VendorName *string
}

// SimStaticIPProperties - Static IP configuration for a SIM, scoped to a particular attached data network and slice.
type SimStaticIPProperties struct {
	// The attached data network on which the static IP address will be used. The combination of attached data network and slice
	// defines the network scope of the IP address. The attached data network must be
	// in the same location as the SIM.
	AttachedDataNetwork *AttachedDataNetworkResourceID

	// The network slice on which the static IP address will be used. The combination of attached data network and slice defines
	// the network scope of the IP address. The slice must be in the same location as
	// the SIM.
	Slice *SliceResourceID

	// The static IP configuration for the SIM to use at the defined network scope.
	StaticIP *SimStaticIPPropertiesStaticIP
}

// SimStaticIPPropertiesStaticIP - The static IP configuration for the SIM to use at the defined network scope.
type SimStaticIPPropertiesStaticIP struct {
	// The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix
	// defined in the attached data network.
	IPv4Address *string
}

// SimUploadList - The SIMs to upload.
type SimUploadList struct {
	// REQUIRED; A list of SIMs to upload.
	Sims []*SimNameAndProperties
}

// Site resource. Must be created in the same location as its parent mobile network.
type Site struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Site properties.
	Properties *SitePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SiteDeletePacketCore - The packet core to delete under a site.
type SiteDeletePacketCore struct {
	// Reference to an packet core control plane resource.
	PacketCore *PacketCoreControlPlaneResourceID
}

// SiteListResult - Response for sites API service call.
type SiteListResult struct {
	// A list of sites in a mobile network.
	Value []*Site

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// SitePropertiesFormat - Site properties.
type SitePropertiesFormat struct {
	// READ-ONLY; An array of IDs of the network functions deployed in the site. Deleting the site will delete any network functions
	// that are deployed in the site.
	NetworkFunctions []*SubResource

	// READ-ONLY; The provisioning state of the site resource.
	ProvisioningState *ProvisioningState
}

// SiteResourceID - Reference to a site resource.
type SiteResourceID struct {
	// REQUIRED; Site resource ID.
	ID *string
}

// Slice - Network slice resource. Must be created in the same location as its parent mobile network.
type Slice struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Slice properties.
	Properties *SlicePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SliceConfiguration - Per-slice settings
type SliceConfiguration struct {
	// REQUIRED; The allowed data networks and the settings to use for them. The list must not contain duplicate items and must
	// contain at least one item.
	DataNetworkConfigurations []*DataNetworkConfiguration

	// REQUIRED; The default data network to use if the UE does not explicitly specify it. Configuration for this object must
	// exist in the dataNetworkConfigurations map. The data network must be in the same location
	// as the SIM policy.
	DefaultDataNetwork *DataNetworkResourceID

	// REQUIRED; A reference to the slice that these settings apply to. The slice must be in the same location as the SIM policy.
	Slice *SliceResourceID
}

// SliceListResult - Response for network slice API service call.
type SliceListResult struct {
	// A list of network slices in a mobile network.
	Value []*Slice

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// SlicePropertiesFormat - Network slice properties.
type SlicePropertiesFormat struct {
	// REQUIRED; Single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
	Snssai *Snssai

	// An optional description for this network slice.
	Description *string

	// READ-ONLY; The provisioning state of the network slice resource.
	ProvisioningState *ProvisioningState
}

// SliceResourceID - Reference to a slice resource.
type SliceResourceID struct {
	// REQUIRED; Slice resource ID.
	ID *string
}

// Snssai - Single-network slice selection assistance information (S-NSSAI).
type Snssai struct {
	// REQUIRED; Slice/service type (SST).
	Sst *int32

	// Slice differentiator (SD).
	Sd *string
}

// SubResource - Reference to another sub resource.
type SubResource struct {
	// REQUIRED; Resource ID.
	ID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UeConnectionInfo4G - UE Connection Info for 4G
type UeConnectionInfo4G struct {
	// REQUIRED; eNodeB S1AP identifier
	EnbS1ApID *int32

	// REQUIRED; Global RAN Node ID
	GlobalRanNodeID *GlobalRanNodeID

	// REQUIRED; MME S1AP identifier
	MmeS1ApID *int32

	// REQUIRED; Radio connection establishment cause
	RrcEstablishmentCause *RrcEstablishmentCause

	// REQUIRED; State of the UE.
	UeState *UeState

	// The timestamp of last activity of UE (UTC).
	LastActivityTime *time.Time

	// Last Visited TAI
	LastVisitedTai *string

	// UE Location Info properties
	LocationInfo *UeLocationInfo

	// Per-UE transport network layer association
	PerUeTnla *string

	// The UE's usage setting
	UeUsageSetting *UeUsageSetting
}

// UeConnectionInfo5G - UE Connection Info for 5G.
type UeConnectionInfo5G struct {
	// REQUIRED; The AMF UE NGAP ID
	AmfUeNgapID *int64

	// REQUIRED; Global RAN Node ID
	GlobalRanNodeID *GlobalRanNodeID

	// REQUIRED; The RAN UE NGAP ID
	RanUeNgapID *int32

	// REQUIRED; Radio connection establishment cause
	RrcEstablishmentCause *RrcEstablishmentCause

	// REQUIRED; State of the UE.
	UeState *UeState

	// Allowed Network Slice Selection Assistance Information
	AllowedNssai []*Snssai

	// The timestamp of last activity of UE (UTC).
	LastActivityTime *time.Time

	// Last Visited TAI
	LastVisitedTai *string

	// UE Location Info properties
	LocationInfo *UeLocationInfo

	// Per-UE transport network layer association
	PerUeTnla *string

	// The UE's usage setting
	UeUsageSetting *UeUsageSetting
}

// UeIPAddress - UE IP address
type UeIPAddress struct {
	// IPv4 address.
	IPV4Addr *string
}

// UeInfo - Basic UE Information.
type UeInfo struct {
	// REQUIRED; Basic UE Information Properties.
	Properties *UeInfoPropertiesFormat

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UeInfo4G - UE Information for 4G.
type UeInfo4G struct {
	// REQUIRED; UE Information properties for 4G.
	Info *UeInfo4GProperties

	// REQUIRED; RAT Type
	RatType *RatType

	// The timestamp of last UE info read from the packet core (UTC).
	LastReadAt *time.Time
}

// GetExtendedUeInfoProperties implements the ExtendedUeInfoPropertiesClassification interface for type UeInfo4G.
func (u *UeInfo4G) GetExtendedUeInfoProperties() *ExtendedUeInfoProperties {
	return &ExtendedUeInfoProperties{
		LastReadAt: u.LastReadAt,
		RatType:    u.RatType,
	}
}

// UeInfo4GProperties - UE Information properties for 4G.
type UeInfo4GProperties struct {
	// REQUIRED; Globally Unique Temporary Identifier (4G)
	Guti *Guti4G

	// REQUIRED; International mobile subscriber identifier
	Imsi *string

	// UE Connection Info for 4G
	ConnectionInfo *UeConnectionInfo4G

	// International mobile equipment identity
	Imei *string

	// International mobile equipment identity – software version
	Imeisv      *string
	SessionInfo []*UeSessionInfo4G
}

// UeInfo5G - UE Information for 5G.
type UeInfo5G struct {
	// REQUIRED; UE Information properties for 5G.
	Info *UeInfo5GProperties

	// REQUIRED; RAT Type
	RatType *RatType

	// The timestamp of last UE info read from the packet core (UTC).
	LastReadAt *time.Time
}

// GetExtendedUeInfoProperties implements the ExtendedUeInfoPropertiesClassification interface for type UeInfo5G.
func (u *UeInfo5G) GetExtendedUeInfoProperties() *ExtendedUeInfoProperties {
	return &ExtendedUeInfoProperties{
		LastReadAt: u.LastReadAt,
		RatType:    u.RatType,
	}
}

// UeInfo5GProperties - UE Information properties for 5G.
type UeInfo5GProperties struct {
	// REQUIRED; 5G GUTI
	FivegGuti *Guti5G

	// REQUIRED; Subscription Permanent Identifier
	Supi *string

	// UE Connection Info for 5G.
	ConnectionInfo *UeConnectionInfo5G

	// Permanent Equipment Identifier
	Pei         *string
	SessionInfo []*UeSessionInfo5G
}

// UeInfoList - Response for packet core list UEs API call.
type UeInfoList struct {
	// A list of UEs in a packet core and their basic information.
	Value []*UeInfo

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// UeInfoPropertiesFormat - Basic UE Information Properties.
type UeInfoPropertiesFormat struct {
	// REQUIRED; RAT Type
	RatType *RatType

	// REQUIRED; State of the UE.
	UeState *UeState

	// The timestamp of last list UEs call to the packet core (UTC).
	LastReadAt    *time.Time
	UeIPAddresses []*DnnIPPair
}

// UeLocationInfo - UE Location Info properties
type UeLocationInfo struct {
	// REQUIRED; Location Type
	LocationType *string

	// REQUIRED; PLMN Identifier
	Plmn *PlmnID

	// REQUIRED; Type Allocation Code of UE
	Tac *string
}

// UeQOSFlow - QoS Flow
type UeQOSFlow struct {
	// REQUIRED; 5G QoS Identifier.
	Fiveqi *int32

	// REQUIRED; Qos Flow Identifier
	Qfi *int32

	// Guaranteed Bit Rate
	Gbr *Ambr

	// Maximum Bit Rate
	Mbr *Ambr
}

// UeSessionInfo4G - UE Session Info for 4G
type UeSessionInfo4G struct {
	// REQUIRED; Access point name
	Apn *string

	// REQUIRED; EPS bearer identifier
	Ebi *int32

	// REQUIRED; Packet Data Network Type
	PdnType *PdnType

	// REQUIRED; UE IP address
	UeIPAddress *UeIPAddress
}

// UeSessionInfo5G - UE Session Info for 5G.
type UeSessionInfo5G struct {
	// REQUIRED; Aggregate maximum bit rate.
	Ambr *Ambr

	// REQUIRED; Data network name
	Dnn *string

	// REQUIRED; Packet Data Network Type
	PdnType *PdnType

	// REQUIRED; PDU session identifier
	PduSessionID *int32

	// REQUIRED
	QosFlow []*UeQOSFlow

	// REQUIRED; Single-network slice selection assistance information (S-NSSAI).
	Snssai *Snssai

	// REQUIRED; UE IP address
	UeIPAddress *UeIPAddress
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}
