//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmsi_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/msi/armmsi"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3d7a3848106b831a4a7f46976fe38aa605c4f44d/specification/msi/resource-manager/Microsoft.ManagedIdentity/stable/2023-01-31/examples/SystemAssignedIdentityGet.json
func ExampleSystemAssignedIdentitiesClient_GetByScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmsi.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSystemAssignedIdentitiesClient().GetByScope(ctx, "scope", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SystemAssignedIdentity = armmsi.SystemAssignedIdentity{
	// 	Name: to.Ptr("resourceName"),
	// 	Type: to.Ptr("ResourceProvider"),
	// 	ID: to.Ptr("/scope"),
	// 	Location: to.Ptr("cus"),
	// 	Properties: &armmsi.SystemAssignedIdentityProperties{
	// 		ClientID: to.Ptr("4024ab25-56a8-4370-aea6-6389221caf29"),
	// 		ClientSecretURL: to.Ptr("https://serviceRoot/scope/credentials?tid=tenantId&oid=principalId&aid=clientId"),
	// 		PrincipalID: to.Ptr("25cc773c-7f05-40fc-a104-32d2300754ad"),
	// 		TenantID: to.Ptr("b6c948ef-f6b5-4384-8354-da3a15eca969"),
	// 	},
	// }
}
